/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.simulationTesting;

import us.ihmc.commons.MathTools;
import us.ihmc.simulationConstructionSetTools.simulationTesting.SimulationComparer;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.yoVariables.variable.YoDouble;

public class BodyPositionSimulationComparer
implements SimulationComparer {
    private final double epsilon;

    public BodyPositionSimulationComparer(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public boolean compare(SimulationConstructionSet scs1, SimulationConstructionSet scs2) {
        YoDouble var0 = this.getRootJoint(scs1).getQx();
        YoDouble var1 = this.getRootJoint(scs2).getQx();
        return MathTools.epsilonEquals((double)var0.getValueAsDouble(), (double)var1.getValueAsDouble(), (double)this.epsilon);
    }

    private FloatingJoint getRootJoint(SimulationConstructionSet scs0) {
        Joint firstRootJoint = (Joint)scs0.getRobots()[0].getRootJoints().get(0);
        if (firstRootJoint instanceof FloatingJoint) {
            return (FloatingJoint)firstRootJoint;
        }
        throw new RuntimeException("first root joint is not a floating joint: " + String.valueOf(firstRootJoint));
    }
}

