/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.optimization;

import us.ihmc.simulationConstructionSetTools.optimization.SimpleControllerToOptimize;
import us.ihmc.simulationConstructionSetTools.optimization.SimpleRobotToOptimize;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.Simulation;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.utilities.parameterOptimization.IndividualToEvaluate;
import us.ihmc.utilities.parameterOptimization.ListOfParametersToOptimize;

public class SimpleSimulationIndividualToEvaluate
extends IndividualToEvaluate {
    private static final boolean DEBUG = false;
    private final ListOfParametersToOptimize listOfParametersToOptimize;
    private final Simulation simulation;
    private final SimpleControllerToOptimize controller;
    private boolean isEvaluationDone = false;
    private double cost;

    public SimpleSimulationIndividualToEvaluate() {
        SimpleRobotToOptimize robot = new SimpleRobotToOptimize();
        this.controller = new SimpleControllerToOptimize();
        robot.setController(this.controller);
        this.simulation = new Simulation((Robot)robot, 1);
        this.listOfParametersToOptimize = this.controller.getListOfParametersToOptimizeForTrialOne();
    }

    public IndividualToEvaluate createNewIndividual() {
        return new SimpleSimulationIndividualToEvaluate();
    }

    public void startEvaluation() {
        this.controller.setCurrentValues(this.listOfParametersToOptimize);
        try {
            this.simulation.simulate(1.0);
        }
        catch (UnreasonableAccelerationException e) {
            System.out.println("SimpleSimulationToOptimize Crashed. Setting cost to Infinity");
            this.cost = Double.POSITIVE_INFINITY;
            this.isEvaluationDone = true;
            return;
        }
        this.cost = this.controller.getCost();
        this.isEvaluationDone = true;
    }

    public boolean isEvaluationDone() {
        return this.isEvaluationDone;
    }

    public double computeFitness() {
        return this.cost;
    }

    public ListOfParametersToOptimize getStructuralParametersToOptimize() {
        return null;
    }

    public ListOfParametersToOptimize getControlParametersToOptimize() {
        return this.listOfParametersToOptimize;
    }

    public void replay() {
    }
}

