/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.util.dataProcessors;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationConstructionSetTools.util.dataProcessors.ValueDataCheckerParameters;

public class ValueDataCheckerParametersTest {
    private double EPSILON = 1.0E-10;

    @Test
    public void testGetDefensiveCopy() {
        ValueDataCheckerParameters valueDataCheckerParametersOriginal = new ValueDataCheckerParameters();
        valueDataCheckerParametersOriginal.setErrorThresholdOnDerivativeComparison(Math.random());
        valueDataCheckerParametersOriginal.setMaximumDerivative(Math.random());
        valueDataCheckerParametersOriginal.setMaximumSecondDerivative(Math.random());
        valueDataCheckerParametersOriginal.setMaximumValue(Math.random());
        valueDataCheckerParametersOriginal.setMinimumValue(valueDataCheckerParametersOriginal.getMaximumValue() - 1.0);
        ValueDataCheckerParameters valueDataCheckerParametersCopy = valueDataCheckerParametersOriginal.getDefensiveCopy();
        Assert.assertEquals((double)valueDataCheckerParametersOriginal.getErrorThresholdOnDerivativeComparison(), (double)valueDataCheckerParametersCopy.getErrorThresholdOnDerivativeComparison(), (double)this.EPSILON);
        Assert.assertEquals((double)valueDataCheckerParametersOriginal.getMaximumDerivative(), (double)valueDataCheckerParametersCopy.getMaximumDerivative(), (double)this.EPSILON);
        Assert.assertEquals((double)valueDataCheckerParametersOriginal.getMaximumSecondDerivative(), (double)valueDataCheckerParametersCopy.getMaximumSecondDerivative(), (double)this.EPSILON);
        Assert.assertEquals((double)valueDataCheckerParametersOriginal.getMaximumValue(), (double)valueDataCheckerParametersCopy.getMaximumValue(), (double)this.EPSILON);
        Assert.assertEquals((double)valueDataCheckerParametersOriginal.getMinimumValue(), (double)valueDataCheckerParametersCopy.getMinimumValue(), (double)this.EPSILON);
    }

    @Test
    public void testErrorThresholdOnDerivativeComparison() {
        ValueDataCheckerParameters valueDataCheckerParametersOriginal = new ValueDataCheckerParameters();
        double value = Math.random();
        valueDataCheckerParametersOriginal.setErrorThresholdOnDerivativeComparison(value);
        Assert.assertEquals((double)valueDataCheckerParametersOriginal.getErrorThresholdOnDerivativeComparison(), (double)value, (double)this.EPSILON);
        valueDataCheckerParametersOriginal.setErrorThresholdOnDerivativeComparison(-value);
        Assert.assertEquals((double)valueDataCheckerParametersOriginal.getErrorThresholdOnDerivativeComparison(), (double)value, (double)this.EPSILON);
    }

    @Test
    public void testMaximumDerivative() {
        ValueDataCheckerParameters valueDataCheckerParametersOriginal = new ValueDataCheckerParameters();
        double value = Math.random();
        valueDataCheckerParametersOriginal.setMaximumDerivative(value);
        Assert.assertEquals((double)valueDataCheckerParametersOriginal.getMaximumDerivative(), (double)value, (double)this.EPSILON);
        valueDataCheckerParametersOriginal.setMaximumDerivative(-value);
        Assert.assertEquals((double)valueDataCheckerParametersOriginal.getMaximumDerivative(), (double)value, (double)this.EPSILON);
    }

    @Test
    public void testMaximumSecondDerivative() {
        ValueDataCheckerParameters valueDataCheckerParametersOriginal = new ValueDataCheckerParameters();
        double value = Math.random();
        valueDataCheckerParametersOriginal.setMaximumSecondDerivative(value);
        Assert.assertEquals((double)valueDataCheckerParametersOriginal.getMaximumSecondDerivative(), (double)value, (double)this.EPSILON);
        valueDataCheckerParametersOriginal.setMaximumSecondDerivative(-value);
        Assert.assertEquals((double)valueDataCheckerParametersOriginal.getMaximumSecondDerivative(), (double)value, (double)this.EPSILON);
    }

    @Test
    public void testMaximumValue() {
        ValueDataCheckerParameters valueDataCheckerParametersOriginal = new ValueDataCheckerParameters();
        double value = Math.random();
        valueDataCheckerParametersOriginal.setMaximumValue(value);
        Assert.assertEquals((double)valueDataCheckerParametersOriginal.getMaximumValue(), (double)value, (double)this.EPSILON);
        valueDataCheckerParametersOriginal.setMaximumValue(-value);
        Assert.assertFalse((valueDataCheckerParametersOriginal.getMaximumValue() == value ? 1 : 0) != 0);
    }

    @Test
    public void testMinimumValue() {
        ValueDataCheckerParameters valueDataCheckerParametersOriginal = new ValueDataCheckerParameters();
        double value = Math.random();
        valueDataCheckerParametersOriginal.setMinimumValue(value);
        Assert.assertEquals((double)valueDataCheckerParametersOriginal.getMinimumValue(), (double)value, (double)this.EPSILON);
        valueDataCheckerParametersOriginal.setMinimumValue(-value);
        Assert.assertFalse((valueDataCheckerParametersOriginal.getMinimumValue() == value ? 1 : 0) != 0);
    }

    @Test
    public void testSetMinGreaterThanMax() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            ValueDataCheckerParameters valueDataCheckerParametersOriginal = new ValueDataCheckerParameters();
            double value = 10.0;
            valueDataCheckerParametersOriginal.setMaximumValue(value);
            valueDataCheckerParametersOriginal.setMinimumValue(value + 1.0);
        });
    }

    @Test
    public void testSetMaxLessThanMin() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            ValueDataCheckerParameters valueDataCheckerParametersOriginal = new ValueDataCheckerParameters();
            double value = 10.0;
            valueDataCheckerParametersOriginal.setMinimumValue(value);
            valueDataCheckerParametersOriginal.setMaximumValue(value - 10.0);
        });
    }
}

