/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.whiteBoard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationConstructionSetTools.whiteBoard.YoWhiteBoard;
import us.ihmc.simulationConstructionSetTools.whiteBoard.YoWhiteBoardListener;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoFactories;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;
import us.ihmc.yoVariables.variable.YoVariableType;

public class YoWhiteBoardTest {
    private static final boolean VERBOSE = false;

    @Test
    public void testWriteNotConnected() throws IOException {
        DoNothingWhiteBoard whiteBoard = new DoNothingWhiteBoard();
        Assertions.assertThrows(RuntimeException.class, () -> whiteBoard.writeData());
    }

    @Test
    public void testReadNotConnected() throws IOException {
        DoNothingWhiteBoard whiteBoard = new DoNothingWhiteBoard();
        Assertions.assertThrows(RuntimeException.class, () -> whiteBoard.readData());
    }

    protected void doASynchronizedWriteThenReadTest(YoWhiteBoard leftWhiteBoard, YoWhiteBoard rightWhiteBoard, int numberOfTests, int numberVariablesToReadOneWriteTwo, int numberVariablesToWriteOneReadTwo) throws IOException {
        this.createRandomRegistriesAndVariables(leftWhiteBoard, rightWhiteBoard, 20, numberVariablesToReadOneWriteTwo, numberVariablesToWriteOneReadTwo);
        leftWhiteBoard.connect();
        rightWhiteBoard.connect();
        YoWhiteBoardListenerForTest leftWhiteBoardListener = new YoWhiteBoardListenerForTest();
        YoWhiteBoardListenerForTest rightWhiteBoardListener = new YoWhiteBoardListenerForTest();
        leftWhiteBoard.attachYoWhiteBoardListener((YoWhiteBoardListener)leftWhiteBoardListener);
        rightWhiteBoard.attachYoWhiteBoardListener((YoWhiteBoardListener)rightWhiteBoardListener);
        long startTime = System.currentTimeMillis();
        ArrayList<YoVariable> leftVariablesToWrite = new ArrayList<YoVariable>();
        ArrayList<YoVariable> leftVariablesToRead = new ArrayList<YoVariable>();
        ArrayList<YoVariable> rightVariablesToWrite = new ArrayList<YoVariable>();
        ArrayList<YoVariable> rightVariablesToRead = new ArrayList<YoVariable>();
        leftWhiteBoard.getAllVariablesToWrite(leftVariablesToWrite);
        leftWhiteBoard.getAllVariablesToRead(leftVariablesToRead);
        rightWhiteBoard.getAllVariablesToWrite(rightVariablesToWrite);
        rightWhiteBoard.getAllVariablesToRead(rightVariablesToRead);
        this.verifyYoVariablesAreEqual(leftVariablesToWrite, rightVariablesToRead);
        this.verifyYoVariablesAreEqual(leftVariablesToRead, rightVariablesToWrite);
        this.waitForWhiteBoardsToConnect(leftWhiteBoard, rightWhiteBoard);
        for (int i = 0; i < numberOfTests; ++i) {
            this.changeWrittenVariablesRandomly(leftWhiteBoard);
            this.changeWrittenVariablesRandomly(rightWhiteBoard);
            Assert.assertFalse((boolean)leftWhiteBoardListener.hasReceivedNewDataBeforeReset());
            Assert.assertFalse((boolean)rightWhiteBoardListener.hasReceivedNewDataBeforeReset());
            leftWhiteBoardListener.reset();
            rightWhiteBoardListener.reset();
            leftWhiteBoard.writeData();
            rightWhiteBoard.writeData();
            while (!leftWhiteBoardListener.isNewDataReady() || !rightWhiteBoardListener.isNewDataReady()) {
                Thread.yield();
            }
            Assert.assertEquals((long)1L, (long)leftWhiteBoard.getNumberOfNewDataSinceLastRead());
            Assert.assertEquals((long)1L, (long)rightWhiteBoard.getNumberOfNewDataSinceLastRead());
            this.verifyThatWhiteBoardsHaveNewDataAvailable(leftWhiteBoard, rightWhiteBoard);
            leftWhiteBoard.readData();
            rightWhiteBoard.readData();
            this.verifyThatWhiteBoardsDoNotHaveNewDataAvailable(leftWhiteBoard, rightWhiteBoard);
            this.verifyYoVariablesHaveSameValues(leftVariablesToWrite, rightVariablesToRead);
            this.verifyYoVariablesHaveSameValues(leftVariablesToRead, rightVariablesToWrite);
        }
        long endTime = System.currentTimeMillis();
        double duration = (double)(endTime - startTime) * 0.001;
        double timePerTest = duration / (double)numberOfTests;
        leftWhiteBoard.closeYoWhiteBoard();
        rightWhiteBoard.closeYoWhiteBoard();
    }

    protected void doAnAsynchronousTest(YoWhiteBoard leftWhiteBoard, YoWhiteBoard rightWhiteBoard, int numberOfTests, int numberVariablesToReadOneWriteTwo, int numberVariablesToWriteOneReadTwo) throws IOException {
        this.createRandomRegistriesAndVariables(leftWhiteBoard, rightWhiteBoard, 20, numberVariablesToReadOneWriteTwo, numberVariablesToWriteOneReadTwo);
        leftWhiteBoard.connect();
        rightWhiteBoard.connect();
        long startTime = System.currentTimeMillis();
        ArrayList<YoVariable> leftVariablesToWrite = new ArrayList<YoVariable>();
        ArrayList<YoVariable> leftVariablesToRead = new ArrayList<YoVariable>();
        ArrayList<YoVariable> rightVariablesToWrite = new ArrayList<YoVariable>();
        ArrayList<YoVariable> rightVariablesToRead = new ArrayList<YoVariable>();
        leftWhiteBoard.getAllVariablesToWrite(leftVariablesToWrite);
        leftWhiteBoard.getAllVariablesToRead(leftVariablesToRead);
        rightWhiteBoard.getAllVariablesToWrite(rightVariablesToWrite);
        rightWhiteBoard.getAllVariablesToRead(rightVariablesToRead);
        this.verifyYoVariablesAreEqual(leftVariablesToWrite, rightVariablesToRead);
        this.verifyYoVariablesAreEqual(leftVariablesToRead, rightVariablesToWrite);
        this.waitForWhiteBoardsToConnect(leftWhiteBoard, rightWhiteBoard);
        Random random = new Random(1234L);
        for (int i = 0; i < numberOfTests; ++i) {
            int numberOfLeftWrites = 1 + random.nextInt(19);
            for (int j = 0; j < numberOfLeftWrites; ++j) {
                this.changeWrittenVariablesRandomly(leftWhiteBoard);
                leftWhiteBoard.writeData();
            }
            int numberOfRightWrites = 1 + random.nextInt(19);
            for (int j = 0; j < numberOfRightWrites; ++j) {
                this.changeWrittenVariablesRandomly(rightWhiteBoard);
                rightWhiteBoard.writeData();
            }
            while (rightWhiteBoard.getNumberOfNewDataSinceLastRead() < numberOfLeftWrites) {
                Thread.yield();
            }
            while (leftWhiteBoard.getNumberOfNewDataSinceLastRead() < numberOfRightWrites) {
                Thread.yield();
            }
            this.sleep(2L);
            Assert.assertEquals((long)numberOfLeftWrites, (long)rightWhiteBoard.getNumberOfNewDataSinceLastRead());
            Assert.assertEquals((long)numberOfRightWrites, (long)leftWhiteBoard.getNumberOfNewDataSinceLastRead());
            this.verifyThatWhiteBoardsHaveNewDataAvailable(leftWhiteBoard, rightWhiteBoard);
            leftWhiteBoard.readData();
            rightWhiteBoard.readData();
            this.verifyThatWhiteBoardsDoNotHaveNewDataAvailable(leftWhiteBoard, rightWhiteBoard);
            this.verifyYoVariablesHaveSameValues(leftVariablesToWrite, rightVariablesToRead);
            this.verifyYoVariablesHaveSameValues(leftVariablesToRead, rightVariablesToWrite);
        }
        long endTime = System.currentTimeMillis();
        double duration = (double)(endTime - startTime) * 0.001;
        double timePerTest = duration / (double)numberOfTests;
        leftWhiteBoard.closeYoWhiteBoard();
        rightWhiteBoard.closeYoWhiteBoard();
    }

    private void sleep(long sleepMillis) {
        try {
            Thread.sleep(sleepMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void verifyThatWhiteBoardsDoNotHaveNewDataAvailable(YoWhiteBoard leftWhiteBoard, YoWhiteBoard rightWhiteBoard) {
        Assert.assertFalse((boolean)leftWhiteBoard.isNewDataAvailable());
        Assert.assertFalse((boolean)rightWhiteBoard.isNewDataAvailable());
        Assert.assertEquals((long)0L, (long)leftWhiteBoard.getNumberOfNewDataSinceLastRead());
        Assert.assertEquals((long)0L, (long)rightWhiteBoard.getNumberOfNewDataSinceLastRead());
    }

    private void verifyThatWhiteBoardsHaveNewDataAvailable(YoWhiteBoard leftWhiteBoard, YoWhiteBoard rightWhiteBoard) {
        Assert.assertTrue((boolean)leftWhiteBoard.isNewDataAvailable());
        Assert.assertTrue((boolean)rightWhiteBoard.isNewDataAvailable());
    }

    private void waitForWhiteBoardsToConnect(YoWhiteBoard leftWhiteBoard, YoWhiteBoard rightWhiteBoard) {
        while (!leftWhiteBoard.isConnected()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while (!rightWhiteBoard.isConnected()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void verifyYoVariablesAreEqual(ArrayList<YoVariable> variablesOne, ArrayList<YoVariable> variablesTwo) {
        Assert.assertEquals((long)variablesOne.size(), (long)variablesTwo.size());
        for (int i = 0; i < variablesOne.size(); ++i) {
            this.verifyYoVariablesAreEqual(variablesOne.get(i), variablesTwo.get(i));
        }
    }

    private void verifyYoVariablesHaveSameValues(ArrayList<YoVariable> variablesOne, ArrayList<YoVariable> variablesTwo) {
        Assert.assertEquals((long)variablesOne.size(), (long)variablesTwo.size());
        for (int i = 0; i < variablesOne.size(); ++i) {
            this.verifyYoVariablesHaveSameValues(variablesOne.get(i), variablesTwo.get(i));
        }
    }

    private void verifyYoVariablesAreEqual(YoVariable variableOne, YoVariable variableTwo) {
        Assert.assertTrue((variableOne.getType() == variableTwo.getType() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)variableOne.getFullNameString().equals(variableTwo.getFullNameString()));
        Assert.assertEquals((double)variableOne.getValueAsDouble(), (double)variableTwo.getValueAsDouble(), (double)1.0E-7);
    }

    private void verifyYoVariablesHaveSameValues(YoVariable variableOne, YoVariable variableTwo) {
        Assert.assertEquals((double)variableOne.getValueAsDouble(), (double)variableTwo.getValueAsDouble(), (double)1.0E-7);
    }

    private void changeWrittenVariablesRandomly(YoWhiteBoard leftWhiteBoard) {
        ArrayList variablesToWrite = new ArrayList();
        leftWhiteBoard.getAllVariablesToWrite(variablesToWrite);
        for (YoVariable variable : variablesToWrite) {
            variable.setValueFromDouble(2.0 * Math.random());
        }
    }

    private void createVariableCopyFromReadToWrite(YoWhiteBoard boardToCopyFrom, YoWhiteBoard boardToCopyTo) {
        ArrayList<YoVariable> allVariableToRead = new ArrayList<YoVariable>();
        ArrayList<YoVariable> allVariableToWrite = new ArrayList<YoVariable>();
        boardToCopyFrom.getAllVariablesToRead(allVariableToRead);
        boardToCopyFrom.getAllVariablesToWrite(allVariableToWrite);
        ArrayList<YoVariable> copyVariablesToWrite = new ArrayList<YoVariable>();
        ArrayList<YoVariable> copyVariablesToRead = new ArrayList<YoVariable>();
        this.createVariableCopies(allVariableToRead, copyVariablesToWrite);
        this.createVariableCopies(allVariableToWrite, copyVariablesToRead);
        boardToCopyTo.setVariablesToWrite(copyVariablesToWrite);
        boardToCopyTo.setVariablesToRead(copyVariablesToRead);
    }

    private void createVariableCopies(ArrayList<YoVariable> variablesToCopy, ArrayList<YoVariable> variablesToCopyTo) {
        YoRegistry rootRegistry = new YoRegistry("root");
        block6: for (YoVariable variable : variablesToCopy) {
            String name = variable.getName();
            YoNamespace namespace = variable.getNamespace();
            YoVariableType yoVariableType = variable.getType();
            YoRegistry registry = YoFactories.findOrCreateRegistry((YoRegistry)rootRegistry, (YoNamespace)namespace);
            switch (yoVariableType) {
                case DOUBLE: {
                    variablesToCopyTo.add((YoVariable)new YoDouble(name, registry));
                    continue block6;
                }
                case INTEGER: {
                    variablesToCopyTo.add((YoVariable)new YoInteger(name, registry));
                    continue block6;
                }
                case BOOLEAN: {
                    variablesToCopyTo.add((YoVariable)new YoBoolean(name, registry));
                    continue block6;
                }
                case ENUM: {
                    throw new RuntimeException("Help Twan!");
                }
            }
            throw new RuntimeException("Should not get here!");
        }
    }

    private void createRandomRegistriesAndVariables(YoWhiteBoard whiteBoardOne, YoWhiteBoard whiteBoardTwo, int numberOfRegistries, int numberVariablesToReadOneWriteTwo, int numberVariablesToWriteOneReadTwo) {
        this.createRandomRegistriesAndVariables(whiteBoardOne, numberOfRegistries, numberVariablesToReadOneWriteTwo, numberVariablesToWriteOneReadTwo);
        this.createVariableCopyFromReadToWrite(whiteBoardOne, whiteBoardTwo);
    }

    private void createRandomRegistriesAndVariables(YoWhiteBoard whiteBoard, int numberOfRegistries, int numberVariablesToRead, int numberVariablesToWrite) {
        Random random = new Random(1776L);
        ArrayList<YoRegistry> registryList = this.generateRandomRegistries(random, numberOfRegistries);
        whiteBoard.setVariablesToRead(this.generateRandomVariables(random, "readVariable", numberVariablesToRead, registryList));
        whiteBoard.setVariablesToWrite(this.generateRandomVariables(random, "writeVariable", numberVariablesToWrite, registryList));
    }

    private ArrayList<YoVariable> generateRandomVariables(Random random, String namePrefix, int numberOfVariables, ArrayList<YoRegistry> registryList) {
        ArrayList<YoVariable> variables = new ArrayList<YoVariable>();
        block5: for (int i = 0; i < numberOfVariables; ++i) {
            int registryIndex = random.nextInt(registryList.size());
            YoRegistry registry = registryList.get(registryIndex);
            int variableType = random.nextInt(3);
            String name = namePrefix + i;
            switch (variableType) {
                case 0: {
                    variables.add((YoVariable)new YoDouble(name, registry));
                    continue block5;
                }
                case 1: {
                    variables.add((YoVariable)new YoInteger(name, registry));
                    continue block5;
                }
                case 2: {
                    variables.add((YoVariable)new YoBoolean(name, registry));
                    continue block5;
                }
                default: {
                    throw new RuntimeException("Shouldn't get here!");
                }
            }
        }
        return variables;
    }

    private ArrayList<YoRegistry> generateRandomRegistries(Random random, int numberOfRegistries) {
        ArrayList<YoRegistry> ret = new ArrayList<YoRegistry>();
        YoRegistry rootRegistry = new YoRegistry("root");
        ret.add(rootRegistry);
        for (int i = 0; i < numberOfRegistries; ++i) {
            YoRegistry registry = new YoRegistry("registry" + i);
            int registryIndex = random.nextInt(ret.size());
            YoRegistry parentRegistry = ret.get(registryIndex);
            parentRegistry.addChild(registry);
            ret.add(registry);
        }
        return ret;
    }

    private final class DoNothingWhiteBoard
    extends YoWhiteBoard {
        public DoNothingWhiteBoard() {
            super("DoNothing", new YoRegistry("DoNothingWhiteBoard"));
        }

        public void whiteBoardSpecificWriteData(double[] doubleVariablesToWriteBuffer, int[] intVariablesToWriteBuffer, boolean[] booleanVariablesToWriteBuffer, int[] enumVariablesToWriteBuffer, int writeIndex) throws IOException {
        }

        public void whiteBoardSpecificConnect() throws IOException {
        }

        public void closeYoWhiteBoard() throws IOException {
        }
    }

    private class YoWhiteBoardListenerForTest
    implements YoWhiteBoardListener {
        private boolean newDataReady = false;
        private boolean hasReceivedNewDataBeforeReset = false;

        private YoWhiteBoardListenerForTest() {
        }

        public void receivedWhiteBoardData() {
            if (this.newDataReady) {
                this.hasReceivedNewDataBeforeReset = true;
            }
            this.newDataReady = true;
        }

        public void reset() {
            this.newDataReady = false;
        }

        public boolean isNewDataReady() {
            return this.newDataReady;
        }

        public boolean hasReceivedNewDataBeforeReset() {
            return this.hasReceivedNewDataBeforeReset;
        }
    }
}

