/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.util.ground;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.simulationConstructionSetTools.util.ground.MeshTerrainObject;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class MeshTerrainObjectTest {
    private static final boolean SHOW_VISUALIZATION = false;
    private static final double SPHERE_RADIUS = 0.01;
    private static final double CUBE_DIMESNION = 0.01;
    private static SimulationConstructionSet scs = null;
    private static final int NUMBER_OF_ITERATIONS = 10000;
    private static final double MAXIMUM_ERROR = 0.01;
    private static final double BUFFER_VALUE = 0.03;
    private static final Random RANDOM = new Random(1200L);
    private static double legoBlockAZoneMaximumZValue = 0.22;
    private static double legoBlockAZoneMinimumZValue = -0.22;
    private static double legoBlockAZoneMaximumYValue = 0.47;
    private static double legoBlockAZoneMinimumYValue = 0.03;
    private static double legoBlockCZoneMaximumZValue = -0.03;
    private static double legoBlockCZoneMinimumZValue = -0.47;
    private static double legoBlockCZoneMaximumYValue = -0.03;
    private static double legoBlockCZoneMinimumYValue = -0.47;
    private static double legoBlockCommaZoneMaximumZValue = -0.28;
    private static double legoBlockCommaZoneMinimumZValue = -4.97;
    private static double legoBlockCommaZoneMaximumYValue = 0.47;
    private static double legoBlockCommaZoneMinimumYValue = 0.03;
    private static double legoBlockDotZoneMaximumZValue = 4.97;
    private static double legoBlockDotZoneMinimumZValue = 0.03;
    private static double legoBlockDotZoneMaximumYValue = -0.03;
    private static double legoBlockDotZoneMinimumYValue = -0.47;
    private static double legoBlockMaximumXValue = 0.47;
    private static double legoBlockMinimumXValue = 0.03;
    private static double hShapeAZoneMaximumZValue = 0.47;
    private static double hShapeAZoneMinimumZValue = -0.47;
    private static double hShapeAZoneMaximumXValue = -0.28;
    private static double hShapeAZoneMinimumXValue = -0.47;
    private static double hShapeAZoneMaximumYValue = 0.22;
    private static double hShapeAZoneMinimumYValue = -0.22;
    private static double hShapeBZoneMaximumZValue = 0.22;
    private static double hShapeBZoneMinimumZValue = -0.22;
    private static double hShapeBZoneMaximumXValue = 0.22;
    private static double hShapeBZoneMinimumXValue = -0.22;
    private static double hShapeBZoneMaximumYValue = 0.22;
    private static double hShapeBZoneMinimumYValue = -0.22;
    private static double hShapeCommaZoneMaximumZValue = 0.47;
    private static double hShapeCommaZoneMinimumZValue = 0.28;
    private static double hShapeDotZoneMaximumZValue = -0.28;
    private static double hShapeDotZoneMinimumZValue = -0.47;

    @AfterEach
    public void tearDown() {
        if (scs != null) {
            scs.closeAndDispose();
            scs = null;
        }
    }

    @Test
    public void testWithVisualization() {
    }

    @Test
    public void testintersectionWithVerticalLine() {
        String relativeFilePath = "models/legoBlock/legoBlock.obj";
        MeshTerrainObject meshTerrainObject = new MeshTerrainObject(relativeFilePath);
        this.showVisualization(meshTerrainObject);
        for (int i = 0; i < 10000; ++i) {
            double randomX = legoBlockMinimumXValue + (legoBlockMaximumXValue - legoBlockMinimumXValue) * RANDOM.nextDouble();
            double randomY = legoBlockAZoneMinimumYValue + (legoBlockAZoneMaximumYValue - legoBlockAZoneMinimumYValue) * RANDOM.nextDouble();
            MeshTerrainObject.IntersectionResult intersectionResult = meshTerrainObject.intersectionWithVerticalLine(randomX, randomY);
            Point3D actualHighestPoint = new Point3D(randomX, randomY, legoBlockAZoneMaximumZValue);
            Point3D actualLowestPoint = new Point3D(randomX, randomY, legoBlockAZoneMinimumZValue);
            Point3D highestPoint = intersectionResult.getHighestIntersection();
            Point3D lowestPoint = intersectionResult.getLowestIntersection();
            Assertions.assertTrue((boolean)intersectionResult.isHighestPointValid());
            Assertions.assertEquals((double)actualHighestPoint.differenceNormSquared((Tuple3DReadOnly)highestPoint), (double)0.0, (double)0.01);
            Assertions.assertEquals((double)actualLowestPoint.differenceNormSquared((Tuple3DReadOnly)lowestPoint), (double)0.0, (double)0.01);
            randomX = legoBlockMinimumXValue + (legoBlockMaximumXValue - legoBlockMinimumXValue) * RANDOM.nextDouble();
            randomY = legoBlockCZoneMinimumYValue + (legoBlockCZoneMaximumYValue - legoBlockCZoneMinimumYValue) * RANDOM.nextDouble();
            intersectionResult = meshTerrainObject.intersectionWithVerticalLine(randomX, randomY);
            actualHighestPoint = new Point3D(randomX, randomY, legoBlockCZoneMaximumZValue);
            actualLowestPoint = new Point3D(randomX, randomY, legoBlockCZoneMinimumZValue);
            highestPoint = intersectionResult.getHighestIntersection();
            lowestPoint = intersectionResult.getLowestIntersection();
            String randomLocationAsString = "x:" + randomX + "   y:" + randomY;
            Assertions.assertTrue((boolean)intersectionResult.isHighestPointValid());
            Assertions.assertEquals((double)actualHighestPoint.differenceNormSquared((Tuple3DReadOnly)highestPoint), (double)0.0, (double)0.01, (String)randomLocationAsString);
            Assertions.assertEquals((double)actualLowestPoint.differenceNormSquared((Tuple3DReadOnly)lowestPoint), (double)0.0, (double)0.01, (String)randomLocationAsString);
            randomX = (0.6 + 5.0 * RANDOM.nextDouble()) * (double)(RANDOM.nextBoolean() ? 1 : -1);
            randomY = (0.6 + 5.0 * RANDOM.nextDouble()) * (double)(RANDOM.nextBoolean() ? 1 : -1);
            intersectionResult = meshTerrainObject.intersectionWithVerticalLine(randomX, randomY);
            Assertions.assertFalse((boolean)intersectionResult.isHighestPointValid());
        }
    }

    @Test
    public void testHeightAt() {
        String relativeFilePath = "models/legoBlock/legoBlock.obj";
        MeshTerrainObject meshTerrainObject = new MeshTerrainObject(relativeFilePath);
        this.showVisualization(meshTerrainObject);
        for (int i = 0; i < 10000; ++i) {
            double randomX = legoBlockMinimumXValue + (legoBlockMaximumXValue - legoBlockMinimumXValue) * RANDOM.nextDouble();
            double randomY = legoBlockAZoneMinimumYValue + (legoBlockAZoneMaximumYValue - legoBlockAZoneMinimumYValue) * RANDOM.nextDouble();
            double randomZ = legoBlockAZoneMinimumYValue + (legoBlockAZoneMaximumZValue - legoBlockAZoneMinimumZValue) * RANDOM.nextDouble();
            String randomLocationAsString = "x:" + randomX + " y:" + randomY + " z:" + randomZ;
            double heightAtValue = meshTerrainObject.heightAt(randomX, randomY, randomZ);
            double actualHeightAtValue = legoBlockAZoneMaximumZValue + 0.03;
            Assertions.assertEquals((double)heightAtValue, (double)actualHeightAtValue, (double)0.01, (String)randomLocationAsString);
            randomY = legoBlockCZoneMinimumYValue + (legoBlockCZoneMaximumYValue - legoBlockCZoneMinimumYValue) * RANDOM.nextDouble();
            randomX = legoBlockMinimumXValue + (legoBlockMaximumXValue - legoBlockMinimumXValue) * RANDOM.nextDouble();
            randomZ = legoBlockCZoneMinimumYValue + (legoBlockCZoneMaximumZValue - legoBlockCZoneMinimumZValue) * RANDOM.nextDouble();
            randomLocationAsString = "x:" + randomX + " y:" + randomY + " z:" + randomZ;
            heightAtValue = meshTerrainObject.heightAt(randomX, randomY, randomZ);
            actualHeightAtValue = legoBlockCZoneMaximumZValue + 0.03;
            Assertions.assertEquals((double)heightAtValue, (double)actualHeightAtValue, (double)0.01, (String)randomLocationAsString);
            randomY = legoBlockDotZoneMinimumYValue + (legoBlockDotZoneMaximumYValue - legoBlockDotZoneMinimumYValue) * RANDOM.nextDouble();
            randomX = legoBlockMinimumXValue + (legoBlockMaximumXValue - legoBlockMinimumXValue) * RANDOM.nextDouble();
            randomZ = legoBlockDotZoneMinimumYValue + (legoBlockDotZoneMaximumZValue - legoBlockDotZoneMinimumZValue) * RANDOM.nextDouble();
            randomLocationAsString = "x:" + randomX + " y:" + randomY + " z:" + randomZ;
            heightAtValue = meshTerrainObject.heightAt(randomX, randomY, randomZ);
            if ((int)heightAtValue * 1000 == -116) {
                System.out.println(heightAtValue);
            }
            actualHeightAtValue = legoBlockDotZoneMinimumZValue - 0.03;
            Assertions.assertEquals((double)heightAtValue, (double)actualHeightAtValue, (double)0.01, (String)randomLocationAsString);
            randomY = legoBlockCommaZoneMinimumYValue + (legoBlockCommaZoneMaximumYValue - legoBlockCommaZoneMinimumYValue) * RANDOM.nextDouble();
            randomX = legoBlockMinimumXValue + (legoBlockMaximumXValue - legoBlockMinimumXValue) * RANDOM.nextDouble();
            randomZ = legoBlockCommaZoneMinimumZValue + (legoBlockCommaZoneMaximumZValue - legoBlockCommaZoneMinimumZValue) * RANDOM.nextDouble();
            randomLocationAsString = "x:" + randomX + " y:" + randomY + " z:" + randomZ;
            heightAtValue = meshTerrainObject.heightAt(randomX, randomY, randomZ);
            actualHeightAtValue = Double.NEGATIVE_INFINITY;
            Assertions.assertEquals((double)heightAtValue, (double)actualHeightAtValue, (double)0.01, (String)randomLocationAsString);
        }
    }

    public void showVisualization(MeshTerrainObject meshTerrainObject) {
    }

    @Test
    public void testHeightAndNormalAt() {
        String relativeFilePath = "models/hShape/hShape.obj";
        MeshTerrainObject meshTerrainObject = new MeshTerrainObject(relativeFilePath);
        this.showVisualization(meshTerrainObject);
        Vector3D normalToPack = new Vector3D(0.0, 0.0, 0.0);
        Vector3D acualNormalToPack = new Vector3D(0.0, 0.0, 1.0);
        for (int i = 0; i < 10000; ++i) {
            double randomX = hShapeAZoneMinimumXValue + (hShapeAZoneMaximumXValue - hShapeAZoneMinimumXValue) * RANDOM.nextDouble();
            double randomY = hShapeAZoneMinimumYValue + (hShapeAZoneMaximumYValue - hShapeAZoneMinimumYValue) * RANDOM.nextDouble();
            double randomZ = hShapeAZoneMinimumZValue + (hShapeAZoneMaximumZValue - hShapeAZoneMinimumZValue) * RANDOM.nextDouble();
            double actualHeightAtValue = hShapeAZoneMaximumZValue + 0.03;
            double heightAtValue = meshTerrainObject.heightAndNormalAt(randomX, randomY, randomZ, (Vector3DBasics)normalToPack);
            Assertions.assertEquals((double)actualHeightAtValue, (double)heightAtValue, (double)0.01);
            Assertions.assertEquals((double)acualNormalToPack.differenceNormSquared((Tuple3DReadOnly)normalToPack), (double)0.0, (double)0.01);
        }
    }

    @Test
    public void testCheckIfInside() {
        String relativeFilePath = "models/hShape/hShape.obj";
        MeshTerrainObject meshTerrainObject = new MeshTerrainObject(relativeFilePath);
        this.showVisualization(meshTerrainObject);
        Point3D intersectionToPack = new Point3D(0.0, 0.0, 0.0);
        Vector3D normalToPack = new Vector3D(0.0, 0.0, 0.0);
        Vector3D acualNormalToPack = new Vector3D(0.0, 0.0, 1.0);
        for (int i = 0; i < 10000; ++i) {
            double randomX = hShapeBZoneMinimumXValue + (hShapeBZoneMaximumXValue - hShapeBZoneMinimumXValue) * RANDOM.nextDouble();
            double randomY = hShapeBZoneMinimumYValue + (hShapeBZoneMaximumYValue - hShapeBZoneMinimumYValue) * RANDOM.nextDouble();
            double randomZ = hShapeBZoneMinimumZValue + (hShapeBZoneMaximumZValue - hShapeBZoneMinimumZValue) * RANDOM.nextDouble();
            Point3D actualIntersectionToPack = new Point3D(randomX, randomY, hShapeBZoneMaximumZValue);
            boolean isInside = meshTerrainObject.checkIfInside(randomX, randomY, randomZ, (Point3DBasics)intersectionToPack, (Vector3DBasics)normalToPack);
            Assertions.assertTrue((boolean)isInside);
            Assertions.assertEquals((double)actualIntersectionToPack.differenceNormSquared((Tuple3DReadOnly)intersectionToPack), (double)0.0, (double)0.01);
            Assertions.assertEquals((double)acualNormalToPack.differenceNormSquared((Tuple3DReadOnly)normalToPack), (double)0.0, (double)0.01);
            randomX = hShapeBZoneMinimumXValue + (hShapeBZoneMaximumXValue - hShapeBZoneMinimumXValue) * RANDOM.nextDouble();
            randomY = hShapeBZoneMinimumYValue + (hShapeBZoneMaximumYValue - hShapeBZoneMinimumYValue) * RANDOM.nextDouble();
            randomZ = hShapeCommaZoneMinimumZValue + (hShapeCommaZoneMaximumZValue - hShapeCommaZoneMinimumZValue) * RANDOM.nextDouble();
            actualIntersectionToPack = new Point3D(randomX, randomY, hShapeCommaZoneMinimumZValue);
            isInside = meshTerrainObject.checkIfInside(randomX, randomY, randomZ, (Point3DBasics)intersectionToPack, (Vector3DBasics)normalToPack);
            Assertions.assertFalse((boolean)isInside);
            Assertions.assertEquals((double)actualIntersectionToPack.differenceNormSquared((Tuple3DReadOnly)intersectionToPack), (double)0.0, (double)0.01);
            Assertions.assertEquals((double)acualNormalToPack.differenceNormSquared((Tuple3DReadOnly)normalToPack), (double)0.0, (double)0.01);
            randomX = hShapeBZoneMinimumXValue + (hShapeBZoneMaximumXValue - hShapeBZoneMinimumXValue) * RANDOM.nextDouble();
            randomY = hShapeBZoneMinimumYValue + (hShapeBZoneMaximumYValue - hShapeBZoneMinimumYValue) * RANDOM.nextDouble();
            randomZ = hShapeDotZoneMinimumZValue + (hShapeDotZoneMaximumZValue - hShapeDotZoneMinimumZValue) * RANDOM.nextDouble();
            actualIntersectionToPack = new Point3D(randomX, randomY, Double.NEGATIVE_INFINITY);
            isInside = meshTerrainObject.checkIfInside(randomX, randomY, randomZ, (Point3DBasics)intersectionToPack, (Vector3DBasics)normalToPack);
            Assertions.assertFalse((boolean)isInside);
            Assertions.assertEquals((double)intersectionToPack.getZ(), (double)Double.NEGATIVE_INFINITY);
        }
    }

    @Test
    public void testMeshTerrainObjectAfterTransformation() {
        String meshPath = "models/cube/cube.obj";
        double cubeSideLength = 0.25;
        double cubeCenterInXOrYOrZ = cubeSideLength / 2.0;
        double squareDiagonalLength = cubeSideLength * Math.sqrt(2.0);
        double minimumXValue = cubeCenterInXOrYOrZ + 0.03 - squareDiagonalLength / 2.0;
        double maximumXValue = cubeCenterInXOrYOrZ - 0.03 + squareDiagonalLength / 2.0;
        Vector3D normalToPack = new Vector3D(0.0, 0.0, 0.0);
        Vector3D actualNormalToPack = new Vector3D(0.0, 0.0, 1.0);
        Quaternion rotateOnAllAxisBy90Deg = new Quaternion(1.5707963267948966, 1.5707963267948966, 1.5707963267948966);
        Quaternion rotateOnXAxisBy45Deg = new Quaternion(0.0, 0.0, 0.7853981633974483);
        Quaternion rotateOnYAxisBy45Deg = new Quaternion(0.0, 0.7853981633974483, 0.0);
        MeshTerrainObject meshObjectRotatedOnXAxisBy90Deg = MeshTerrainObjectTest.makeRotatedMeshTerrainObject(rotateOnAllAxisBy90Deg, cubeSideLength, meshPath);
        MeshTerrainObject meshObjectRotatedOnXAxisBy45Deg = MeshTerrainObjectTest.makeRotatedMeshTerrainObject(rotateOnXAxisBy45Deg, cubeSideLength, meshPath);
        MeshTerrainObject meshObjectRotatedOnYAxisBy45Deg = MeshTerrainObjectTest.makeRotatedMeshTerrainObject(rotateOnYAxisBy45Deg, cubeSideLength, meshPath);
        this.showVisualization(meshObjectRotatedOnXAxisBy90Deg);
        this.showVisualization(meshObjectRotatedOnXAxisBy45Deg);
        this.showVisualization(meshObjectRotatedOnYAxisBy45Deg);
        for (int i = 0; i < 10000; ++i) {
            double randomX = 0.03 + (cubeSideLength - 0.06) * RANDOM.nextDouble();
            double randomY = 0.03 + (cubeSideLength - 0.06) * RANDOM.nextDouble();
            double randomZ = cubeSideLength * 5.0 + RANDOM.nextDouble();
            double heightAtValue = meshObjectRotatedOnXAxisBy90Deg.heightAndNormalAt(randomX, randomY, randomZ, (Vector3DBasics)normalToPack);
            double actualHeightAtValue = cubeSideLength;
            actualNormalToPack = new Vector3D(0.0, 0.0, 1.0);
            Assertions.assertEquals((double)actualHeightAtValue, (double)heightAtValue, (double)0.01);
            Assertions.assertEquals((double)actualNormalToPack.differenceNormSquared((Tuple3DReadOnly)normalToPack), (double)0.0, (double)0.01);
            randomX = minimumXValue + (cubeSideLength / 2.0 - 0.03) * RANDOM.nextDouble();
            randomY = 0.03 + (cubeSideLength - 0.06) * RANDOM.nextDouble();
            randomZ = cubeSideLength * 5.0 + RANDOM.nextDouble();
            heightAtValue = meshObjectRotatedOnYAxisBy45Deg.heightAndNormalAt(randomX, randomY, randomZ, (Vector3DBasics)normalToPack);
            actualHeightAtValue = cubeSideLength;
            actualNormalToPack = new Vector3D(-1.0 / Math.sqrt(2.0), 0.0, 1.0 / Math.sqrt(2.0));
            Assertions.assertEquals((double)actualNormalToPack.differenceNormSquared((Tuple3DReadOnly)normalToPack), (double)0.0, (double)0.01);
            randomX = maximumXValue - (cubeSideLength / 2.0 - 0.06) * RANDOM.nextDouble();
            randomY = 0.03 + (cubeSideLength - 0.06) * RANDOM.nextDouble();
            randomZ = cubeSideLength * 5.0 + RANDOM.nextDouble();
            heightAtValue = meshObjectRotatedOnYAxisBy45Deg.heightAndNormalAt(randomX, randomY, randomZ, (Vector3DBasics)normalToPack);
            actualNormalToPack = new Vector3D(1.0 / Math.sqrt(2.0), 0.0, 1.0 / Math.sqrt(2.0));
            Assertions.assertEquals((double)actualNormalToPack.differenceNormSquared((Tuple3DReadOnly)normalToPack), (double)0.0, (double)0.01);
            randomX = 0.03 + (cubeSideLength - 0.06) * RANDOM.nextDouble();
            randomY = minimumXValue + (cubeSideLength / 2.0 - 0.03) * RANDOM.nextDouble();
            randomZ = cubeSideLength * 5.0 + RANDOM.nextDouble();
            heightAtValue = meshObjectRotatedOnXAxisBy45Deg.heightAndNormalAt(randomX, randomY, randomZ, (Vector3DBasics)normalToPack);
            actualHeightAtValue = cubeSideLength;
            actualNormalToPack = new Vector3D(0.0, -1.0 / Math.sqrt(2.0), 1.0 / Math.sqrt(2.0));
            Assertions.assertEquals((double)actualNormalToPack.differenceNormSquared((Tuple3DReadOnly)normalToPack), (double)0.0, (double)0.01);
            randomX = 0.03 + (cubeSideLength - 0.06) * RANDOM.nextDouble();
            randomY = maximumXValue - (cubeSideLength / 2.0 - 0.06) * RANDOM.nextDouble();
            randomZ = cubeSideLength * 5.0 + RANDOM.nextDouble();
            heightAtValue = meshObjectRotatedOnXAxisBy45Deg.heightAndNormalAt(randomX, randomY, randomZ, (Vector3DBasics)normalToPack);
            actualNormalToPack = new Vector3D(0.0, 1.0 / Math.sqrt(2.0), 1.0 / Math.sqrt(2.0));
            Assertions.assertEquals((double)actualNormalToPack.differenceNormSquared((Tuple3DReadOnly)normalToPack), (double)0.0, (double)0.01);
        }
    }

    public static MeshTerrainObject makeRotatedMeshTerrainObject(Quaternion orientation, double cubeLength, String meshPath) {
        RigidBodyTransform configuration = new RigidBodyTransform();
        Vector3D translation = new Vector3D(cubeLength / 2.0, cubeLength / 2.0, cubeLength / 2.0);
        configuration.set((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)translation);
        MeshTerrainObject meshTerrainObject = new MeshTerrainObject(meshPath, (RigidBodyTransformReadOnly)configuration);
        return meshTerrainObject;
    }

    @Test
    public void testIsClose() {
        String legoBlockRelativeFilePath = "models/legoBlock/legoBlock.obj";
        MeshTerrainObject legoBlockMeshTerrainObject = new MeshTerrainObject(legoBlockRelativeFilePath);
        String hShapeRelativeFilePath = "models/hShape/hShape.obj";
        MeshTerrainObject hShapeMeshTerrainObject = new MeshTerrainObject(hShapeRelativeFilePath);
        double legoBlockMaximumXValue = 0.5;
        double legoBlockMinimumXValue = 0.0;
        double legoBlockMaximumYValue = 0.5;
        double legoBlockMinimumYValue = -0.5;
        double legoBlockMaximumZValue = 0.25;
        double legoBlockMinimumZValue = -0.5;
        double hShapeMaximumYValue = 0.25;
        double hShapeMinimumYValue = -0.25;
        double hShapeMaximumXValue = 0.5;
        double hShapeMinimumXValue = -0.5;
        double hShapeMaximumZValue = 0.5;
        double hShapeMinimumZValue = -0.5;
        for (int i = 0; i < 10000; ++i) {
            double randomX = legoBlockMinimumXValue + 0.03 + (legoBlockMaximumXValue - legoBlockMinimumXValue - 0.06) * RANDOM.nextDouble();
            double randomY = legoBlockMinimumYValue + 0.03 + (legoBlockMaximumYValue - legoBlockMinimumYValue - 0.06) * RANDOM.nextDouble();
            double randomZ = legoBlockMinimumZValue + 0.03 + (legoBlockMaximumZValue - legoBlockMinimumZValue - 0.06) * RANDOM.nextDouble();
            String randomLocation = "x:" + randomX + "   z:" + randomY + "  y:" + randomZ;
            Assertions.assertTrue((boolean)legoBlockMeshTerrainObject.isClose(randomX, randomY, randomZ), (String)randomLocation);
            randomX = (1.1 * legoBlockMaximumXValue + RANDOM.nextDouble() * 5.0) * (double)(RANDOM.nextBoolean() ? 1 : -1);
            randomX = (1.1 * legoBlockMaximumYValue + RANDOM.nextDouble() * 5.0) * (double)(RANDOM.nextBoolean() ? 1 : -1);
            randomX = (1.1 * legoBlockMinimumZValue - RANDOM.nextDouble() * 5.0) * (double)(RANDOM.nextBoolean() ? 1 : -1);
            randomLocation = "x:" + randomX + "   z:" + randomY + "  y:" + randomZ;
            Assertions.assertFalse((boolean)legoBlockMeshTerrainObject.isClose(randomX, randomY, randomZ), (String)randomLocation);
            randomX = hShapeMinimumXValue + 0.03 + (hShapeMaximumXValue - hShapeMinimumXValue - 0.06) * RANDOM.nextDouble();
            randomY = hShapeMinimumYValue + 0.03 + (hShapeMaximumYValue - hShapeMinimumYValue - 0.06) * RANDOM.nextDouble();
            randomZ = hShapeMinimumZValue + 0.03 + (hShapeMaximumZValue - hShapeMinimumZValue - 0.06) * RANDOM.nextDouble();
            randomLocation = "x:" + randomX + "   z:" + randomY + "  y:" + randomZ;
            Assertions.assertTrue((boolean)hShapeMeshTerrainObject.isClose(randomX, randomY, randomZ), (String)randomLocation);
            randomX = (1.1 * hShapeMaximumXValue + RANDOM.nextDouble() * 5.0) * (double)(RANDOM.nextBoolean() ? 1 : -1);
            randomX = (1.1 * hShapeMaximumYValue + RANDOM.nextDouble() * 5.0) * (double)(RANDOM.nextBoolean() ? 1 : -1);
            randomX = (1.1 * hShapeMaximumZValue + RANDOM.nextDouble() * 5.0) * (double)(RANDOM.nextBoolean() ? 1 : -1);
            randomLocation = "x:" + randomX + "   z:" + randomY + "  y:" + randomZ;
            Assertions.assertFalse((boolean)legoBlockMeshTerrainObject.isClose(randomX, randomY, randomZ), (String)randomLocation);
        }
    }

    public static void addArrowForNormal(Double xPoint, Double yPoint, Double heightAt, Vector3D normal) {
        YoRegistry robotsYoVariableRegistry = new YoRegistry("surfaceNormals");
        YoFramePoint3D planarRegionPointInWorld = new YoFramePoint3D("arrow", ReferenceFrame.getWorldFrame(), robotsYoVariableRegistry);
        Point3D translation = new Point3D(xPoint.doubleValue(), yPoint.doubleValue(), heightAt.doubleValue());
        planarRegionPointInWorld.set((Tuple3DReadOnly)translation);
        YoFrameVector3D surfaceNormal = new YoFrameVector3D("NormalVector", ReferenceFrame.getWorldFrame(), robotsYoVariableRegistry);
        surfaceNormal.set((Tuple3DReadOnly)normal);
        YoGraphicVector surfaceNormalGraphic = new YoGraphicVector("PlanarRegionSurfaceNormalGraphic", planarRegionPointInWorld, surfaceNormal, YoAppearance.Aqua());
        scs.addYoGraphic((YoGraphic)surfaceNormalGraphic);
    }

    private static void addGraphicWithTestPoints(Graphics3DObject viz, MeshTerrainObject meshTerrainObject, Point3D point, AppearanceDefinition lineAppearance) {
        Double xPoint = point.getX();
        Double yPoint = point.getY();
        Double zPoint = point.getZ();
        Vector3D normalToPack = new Vector3D();
        normalToPack.set(0.0, 0.0, 0.0);
        double result = meshTerrainObject.heightAndNormalAt(xPoint.doubleValue(), yPoint.doubleValue(), zPoint.doubleValue(), (Vector3DBasics)normalToPack);
        if (result != Double.NEGATIVE_INFINITY) {
            MeshTerrainObjectTest.addArrowForNormal(xPoint, yPoint, result, normalToPack);
            viz.identity();
            viz.translate(xPoint.doubleValue(), yPoint.doubleValue(), zPoint.doubleValue());
            viz.addSphere(0.01, YoAppearance.Red());
            viz.identity();
            viz.translate(xPoint.doubleValue(), yPoint.doubleValue(), result);
            viz.addSphere(0.01, YoAppearance.Yellow());
        } else {
            viz.identity();
            viz.translate(xPoint.doubleValue(), yPoint.doubleValue(), zPoint.doubleValue());
            viz.addCube(0.01, 0.01, 0.01, YoAppearance.Red());
        }
        viz.identity();
        viz.translate(xPoint.doubleValue(), yPoint.doubleValue(), -500.0);
        viz.addCylinder(1000.0, 0.008, lineAppearance);
    }
}

