/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.simulationTesting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import us.ihmc.commons.MathTools;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoVariableListComparer {
    private final double epsilon;
    private final List<YoVariable[]> differences = new ArrayList<YoVariable[]>();
    private List<String> exceptions = new ArrayList<String>();

    public YoVariableListComparer(double epsilon) {
        this.epsilon = epsilon;
    }

    public boolean compare(List<YoVariable> allVariables0, List<YoVariable> allVariables1) {
        this.differences.clear();
        Comparator<YoVariable> alphabeticOrderComparator = new Comparator<YoVariable>(){

            @Override
            public int compare(YoVariable arg0, YoVariable arg1) {
                return arg0.getFullNameString().compareTo(arg1.getFullNameString());
            }
        };
        Collections.sort(allVariables0, alphabeticOrderComparator);
        Collections.sort(allVariables1, alphabeticOrderComparator);
        allVariables0 = this.removeExceptionalVariables(allVariables0);
        allVariables1 = this.removeExceptionalVariables(allVariables1);
        int index0 = 0;
        int size0 = allVariables0.size();
        int size1 = allVariables1.size();
        for (int index1 = 0; index0 < size0 && index1 < size1; ++index0, ++index1) {
            YoVariable var0 = allVariables0.get(index0);
            YoVariable var1 = allVariables1.get(index1);
            double val0 = var0.getValueAsDouble();
            double val1 = var1.getValueAsDouble();
            if (!var0.getFullNameString().equals(var1.getFullNameString())) {
                this.addDifference(var0, var1);
                continue;
            }
            if (Double.isNaN(val0)) {
                if (Double.isNaN(val1)) continue;
                this.addDifference(var0, var1);
                continue;
            }
            if (Double.isInfinite(val0)) {
                if (!Double.isInfinite(val1)) {
                    this.addDifference(var0, var1);
                }
                if (Math.signum(val0) == Math.signum(val1)) continue;
                this.addDifference(var0, var1);
                continue;
            }
            if (MathTools.epsilonEquals((double)val0, (double)var1.getValueAsDouble(), (double)this.epsilon)) continue;
            this.addDifference(var0, var1);
        }
        if (size0 != size1) {
            return false;
        }
        return this.differences.isEmpty();
    }

    private List<YoVariable> removeExceptionalVariables(List<YoVariable> variables) {
        ArrayList<YoVariable> variablesWithoutExceptions = new ArrayList<YoVariable>();
        for (int i = 0; i < variables.size(); ++i) {
            YoVariable variable = variables.get(i);
            if (YoVariableListComparer.isException(this.exceptions, variable)) continue;
            variablesWithoutExceptions.add(variable);
        }
        return variablesWithoutExceptions;
    }

    private void addDifference(YoVariable var0, YoVariable var1) {
        YoVariable[] difference = new YoVariable[]{var0, var1};
        this.differences.add(difference);
    }

    public List<YoVariable[]> getDifferences() {
        return this.differences;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Differences:\n");
        for (YoVariable[] difference : this.differences) {
            buf.append(difference[0]);
            buf.append("\n");
            buf.append(difference[1]);
            buf.append("\n\n");
        }
        return buf.toString();
    }

    public void addException(String exception) {
        this.exceptions.add(exception);
    }

    private static boolean isException(List<String> exceptions, YoVariable variable) {
        boolean isException = false;
        if (exceptions != null) {
            for (String exceptionName : exceptions) {
                String lowerCaseExceptionString;
                String lowerCaseVariableName = variable.getFullNameString().toLowerCase();
                isException = lowerCaseVariableName.contains(lowerCaseExceptionString = exceptionName.toLowerCase());
                if (!isException) continue;
                return isException;
            }
        }
        return isException;
    }
}

