/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.simulationTesting;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationConstructionSetTools.simulationTesting.AllYoVariablesSimulationComparer;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.util.ControllerFailureException;
import us.ihmc.simulationconstructionset.util.simulationRunner.BlockingSimulationRunner;
import us.ihmc.simulationconstructionset.util.simulationRunner.StateFileComparer;
import us.ihmc.simulationconstructionset.util.simulationRunner.VariableDifference;
import us.ihmc.yoVariables.variable.YoVariable;

public class SimulationTestTools {
    public static void compare(List<File> stateFiles, SimulationConstructionSet scs, List<String> namesToSkipOver) {
        double maxPercentDiff = Double.MIN_VALUE;
        ArrayList variableDifferences = StateFileComparer.percentualCompareStateFiles((File)stateFiles.get(0), (File)stateFiles.get(1), (double)maxPercentDiff, namesToSkipOver);
        SimulationTestTools.deleteStateFiles(stateFiles);
        SimulationTestTools.assertChangedVarsEmpty(scs, variableDifferences);
        scs = null;
    }

    public static SimulationConstructionSet runNumberOfTicks(SimulationConstructionSet scs, int nTicks) {
        scs.simulate(nTicks);
        SimulationTestTools.waitForSimulationToFinish(scs);
        return scs;
    }

    public static ArrayList<File> createStateFiles(int nStateFiles) {
        ArrayList<File> stateFiles = new ArrayList<File>();
        for (int i = 0; i < nStateFiles; ++i) {
            stateFiles.add(new File("stateFile" + i));
        }
        return stateFiles;
    }

    public static void compareStateFiles(ArrayList<File> stateFiles, SimulationConstructionSet scs) {
        double maxPercentDiff = Double.MIN_VALUE;
        ArrayList variableDifferences = StateFileComparer.percentualCompareStateFiles((File)stateFiles.get(0), (File)stateFiles.get(1), (double)maxPercentDiff, null);
        SimulationTestTools.deleteStateFiles(stateFiles);
        SimulationTestTools.assertChangedVarsEmpty(scs, variableDifferences);
    }

    private static void waitForSimulationToFinish(SimulationConstructionSet scs) {
        while (scs.isSimulating()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static void deleteStateFiles(List<File> stateFiles) {
        for (File stateFile : stateFiles) {
            stateFile.delete();
        }
    }

    public static void assertChangedVarsEmpty(SimulationConstructionSet scs, List<VariableDifference> variableDifferences) {
        String message = SimulationTestTools.createFailMessage(scs.getVariables(), variableDifferences);
        scs = null;
        Assert.assertEquals((String)message, (Object)true, (Object)variableDifferences.isEmpty());
    }

    private static String createFailMessage(List<YoVariable> allVariables, List<VariableDifference> variableDifferences) {
        String numberOfVarsChangedString = variableDifferences.size() + " out of " + allVariables.size() + " YoVariables changed.\n";
        String changedVarsString = "Changed vars:\n" + VariableDifference.allVariableDifferencesToString(variableDifferences);
        String message = numberOfVarsChangedString + changedVarsString;
        return message;
    }

    public static void testRewindabilitySimple(SimulationConstructionSet scs, double simulationTime, ArrayList<String> namesToSkipOver) throws BlockingSimulationRunner.SimulationExceededMaximumTimeException {
        int nStateFiles = 2;
        ArrayList<File> stateFiles = SimulationTestTools.createStateFiles(nStateFiles);
        for (int i = 0; i < nStateFiles; ++i) {
            scs.simulate(simulationTime);
            BlockingSimulationRunner.waitForSimulationToFinish((SimulationConstructionSet)scs, (double)120.0, (boolean)true);
            scs.writeState(stateFiles.get(i));
            scs.gotoInPointNow();
            Assert.assertEquals((long)scs.getCurrentIndex(), (long)0L);
        }
        SimulationTestTools.compare(stateFiles, scs, namesToSkipOver);
    }

    public static void testRewindabilityNumberOfTicks(SimulationConstructionSet scs, int nTicks, List<String> namesToSkipOver) throws BlockingSimulationRunner.SimulationExceededMaximumTimeException {
        int nStateFiles = 2;
        ArrayList<File> stateFiles = SimulationTestTools.createStateFiles(nStateFiles);
        for (int i = 0; i < nStateFiles; ++i) {
            scs.simulate(nTicks);
            BlockingSimulationRunner.waitForSimulationToFinish((SimulationConstructionSet)scs, (double)120.0, (boolean)true);
            scs.writeState(stateFiles.get(i));
            scs.gotoInPointNow();
            Assert.assertEquals((long)scs.getCurrentIndex(), (long)0L);
        }
        SimulationTestTools.compare(stateFiles, scs, namesToSkipOver);
    }

    public static void testRandom(ArrayList<SimulationConstructionSet> scss, Random random) throws BlockingSimulationRunner.SimulationExceededMaximumTimeException {
        double epsilon = 1.0E-12;
        double maximumClockRunTimeInSeconds = 120.0;
        int nIterations = 10;
        double maxSimTime = 0.25;
        double maxRewindTime = 0.5;
        AllYoVariablesSimulationComparer comparer = new AllYoVariablesSimulationComparer(epsilon);
        comparer.addException("DurationMilli");
        comparer.addException("TimeNano");
        for (int i = 0; i < nIterations; ++i) {
            int y;
            double simTime = random.nextDouble() * maxSimTime;
            for (y = 0; y < scss.size(); ++y) {
                scss.get(y).simulate(simTime);
            }
            for (y = 0; y < scss.size(); ++y) {
                BlockingSimulationRunner.waitForSimulationToFinish((SimulationConstructionSet)scss.get(y), (double)maximumClockRunTimeInSeconds, (boolean)true);
            }
            double rewindTime = random.nextDouble() * maxRewindTime;
            scss.get(0).setInPoint();
            scss.get(0).simulate(rewindTime);
            scss.get(1).simulate(1);
            for (int y2 = 0; y2 < scss.size(); ++y2) {
                BlockingSimulationRunner.waitForSimulationToFinish((SimulationConstructionSet)scss.get(y2), (double)maximumClockRunTimeInSeconds, (boolean)true);
            }
            scss.get(0).gotoInPointNow();
            scss.get(0).simulate(1);
            BlockingSimulationRunner.waitForSimulationToFinish((SimulationConstructionSet)scss.get(0), (double)maximumClockRunTimeInSeconds, (boolean)true);
            Assert.assertEquals((String)"indices not the same", (long)scss.get(0).getCurrentIndex(), (long)scss.get(1).getCurrentIndex());
            Assert.assertEquals((String)"times not the same", (double)scss.get(0).getRobots()[0].getTime(), (double)scss.get(1).getRobots()[0].getTime(), (double)epsilon);
            boolean result = comparer.compare(scss.get(0), scss.get(1));
            if (result) continue;
            Assert.fail((String)comparer.toString());
        }
    }

    public static void testInitialValuesStoredCorrectly(SimulationConstructionSet scs, List<String> namesToSkipOver, double maximumClockRunTimeInSeconds) throws BlockingSimulationRunner.SimulationExceededMaximumTimeException, ControllerFailureException {
        namesToSkipOver.add("qdd_");
        int nStateFiles = 2;
        ArrayList<File> stateFiles = SimulationTestTools.createStateFiles(nStateFiles);
        scs.writeState(stateFiles.get(0));
        BlockingSimulationRunner blockingSimulationRunner = new BlockingSimulationRunner(scs, maximumClockRunTimeInSeconds, true);
        blockingSimulationRunner.simulateNTicksAndBlock(1);
        scs.stepBackwardNow();
        scs.writeState(stateFiles.get(1));
        SimulationTestTools.compare(stateFiles, scs, namesToSkipOver);
    }
}

