/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.optimization;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationConstructionSetTools.optimization.SimpleControllerToOptimize;
import us.ihmc.simulationConstructionSetTools.optimization.SimpleRobotToOptimize;
import us.ihmc.simulationConstructionSetTools.optimization.SimpleSimulationIndividualToEvaluate;
import us.ihmc.utilities.parameterOptimization.IndividualToEvaluate;
import us.ihmc.utilities.parameterOptimization.ListOfParametersToOptimize;
import us.ihmc.utilities.parameterOptimization.OptimizationProblem;
import us.ihmc.utilities.parameterOptimization.SimpleRandomGradientDecentParameterOptimizer;

public class SimpleSimulationTest {
    @Test
    public void testSimpleSimulation() {
        SimpleRobotToOptimize robot = new SimpleRobotToOptimize();
        SimpleControllerToOptimize controller = new SimpleControllerToOptimize();
        robot.setController(controller);
        SimpleSimulationIndividualToEvaluate costFunction = new SimpleSimulationIndividualToEvaluate();
        double stepChange = 0.01;
        Random random = new Random(1984L);
        SimpleRandomGradientDecentParameterOptimizer optimizer = new SimpleRandomGradientDecentParameterOptimizer(random, stepChange);
        boolean maximize = false;
        double cutoffFitness = Double.NEGATIVE_INFINITY;
        int maximumNumberOfIndividualsToEvaluate = 1000;
        OptimizationProblem optimizationProblem = new OptimizationProblem((IndividualToEvaluate)costFunction, maximize, cutoffFitness, maximumNumberOfIndividualsToEvaluate);
        IndividualToEvaluate optimalIndividualToEvaluate = optimizer.optimize(optimizationProblem);
        ListOfParametersToOptimize optimalListOfParametersToOptimize = optimalIndividualToEvaluate.getAllParametersToOptimize();
        controller.setCurrentValues(optimalListOfParametersToOptimize);
        controller.printParameters(optimalListOfParametersToOptimize);
        Assert.assertTrue((boolean)controller.verifyParametersCloseToOptimal());
    }
}

