/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.simulationTesting;

import us.ihmc.simulationConstructionSetTools.simulationTesting.SimulationComparisonScript;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;

public class SimpleRewindabilityComparisonScript
implements SimulationComparisonScript {
    private final boolean DEBUG = false;
    private final int nTicksInitial;
    private final int nTicksCompare;
    private final int nTicksFinal;

    public SimpleRewindabilityComparisonScript(int nTicksInitial, int nTicksCompare, int nTicksFinal) {
        this.nTicksInitial = nTicksInitial;
        this.nTicksCompare = nTicksCompare;
        this.nTicksFinal = nTicksFinal;
    }

    @Override
    public void doInitialAction(SimulationConstructionSet scs0, SimulationConstructionSet scs1) {
        SimulationConstructionSet[] scss;
        if (scs0.getRecordFreq() != scs1.getRecordFreq()) {
            throw new RuntimeException("scs0.getRecordFreq() != scs1.getRecordFreq()");
        }
        if ((long)this.nTicksInitial % scs0.getRecordFreq() != 0L) {
            throw new RuntimeException("nTicksInitial must be divisible by record frequency!");
        }
        for (SimulationConstructionSet scs : scss = new SimulationConstructionSet[]{scs0, scs1}) {
            scs.simulate(this.nTicksInitial);
        }
        for (SimulationConstructionSet scs : scss) {
            this.waitForSimulationToFinish(scs);
        }
    }

    @Override
    public void doFinalAction(SimulationConstructionSet scs0, SimulationConstructionSet scs1) {
        SimulationConstructionSet[] scss;
        if (scs0.getRecordFreq() != scs1.getRecordFreq()) {
            throw new RuntimeException("scs0.getRecordFreq() != scs1.getRecordFreq()");
        }
        if ((long)this.nTicksCompare % scs0.getRecordFreq() != 0L) {
            throw new RuntimeException("nTicksCompare must be divisible by record frequency!");
        }
        if ((long)this.nTicksFinal % scs0.getRecordFreq() != 0L) {
            throw new RuntimeException("nTicksFinal must be divisible by record frequency!");
        }
        for (SimulationConstructionSet scs : scss = new SimulationConstructionSet[]{scs0, scs1}) {
            scs.setInPoint();
        }
        scs0.simulate(this.nTicksCompare);
        this.waitForSimulationToFinish(scs0);
        boolean index = false;
        for (SimulationConstructionSet scs : scss) {
            scs.gotoInPointNow();
            scs.simulate(this.nTicksFinal);
            this.waitForSimulationToFinish(scs);
        }
    }

    private void waitForSimulationToFinish(SimulationConstructionSet scs) {
        while (scs.isSimulating()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

