/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.joystick;

import java.util.Random;
import net.java.games.input.Component;
import net.java.games.input.Event;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationConstructionSetTools.joystick.DoubleYoVariableJoystickEventListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoDoubleJoystickEventListenerTest {
    @Test
    public void testMinMaxAverage() {
        YoRegistry registry = new YoRegistry("test");
        YoDouble variable = new YoDouble("test", registry);
        TestComponent component = new TestComponent();
        component.setAnalog(true);
        component.setDeadZone(0.0f);
        int nTests = 100;
        for (int i = 0; i < nTests; ++i) {
            Random random = new Random(12342L);
            double min = random.nextDouble() - 0.5;
            double max = min + random.nextDouble();
            double deadZone = 0.0;
            boolean signFlip = false;
            DoubleYoVariableJoystickEventListener listener = new DoubleYoVariableJoystickEventListener(variable, (Component)component, min, max, deadZone, signFlip);
            Event event = new Event();
            event.set((Component)component, -1.0f, 0L);
            listener.processEvent(event);
            Assert.assertEquals((double)min, (double)variable.getDoubleValue(), (double)0.0);
            event.set((Component)component, 1.0f, 0L);
            listener.processEvent(event);
            Assert.assertEquals((double)max, (double)variable.getDoubleValue(), (double)0.0);
            event.set((Component)component, 0.0f, 0L);
            listener.processEvent(event);
            Assert.assertEquals((double)((min + max) / 2.0), (double)variable.getDoubleValue(), (double)0.0);
        }
    }

    private final class TestComponent
    implements Component {
        private boolean isRelative;
        private boolean isAnalog;
        private float pollData;
        private String name;
        private Component.Identifier identifier;
        private float deadZone;

        private TestComponent() {
        }

        public boolean isRelative() {
            return this.isRelative;
        }

        public boolean isAnalog() {
            return this.isAnalog;
        }

        public float getPollData() {
            return this.pollData;
        }

        public String getName() {
            return this.name;
        }

        public Component.Identifier getIdentifier() {
            return this.identifier;
        }

        public float getDeadZone() {
            return this.deadZone;
        }

        public void setRelative(boolean isRelative) {
            this.isRelative = isRelative;
        }

        public void setAnalog(boolean isAnalog) {
            this.isAnalog = isAnalog;
        }

        public void setPollData(float pollData) {
            this.pollData = pollData;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setIdentifier(Component.Identifier identifier) {
            this.identifier = identifier;
        }

        public void setDeadZone(float deadZone) {
            this.deadZone = deadZone;
        }
    }
}

