/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.util.ground;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.simulationConstructionSetTools.util.ground.PlanarRegionTerrainObject;

public class PlanarRegionTerrainObjectTest {
    private static final double DEFAULT_ALLOWABLE_PENETRATION_THICKNESS = 100000.0;

    @Test
    public void testHeightAt() throws Exception {
        Random random = new Random(1776L);
        for (int i = 0; i < 100000; ++i) {
            PlanarRegion planarRegion = PlanarRegion.generatePlanarRegionFromRandomPolygonsWithRandomTransform((Random)random, (int)random.nextInt(10), (double)RandomNumbers.nextDouble((Random)random, (double)0.0, (double)30.0), (int)(3 + random.nextInt(10)));
            BoundingBox3D boundingBox3dInWorld = planarRegion.getBoundingBox3dInWorld();
            double randomXCoord = RandomNumbers.nextDouble((Random)random, (double)(boundingBox3dInWorld.getMinX() - 10.0), (double)(boundingBox3dInWorld.getMaxX() + 10.0));
            double randomYCoord = RandomNumbers.nextDouble((Random)random, (double)(boundingBox3dInWorld.getMinY() - 10.0), (double)(boundingBox3dInWorld.getMaxY() + 10.0));
            double randomZCoord = RandomNumbers.nextDouble((Random)random, (double)(boundingBox3dInWorld.getMinZ() - 10.0), (double)(boundingBox3dInWorld.getMaxZ() + 10.0));
            PlanarRegionTerrainObject terrainObject = new PlanarRegionTerrainObject(planarRegion, 100000.0);
            double planarRegionZAtXY = planarRegion.getPlaneZGivenXY(randomXCoord, randomYCoord);
            if (planarRegion.isPointInsideByProjectionOntoXYPlane(randomXCoord, randomYCoord)) {
                Assert.assertEquals((double)planarRegionZAtXY, (double)terrainObject.heightAt(randomXCoord, randomYCoord, randomZCoord), (double)1.0E-10);
                continue;
            }
            Assert.assertNotEquals((double)planarRegionZAtXY, (double)terrainObject.heightAt(randomXCoord, randomYCoord, randomZCoord), (double)1.0E-10);
        }
    }

    @Test
    public void testHeightAndNormalAt() {
        Random random = new Random(1776L);
        Vector3D terrainObjectNormalToPack = new Vector3D();
        Vector3D expectedTerrainNormal = new Vector3D();
        Vector3D standardGroundNormal = new Vector3D(0.0, 0.0, 1.0);
        for (int i = 0; i < 100000; ++i) {
            PlanarRegion planarRegion = PlanarRegion.generatePlanarRegionFromRandomPolygonsWithRandomTransform((Random)random, (int)random.nextInt(10), (double)RandomNumbers.nextDouble((Random)random, (double)0.0, (double)30.0), (int)(3 + random.nextInt(10)));
            BoundingBox3D boundingBox3dInWorld = planarRegion.getBoundingBox3dInWorld();
            double randomXCoord = RandomNumbers.nextDouble((Random)random, (double)(boundingBox3dInWorld.getMinX() - 10.0), (double)(boundingBox3dInWorld.getMaxX() + 10.0));
            double randomYCoord = RandomNumbers.nextDouble((Random)random, (double)(boundingBox3dInWorld.getMinY() - 10.0), (double)(boundingBox3dInWorld.getMaxY() + 10.0));
            double randomZCoord = RandomNumbers.nextDouble((Random)random, (double)(boundingBox3dInWorld.getMinZ() - 10.0), (double)(boundingBox3dInWorld.getMaxZ() + 10.0));
            PlanarRegionTerrainObject terrainObject = new PlanarRegionTerrainObject(planarRegion, 100000.0);
            double planarRegionZAtXY = planarRegion.getPlaneZGivenXY(randomXCoord, randomYCoord);
            double heightAt = terrainObject.heightAndNormalAt(randomXCoord, randomYCoord, randomZCoord, (Vector3DBasics)terrainObjectNormalToPack);
            planarRegion.getNormal((Vector3DBasics)expectedTerrainNormal);
            if (planarRegion.getNormal().getZ() < 0.0) {
                expectedTerrainNormal.negate();
            }
            if (planarRegion.isPointInsideByProjectionOntoXYPlane(randomXCoord, randomYCoord)) {
                Assert.assertEquals((double)planarRegionZAtXY, (double)heightAt, (double)1.0E-10);
                EuclidCoreTestTools.assertTuple3DEquals((String)"Normals are not equal!", (Tuple3DReadOnly)terrainObjectNormalToPack, (Tuple3DReadOnly)expectedTerrainNormal, (double)1.0E-10);
                continue;
            }
            Assert.assertNotEquals((double)planarRegionZAtXY, (double)heightAt, (double)1.0E-10);
            EuclidCoreTestTools.assertTuple3DEquals((String)"Normals are not equal!", (Tuple3DReadOnly)standardGroundNormal, (Tuple3DReadOnly)terrainObjectNormalToPack, (double)1.0E-10);
        }
    }

    @Test
    public void testGetBoundingBox() throws Exception {
        Random random = new Random(1776L);
        Point3D planarRegionBoundingBoxMinPoint = new Point3D();
        Point3D planarRegionBoundingBoxMaxPoint = new Point3D();
        Point3D terrainObjectBoundingBoxMinPoint = new Point3D();
        Point3D terrainObjectBoundingBoxMaxPoint = new Point3D();
        for (int i = 0; i < 100000; ++i) {
            int numberOfRandomlyGeneratedPolygons = random.nextInt(10);
            double maxAbsoluteXYForPolygons = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)30.0);
            PlanarRegion planarRegion = PlanarRegion.generatePlanarRegionFromRandomPolygonsWithRandomTransform((Random)random, (int)numberOfRandomlyGeneratedPolygons, (double)maxAbsoluteXYForPolygons, (int)numberOfRandomlyGeneratedPolygons);
            PlanarRegionTerrainObject terrainObject = new PlanarRegionTerrainObject(planarRegion, 100000.0);
            planarRegionBoundingBoxMinPoint.set((Tuple3DReadOnly)planarRegion.getBoundingBox3dInWorld().getMinPoint());
            planarRegionBoundingBoxMaxPoint.set((Tuple3DReadOnly)planarRegion.getBoundingBox3dInWorld().getMaxPoint());
            terrainObjectBoundingBoxMinPoint.set((Tuple3DReadOnly)terrainObject.getBoundingBox().getMinPoint());
            terrainObjectBoundingBoxMaxPoint.set((Tuple3DReadOnly)terrainObject.getBoundingBox().getMaxPoint());
            if (numberOfRandomlyGeneratedPolygons == 0) {
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)planarRegionBoundingBoxMinPoint);
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)planarRegionBoundingBoxMaxPoint);
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)terrainObjectBoundingBoxMinPoint);
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)terrainObjectBoundingBoxMaxPoint);
                continue;
            }
            EuclidCoreTestTools.assertTuple3DEquals((String)"Bounding box min points are not equal!", (Tuple3DReadOnly)planarRegionBoundingBoxMinPoint, (Tuple3DReadOnly)terrainObjectBoundingBoxMinPoint, (double)1.0E-10);
            EuclidCoreTestTools.assertTuple3DEquals((String)"Bounding box max points are not equal!", (Tuple3DReadOnly)planarRegionBoundingBoxMaxPoint, (Tuple3DReadOnly)terrainObjectBoundingBoxMaxPoint, (double)1.0E-10);
        }
    }

    @Test
    public void testIsClose() throws Exception {
        Random random = new Random(1776L);
        for (int i = 0; i < 100000; ++i) {
            PlanarRegion planarRegion = PlanarRegion.generatePlanarRegionFromRandomPolygonsWithRandomTransform((Random)random, (int)random.nextInt(10), (double)RandomNumbers.nextDouble((Random)random, (double)0.0, (double)30.0), (int)(3 + random.nextInt(10)));
            BoundingBox3D boundingBox3dInWorld = planarRegion.getBoundingBox3dInWorld();
            double randomXCoord = RandomNumbers.nextDouble((Random)random, (double)(boundingBox3dInWorld.getMinX() - 10.0), (double)(boundingBox3dInWorld.getMaxX() + 10.0));
            double randomYCoord = RandomNumbers.nextDouble((Random)random, (double)(boundingBox3dInWorld.getMinY() - 10.0), (double)(boundingBox3dInWorld.getMaxY() + 10.0));
            double randomZCoord = RandomNumbers.nextDouble((Random)random, (double)(boundingBox3dInWorld.getMinZ() - 10.0), (double)(boundingBox3dInWorld.getMaxZ() + 10.0));
            PlanarRegionTerrainObject terrainObject = new PlanarRegionTerrainObject(planarRegion, 100000.0);
            if (boundingBox3dInWorld.isXYInsideInclusive(randomXCoord, randomYCoord)) {
                Assert.assertTrue((boolean)terrainObject.isClose(randomXCoord, randomYCoord, randomZCoord));
                continue;
            }
            Assert.assertFalse((boolean)terrainObject.isClose(randomXCoord, randomYCoord, randomZCoord));
        }
    }

    @Test
    public void testCheckIfInside() throws Exception {
        Random random = new Random(1776L);
        RigidBodyTransform transformToWorld = new RigidBodyTransform();
        Vector3D translation = new Vector3D();
        Point3D randomPoint = new Point3D();
        Vector3D planarRegionSurfaceNormal = new Vector3D();
        Vector3D terrainObjectNormalToPack = new Vector3D();
        Point3D terrainObjectIntersectionToPack = new Point3D();
        for (int i = 0; i < 100000; ++i) {
            PlanarRegion planarRegion = PlanarRegion.generatePlanarRegionFromRandomPolygonsWithRandomTransform((Random)random, (int)random.nextInt(10), (double)RandomNumbers.nextDouble((Random)random, (double)0.0, (double)30.0), (int)(3 + random.nextInt(10)));
            double randomXCoord = RandomNumbers.nextDouble((Random)random, (double)15.0);
            double randomYCoord = RandomNumbers.nextDouble((Random)random, (double)15.0);
            boolean shouldGeneratePointGuaranteedOnPlane = random.nextBoolean();
            double randomZCoord = shouldGeneratePointGuaranteedOnPlane && planarRegion.isPointInsideByProjectionOntoXYPlane(randomXCoord, randomYCoord) ? planarRegion.getPlaneZGivenXY(randomXCoord, randomYCoord) + RandomNumbers.nextDouble((Random)random, (double)1.0E-8) : RandomNumbers.nextDouble((Random)random, (double)15.0);
            randomPoint.set(randomXCoord, randomYCoord, randomZCoord);
            PlanarRegionTerrainObject terrainObject = new PlanarRegionTerrainObject(planarRegion, 100000.0);
            planarRegion.getTransformToWorld(transformToWorld);
            translation.set((Tuple3DReadOnly)transformToWorld.getTranslation());
            planarRegion.getNormal((Vector3DBasics)planarRegionSurfaceNormal);
            if (planarRegion.isPointOnOrSlightlyBelow((Point3DReadOnly)randomPoint, 100000.0)) {
                Assert.assertTrue((boolean)terrainObject.checkIfInside(randomXCoord, randomYCoord, randomZCoord, (Point3DBasics)terrainObjectIntersectionToPack, (Vector3DBasics)terrainObjectNormalToPack));
                EuclidCoreTestTools.assertTuple3DEquals((String)"Intersection to pack is not correct!", (Tuple3DReadOnly)randomPoint, (Tuple3DReadOnly)terrainObjectIntersectionToPack, (double)1.0E-10);
                EuclidCoreTestTools.assertTuple3DEquals((String)"Surface normal to pack is not correct!", (Tuple3DReadOnly)planarRegionSurfaceNormal, (Tuple3DReadOnly)terrainObjectNormalToPack, (double)1.0E-10);
                continue;
            }
            Assert.assertFalse((boolean)terrainObject.checkIfInside(randomXCoord, randomYCoord, randomZCoord, null, null));
        }
    }

    @Test
    public void testCheckIfInsideAlongBoxEdges() {
        Random random = new Random(38923L);
        for (int i = 0; i < 10000; ++i) {
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            double boxWidth = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0, (double)5.0);
            double allowablePenetrationThickness = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)0.1);
            ConvexPolygon2D polygon = new ConvexPolygon2D();
            polygon.addVertex(0.5 * boxWidth, 0.5 * boxWidth);
            polygon.addVertex(0.5 * boxWidth, -0.5 * boxWidth);
            polygon.addVertex(-0.5 * boxWidth, 0.5 * boxWidth);
            polygon.addVertex(-0.5 * boxWidth, -0.5 * boxWidth);
            polygon.update();
            PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transform, (Vertex2DSupplier)polygon);
            PlanarRegionTerrainObject terrainObject = new PlanarRegionTerrainObject(planarRegion, allowablePenetrationThickness);
            double epsilon = 1.0E-7;
            ArrayList<Point3D> insidePoints = new ArrayList<Point3D>();
            insidePoints.add(new Point3D(0.0, 0.0, -epsilon));
            insidePoints.add(new Point3D(-0.5 * boxWidth + epsilon, 0.0, -epsilon));
            insidePoints.add(new Point3D(-0.5 * boxWidth + epsilon, 0.5 * boxWidth - epsilon, -epsilon));
            insidePoints.add(new Point3D(0.0, 0.0, -allowablePenetrationThickness + epsilon));
            insidePoints.add(new Point3D(0.5 * boxWidth - epsilon, 0.5 * boxWidth - epsilon, -allowablePenetrationThickness + epsilon));
            insidePoints.add(new Point3D(-0.5 * boxWidth + epsilon, 0.5 * boxWidth - epsilon, -allowablePenetrationThickness + epsilon));
            ArrayList<Point3D> outsidePoints = new ArrayList<Point3D>();
            outsidePoints.add(new Point3D(0.0, 0.0, epsilon));
            outsidePoints.add(new Point3D(-0.5 * boxWidth - epsilon, 0.0, -epsilon));
            outsidePoints.add(new Point3D(-0.5 * boxWidth + epsilon, 0.5 * boxWidth + epsilon, -epsilon));
            outsidePoints.add(new Point3D(0.0, 0.0, -allowablePenetrationThickness - epsilon));
            outsidePoints.add(new Point3D(0.5 * boxWidth + epsilon, 0.5 * boxWidth - epsilon, -allowablePenetrationThickness + epsilon));
            outsidePoints.add(new Point3D(-0.5 * boxWidth + epsilon, 0.5 * boxWidth - epsilon, -allowablePenetrationThickness - epsilon));
            outsidePoints.add(new Point3D(3.0 * boxWidth, 3.0 * boxWidth, 5.0 * allowablePenetrationThickness));
            boolean regionFacesDown = planarRegion.getNormal().getZ() < 0.0;
            for (Point3D point : insidePoints) {
                Vector3D expectedNormal = new Vector3D((Tuple3DReadOnly)planarRegion.getNormal());
                if (regionFacesDown) {
                    point.setZ(-point.getZ());
                    expectedNormal.negate();
                }
                point.applyTransform((Transform)transform);
                Vector3D normal = new Vector3D();
                boolean isInside = terrainObject.checkIfInside(point.getX(), point.getY(), point.getZ(), (Point3DBasics)new Point3D(), (Vector3DBasics)normal);
                Assertions.assertTrue((boolean)isInside);
                Assertions.assertTrue((boolean)expectedNormal.epsilonEquals(normal, epsilon));
            }
            for (Point3D point : outsidePoints) {
                if (regionFacesDown) {
                    point.setZ(-point.getZ());
                }
                point.applyTransform((Transform)transform);
                boolean isInside = terrainObject.checkIfInside(point.getX(), point.getY(), point.getZ(), (Point3DBasics)new Point3D(), (Vector3DBasics)new Vector3D());
                Assertions.assertFalse((boolean)isInside);
            }
        }
    }
}

