/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.simulationTesting;

import java.lang.reflect.Field;
import java.util.Collection;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationConstructionSetTools.simulationTesting.ReflectionSimulationComparer;
import us.ihmc.simulationConstructionSetTools.simulationTesting.SimpleRewindabilityComparisonScript;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.tools.MemoryTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoInteger;

public class ReflectionSimulationComparerTest {
    @BeforeEach
    public void showMemoryUsageBeforeTest() {
        MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)(this.getClass().getSimpleName() + " before test."));
    }

    @AfterEach
    public void showMemoryUsageAfterTest() {
        MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)(this.getClass().getSimpleName() + " after test."));
    }

    @Test
    public void testTwoEmptySimulations() {
        ReflectionSimulationComparer comparer = new ReflectionSimulationComparer(Integer.MAX_VALUE, Integer.MAX_VALUE);
        SimulationConstructionSetParameters parameters = new SimulationConstructionSetParameters();
        parameters.setCreateGUI(false);
        parameters.setDataBufferSize(100);
        SimulationConstructionSet scs0 = new SimulationConstructionSet(new Robot("Null"), parameters);
        SimulationConstructionSet scs1 = new SimulationConstructionSet(new Robot("Null"), parameters);
        boolean simulationsAreTheSame = comparer.compare(scs0, scs1);
        Assert.assertFalse((boolean)simulationsAreTheSame);
        simulationsAreTheSame = comparer.compare(scs0, scs1);
        Assert.assertFalse((boolean)simulationsAreTheSame);
        Collection<Field> differingFields = comparer.getDifferingFields();
        Assert.assertEquals((long)2L, (long)differingFields.size());
        for (Field field : differingFields) {
            String fieldName = field.getName();
            Assert.assertTrue((boolean)fieldName.equals("hash"));
        }
        comparer = new ReflectionSimulationComparer(Integer.MAX_VALUE, Integer.MAX_VALUE);
        comparer.addFieldsToIgnore(differingFields);
        simulationsAreTheSame = comparer.compare(scs0, scs1);
        Assert.assertTrue((boolean)simulationsAreTheSame);
    }

    @Test
    public void testTwoRewindableSimulationsWithAScript() throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, UnreasonableAccelerationException {
        Robot robot0 = this.createSimpleRobot();
        RewindableOrNotRewindableController rewindableController0 = new RewindableOrNotRewindableController(true);
        robot0.setController((RobotController)rewindableController0);
        SimulationConstructionSetParameters parameters = new SimulationConstructionSetParameters();
        parameters.setCreateGUI(false);
        parameters.setDataBufferSize(100);
        SimulationConstructionSet scs0 = new SimulationConstructionSet(robot0, parameters);
        scs0.setDT(1.0E-4, 11);
        scs0.startOnAThread();
        Robot robot1 = this.createSimpleRobot();
        RewindableOrNotRewindableController rewindableController1 = new RewindableOrNotRewindableController(true);
        robot1.setController((RobotController)rewindableController1);
        SimulationConstructionSet scs1 = new SimulationConstructionSet(robot1, parameters);
        scs1.setDT(1.0E-4, 11);
        scs1.startOnAThread();
        int nTicksInitial = 121;
        int nTicksCompare = 121;
        int nTicksFinal = 11;
        SimpleRewindabilityComparisonScript script = new SimpleRewindabilityComparisonScript(nTicksInitial, nTicksCompare, nTicksFinal);
        ReflectionSimulationComparer.compareTwoSimulations(scs0, scs1, script, true, true);
    }

    private Robot createSimpleRobot() {
        Robot robot0 = new Robot("robot");
        FloatingJoint floatingJoint0 = new FloatingJoint("floatingJoint", (Tuple3DReadOnly)new Vector3D(), robot0);
        Link link0 = new Link("body");
        link0.setMass(1.0);
        link0.setMomentOfInertia(0.1, 0.1, 0.1);
        floatingJoint0.setLink(link0);
        robot0.addRootJoint((Joint)floatingJoint0);
        return robot0;
    }

    @Test
    public void testTwoNonRewindableSimulationsWithAScript() throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, UnreasonableAccelerationException {
        Robot robot0 = new Robot("robot");
        RewindableOrNotRewindableController rewindableController0 = new RewindableOrNotRewindableController(false);
        robot0.setController((RobotController)rewindableController0);
        SimulationConstructionSetParameters parameters = new SimulationConstructionSetParameters();
        parameters.setCreateGUI(false);
        parameters.setDataBufferSize(100);
        SimulationConstructionSet scs0 = new SimulationConstructionSet(robot0, parameters);
        scs0.setDT(1.0E-4, 10);
        scs0.startOnAThread();
        Robot robot1 = new Robot("robot");
        RewindableOrNotRewindableController rewindableController1 = new RewindableOrNotRewindableController(false);
        robot1.setController((RobotController)rewindableController1);
        SimulationConstructionSet scs1 = new SimulationConstructionSet(robot1, parameters);
        scs1.setDT(1.0E-4, 10);
        scs1.startOnAThread();
        int nTicksInitial = 20;
        int nTicksCompare = 30;
        int nTicksFinal = 40;
        SimpleRewindabilityComparisonScript script = new SimpleRewindabilityComparisonScript(nTicksInitial, nTicksCompare, nTicksFinal);
        ReflectionSimulationComparer.compareTwoSimulations(scs0, scs1, script, false, true);
    }

    private class RewindableOrNotRewindableController
    implements RobotController {
        private final YoRegistry registry = new YoRegistry("RewindableObject");
        private final YoInteger counter = new YoInteger("counter", this.registry);
        private int counter2;
        private final boolean isRewindable;

        public RewindableOrNotRewindableController(boolean isRewindable) {
            this.isRewindable = isRewindable;
        }

        public void initialize() {
        }

        public YoRegistry getYoRegistry() {
            return this.registry;
        }

        public String getName() {
            return "RewindableController";
        }

        public String getDescription() {
            return this.getName();
        }

        public void doControl() {
            this.counter.increment();
            if (!this.isRewindable) {
                ++this.counter2;
            }
        }
    }
}

