/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.utilities.screwTheory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.mecano.algorithms.InverseDynamicsCalculator;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.random.RandomGeometry;
import us.ihmc.robotics.referenceFrames.TranslationReferenceFrame;
import us.ihmc.robotics.screwTheory.InverseDynamicsMechanismExplorer;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.FloatingPlanarJoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SliderJoint;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.yoVariables.variable.YoDouble;

public class InverseDynamicsCalculatorSCSTest {
    private static final boolean EXPLORE_AND_PRINT = false;
    private static final Vector3D X = new Vector3D(1.0, 0.0, 0.0);
    private static final Vector3D Y = new Vector3D(0.0, 1.0, 0.0);
    private static final Vector3D Z = new Vector3D(0.0, 0.0, 1.0);
    private final Random random = new Random(100L);
    private final FrameVector3D linearVelocityFrameVector = new FrameVector3D();
    private final FrameVector3D angularVelocityFrameVector = new FrameVector3D();

    @BeforeEach
    public void setUp() {
    }

    @Test
    public void testOneFreeRigidBody() {
        Robot robot = new Robot("robot");
        double gravity = -9.81;
        robot.setGravity(gravity);
        ReferenceFrame inertialFrame = ReferenceFrame.getWorldFrame();
        RigidBody elevator = new RigidBody("elevator", inertialFrame);
        MovingReferenceFrame elevatorFrame = elevator.getBodyFixedFrame();
        FloatingJoint rootJoint = new FloatingJoint("root", (Tuple3DReadOnly)new Vector3D(0.1, 0.2, 0.3), robot);
        robot.addRootJoint((Joint)rootJoint);
        SixDoFJoint rootInverseDynamicsJoint = new SixDoFJoint("root", (RigidBodyBasics)elevator);
        Link link = this.createRandomLink("link", false);
        rootJoint.setLink(link);
        Vector3D comOffset = new Vector3D();
        link.getComOffset((Vector3DBasics)comOffset);
        RigidBodyBasics body = this.copyLinkAsRigidBody(link, (JointBasics)rootInverseDynamicsJoint, "body");
        this.setRandomPosition(rootJoint, rootInverseDynamicsJoint);
        this.setRandomVelocity(rootJoint, rootInverseDynamicsJoint);
        elevator.updateFramesRecursively();
        MovingReferenceFrame bodyFixedFrame = body.getBodyFixedFrame();
        TranslationReferenceFrame forceApplicationFrame = new TranslationReferenceFrame("forceApplicationFrame", (ReferenceFrame)bodyFixedFrame);
        Vector3D translationFromCoM = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        forceApplicationFrame.updateTranslation((Tuple3DReadOnly)translationFromCoM);
        Vector3D externalForcePointOffset = new Vector3D((Tuple3DReadOnly)comOffset);
        externalForcePointOffset.add((Tuple3DReadOnly)translationFromCoM);
        ExternalForcePoint externalForcePoint = new ExternalForcePoint("rootExternalForcePoint", (Tuple3DReadOnly)externalForcePointOffset, robot.getRobotsYoRegistry());
        rootJoint.addExternalForcePoint(externalForcePoint);
        externalForcePoint.setForce(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        Vector3D externalForce = new Vector3D();
        externalForcePoint.getForce((Vector3DBasics)externalForce);
        RigidBodyTransform worldToBody = elevatorFrame.getTransformToDesiredFrame((ReferenceFrame)forceApplicationFrame);
        worldToBody.transform((Vector3DBasics)externalForce);
        Wrench inputWrench = new Wrench((ReferenceFrame)forceApplicationFrame, (ReferenceFrame)forceApplicationFrame, (Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)externalForce);
        this.doRobotDynamics(robot);
        this.copyAccelerationFromForwardToInverse(rootJoint, rootInverseDynamicsJoint);
        InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((RigidBodyReadOnly)elevator);
        inverseDynamicsCalculator.setGravitionalAcceleration(gravity);
        inverseDynamicsCalculator.compute();
        inverseDynamicsCalculator.writeComputedJointWrenches(SubtreeStreams.fromChildren((RigidBodyBasics)elevator).collect(Collectors.toList()));
        Wrench outputWrench = new Wrench((WrenchReadOnly)rootInverseDynamicsJoint.getJointWrench());
        outputWrench.setBodyFrame((ReferenceFrame)forceApplicationFrame);
        outputWrench.changeFrame((ReferenceFrame)forceApplicationFrame);
        this.compareWrenches(inputWrench, outputWrench);
    }

    @Test
    public void testChainNoGravity() {
        Robot robot = new Robot("robot");
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        LinkedHashMap<RevoluteJoint, PinJoint> jointMap = new LinkedHashMap<RevoluteJoint, PinJoint>();
        RigidBody elevator = new RigidBody("elevator", worldFrame);
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, X};
        double gravity = 0.0;
        InverseDynamicsCalculatorSCSTest.createRandomChainRobotAndSetJointPositionsAndVelocities(robot, jointMap, worldFrame, (RigidBodyBasics)elevator, jointAxes, gravity, true, true, this.random);
        this.createInverseDynamicsCalculatorAndCompute((RigidBodyBasics)elevator, gravity, worldFrame, true, true);
        InverseDynamicsCalculatorSCSTest.copyTorques(jointMap);
        this.doRobotDynamics(robot);
        this.assertAccelerationsEqual(jointMap);
    }

    @Test
    public void testTreeWithNoGravity() {
        Robot robot = new Robot("robot");
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        LinkedHashMap<RevoluteJoint, PinJoint> jointMap = new LinkedHashMap<RevoluteJoint, PinJoint>();
        RigidBody elevator = new RigidBody("elevator", worldFrame);
        double gravity = 0.0;
        int numberOfJoints = 3;
        InverseDynamicsCalculatorSCSTest.createRandomTreeRobotAndSetJointPositionsAndVelocities(robot, jointMap, worldFrame, (RigidBodyBasics)elevator, numberOfJoints, gravity, true, true, this.random);
        this.createInverseDynamicsCalculatorAndCompute((RigidBodyBasics)elevator, gravity, worldFrame, true, true);
        InverseDynamicsCalculatorSCSTest.copyTorques(jointMap);
        this.doRobotDynamics(robot);
        this.assertAccelerationsEqual(jointMap);
    }

    @Test
    public void testTreeWithGravity() {
        Robot robot = new Robot("robot");
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        LinkedHashMap<RevoluteJoint, PinJoint> jointMap = new LinkedHashMap<RevoluteJoint, PinJoint>();
        RigidBody elevator = new RigidBody("elevator", worldFrame);
        double gravity = -9.8;
        int numberOfJoints = 100;
        InverseDynamicsCalculatorSCSTest.createRandomTreeRobotAndSetJointPositionsAndVelocities(robot, jointMap, worldFrame, (RigidBodyBasics)elevator, numberOfJoints, gravity, true, true, this.random);
        this.createInverseDynamicsCalculatorAndCompute((RigidBodyBasics)elevator, gravity, worldFrame, true, true);
        InverseDynamicsCalculatorSCSTest.copyTorques(jointMap);
        this.doRobotDynamics(robot);
        this.assertAccelerationsEqual(jointMap);
    }

    @Test
    public void testDoingInverseDynamicsTermPerTerm() {
        Robot robot = new Robot("robot");
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        LinkedHashMap<RevoluteJoint, PinJoint> jointMap = new LinkedHashMap<RevoluteJoint, PinJoint>();
        LinkedHashMap<RevoluteJoint, Double> tau_gravity = new LinkedHashMap<RevoluteJoint, Double>();
        LinkedHashMap<RevoluteJoint, Double> tau_cc = new LinkedHashMap<RevoluteJoint, Double>();
        LinkedHashMap<RevoluteJoint, Double> tau_qdd = new LinkedHashMap<RevoluteJoint, Double>();
        RigidBody elevator = new RigidBody("elevator", worldFrame);
        double gravity = -9.8;
        int numberOfJoints = 100;
        InverseDynamicsCalculatorSCSTest.createRandomTreeRobotAndSetJointPositionsAndVelocities(robot, jointMap, worldFrame, (RigidBodyBasics)elevator, numberOfJoints, gravity, true, true, this.random);
        this.createInverseDynamicsCalculatorAndCompute((RigidBodyBasics)elevator, gravity, worldFrame, false, false);
        for (RevoluteJoint joint : jointMap.keySet()) {
            tau_gravity.put(joint, joint.getTau());
        }
        this.createInverseDynamicsCalculatorAndCompute((RigidBodyBasics)elevator, 0.0, worldFrame, true, false);
        for (RevoluteJoint joint : jointMap.keySet()) {
            tau_cc.put(joint, joint.getTau());
        }
        this.createInverseDynamicsCalculatorAndCompute((RigidBodyBasics)elevator, 0.0, worldFrame, false, true);
        for (RevoluteJoint joint : jointMap.keySet()) {
            tau_qdd.put(joint, joint.getTau());
        }
        for (RevoluteJoint joint : jointMap.keySet()) {
            joint.setTau((Double)tau_qdd.get(joint) + (Double)tau_cc.get(joint) + (Double)tau_gravity.get(joint));
        }
        InverseDynamicsCalculatorSCSTest.copyTorques(jointMap);
        this.doRobotDynamics(robot);
        this.assertAccelerationsEqual(jointMap);
    }

    @Test
    public void testDoingNothing() {
        Robot robot = new Robot("robot");
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        LinkedHashMap<RevoluteJoint, PinJoint> jointMap = new LinkedHashMap<RevoluteJoint, PinJoint>();
        RigidBody elevator = new RigidBody("elevator", worldFrame);
        double gravity = -9.8;
        int numberOfJoints = 100;
        InverseDynamicsCalculatorSCSTest.createRandomTreeRobotAndSetJointPositionsAndVelocities(robot, jointMap, worldFrame, (RigidBodyBasics)elevator, numberOfJoints, gravity, true, true, this.random);
        this.createInverseDynamicsCalculatorAndCompute((RigidBodyBasics)elevator, 0.0, worldFrame, false, false);
        double epsilon = 1.0E-12;
        for (RevoluteJoint joint : jointMap.keySet()) {
            double tau = joint.getTau();
            Assert.assertEquals((double)0.0, (double)tau, (double)epsilon);
        }
    }

    @Test
    public void testGravityCompensationForChain() {
        Robot robot = new Robot("robot");
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        LinkedHashMap<RevoluteJoint, PinJoint> jointMap = new LinkedHashMap<RevoluteJoint, PinJoint>();
        RigidBody elevator = new RigidBody("elevator", worldFrame);
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, X};
        double gravity = -9.8;
        InverseDynamicsCalculatorSCSTest.createRandomChainRobotAndSetJointPositionsAndVelocities(robot, jointMap, worldFrame, (RigidBodyBasics)elevator, jointAxes, gravity, false, false, this.random);
        this.createInverseDynamicsCalculatorAndCompute((RigidBodyBasics)elevator, gravity, worldFrame, false, false);
        InverseDynamicsCalculatorSCSTest.copyTorques(jointMap);
        this.doRobotDynamics(robot);
        this.assertZeroAccelerations(jointMap);
    }

    @Test
    public void testChainWithGravity() {
        Robot robot = new Robot("robot");
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        LinkedHashMap<RevoluteJoint, PinJoint> jointMap = new LinkedHashMap<RevoluteJoint, PinJoint>();
        RigidBody elevator = new RigidBody("elevator", worldFrame);
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, X};
        double gravity = -9.8;
        InverseDynamicsCalculatorSCSTest.createRandomChainRobotAndSetJointPositionsAndVelocities(robot, jointMap, worldFrame, (RigidBodyBasics)elevator, jointAxes, gravity, true, true, this.random);
        this.createInverseDynamicsCalculatorAndCompute((RigidBodyBasics)elevator, gravity, worldFrame, true, true);
        InverseDynamicsCalculatorSCSTest.copyTorques(jointMap);
        this.doRobotDynamics(robot);
        this.assertAccelerationsEqual(jointMap);
    }

    private void exploreAndPrintRobot(Robot robot) {
        RobotExplorer robotExplorer = new RobotExplorer(robot);
        StringBuffer buffer = new StringBuffer();
        robotExplorer.getRobotInformationAsStringBuffer(buffer);
        System.out.println("-----------------------------");
        System.out.println(buffer);
        System.out.println("-----------------------------");
    }

    private void exploreAndPrintInverseDynamicsMechanism(RigidBodyBasics elevator) {
        InverseDynamicsMechanismExplorer idMechanismExplorer = new InverseDynamicsMechanismExplorer(elevator);
        System.out.println("-----------------------------");
        System.out.println(idMechanismExplorer);
        System.out.println("-----------------------------");
    }

    private InverseDynamicsCalculator createInverseDynamicsCalculatorAndCompute(RigidBodyBasics elevator, double gravity, ReferenceFrame worldFrame, boolean doVelocityTerms, boolean doAcceleration) {
        InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((RigidBodyReadOnly)elevator, doVelocityTerms, doAcceleration);
        inverseDynamicsCalculator.setGravitionalAcceleration(gravity);
        inverseDynamicsCalculator.compute();
        inverseDynamicsCalculator.writeComputedJointWrenches(SubtreeStreams.fromChildren((RigidBodyBasics)elevator).collect(Collectors.toList()));
        return inverseDynamicsCalculator;
    }

    private void compareWrenches(Wrench inputWrench, Wrench outputWrench) {
        inputWrench.getBodyFrame().checkReferenceFrameMatch(outputWrench.getBodyFrame());
        inputWrench.getReferenceFrame().checkReferenceFrameMatch(outputWrench.getReferenceFrame());
        double epsilon = 1.0E-12;
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D((Tuple3DReadOnly)inputWrench.getAngularPart()), (Tuple3DReadOnly)new Vector3D((Tuple3DReadOnly)outputWrench.getAngularPart()), (double)epsilon);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D((Tuple3DReadOnly)inputWrench.getLinearPart()), (Tuple3DReadOnly)new Vector3D((Tuple3DReadOnly)outputWrench.getLinearPart()), (double)epsilon);
    }

    private static void copyTorques(HashMap<RevoluteJoint, PinJoint> jointMap) {
        for (RevoluteJoint idJoint : jointMap.keySet()) {
            OneDegreeOfFreedomJoint joint = (OneDegreeOfFreedomJoint)jointMap.get(idJoint);
            double tau = idJoint.getTau();
            joint.setTau(tau);
        }
    }

    private void assertAccelerationsEqual(HashMap<RevoluteJoint, PinJoint> jointMap) {
        double epsilon = 1.0E-12;
        for (RevoluteJoint idJoint : jointMap.keySet()) {
            OneDegreeOfFreedomJoint revoluteJoint = (OneDegreeOfFreedomJoint)jointMap.get(idJoint);
            YoDouble qddVariable = revoluteJoint.getQDDYoVariable();
            double qdd = qddVariable.getDoubleValue();
            double qddInverse = idJoint.getQdd();
            Assert.assertEquals((double)qddInverse, (double)qdd, (double)epsilon);
        }
    }

    private void assertZeroAccelerations(HashMap<RevoluteJoint, PinJoint> jointMap) {
        double epsilon = 1.0E-12;
        for (OneDegreeOfFreedomJoint oneDegreeOfFreedomJoint : jointMap.values()) {
            double qdd = oneDegreeOfFreedomJoint.getQDDYoVariable().getDoubleValue();
            Assert.assertEquals((double)0.0, (double)qdd, (double)epsilon);
        }
    }

    private void doRobotDynamics(Robot robot) {
        try {
            robot.doDynamicsButDoNotIntegrate();
        }
        catch (UnreasonableAccelerationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void createRandomChainRobotAndSetJointPositionsAndVelocities(Robot robot, HashMap<RevoluteJoint, PinJoint> jointMap, ReferenceFrame worldFrame, RigidBodyBasics elevator, Vector3D[] jointAxes, double gravity, boolean useRandomVelocity, boolean useRandomAcceleration, Random random) {
        robot.setGravity(gravity);
        RigidBodyBasics currentIDBody = elevator;
        PinJoint previousJoint = null;
        for (int i = 0; i < jointAxes.length; ++i) {
            Vector3D jointOffset = RandomGeometry.nextVector3D((Random)random);
            Vector3D jointAxis = jointAxes[i];
            Matrix3D momentOfInertia = RandomGeometry.nextDiagonalMatrix3D((Random)random);
            double mass = random.nextDouble();
            Vector3D comOffset = RandomGeometry.nextVector3D((Random)random);
            double jointPosition = random.nextDouble();
            double jointVelocity = useRandomVelocity ? random.nextDouble() : 0.0;
            double jointAcceleration = useRandomAcceleration ? random.nextDouble() : 0.0;
            RevoluteJoint currentIDJoint = new RevoluteJoint("jointID" + i, currentIDBody, (Tuple3DReadOnly)jointOffset, (Vector3DReadOnly)jointAxis);
            currentIDJoint.setQ(jointPosition);
            currentIDJoint.setQd(jointVelocity);
            currentIDJoint.setQdd(jointAcceleration);
            currentIDBody = new RigidBody("bodyID" + i, (JointBasics)currentIDJoint, (Matrix3DReadOnly)momentOfInertia, mass, (Tuple3DReadOnly)comOffset);
            PinJoint currentJoint = new PinJoint("joint" + i, (Tuple3DReadOnly)jointOffset, robot, (Vector3DReadOnly)jointAxis);
            currentJoint.setInitialState(jointPosition, jointVelocity);
            if (previousJoint == null) {
                robot.addRootJoint((Joint)currentJoint);
            } else {
                previousJoint.addJoint((Joint)currentJoint);
            }
            Link currentBody = new Link("body" + i);
            currentBody.setComOffset((Vector3DReadOnly)comOffset);
            currentBody.setMass(mass);
            currentBody.setMomentOfInertia((Matrix3DReadOnly)momentOfInertia);
            currentJoint.setLink(currentBody);
            jointMap.put(currentIDJoint, currentJoint);
            previousJoint = currentJoint;
        }
        elevator.updateFramesRecursively();
    }

    public static void createRandomTreeRobotAndSetJointPositionsAndVelocities(Robot robot, HashMap<RevoluteJoint, PinJoint> jointMap, ReferenceFrame worldFrame, RigidBodyBasics elevator, int numberOfJoints, double gravity, boolean useRandomVelocity, boolean useRandomAcceleration, Random random) {
        robot.setGravity(gravity);
        ArrayList<PinJoint> potentialParentJoints = new ArrayList<PinJoint>();
        ArrayList<RevoluteJoint> potentialInverseDynamicsParentJoints = new ArrayList<RevoluteJoint>();
        for (int i = 0; i < numberOfJoints; ++i) {
            RigidBodyBasics inverseDynamicsParentBody;
            Vector3D jointOffset = RandomGeometry.nextVector3D((Random)random);
            Vector3D jointAxis = new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble());
            jointAxis.normalize();
            Matrix3D momentOfInertia = RandomGeometry.nextDiagonalMatrix3D((Random)random);
            double mass = random.nextDouble();
            Vector3D comOffset = RandomGeometry.nextVector3D((Random)random);
            double jointPosition = random.nextDouble();
            double jointVelocity = useRandomVelocity ? random.nextDouble() : 0.0;
            double jointAcceleration = useRandomAcceleration ? random.nextDouble() : 0.0;
            PinJoint currentJoint = new PinJoint("joint" + i, (Tuple3DReadOnly)jointOffset, robot, (Vector3DReadOnly)jointAxis);
            currentJoint.setInitialState(jointPosition, jointVelocity);
            if (potentialParentJoints.isEmpty()) {
                robot.addRootJoint((Joint)currentJoint);
                inverseDynamicsParentBody = elevator;
            } else {
                int parentIndex = random.nextInt(potentialParentJoints.size());
                ((PinJoint)potentialParentJoints.get(parentIndex)).addJoint((Joint)currentJoint);
                RevoluteJoint inverseDynamicsParentJoint = (RevoluteJoint)potentialInverseDynamicsParentJoints.get(parentIndex);
                inverseDynamicsParentBody = inverseDynamicsParentJoint.getSuccessor();
            }
            RevoluteJoint currentIDJoint = new RevoluteJoint("jointID" + i, inverseDynamicsParentBody, (Tuple3DReadOnly)jointOffset, (Vector3DReadOnly)jointAxis);
            currentIDJoint.setQ(jointPosition);
            currentIDJoint.setQd(jointVelocity);
            currentIDJoint.setQdd(jointAcceleration);
            new RigidBody("bodyID" + i, (JointBasics)currentIDJoint, (Matrix3DReadOnly)momentOfInertia, mass, (Tuple3DReadOnly)comOffset);
            Link currentBody = new Link("body" + i);
            currentBody.setComOffset((Vector3DReadOnly)comOffset);
            currentBody.setMass(mass);
            currentBody.setMomentOfInertia((Matrix3DReadOnly)momentOfInertia);
            currentJoint.setLink(currentBody);
            jointMap.put(currentIDJoint, currentJoint);
            potentialParentJoints.add(currentJoint);
            potentialInverseDynamicsParentJoints.add(currentIDJoint);
        }
        elevator.updateFramesRecursively();
    }

    private Link createRandomLink(String linkName, boolean useZeroCoMOffset) {
        Link link = new Link(linkName);
        link.setMomentOfInertia(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        link.setMass(this.random.nextDouble());
        Vector3D comOffset = useZeroCoMOffset ? new Vector3D() : new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        link.setComOffset((Vector3DReadOnly)comOffset);
        Graphics3DObject linkGraphics = new Graphics3DObject();
        Matrix3D momentOfInertia = new Matrix3D();
        link.getMomentOfInertia((Matrix3DBasics)momentOfInertia);
        double mass = link.getMass();
        linkGraphics.createInertiaEllipsoid((Matrix3DReadOnly)momentOfInertia, (Vector3DReadOnly)comOffset, mass, YoAppearance.Red());
        link.setLinkGraphics(linkGraphics);
        return link;
    }

    private RigidBodyBasics copyLinkAsRigidBody(Link link, JointBasics currentInverseDynamicsJoint, String bodyName) {
        Vector3D comOffset = new Vector3D();
        link.getComOffset((Vector3DBasics)comOffset);
        Matrix3D momentOfInertia = new Matrix3D();
        link.getMomentOfInertia((Matrix3DBasics)momentOfInertia);
        return new RigidBody(bodyName, currentInverseDynamicsJoint, (Matrix3DReadOnly)momentOfInertia, link.getMass(), (Tuple3DReadOnly)comOffset);
    }

    private void setRandomPosition(FloatingJoint floatingJoint, SixDoFJoint sixDoFJoint) {
        Point3D rootPosition = new Point3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        double yaw = this.random.nextDouble();
        double pitch = this.random.nextDouble();
        double roll = this.random.nextDouble();
        floatingJoint.setPosition((Tuple3DReadOnly)rootPosition);
        floatingJoint.setYawPitchRoll(yaw, pitch, roll);
        sixDoFJoint.setJointPosition((Tuple3DReadOnly)rootPosition);
        sixDoFJoint.getJointPose().getOrientation().setYawPitchRoll(yaw, pitch, roll);
    }

    private void setRandomVelocity(FloatingJoint floatingJoint, SixDoFJoint sixDoFJoint) {
        Vector3D linearVelocity = RandomGeometry.nextVector3D((Random)this.random, (double)1.0);
        Vector3D angularVelocity = RandomGeometry.nextVector3D((Random)this.random, (double)1.0);
        floatingJoint.setVelocity((Tuple3DReadOnly)linearVelocity);
        floatingJoint.setAngularVelocityInBody((Vector3DReadOnly)angularVelocity);
        MovingReferenceFrame elevatorFrame = sixDoFJoint.getFrameBeforeJoint();
        MovingReferenceFrame bodyFrame = sixDoFJoint.getFrameAfterJoint();
        floatingJoint.getVelocity((FrameVector3DBasics)this.linearVelocityFrameVector);
        this.linearVelocityFrameVector.changeFrame((ReferenceFrame)bodyFrame);
        floatingJoint.getAngularVelocity((FrameVector3DBasics)this.angularVelocityFrameVector, (ReferenceFrame)bodyFrame);
        Twist bodyTwist = new Twist((ReferenceFrame)bodyFrame, (ReferenceFrame)elevatorFrame, (ReferenceFrame)bodyFrame, (Vector3DReadOnly)this.angularVelocityFrameVector, (Vector3DReadOnly)this.linearVelocityFrameVector);
        sixDoFJoint.setJointTwist((TwistReadOnly)bodyTwist);
    }

    private void copyAccelerationFromForwardToInverse(FloatingJoint floatingJoint, SixDoFJoint sixDoFJoint) {
        Twist bodyTwist = new Twist();
        bodyTwist.setIncludingFrame((SpatialMotionReadOnly)sixDoFJoint.getJointTwist());
        FrameVector3D originAcceleration = new FrameVector3D((ReferenceFrame)sixDoFJoint.getFrameBeforeJoint());
        FrameVector3D angularAcceleration = new FrameVector3D((ReferenceFrame)sixDoFJoint.getFrameAfterJoint());
        floatingJoint.getLinearAccelerationInWorld((Vector3DBasics)originAcceleration);
        floatingJoint.getAngularAccelerationInBody((Vector3DBasics)angularAcceleration);
        originAcceleration.changeFrame((ReferenceFrame)sixDoFJoint.getFrameBeforeJoint());
        SpatialAcceleration spatialAccelerationVector = new SpatialAcceleration((ReferenceFrame)sixDoFJoint.getFrameAfterJoint(), (ReferenceFrame)sixDoFJoint.getFrameBeforeJoint(), (ReferenceFrame)sixDoFJoint.getFrameAfterJoint());
        spatialAccelerationVector.setBasedOnOriginAcceleration((FrameVector3DReadOnly)angularAcceleration, (FrameVector3DReadOnly)originAcceleration, (TwistReadOnly)bodyTwist);
        sixDoFJoint.setJointAcceleration((SpatialAccelerationReadOnly)spatialAccelerationVector);
    }

    private static class RobotExplorer {
        private final Robot robot;

        public RobotExplorer(Robot robot) {
            this.robot = robot;
        }

        public void getRobotInformationAsStringBuffer(StringBuffer buffer) {
            List rootJoints = this.robot.getRootJoints();
            for (Joint rootJoint : rootJoints) {
                buffer.append("Found Root Joint.\n");
                this.printJointInformation(rootJoint, buffer);
            }
        }

        private void printJointInformation(Joint joint, StringBuffer buffer) {
            String jointName = joint.getName();
            buffer.append("Joint name = " + jointName + "\n");
            Vector3D offset = new Vector3D();
            joint.getOffset((Vector3DBasics)offset);
            buffer.append("Joint offset = " + offset + "\n");
            Vector3D jointAxis = new Vector3D();
            joint.getJointAxis((Vector3DBasics)jointAxis);
            buffer.append("Joint axis = " + jointAxis + "\n");
            if (joint instanceof PinJoint) {
                this.printPinJointInformation((OneDegreeOfFreedomJoint)joint, buffer);
            } else if (joint instanceof SliderJoint) {
                this.printSliderJointInformation((SliderJoint)joint, buffer);
            } else if (joint instanceof FloatingJoint) {
                this.printFloatingJointInformation((FloatingJoint)joint, buffer);
            } else if (joint instanceof FloatingPlanarJoint) {
                this.printFloatingPlanarJointInformation((FloatingPlanarJoint)joint, buffer);
            } else {
                throw new RuntimeException("Only Pin and Slider implemented right now");
            }
            Link link = joint.getLink();
            this.printLinkInformation(link, buffer);
            List childrenJoints = joint.getChildrenJoints();
            for (Joint childJoint : childrenJoints) {
                buffer.append("Found Child Joint of " + jointName + ".\n");
                this.printJointInformation(childJoint, buffer);
            }
        }

        private void printPinJointInformation(OneDegreeOfFreedomJoint pinJoint, StringBuffer buffer) {
            buffer.append("Joint is a Pin Joint.\n");
            YoDouble q = pinJoint.getQYoVariable();
            buffer.append("Its q variable is named " + q.getName() + "\n");
        }

        private void printSliderJointInformation(SliderJoint sliderJoint, StringBuffer buffer) {
            buffer.append("Joint is a Slider Joint.\n");
            YoDouble q = sliderJoint.getQYoVariable();
            buffer.append("Its q variable is named " + q.getName() + "\n");
        }

        private void printFloatingJointInformation(FloatingJoint floatingJoint, StringBuffer buffer) {
            buffer.append("Joint is a Floating Joint.\n");
        }

        private void printFloatingPlanarJointInformation(FloatingPlanarJoint floatingPlanarJoint, StringBuffer buffer) {
            buffer.append("Joint is a Floating Planar Joint.\n");
        }

        private void printLinkInformation(Link link, StringBuffer buffer) {
            double mass = link.getMass();
            Vector3D comOffset = new Vector3D();
            link.getComOffset((Vector3DBasics)comOffset);
            Matrix3D momentOfInertia = new Matrix3D();
            link.getMomentOfInertia((Matrix3DBasics)momentOfInertia);
            buffer.append("Mass = " + mass + "\n");
            buffer.append("comOffset = " + comOffset + "\n");
            buffer.append("momentOfInertia = \n" + momentOfInertia + "\n");
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            this.getRobotInformationAsStringBuffer(buffer);
            return buffer.toString();
        }
    }
}

