/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.simulatedSensors;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.sensors.RawIMUSensorsInterface;
import us.ihmc.simulationConstructionSetTools.simulatedSensors.PerfectSimulatedIMURawSensorReader;
import us.ihmc.simulationConstructionSetTools.simulatedSensors.SimulatedIMURawSensorReader;

public class SimulatedIMURawSensorReaderTest {
    private final RawSensors rawSensors = new RawSensors();
    private final TestingRobotModel fullRobotModel = new TestingRobotModel();
    private final RigidBodyBasics rigidBody = this.fullRobotModel.getBodyLink();
    private final ReferenceFrame bodyFrame = this.fullRobotModel.getBodyFrame();
    private final RotationMatrix actualIMUOrientation = new RotationMatrix();
    private final Vector3D actualLinearAcceleration = new Vector3D();
    private final Vector3D actualAngularVelocity = new Vector3D();
    private final AxisAngle randomBodyAxisAngle = new AxisAngle();
    private final RigidBodyTransform randomTransformBodyToWorld = new RigidBodyTransform();
    private final FrameVector3D randomLinearVelocity = new FrameVector3D((ReferenceFrame)null);
    private final FrameVector3D randomAngularVelocity = new FrameVector3D((ReferenceFrame)null);
    private final FrameVector3D randomLinearAcceleration = new FrameVector3D((ReferenceFrame)null);
    private final FrameVector3D randomAngularAcceleration = new FrameVector3D((ReferenceFrame)null);
    private final RotationMatrix expectedIMUOrientation = new RotationMatrix();
    private final Vector3D expectedAngularVelocityInIMUFrame = new Vector3D();
    private final Vector3D expectedLinearAccelerationOfIMUInIMUFrame = new Vector3D();
    private final FrameVector3D jointToIMUOffset = new FrameVector3D(this.bodyFrame, 2.0 * (Math.random() - 0.5), 2.0 * (Math.random() - 0.5), 2.0 * (Math.random() - 0.5));
    private final AxisAngle jointToIMURotation = new AxisAngle(2.0 * (Math.random() - 0.5), 2.0 * (Math.random() - 0.5), 2.0 * (Math.random() - 0.5), Math.random() * 2.0 * Math.PI);
    private final RigidBodyTransform transformIMUToJoint = new RigidBodyTransform();
    private final RigidBodyTransform transformJointToIMU = new RigidBodyTransform();
    private ReferenceFrame imuFrame;
    public static final double GRAVITY = (2.0 * Math.random() - 1.0) * 15.0;
    public static final int IMU_INDEX = (int)(10.0 * Math.random());
    private SimulatedIMURawSensorReader simulatedIMURawSensorReader;

    @BeforeEach
    public void setUp() throws Exception {
        this.transformIMUToJoint.getRotation().set((Orientation3DReadOnly)this.jointToIMURotation);
        this.transformIMUToJoint.getTranslation().set((Tuple3DReadOnly)this.jointToIMUOffset);
        this.transformJointToIMU.setAndInvert((RigidBodyTransformReadOnly)this.transformIMUToJoint);
        this.imuFrame = this.fullRobotModel.createOffsetFrame(this.fullRobotModel.getBodyLink().getParentJoint(), this.transformIMUToJoint, "imuFrame");
        Vector3D linearAcceleration = new Vector3D(0.0, 0.0, GRAVITY);
        Vector3D angularAcceleration = new Vector3D();
        ReferenceFrame rootBodyFrame = this.fullRobotModel.getElevatorFrame();
        SpatialAcceleration rootAcceleration = new SpatialAcceleration(rootBodyFrame, ReferenceFrame.getWorldFrame(), rootBodyFrame, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration);
        this.simulatedIMURawSensorReader = new PerfectSimulatedIMURawSensorReader((RawIMUSensorsInterface)this.rawSensors, IMU_INDEX, this.rigidBody, this.imuFrame, this.fullRobotModel.getElevator(), (SpatialAccelerationReadOnly)rootAcceleration);
        this.simulatedIMURawSensorReader.initialize();
    }

    @Test
    public void testRead() {
        for (int i = 0; i < 10000; ++i) {
            this.generateAppliedOrientation();
            this.generateAppliedVelocity();
            this.generateAppliedAcceleration();
            this.fullRobotModel.update(this.randomTransformBodyToWorld, this.randomLinearVelocity, this.randomAngularVelocity, this.randomLinearAcceleration, this.randomAngularAcceleration);
            this.simulatedIMURawSensorReader.read();
            this.rawSensors.getOrientation(this.actualIMUOrientation, IMU_INDEX);
            this.rawSensors.getAngularVelocity(this.actualAngularVelocity, IMU_INDEX);
            this.rawSensors.getAcceleration(this.actualLinearAcceleration, IMU_INDEX);
            this.generateExpectedOrientation();
            this.generateExpectedAngularVelocity();
            this.generateExpectedLinearAcceleration();
            SimulatedIMURawSensorReaderTest.assertEqualsRotationMatrix(this.expectedIMUOrientation, this.actualIMUOrientation, 0.001);
            SimulatedIMURawSensorReaderTest.assertEqualsVector(this.expectedAngularVelocityInIMUFrame, this.actualAngularVelocity, 0.001);
            SimulatedIMURawSensorReaderTest.assertEqualsVector(this.expectedLinearAccelerationOfIMUInIMUFrame, this.actualLinearAcceleration, 0.001);
        }
    }

    private void generateAppliedOrientation() {
        this.randomBodyAxisAngle.set(2.0 * (Math.random() - 0.5), 2.0 * (Math.random() - 0.5), 2.0 * (Math.random() - 0.5), Math.random() * 2.0 * Math.PI);
        this.randomTransformBodyToWorld.setRotationAndZeroTranslation((Orientation3DReadOnly)this.randomBodyAxisAngle);
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.setRotationAndZeroTranslation((Orientation3DReadOnly)this.randomBodyAxisAngle);
    }

    private void generateAppliedVelocity() {
        this.randomLinearVelocity.setIncludingFrame(this.bodyFrame, Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
        this.randomLinearVelocity.scale(10.0);
        this.randomAngularVelocity.setIncludingFrame(this.bodyFrame, Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
        this.randomAngularVelocity.scale(10.0);
    }

    private void generateAppliedAcceleration() {
        this.randomLinearAcceleration.setIncludingFrame(this.bodyFrame, Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
        this.randomLinearAcceleration.scale(40.0);
        this.randomAngularAcceleration.setIncludingFrame(this.bodyFrame, Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
        this.randomAngularAcceleration.scale(20.0);
    }

    private void generateExpectedOrientation() {
        RotationMatrix randomTransformBodyToWorldMatrix = new RotationMatrix();
        RotationMatrix transformIMUToJointMatrix = new RotationMatrix();
        randomTransformBodyToWorldMatrix.set((RotationMatrixReadOnly)this.randomTransformBodyToWorld.getRotation());
        transformIMUToJointMatrix.set((RotationMatrixReadOnly)this.transformIMUToJoint.getRotation());
        this.expectedIMUOrientation.set(randomTransformBodyToWorldMatrix);
        this.expectedIMUOrientation.multiply((RotationMatrixReadOnly)transformIMUToJointMatrix);
    }

    private void generateExpectedAngularVelocity() {
        this.expectedAngularVelocityInIMUFrame.set((Tuple3DReadOnly)this.randomAngularVelocity);
        this.transformJointToIMU.transform((Vector3DBasics)this.expectedAngularVelocityInIMUFrame);
    }

    private void generateExpectedLinearAcceleration() {
        FrameVector3D centerAppliedAccelerationPart = new FrameVector3D((FrameTuple3DReadOnly)this.randomLinearAcceleration);
        FrameVector3D centerCoriolisAccelerationPart = new FrameVector3D(this.bodyFrame);
        centerCoriolisAccelerationPart.cross((FrameVector3DReadOnly)this.randomAngularVelocity, (FrameVector3DReadOnly)this.randomLinearVelocity);
        FrameVector3D gravitationalAccelerationPart = new FrameVector3D(this.fullRobotModel.getWorldFrame());
        gravitationalAccelerationPart.setZ(GRAVITY);
        gravitationalAccelerationPart.changeFrame(this.bodyFrame);
        FrameVector3D centripedalAccelerationPart = new FrameVector3D(this.bodyFrame);
        centripedalAccelerationPart.cross((FrameVector3DReadOnly)this.randomAngularVelocity, (FrameVector3DReadOnly)this.jointToIMUOffset);
        centripedalAccelerationPart.cross((FrameVector3DReadOnly)this.randomAngularVelocity, (FrameVector3DReadOnly)centripedalAccelerationPart);
        FrameVector3D angularAccelerationPart = new FrameVector3D(this.bodyFrame);
        angularAccelerationPart.cross((FrameVector3DReadOnly)this.randomAngularAcceleration, (FrameVector3DReadOnly)this.jointToIMUOffset);
        this.expectedLinearAccelerationOfIMUInIMUFrame.set((Tuple3DReadOnly)centerAppliedAccelerationPart);
        this.expectedLinearAccelerationOfIMUInIMUFrame.add((Tuple3DReadOnly)centerCoriolisAccelerationPart);
        this.expectedLinearAccelerationOfIMUInIMUFrame.add((Tuple3DReadOnly)gravitationalAccelerationPart);
        this.expectedLinearAccelerationOfIMUInIMUFrame.add((Tuple3DReadOnly)centripedalAccelerationPart);
        this.expectedLinearAccelerationOfIMUInIMUFrame.add((Tuple3DReadOnly)angularAccelerationPart);
        this.transformJointToIMU.transform((Vector3DBasics)this.expectedLinearAccelerationOfIMUInIMUFrame);
    }

    private static void assertEqualsVector(Vector3D expected, Vector3D actual, double delta) {
        Assert.assertEquals((double)expected.getX(), (double)actual.getX(), (double)delta);
        Assert.assertEquals((double)expected.getY(), (double)actual.getY(), (double)delta);
        Assert.assertEquals((double)expected.getZ(), (double)actual.getZ(), (double)delta);
    }

    private static void assertEqualsRotationMatrix(RotationMatrix expected, RotationMatrix actual, double delta) {
        RotationMatrix differenceMatrix = new RotationMatrix();
        differenceMatrix.setAndTranspose((Matrix3DReadOnly)expected);
        differenceMatrix.multiply((RotationMatrixReadOnly)actual);
        AxisAngle differenceAxisAngle = new AxisAngle((Orientation3DReadOnly)differenceMatrix);
        double differenceAngle = differenceAxisAngle.getAngle();
        Assert.assertEquals((double)0.0, (double)differenceAngle, (double)delta);
    }

    private static class TestingRobotModel {
        private final RigidBodyBasics elevator;
        private final RigidBodyBasics body;
        private final SixDoFJoint rootJoint;
        private final ReferenceFrame worldFrame;
        private final double Ixx = Math.random();
        private final double Iyy = Math.random();
        private final double Izz = Math.random();
        private final double mass = Math.random();
        private Vector3D comOffset = new Vector3D(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
        private final ReferenceFrame elevatorFrame;
        private final ReferenceFrame bodyFrame;

        public TestingRobotModel() {
            this.worldFrame = ReferenceFrame.getWorldFrame();
            this.elevator = new RigidBody("elevator", this.worldFrame);
            this.elevatorFrame = this.elevator.getBodyFixedFrame();
            this.rootJoint = new SixDoFJoint("rootJoint", this.elevator);
            this.body = new RigidBody("body", (JointBasics)this.rootJoint, this.Ixx, this.Iyy, this.Izz, this.mass, (Tuple3DReadOnly)this.comOffset);
            this.bodyFrame = this.rootJoint.getFrameAfterJoint();
        }

        public void update(RigidBodyTransform transformBodyToWorld, FrameVector3D linearVelocity, FrameVector3D angularVelocity, FrameVector3D linearAcceleration, FrameVector3D angularAcceleration) {
            this.rootJoint.setJointConfiguration((RigidBodyTransformReadOnly)transformBodyToWorld);
            this.updateFrames();
            Twist bodyTwist = new Twist(this.bodyFrame, this.elevatorFrame, this.bodyFrame, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity);
            this.rootJoint.setJointTwist((TwistReadOnly)bodyTwist);
            SpatialAcceleration accelerationOfChestWithRespectToWorld = new SpatialAcceleration(this.bodyFrame, this.worldFrame, this.bodyFrame, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration);
            accelerationOfChestWithRespectToWorld.setBaseFrame(this.getElevatorFrame());
            this.rootJoint.setJointAcceleration((SpatialAccelerationReadOnly)accelerationOfChestWithRespectToWorld);
            this.updateFrames();
        }

        public void updateFrames() {
            this.elevator.updateFramesRecursively();
        }

        public RigidBodyBasics getBodyLink() {
            return this.body;
        }

        public ReferenceFrame getWorldFrame() {
            return this.worldFrame;
        }

        public ReferenceFrame getBodyFrame() {
            return this.bodyFrame;
        }

        public ReferenceFrame getElevatorFrame() {
            return this.elevator.getBodyFixedFrame();
        }

        public RigidBodyBasics getElevator() {
            return this.elevator;
        }

        public FrameVector3D getReferenceFrameTransInWorldFrame(ReferenceFrame frame) {
            Vector3D trans = new Vector3D();
            trans.set((Tuple3DReadOnly)frame.getTransformToDesiredFrame(this.worldFrame).getTranslation());
            FrameVector3D ret = new FrameVector3D(this.worldFrame, (Tuple3DReadOnly)trans);
            return ret;
        }

        private ReferenceFrame createOffsetFrame(JointBasics previousJoint, RigidBodyTransform transformToParent, String frameName) {
            MovingReferenceFrame parentFrame = previousJoint.getFrameAfterJoint();
            ReferenceFrame beforeJointFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)frameName, (ReferenceFrame)parentFrame, (RigidBodyTransformReadOnly)transformToParent);
            return beforeJointFrame;
        }
    }

    private static class RawSensors
    implements RawIMUSensorsInterface {
        private double r_imu_m00 = 0.0;
        private double r_imu_m01 = 0.0;
        private double r_imu_m02 = 0.0;
        private double r_imu_m10 = 0.0;
        private double r_imu_m11 = 0.0;
        private double r_imu_m12 = 0.0;
        private double r_imu_m20 = 0.0;
        private double r_imu_m21 = 0.0;
        private double r_imu_m22 = 0.0;
        private double r_imu_accel_x = 0.0;
        private double r_imu_accel_y = 0.0;
        private double r_imu_accel_z = 0.0;
        private double r_imu_gyro_x = 0.0;
        private double r_imu_gyro_y = 0.0;
        private double r_imu_gyro_z = 0.0;
        private double r_imu_compass_x = 0.0;
        private double r_imu_compass_y = 0.0;
        private double r_imu_compass_z = 0.0;

        private RawSensors() {
        }

        public void setOrientation(RotationMatrix orientation, int imuIndex) {
            this.r_imu_m00 = orientation.getM00();
            this.r_imu_m01 = orientation.getM01();
            this.r_imu_m02 = orientation.getM02();
            this.r_imu_m10 = orientation.getM10();
            this.r_imu_m11 = orientation.getM11();
            this.r_imu_m12 = orientation.getM12();
            this.r_imu_m20 = orientation.getM20();
            this.r_imu_m21 = orientation.getM21();
            this.r_imu_m22 = orientation.getM22();
        }

        public void setAcceleration(Vector3D acceleration, int imuIndex) {
            this.r_imu_accel_x = acceleration.getX();
            this.r_imu_accel_y = acceleration.getY();
            this.r_imu_accel_z = acceleration.getZ();
        }

        public void setAngularVelocity(Vector3D gyroscope, int imuIndex) {
            this.r_imu_gyro_x = gyroscope.getX();
            this.r_imu_gyro_y = gyroscope.getY();
            this.r_imu_gyro_z = gyroscope.getZ();
        }

        public void setCompass(Vector3D compass, int imuIndex) {
            this.r_imu_compass_x = compass.getX();
            this.r_imu_compass_y = compass.getY();
            this.r_imu_compass_z = compass.getZ();
        }

        public void getOrientation(RotationMatrix orientationToPack, int imuIndex) {
            orientationToPack.set(this.r_imu_m00, this.r_imu_m01, this.r_imu_m02, this.r_imu_m10, this.r_imu_m11, this.r_imu_m12, this.r_imu_m20, this.r_imu_m21, this.r_imu_m22);
        }

        public void getAcceleration(Vector3D accelerationToPack, int imuIndex) {
            accelerationToPack.set(this.r_imu_accel_x, this.r_imu_accel_y, this.r_imu_accel_z);
        }

        public void getAngularVelocity(Vector3D angularVelocityToPack, int imuIndex) {
            angularVelocityToPack.set(this.r_imu_gyro_x, this.r_imu_gyro_y, this.r_imu_gyro_z);
        }

        public void getCompass(Vector3D compassToPack, int imuIndex) {
            compassToPack.set(this.r_imu_compass_x, this.r_imu_compass_y, this.r_imu_compass_z);
        }
    }
}

