/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.GroundContactPointsHolder;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.util.LinearStickSlipGroundContactModel;
import us.ihmc.simulationconstructionset.util.ground.FlatGroundProfile;
import us.ihmc.simulationconstructionset.util.ground.SlopedPlaneGroundProfile;
import us.ihmc.yoVariables.registry.YoRegistry;

public class LinearStickSlipGroundContactModelTest {
    private static SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();

    @Test
    public void testNonlinearZForce() {
        YoRegistry registry;
        boolean visualize = false;
        SimulationConstructionSet scs = null;
        if (visualize) {
            scs = new SimulationConstructionSet(new Robot("TestZForce"), parameters);
            registry = scs.getRootRegistry();
        } else {
            registry = new YoRegistry("TestRegistry");
        }
        GroundContactPoint groundContactPoint = new GroundContactPoint("testPoint", registry);
        GroundContactPointsHolder pointsHolder = this.createGroundContactPointsHolder(groundContactPoint);
        LinearStickSlipGroundContactModel groundContactModel = new LinearStickSlipGroundContactModel(pointsHolder, registry);
        groundContactModel.disableSlipping();
        if (visualize) {
            scs.startOnAThread();
        }
        for (double z = 1.0E-5; z > -0.02; z -= 1.0E-5) {
            Point3D position = new Point3D(0.0, 0.0, z);
            Vector3D velocity = new Vector3D(0.0, 0.0, 0.0);
            groundContactPoint.setPosition((Point3DReadOnly)position);
            groundContactPoint.setVelocity((Vector3DReadOnly)velocity);
            groundContactModel.enableSurfaceNormal();
            groundContactModel.doGroundContact();
            Vector3D force = new Vector3D();
            groundContactPoint.getForce((Vector3DBasics)force);
            if (!visualize) continue;
            scs.tickAndUpdate();
        }
        if (visualize) {
            ThreadTools.sleepForever();
        }
    }

    @Test
    public void testOnFlatGroundNoSlipCompareWithAndWithoutNormals() {
        YoRegistry registry = new YoRegistry("TestRegistry");
        GroundContactPoint groundContactPoint = new GroundContactPoint("testPoint", registry);
        GroundContactPointsHolder pointsHolder = this.createGroundContactPointsHolder(groundContactPoint);
        LinearStickSlipGroundContactModel groundContactModel = new LinearStickSlipGroundContactModel(pointsHolder, registry);
        groundContactModel.disableSlipping();
        Point3D position = new Point3D(0.0, 0.0, -0.002);
        Vector3D velocity = new Vector3D(0.0, 0.0, -1.0);
        groundContactPoint.setPosition((Point3DReadOnly)position);
        groundContactPoint.setVelocity((Vector3DReadOnly)velocity);
        groundContactModel.enableSurfaceNormal();
        groundContactModel.doGroundContact();
        Vector3D force = new Vector3D();
        groundContactPoint.getForce((Vector3DBasics)force);
        Assert.assertEquals(0.0, force.getX(), 1.0E-7);
        Assert.assertEquals(0.0, force.getY(), 1.0E-7);
        Assert.assertTrue(force.getZ() > 0.0);
        Point3D touchdownPosition = new Point3D();
        groundContactPoint.getTouchdownLocation((Point3DBasics)touchdownPosition);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)touchdownPosition, (EuclidGeometry)position, (double)1.0E-7);
        groundContactModel.disableSurfaceNormal();
        groundContactModel.doGroundContact();
        Vector3D forceWithNormalsDisabled = new Vector3D();
        groundContactPoint.getForce((Vector3DBasics)forceWithNormalsDisabled);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)force, (EuclidGeometry)forceWithNormalsDisabled, (double)1.0E-7);
        int numberOfTests = 1000;
        Random random = new Random(1977L);
        for (int i = 0; i < numberOfTests; ++i) {
            double maxAbsoluteX = 0.01;
            double maxAbsoluteY = 0.01;
            double maxAbsoluteZ = 0.01;
            double maxSpeed = 0.1;
            position = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)maxAbsoluteX, (double)maxAbsoluteY, (double)maxAbsoluteZ);
            if (position.getZ() > -0.002) {
                position.setZ(-0.002);
            }
            if ((velocity = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)maxSpeed)).getZ() > 0.0) {
                velocity.setZ(-velocity.getZ());
            }
            groundContactPoint.setPosition((Point3DReadOnly)position);
            groundContactPoint.setVelocity((Vector3DReadOnly)velocity);
            groundContactModel.enableSurfaceNormal();
            groundContactModel.doGroundContact();
            Assert.assertTrue(groundContactPoint.isInContact());
            groundContactPoint.getForce((Vector3DBasics)force);
            groundContactModel.disableSurfaceNormal();
            groundContactModel.doGroundContact();
            Assert.assertTrue(groundContactPoint.isInContact());
            groundContactPoint.getForce((Vector3DBasics)forceWithNormalsDisabled);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)force, (EuclidGeometry)forceWithNormalsDisabled, (double)1.0E-7);
            Point3D touchdownTest = new Point3D();
            groundContactPoint.getTouchdownLocation((Point3DBasics)touchdownTest);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)touchdownPosition, (EuclidGeometry)touchdownTest, (double)1.0E-7);
        }
        position.set(0.2, 0.3, 1.0E-7);
        velocity.set(0.0, 0.0, 0.0);
        groundContactPoint.setPosition((Point3DReadOnly)position);
        groundContactPoint.setVelocity((Vector3DReadOnly)velocity);
        groundContactModel.enableSurfaceNormal();
        groundContactModel.doGroundContact();
        Assert.assertFalse(groundContactPoint.isInContact());
        groundContactPoint.getForce((Vector3DBasics)force);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(0.0, 0.0, 0.0), (EuclidGeometry)force, (double)1.0E-7);
    }

    @Test
    public void testOnSlantedGroundCompareWithAndWithoutNormals() {
        YoRegistry registryOnFlat = new YoRegistry("TestRegistryOnFlat");
        YoRegistry registryOnSlope = new YoRegistry("TestRegistryOnFlat");
        GroundContactPoint groundContactPointOnFlat = new GroundContactPoint("testPointOnFlat", registryOnFlat);
        GroundContactPointsHolder pointsHolderOnFlat = this.createGroundContactPointsHolder(groundContactPointOnFlat);
        GroundContactPoint groundContactPointOnSlope = new GroundContactPoint("testPointOnSlope", registryOnSlope);
        GroundContactPointsHolder pointsHolderOnSlope = this.createGroundContactPointsHolder(groundContactPointOnSlope);
        LinearStickSlipGroundContactModel groundContactModelOnFlat = new LinearStickSlipGroundContactModel(pointsHolderOnFlat, registryOnFlat);
        groundContactModelOnFlat.enableSlipping();
        LinearStickSlipGroundContactModel groundContactModelOnSlope = new LinearStickSlipGroundContactModel(pointsHolderOnSlope, registryOnSlope);
        groundContactModelOnSlope.enableSlipping();
        FlatGroundProfile flatGroundProfile = new FlatGroundProfile();
        groundContactModelOnFlat.setGroundProfile3D((GroundProfile3D)flatGroundProfile);
        RigidBodyTransform transform3D = new RigidBodyTransform();
        transform3D.setRotationRollAndZeroTranslation(0.3);
        transform3D.setRotationPitchAndZeroTranslation(-0.7);
        transform3D.getTranslation().set((Tuple3DReadOnly)new Vector3D(0.1, 0.2, 0.3));
        RigidBodyTransform inverseTransform3D = new RigidBodyTransform((RigidBodyTransformReadOnly)transform3D);
        inverseTransform3D.invert();
        Vector3D surfaceNormal = new Vector3D(0.0, 0.0, 1.0);
        transform3D.transform((Vector3DBasics)surfaceNormal);
        surfaceNormal.normalize();
        Point3D intersectionPoint = new Point3D();
        transform3D.transform((Point3DBasics)intersectionPoint);
        SlopedPlaneGroundProfile slopedGroundProfile = new SlopedPlaneGroundProfile(surfaceNormal, intersectionPoint, 100.0);
        groundContactModelOnSlope.setGroundProfile3D((GroundProfile3D)slopedGroundProfile);
        Random random = new Random(1833L);
        int numberOfTests = 10000;
        for (int i = 0; i < numberOfTests; ++i) {
            double maxAbsoluteXYZ = 0.1;
            double maxAbsoluteVelocity = 1.0;
            Point3D queryPointOnFlat = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)maxAbsoluteXYZ, (double)maxAbsoluteXYZ, (double)maxAbsoluteXYZ);
            Vector3D queryVelocityOnFlat = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)maxAbsoluteVelocity);
            groundContactPointOnFlat.setPosition((Point3DReadOnly)queryPointOnFlat);
            groundContactPointOnFlat.setVelocity((Vector3DReadOnly)queryVelocityOnFlat);
            groundContactModelOnFlat.doGroundContact();
            Vector3D forceOnFlat = new Vector3D();
            groundContactPointOnFlat.getForce((Vector3DBasics)forceOnFlat);
            Point3D queryPointOnSlope = new Point3D((Tuple3DReadOnly)queryPointOnFlat);
            Vector3D queryVelocityOnSlope = new Vector3D((Tuple3DReadOnly)queryVelocityOnFlat);
            transform3D.transform((Point3DBasics)queryPointOnSlope);
            transform3D.transform((Vector3DBasics)queryVelocityOnSlope);
            groundContactPointOnSlope.setPosition((Point3DReadOnly)queryPointOnSlope);
            groundContactPointOnSlope.setVelocity((Vector3DReadOnly)queryVelocityOnSlope);
            groundContactModelOnSlope.doGroundContact();
            Vector3D forceOnSlope = new Vector3D();
            groundContactPointOnSlope.getForce((Vector3DBasics)forceOnSlope);
            inverseTransform3D.transform((Vector3DBasics)forceOnSlope);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)forceOnFlat, (EuclidGeometry)forceOnSlope, (double)1.0E-7);
            Assert.assertTrue(groundContactPointOnFlat.isInContact() == groundContactPointOnSlope.isInContact());
            Assert.assertTrue(groundContactPointOnFlat.isSlipping() == groundContactPointOnSlope.isSlipping());
        }
    }

    private GroundContactPointsHolder createGroundContactPointsHolder(GroundContactPoint groundContactPoint) {
        final ArrayList<GroundContactPoint> groundContactPoints = new ArrayList<GroundContactPoint>();
        groundContactPoints.add(groundContactPoint);
        GroundContactPointsHolder pointsHolder = new GroundContactPointsHolder(){

            public ArrayList<GroundContactPoint> getGroundContactPoints(int groundContactGroupIdentifier) {
                return groundContactPoints;
            }
        };
        return pointsHolder;
    }
}

