/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.GroundContactModel;
import us.ihmc.simulationconstructionset.GroundContactPointsHolder;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.util.LinearStickSlipGroundContactModel;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;

public abstract class GroundProfileTest {
    private static SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
    private boolean VISUALIZE = false;
    private boolean DEBUG = false;
    private final double percentMaxHeightPerExcursionDistance = 0.1;

    public abstract GroundProfile3D getGroundProfile();

    public abstract double getMaxPercentageOfAllowableValleyPoints();

    public abstract double getMaxPercentageOfAllowablePeakPoints();

    public abstract double getMaxPercentageOfAllowableDropOffs();

    @Test
    public void testSurfaceNormalGridForSmoothTerrainUsingHeightMap() {
        boolean tooManyDropOffChecks;
        Random random = new Random(1234L);
        GroundProfile3D groundProfile = this.getGroundProfile();
        HeightMapWithNormals heightMap = groundProfile.getHeightMapIfAvailable();
        if (heightMap == null) {
            return;
        }
        SimulationConstructionSet scs = null;
        BagOfBalls bagOfBalls = null;
        YoFramePoint3D surfaceNormalPointForViz = null;
        YoFrameVector3D surfaceNormalViz = null;
        if (this.VISUALIZE) {
            Robot robot = new Robot("Test");
            LinearStickSlipGroundContactModel groundModel = new LinearStickSlipGroundContactModel((GroundContactPointsHolder)robot, robot.getRobotsYoRegistry());
            groundModel.setGroundProfile3D(groundProfile);
            robot.setGroundContactModel((GroundContactModel)groundModel);
            YoGraphicsListRegistry yoGraphicsListRegistry = new YoGraphicsListRegistry();
            bagOfBalls = new BagOfBalls(robot.getRobotsYoRegistry(), yoGraphicsListRegistry);
            surfaceNormalPointForViz = new YoFramePoint3D("surfaceNormalPointForViz", ReferenceFrame.getWorldFrame(), robot.getRobotsYoRegistry());
            surfaceNormalViz = new YoFrameVector3D("surfaceNormalVector", ReferenceFrame.getWorldFrame(), robot.getRobotsYoRegistry());
            YoGraphicVector surfaceNormalGraphicVector = new YoGraphicVector("surfaceNormalViz", surfaceNormalPointForViz, surfaceNormalViz, YoAppearance.AliceBlue());
            yoGraphicsListRegistry.registerYoGraphic("Viz", (YoGraphic)surfaceNormalGraphicVector);
            scs = new SimulationConstructionSet(robot, parameters);
            scs.setGroundVisible(true);
            scs.addYoGraphicsListRegistry(yoGraphicsListRegistry);
            scs.startOnAThread();
        }
        BoundingBox3D boundingBox = groundProfile.getBoundingBox();
        double xMin = boundingBox.getMinX();
        double yMin = boundingBox.getMinY();
        double xMax = boundingBox.getMaxX();
        double yMax = boundingBox.getMaxY();
        if (Double.isInfinite(xMin)) {
            xMin = -10.0;
        }
        if (Double.isInfinite(xMax)) {
            xMax = 10.0;
        }
        if (Double.isInfinite(yMin)) {
            yMin = -10.0;
        }
        if (Double.isInfinite(yMax)) {
            yMax = 10.0;
        }
        int numberOfPeakPoints = 0;
        int numberOfValleyPoints = 0;
        int numberOfDropOffChecks = 0;
        int numberOfTotalPoints = 0;
        int numberOfTotalChecks = 0;
        int xSteps = 100;
        int ySteps = 100;
        double xStep = (xMax - xMin) / (double)xSteps;
        double yStep = (yMax - yMin) / (double)ySteps;
        for (int i = 2; i < xSteps - 2; ++i) {
            double x = xMin + (double)i * xStep;
            for (int j = 2; j < ySteps - 2; ++j) {
                boolean aboveAValley;
                boolean belowAPeak;
                double y = yMin + (double)j * yStep;
                Vector3D surfaceNormal = new Vector3D();
                double height = heightMap.heightAndNormalAt(x, y, 0.0, (Vector3DBasics)surfaceNormal);
                Assert.assertEquals(1.0, surfaceNormal.length(), 1.0E-7);
                Point3D queryPoint = new Point3D(x, y, height);
                ++numberOfTotalPoints;
                Point3D queryPointALittleInside = new Point3D((Tuple3DReadOnly)queryPoint);
                queryPointALittleInside.scaleAdd(-0.002, (Tuple3DReadOnly)surfaceNormal, (Tuple3DReadOnly)queryPointALittleInside);
                Point3D queryPointALittleOutside = new Point3D((Tuple3DReadOnly)queryPoint);
                queryPointALittleOutside.scaleAdd(0.002, (Tuple3DReadOnly)surfaceNormal, (Tuple3DReadOnly)queryPointALittleOutside);
                Vector3D surfaceNormalCheck = new Vector3D();
                Point3D intersectionCheck = new Point3D();
                boolean insideShouldBeTrue = groundProfile.checkIfInside(queryPointALittleInside.getX(), queryPointALittleInside.getY(), queryPointALittleInside.getZ(), (Point3DBasics)intersectionCheck, (Vector3DBasics)surfaceNormalCheck);
                Assert.assertEquals(1.0, surfaceNormal.length(), 1.0E-7);
                boolean surfaceNormalsAreClose = surfaceNormalCheck.dot((Tuple3DReadOnly)surfaceNormal) > 0.999;
                boolean bl = belowAPeak = !surfaceNormalsAreClose;
                if (belowAPeak) {
                    ++numberOfPeakPoints;
                } else {
                    Assert.assertTrue(insideShouldBeTrue);
                    Assert.assertTrue(groundProfile.isClose(queryPointALittleInside.getX(), queryPointALittleInside.getY(), queryPointALittleInside.getZ()));
                }
                EuclidCoreTestTools.assertEquals((EuclidGeometry)intersectionCheck, (EuclidGeometry)queryPoint, (double)0.002);
                boolean outsideShouldBeFalse = groundProfile.checkIfInside(queryPointALittleOutside.getX(), queryPointALittleOutside.getY(), queryPointALittleOutside.getZ(), (Point3DBasics)intersectionCheck, (Vector3DBasics)surfaceNormalCheck);
                Assert.assertEquals(1.0, surfaceNormal.length(), 1.0E-7);
                surfaceNormalsAreClose = surfaceNormalCheck.dot((Tuple3DReadOnly)surfaceNormal) > 0.999;
                boolean bl2 = aboveAValley = !surfaceNormalsAreClose;
                if (aboveAValley) {
                    ++numberOfValleyPoints;
                } else {
                    Assert.assertFalse(outsideShouldBeFalse);
                }
                EuclidCoreTestTools.assertEquals((EuclidGeometry)intersectionCheck, (EuclidGeometry)queryPoint, (double)0.002);
                if (this.VISUALIZE) {
                    Vector3D normalToDraw = new Vector3D((Tuple3DReadOnly)surfaceNormal);
                    if (aboveAValley) {
                        normalToDraw.scale(0.5);
                    } else if (belowAPeak) {
                        normalToDraw.scale(2.0);
                    }
                    surfaceNormalPointForViz.set((Tuple3DReadOnly)queryPoint);
                    surfaceNormalViz.set((Tuple3DReadOnly)normalToDraw);
                    AppearanceDefinition appearance = YoAppearance.AliceBlue();
                    bagOfBalls.setBallLoop((FramePoint3DReadOnly)new FramePoint3D(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)queryPoint), appearance);
                    scs.setTime(scs.getTime() + 0.001);
                    scs.tickAndUpdate();
                }
                Assert.assertFalse(aboveAValley && belowAPeak);
                if (aboveAValley || belowAPeak) continue;
                Vector3D alongDirectionOne = new Vector3D();
                Vector3D alongDirectionTwo = new Vector3D();
                alongDirectionOne.set(1.0, 0.0, 0.0);
                alongDirectionTwo.cross((Tuple3DReadOnly)surfaceNormal, (Tuple3DReadOnly)alongDirectionOne);
                alongDirectionTwo.normalize();
                alongDirectionOne.cross((Tuple3DReadOnly)alongDirectionTwo, (Tuple3DReadOnly)surfaceNormal);
                int numberOfChecks = 10;
                double excursionDistance = 0.001;
                double maxTolerableHeightDifferenceFromLinearModel = 0.1 * excursionDistance;
                for (int k = 0; k < numberOfChecks; ++k) {
                    boolean hitADropOff;
                    ++numberOfTotalChecks;
                    Vector2D excursionVector2d = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)excursionDistance);
                    Vector3D excursionVector = new Vector3D((Tuple3DReadOnly)alongDirectionOne);
                    excursionVector.scale(excursionVector2d.getX());
                    excursionVector.scaleAdd(excursionVector2d.getY(), (Tuple3DReadOnly)alongDirectionTwo, (Tuple3DReadOnly)excursionVector);
                    queryPoint.set(x, y, height);
                    queryPoint.add((Tuple3DReadOnly)excursionVector);
                    double heightAtQueryPoint = heightMap.heightAt(queryPoint.getX(), queryPoint.getY(), queryPoint.getZ());
                    double heightDifferenceFromLinearModel = queryPoint.getZ() - heightAtQueryPoint;
                    boolean bl3 = hitADropOff = Math.abs(heightDifferenceFromLinearModel) > maxTolerableHeightDifferenceFromLinearModel;
                    if (hitADropOff && this.DEBUG) {
                        System.out.println("(x, y, z) = (" + x + ", " + y + ", " + height + ")");
                        System.out.println("surfaceNormal = " + surfaceNormal);
                        System.out.println("alongDirectionOne = " + alongDirectionOne);
                        System.out.println("alongDirectionTwo = " + alongDirectionTwo);
                        System.out.println("excursionVector = " + excursionVector);
                        System.out.println("queryPoint = " + queryPoint);
                        System.out.println("heightAtQueryPoint = " + heightAtQueryPoint);
                        System.out.println("heightDifferenceFromLinearModel = " + heightDifferenceFromLinearModel);
                        System.out.println();
                    }
                    if (!hitADropOff) continue;
                    ++numberOfDropOffChecks;
                }
            }
        }
        double percentPeakPoints = (double)numberOfPeakPoints / (double)numberOfTotalPoints;
        double percentValleyPoints = (double)numberOfValleyPoints / (double)numberOfTotalPoints;
        double percentDropOffChecks = (double)numberOfDropOffChecks / (double)numberOfTotalChecks;
        boolean tooManyPeakPoints = percentPeakPoints > this.getMaxPercentageOfAllowablePeakPoints();
        boolean tooManyValleyPoints = percentValleyPoints > this.getMaxPercentageOfAllowableValleyPoints();
        boolean bl = tooManyDropOffChecks = percentDropOffChecks > this.getMaxPercentageOfAllowableDropOffs();
        if (tooManyPeakPoints || tooManyValleyPoints || tooManyDropOffChecks) {
            System.out.println("numberOfPeakPoints = " + numberOfPeakPoints);
            System.out.println("numberOfValleyPoints = " + numberOfValleyPoints);
            System.out.println("numberOfTotalPoints = " + numberOfTotalPoints);
            System.out.println("percentPeakPoints = " + percentPeakPoints);
            System.out.println("percentValleyPoints = " + percentValleyPoints);
            System.out.println("numberOfDropOffChecks = " + numberOfDropOffChecks);
            System.out.println("numberOfTotalChecks = " + numberOfTotalChecks);
            System.out.println("percentDropOffChecks = " + percentDropOffChecks);
        }
        Assert.assertFalse(tooManyPeakPoints);
        Assert.assertFalse(tooManyValleyPoints);
        Assert.assertFalse(tooManyDropOffChecks);
        if (this.VISUALIZE) {
            ThreadTools.sleepForever();
        }
    }
}

