/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.JointWrenchSensor;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class JointWrenchSensorTest {
    @Test
    public void testStaticallyHangingMasses() throws UnreasonableAccelerationException {
        double massOne = 7.21;
        double massTwo = 8.64;
        Vector3D sensorOffsetFromJointOne = new Vector3D(0.0, 0.0, -0.1);
        Vector3D sensorOffsetFromJointTwo = new Vector3D(0.0, 0.0, -0.1);
        Robot robot = new Robot("JointWrenchSensorTest");
        PinJoint pinJointOne = this.createPinJointWithHangingMass("pinJointOne", massOne, Axis3D.Y, robot);
        JointWrenchSensor jointWrenchSensorOne = new JointWrenchSensor("jointWrenchSensorOne", (Tuple3DReadOnly)sensorOffsetFromJointOne, robot);
        pinJointOne.addJointWrenchSensor(jointWrenchSensorOne);
        Assert.assertTrue(jointWrenchSensorOne == pinJointOne.getJointWrenchSensor());
        robot.addRootJoint((Joint)pinJointOne);
        PinJoint pinJointTwo = this.createPinJointWithHangingMass("pinJointTwo", massTwo, Axis3D.X, robot);
        JointWrenchSensor jointWrenchSensorTwo = new JointWrenchSensor("jointWrenchSensorTwo", (Tuple3DReadOnly)sensorOffsetFromJointTwo, robot);
        pinJointTwo.addJointWrenchSensor(jointWrenchSensorTwo);
        Assert.assertTrue(jointWrenchSensorTwo == pinJointTwo.getJointWrenchSensor());
        pinJointOne.addJoint((Joint)pinJointTwo);
        robot.doDynamicsButDoNotIntegrate();
        Vector3D expectedJointForce = new Vector3D(0.0, 0.0, (massOne + massTwo) * robot.getGravityZ());
        Vector3D expectedJointTorque = new Vector3D();
        this.assertJointWrenchEquals(jointWrenchSensorOne, expectedJointForce, expectedJointTorque);
        expectedJointForce = new Vector3D(0.0, 0.0, massTwo * robot.getGravityZ());
        expectedJointTorque = new Vector3D();
        this.assertJointWrenchEquals(jointWrenchSensorTwo, expectedJointForce, expectedJointTorque);
        this.assertJointWrenchSensorConsistency(robot, jointWrenchSensorOne);
        this.assertJointWrenchSensorConsistency(robot, jointWrenchSensorTwo);
        pinJointOne.setQ(Math.PI);
        robot.doDynamicsButDoNotIntegrate();
        expectedJointForce = new Vector3D(0.0, 0.0, -(massOne + massTwo) * robot.getGravityZ());
        expectedJointTorque = new Vector3D();
        this.assertJointWrenchEquals(jointWrenchSensorOne, expectedJointForce, expectedJointTorque);
        expectedJointForce = new Vector3D(0.0, 0.0, -massTwo * robot.getGravityZ());
        expectedJointTorque = new Vector3D();
        this.assertJointWrenchEquals(jointWrenchSensorTwo, expectedJointForce, expectedJointTorque);
    }

    @Test
    public void testJointTorquesMatchWhenSensorAtJoint() throws UnreasonableAccelerationException {
        double massOne = 7.21;
        double massTwo = 8.64;
        Vector3D sensorOffsetFromJointOne = new Vector3D(0.0, 0.017, 0.0);
        Vector3D sensorOffsetFromJointTwo = new Vector3D(0.015, 0.0, 0.0);
        Robot robot = new Robot("JointWrenchSensorTest");
        PinJoint pinJointOne = this.createPinJointWithHangingMass("pinJointOne", massOne, Axis3D.Y, robot);
        JointWrenchSensor jointWrenchSensorOne = new JointWrenchSensor("jointWrenchSensorOne", (Tuple3DReadOnly)sensorOffsetFromJointOne, robot);
        pinJointOne.addJointWrenchSensor(jointWrenchSensorOne);
        Assert.assertTrue(jointWrenchSensorOne == pinJointOne.getJointWrenchSensor());
        robot.addRootJoint((Joint)pinJointOne);
        PinJoint pinJointTwo = this.createPinJointWithHangingMass("pinJointTwo", massTwo, Axis3D.X, robot);
        JointWrenchSensor jointWrenchSensorTwo = new JointWrenchSensor("jointWrenchSensorTwo", (Tuple3DReadOnly)sensorOffsetFromJointTwo, robot);
        pinJointTwo.addJointWrenchSensor(jointWrenchSensorTwo);
        Assert.assertTrue(jointWrenchSensorTwo == pinJointTwo.getJointWrenchSensor());
        pinJointOne.addJoint((Joint)pinJointTwo);
        Vector3D jointTorque = new Vector3D();
        Random random = new Random(1797L);
        pinJointOne.setQ(RandomNumbers.nextDouble((Random)random, (double)(-Math.PI), (double)Math.PI));
        pinJointTwo.setQ(RandomNumbers.nextDouble((Random)random, (double)(-Math.PI), (double)Math.PI));
        pinJointOne.setQd(RandomNumbers.nextDouble((Random)random, (double)-1.0, (double)1.0));
        pinJointTwo.setQd(RandomNumbers.nextDouble((Random)random, (double)-1.0, (double)1.0));
        for (int i = 0; i < 100; ++i) {
            pinJointOne.setTau(RandomNumbers.nextDouble((Random)random, (double)-1.0, (double)1.0));
            pinJointTwo.setTau(RandomNumbers.nextDouble((Random)random, (double)-1.0, (double)1.0));
            robot.doDynamicsAndIntegrate(1.0E-4);
            jointWrenchSensorOne.getJointTorque((Tuple3DBasics)jointTorque);
            Assert.assertEquals(pinJointOne.getTauYoVariable().getDoubleValue(), -jointTorque.getY(), 1.0E-7);
            jointWrenchSensorTwo.getJointTorque((Tuple3DBasics)jointTorque);
            Assert.assertEquals(pinJointTwo.getTauYoVariable().getDoubleValue(), -jointTorque.getX(), 1.0E-7);
        }
    }

    @Test
    public void testOffsetAtCenterOfMassWithCantileveredBeam() throws UnreasonableAccelerationException {
        double massOne = 7.21;
        Robot robot = new Robot("JointWrenchSensorTest");
        PinJoint pinJointOne = this.createPinJointWithHangingMass("pinJointOne", massOne, Axis3D.Y, robot);
        Vector3D comOffsetFromJointOne = new Vector3D();
        pinJointOne.getLink().getComOffset((Vector3DBasics)comOffsetFromJointOne);
        JointWrenchSensor jointWrenchSensorOne = new JointWrenchSensor("jointWrenchSensorOne", (Tuple3DReadOnly)comOffsetFromJointOne, robot);
        pinJointOne.addJointWrenchSensor(jointWrenchSensorOne);
        Assert.assertTrue(jointWrenchSensorOne == pinJointOne.getJointWrenchSensor());
        robot.addRootJoint((Joint)pinJointOne);
        pinJointOne.setQ(1.5707963267948966);
        pinJointOne.setTau(massOne * robot.getGravityZ() * comOffsetFromJointOne.getZ());
        robot.doDynamicsAndIntegrate(1.0E-4);
        double jointAcceleration = pinJointOne.getQDDYoVariable().getDoubleValue();
        Assert.assertEquals(0.0, jointAcceleration, 1.0E-7);
        Vector3D expectedJointForce = new Vector3D(-massOne * robot.getGravityZ(), 0.0, 0.0);
        Vector3D expectedJointTorque = new Vector3D();
        this.assertJointWrenchEquals(jointWrenchSensorOne, expectedJointForce, expectedJointTorque);
    }

    private void assertJointWrenchSensorConsistency(Robot robot, JointWrenchSensor jointWrenchSensor) {
        Vector3D jointForce = new Vector3D();
        Vector3D jointTorque = new Vector3D();
        jointWrenchSensor.getJointForce((Tuple3DBasics)jointForce);
        jointWrenchSensor.getJointTorque((Tuple3DBasics)jointTorque);
        String name = jointWrenchSensor.getName();
        YoRegistry robotsYoRegistry = robot.getRobotsYoRegistry();
        YoDouble forceX = (YoDouble)robotsYoRegistry.findVariable(name + "_fX");
        YoDouble forceY = (YoDouble)robotsYoRegistry.findVariable(name + "_fY");
        YoDouble forceZ = (YoDouble)robotsYoRegistry.findVariable(name + "_fZ");
        YoDouble torqueX = (YoDouble)robotsYoRegistry.findVariable(name + "_tX");
        YoDouble torqueY = (YoDouble)robotsYoRegistry.findVariable(name + "_tY");
        YoDouble torqueZ = (YoDouble)robotsYoRegistry.findVariable(name + "_tZ");
        Assert.assertEquals(jointForce.getX(), forceX.getDoubleValue(), 1.0E-7);
        Assert.assertEquals(jointForce.getY(), forceY.getDoubleValue(), 1.0E-7);
        Assert.assertEquals(jointForce.getZ(), forceZ.getDoubleValue(), 1.0E-7);
        Assert.assertEquals(jointTorque.getX(), torqueX.getDoubleValue(), 1.0E-7);
        Assert.assertEquals(jointTorque.getY(), torqueY.getDoubleValue(), 1.0E-7);
        Assert.assertEquals(jointTorque.getZ(), torqueZ.getDoubleValue(), 1.0E-7);
    }

    private void assertJointWrenchEquals(JointWrenchSensor jointWrenchSensor, Vector3D expectedJointForce, Vector3D expectedJointTorque) {
        Vector3D jointForce = new Vector3D();
        Vector3D jointTorque = new Vector3D();
        jointWrenchSensor.getJointForce((Tuple3DBasics)jointForce);
        jointWrenchSensor.getJointTorque((Tuple3DBasics)jointTorque);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedJointForce, (Tuple3DReadOnly)jointForce, (double)1.0E-7);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedJointTorque, (Tuple3DReadOnly)jointTorque, (double)1.0E-7);
    }

    private PinJoint createPinJointWithHangingMass(String name, double mass, Axis3D axis, Robot robot) {
        PinJoint pinJoint = new PinJoint(name, (Tuple3DReadOnly)new Vector3D(), robot, (Vector3DReadOnly)axis);
        Vector3D comOffset = new Vector3D(0.0, 0.0, -1.0);
        Link linkOne = new Link("link");
        linkOne.setMass(mass);
        linkOne.setComOffset((Vector3DReadOnly)comOffset);
        linkOne.setMassAndRadiiOfGyration(mass, 0.1, 0.1, 0.1);
        pinJoint.setLink(linkOne);
        return pinJoint;
    }
}

