/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferProcessor;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class SimulationConstructionSetProcessDataCallTest {
    private static final boolean DEBUG = false;
    private YoRegistry registry;

    @Test
    public void testForwardCount() {
        Robot robot = new Robot("testRobot");
        SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
        parameters.setCreateGUI(false);
        parameters.setDataBufferSize(8192);
        SimulationConstructionSet scs = new SimulationConstructionSet(robot, parameters);
        this.registry = new YoRegistry("testRegustry");
        YoDouble dataSet = new YoDouble("dataSet", this.registry);
        scs.addYoRegistry(this.registry);
        int startValue = 5;
        int maxValue = 15;
        for (int i = startValue; i < maxValue; ++i) {
            dataSet.set((double)i);
            scs.tickAndUpdate();
        }
        scs.setOutPoint();
        scs.setCurrentIndex(1);
        scs.setInPoint();
        scs.cropBuffer();
        CounterProcessingFunction counterProcessingFunction = new CounterProcessingFunction(this.registry, true);
        scs.applyDataProcessingFunction((YoBufferProcessor)counterProcessingFunction);
        YoDouble counterVariable = counterProcessingFunction.getCountVariable();
        for (int i = 0; i < maxValue - startValue; ++i) {
            scs.setCurrentIndex(i);
            double testNum1 = dataSet.getDoubleValue();
            double testNum2 = counterVariable.getDoubleValue();
            Assert.assertEquals(testNum1 - testNum2, (double)startValue, 0.0);
        }
        scs.closeAndDispose();
    }

    @Test
    public void testBackwardCount() {
        Robot robot = new Robot("testRobot");
        SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
        parameters.setCreateGUI(false);
        parameters.setDataBufferSize(8192);
        SimulationConstructionSet scs = new SimulationConstructionSet(robot, parameters);
        this.registry = new YoRegistry("testRegustry");
        YoDouble dataSet = new YoDouble("dataSet", this.registry);
        scs.addYoRegistry(this.registry);
        int startValue = 5;
        int maxValue = 15;
        for (int i = startValue; i < maxValue; ++i) {
            dataSet.set((double)i);
            scs.tickAndUpdate();
        }
        scs.setOutPoint();
        scs.setCurrentIndex(1);
        scs.setInPoint();
        scs.cropBuffer();
        CounterProcessingFunction counterProcessingFunction = new CounterProcessingFunction(this.registry, false);
        scs.applyDataProcessingFunction((YoBufferProcessor)counterProcessingFunction);
        YoDouble counterVariable = counterProcessingFunction.getCountVariable();
        for (int i = 0; i < maxValue - startValue; ++i) {
            scs.setCurrentIndex(i);
            double testNum1 = dataSet.getDoubleValue();
            double testNum2 = counterVariable.getDoubleValue();
            Assert.assertEquals(testNum1 + testNum2, (double)(maxValue - 1), 0.0);
        }
        scs.closeAndDispose();
    }

    @Test
    public void testForwardCopy() {
        Robot robot = new Robot("testRobot");
        SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
        parameters.setCreateGUI(false);
        parameters.setDataBufferSize(8192);
        SimulationConstructionSet scs = new SimulationConstructionSet(robot, parameters);
        this.registry = new YoRegistry("testRegustry");
        YoDouble dataSet = new YoDouble("dataSet", this.registry);
        scs.addYoRegistry(this.registry);
        int startValue = 5;
        int maxValue = 15;
        for (int i = startValue; i < maxValue; ++i) {
            dataSet.set((double)i);
            scs.tickAndUpdate();
        }
        scs.setOutPoint();
        scs.setCurrentIndex(1);
        scs.setInPoint();
        scs.cropBuffer();
        CopierProcessingFunction copierProcessingFunction = new CopierProcessingFunction(dataSet, this.registry, true);
        scs.applyDataProcessingFunction((YoBufferProcessor)copierProcessingFunction);
        YoDouble copierVariable = copierProcessingFunction.getCopyVariable();
        for (int i = 0; i < maxValue - startValue; ++i) {
            scs.setCurrentIndex(i);
            double testNum1 = dataSet.getDoubleValue();
            double testNum2 = copierVariable.getDoubleValue();
            Assert.assertEquals(testNum1 - testNum2, 0.0, 0.0);
        }
        scs.closeAndDispose();
    }

    @Test
    public void testBackwardCopy() {
        Robot robot = new Robot("testRobot");
        SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
        parameters.setCreateGUI(false);
        parameters.setDataBufferSize(8192);
        SimulationConstructionSet scs = new SimulationConstructionSet(robot, parameters);
        this.registry = new YoRegistry("testRegustry");
        YoDouble dataSet = new YoDouble("dataSet", this.registry);
        scs.addYoRegistry(this.registry);
        int startValue = 5;
        int maxValue = 15;
        for (int i = startValue; i < maxValue; ++i) {
            dataSet.set((double)i);
            scs.tickAndUpdate();
        }
        scs.setOutPoint();
        scs.setCurrentIndex(1);
        scs.setInPoint();
        scs.cropBuffer();
        CopierProcessingFunction copierProcessingFunction = new CopierProcessingFunction(dataSet, this.registry, false);
        scs.applyDataProcessingFunction((YoBufferProcessor)copierProcessingFunction);
        YoDouble copierVariable = copierProcessingFunction.getCopyVariable();
        for (int i = 0; i < maxValue - startValue; ++i) {
            scs.setCurrentIndex(i);
            double testNum1 = dataSet.getDoubleValue();
            double testNum2 = copierVariable.getDoubleValue();
            Assert.assertEquals(testNum1 - testNum2, 0.0, 0.0);
        }
        scs.closeAndDispose();
    }

    public static class CounterProcessingFunction
    implements YoBufferProcessor {
        private final boolean forward;
        private final YoDouble countVariable;
        private int count = 0;

        public CounterProcessingFunction(YoRegistry registry, boolean forward) {
            this.forward = forward;
            this.countVariable = new YoDouble("countVariable", registry);
        }

        public boolean goForward() {
            return this.forward;
        }

        public void process(int startIndex, int endIndex, int currentIndex) {
            this.countVariable.set((double)this.count);
            ++this.count;
        }

        public YoDouble getCountVariable() {
            return this.countVariable;
        }
    }

    public static class CopierProcessingFunction
    implements YoBufferProcessor {
        private final boolean forward;
        private final YoDouble copyVariable;
        private final YoDouble testVariable;

        public CopierProcessingFunction(YoDouble inputData, YoRegistry registry, boolean forward) {
            this.forward = forward;
            this.testVariable = inputData;
            this.copyVariable = new YoDouble("copyVariable", registry);
        }

        public boolean goForward() {
            return this.forward;
        }

        public void process(int startIndex, int endIndex, int currentIndex) {
            double holderDouble = this.testVariable.getDoubleValue();
            this.copyVariable.set(holderDouble);
        }

        public YoDouble getCopyVariable() {
            return this.copyVariable;
        }
    }
}

