/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.screwTools;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyTwistProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointMatrixIndexProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;

public class RigidBodyDeltaTwistCalculator
implements Function<RigidBodyReadOnly, TwistReadOnly> {
    private final ReferenceFrame inertialFrame;
    private final JointMatrixIndexProvider jointMatrixIndexProvider;
    private RigidBodyTwistProvider deltaTwistProvider;
    private final DMatrixRMaj velocityChangeMatrix;
    private final Map<RigidBodyReadOnly, Twist> rigidBodyTwistMap = new HashMap<RigidBodyReadOnly, Twist>();
    private final Twist jointTwist = new Twist();

    public RigidBodyDeltaTwistCalculator(ReferenceFrame inertialFrame, JointMatrixIndexProvider jointMatrixIndexProvider, DMatrixRMaj velocityChangeMatrix) {
        this.inertialFrame = inertialFrame;
        this.jointMatrixIndexProvider = jointMatrixIndexProvider;
        this.velocityChangeMatrix = velocityChangeMatrix;
        this.deltaTwistProvider = RigidBodyTwistProvider.toRigidBodyTwistProvider((Function)this, (ReferenceFrame)inertialFrame);
    }

    public void reset() {
        this.rigidBodyTwistMap.clear();
    }

    public RigidBodyTwistProvider getDeltaTwistProvider() {
        return this.deltaTwistProvider;
    }

    @Override
    public TwistReadOnly apply(RigidBodyReadOnly body) {
        Twist twistOfBody = this.rigidBodyTwistMap.get(body);
        if (twistOfBody == null) {
            JointReadOnly parentJoint = body.getParentJoint();
            RigidBodyReadOnly parentBody = parentJoint.getPredecessor();
            TwistReadOnly twistOfParentBody = parentBody.isRootBody() ? null : this.apply(parentBody);
            if (parentJoint instanceof OneDoFJointReadOnly) {
                this.jointTwist.setIncludingFrame((SpatialMotionReadOnly)((OneDoFJointReadOnly)parentJoint).getUnitJointTwist());
                this.jointTwist.scale(this.velocityChangeMatrix.get(this.jointMatrixIndexProvider.getJointDoFIndices(parentJoint)[0]));
            } else if (parentJoint instanceof SixDoFJointReadOnly) {
                this.jointTwist.set(this.jointMatrixIndexProvider.getJointDoFIndices(parentJoint)[0], (DMatrix)this.velocityChangeMatrix);
                this.jointTwist.setReferenceFrame((ReferenceFrame)parentJoint.getFrameAfterJoint());
                this.jointTwist.setBaseFrame((ReferenceFrame)parentJoint.getFrameBeforeJoint());
                this.jointTwist.setBodyFrame((ReferenceFrame)parentJoint.getFrameAfterJoint());
            } else {
                throw new UnsupportedOperationException("Implement me for: " + parentJoint.getClass().getSimpleName());
            }
            this.jointTwist.changeFrame((ReferenceFrame)body.getBodyFixedFrame());
            this.jointTwist.setBaseFrame((ReferenceFrame)parentBody.getBodyFixedFrame());
            this.jointTwist.setBodyFrame((ReferenceFrame)body.getBodyFixedFrame());
            twistOfBody = new Twist();
            if (twistOfParentBody == null) {
                twistOfBody.setToZero((ReferenceFrame)parentBody.getBodyFixedFrame(), this.inertialFrame, (ReferenceFrame)parentBody.getBodyFixedFrame());
            } else {
                twistOfBody.setIncludingFrame((SpatialMotionReadOnly)twistOfParentBody);
            }
            twistOfBody.changeFrame((ReferenceFrame)body.getBodyFixedFrame());
            twistOfBody.add((TwistReadOnly)this.jointTwist);
            this.rigidBodyTwistMap.put(body, twistOfBody);
        }
        return twistOfBody;
    }
}

