/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.contactPointBased;

import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.simulation.collision.Collidable;
import us.ihmc.scs2.simulation.collision.CollidableHolder;
import us.ihmc.scs2.simulation.parameters.ContactPointBasedContactParameters;
import us.ihmc.scs2.simulation.parameters.ContactPointBasedContactParametersReadOnly;
import us.ihmc.scs2.simulation.parameters.YoContactPointBasedContactParameters;
import us.ihmc.scs2.simulation.robot.RobotInterface;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.trackers.GroundContactPoint;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ContactPointBasedForceCalculator {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoContactPointBasedContactParameters parameters = new YoContactPointBasedContactParameters("ground", this.registry);
    private final ReferenceFrame inertialFrame;
    private boolean hasPrintedErrorMessageAboutMultipleCollisions = false;
    private final Point3D closestPointOnSurface = new Point3D();
    private final Vector3D normalAtClosestPoint = new Vector3D();
    private final Vector3D deltaPositionFromTouchdown = new Vector3D();
    private final Vector3D linearVelocityWorld = new Vector3D();
    private final Vector3D inPlaneVector1 = new Vector3D();
    private final Vector3D inPlaneVector2 = new Vector3D();
    private final Vector3D forceParallel = new Vector3D();
    private final Vector3D forceNormal = new Vector3D();
    private final Vector3D forceWorld = new Vector3D();

    public ContactPointBasedForceCalculator(ReferenceFrame inertialFrame, YoRegistry parentRegistry) {
        this.inertialFrame = inertialFrame;
        this.parameters.set(ContactPointBasedContactParameters.defaultParameters());
        parentRegistry.addChild(this.registry);
    }

    public void setParameters(ContactPointBasedContactParametersReadOnly parameters) {
        this.parameters.set(parameters);
    }

    public void resolveContactForces(List<? extends RobotInterface> robots, CollidableHolder staticCollidableHolder) {
        for (RobotInterface robotInterface : robots) {
            this.resolveContactForces(robotInterface, staticCollidableHolder);
        }
    }

    public void resolveContactForces(RobotInterface robot, CollidableHolder staticCollidableHolder) {
        for (SimJointBasics simJointBasics : robot.getJointsToConsider()) {
            if (simJointBasics.getAuxiliaryData().getGroundContactPoints().isEmpty()) continue;
            for (GroundContactPoint gcp : simJointBasics.getAuxiliaryData().getGroundContactPoints()) {
                YoFramePoseUsingYawPitchRoll gcpPose = gcp.getPose();
                List activeCollidables = staticCollidableHolder.getCollidables().stream().filter(collidable -> {
                    if (!collidable.getBoundingBox().isInsideInclusive((FramePoint3DReadOnly)gcpPose.getPosition())) {
                        return false;
                    }
                    return collidable.getShape().isPointInside((FramePoint3DReadOnly)gcpPose.getPosition());
                }).collect(Collectors.toList());
                if (activeCollidables.isEmpty()) {
                    gcp.getInContact().set(false);
                    gcp.getIsSlipping().set(false);
                    gcp.getWrench().setToZero();
                    continue;
                }
                if (activeCollidables.size() > 1 && !this.hasPrintedErrorMessageAboutMultipleCollisions) {
                    LogTools.error((String)"Cannot handle collision to more than one collidable. (Reporting error only once)");
                    this.hasPrintedErrorMessageAboutMultipleCollisions = true;
                }
                Collidable collidable2 = (Collidable)activeCollidables.get(0);
                collidable2.getShape().evaluatePoint3DCollision((FramePoint3DReadOnly)gcpPose.getPosition(), (Point3DBasics)this.closestPointOnSurface, (Vector3DBasics)this.normalAtClosestPoint);
                YoFramePose3D gcpTouchdownPose = gcp.getTouchdownPose();
                if (!gcp.getInContact().getValue()) {
                    gcp.getInContact().set(true);
                    gcpTouchdownPose.set(gcpPose);
                    gcp.getContactNormal().set((Tuple3DReadOnly)this.normalAtClosestPoint);
                }
                this.resolveContactForceUsingSurfaceNormal(gcp);
                this.checkIfSlipping(gcp);
            }
        }
    }

    private void resolveContactForceUsingSurfaceNormal(GroundContactPoint gcp) {
        YoFramePoseUsingYawPitchRoll gcpPose = gcp.getPose();
        YoFramePose3D gcpTouchdownPose = gcp.getTouchdownPose();
        YoFrameVector3D contactNormal = gcp.getContactNormal();
        this.deltaPositionFromTouchdown.sub((Tuple3DReadOnly)gcpTouchdownPose.getPosition(), (Tuple3DReadOnly)gcpPose.getPosition());
        this.linearVelocityWorld.set((Tuple3DReadOnly)gcp.getTwist().getLinearPart());
        gcp.getFrame().transformFromThisToDesiredFrame(this.inertialFrame, (Transformable)this.linearVelocityWorld);
        this.inPlaneVector1.set((Tuple3DReadOnly)Axis3D.Y);
        if (Math.abs(this.inPlaneVector1.dot((Tuple3DReadOnly)contactNormal)) == 1.0) {
            this.inPlaneVector1.set((Tuple3DReadOnly)Axis3D.X);
        }
        this.inPlaneVector1.cross((Tuple3DReadOnly)this.inPlaneVector1, (Tuple3DReadOnly)contactNormal);
        this.inPlaneVector1.normalize();
        this.inPlaneVector2.cross((Tuple3DReadOnly)contactNormal, (Tuple3DReadOnly)this.inPlaneVector1);
        this.inPlaneVector2.normalize();
        double xPrime = this.inPlaneVector1.dot((Tuple3DReadOnly)this.deltaPositionFromTouchdown);
        double yPrime = this.inPlaneVector2.dot((Tuple3DReadOnly)this.deltaPositionFromTouchdown);
        double zPrime = contactNormal.dot((Tuple3DReadOnly)this.deltaPositionFromTouchdown);
        this.forceParallel.setAndScale(xPrime, (Tuple3DReadOnly)this.inPlaneVector1);
        this.forceParallel.scaleAdd(yPrime, (Tuple3DReadOnly)this.inPlaneVector2, (Tuple3DReadOnly)this.forceParallel);
        this.forceParallel.scale(this.parameters.getKxy());
        this.forceNormal.set((Tuple3DReadOnly)contactNormal);
        if (this.parameters.getStiffeningLength() - zPrime > 0.002) {
            this.forceNormal.scale(this.parameters.getKz() * zPrime / (this.parameters.getStiffeningLength() - zPrime));
        } else {
            this.forceNormal.scale(this.parameters.getKz() * zPrime / 0.002);
        }
        xPrime = this.inPlaneVector1.dot((Tuple3DReadOnly)this.linearVelocityWorld);
        yPrime = this.inPlaneVector2.dot((Tuple3DReadOnly)this.linearVelocityWorld);
        zPrime = contactNormal.dot((Tuple3DReadOnly)this.linearVelocityWorld);
        this.forceParallel.scaleAdd(-this.parameters.getBxy() * xPrime, (Tuple3DReadOnly)this.inPlaneVector1, (Tuple3DReadOnly)this.forceParallel);
        this.forceParallel.scaleAdd(-this.parameters.getBxy() * yPrime, (Tuple3DReadOnly)this.inPlaneVector2, (Tuple3DReadOnly)this.forceParallel);
        this.forceNormal.scaleAdd(-this.parameters.getBz() * zPrime, (Tuple3DReadOnly)contactNormal, (Tuple3DReadOnly)this.forceNormal);
        double magnitudeOfForceNormal = this.forceNormal.dot((Tuple3DReadOnly)contactNormal);
        if (magnitudeOfForceNormal < 0.0) {
            if (zPrime < 0.0) {
                this.forceParallel.setToZero();
                this.forceNormal.setToZero();
                gcp.getInContact().set(false);
            } else {
                this.forceNormal.set(0.0, 0.0, 0.0);
            }
        }
        gcp.getWrench().getLinearPart().add((Tuple3DReadOnly)this.forceParallel, (Tuple3DReadOnly)this.forceNormal);
        this.inertialFrame.transformFromThisToDesiredFrame((ReferenceFrame)gcp.getFrame(), (Transformable)gcp.getWrench().getLinearPart());
    }

    private void checkIfSlipping(GroundContactPoint gcp) {
        if (!this.parameters.isSlipEnabled()) {
            gcp.getIsSlipping().set(false);
            return;
        }
        this.forceWorld.set((Tuple3DReadOnly)gcp.getWrench().getLinearPart());
        gcp.getFrame().transformFromThisToDesiredFrame((ReferenceFrame)gcp.getFrame(), (Transformable)this.forceWorld);
        YoFrameVector3D contactNormal = gcp.getContactNormal();
        this.forceNormal.set((Tuple3DReadOnly)contactNormal);
        this.forceNormal.scale(contactNormal.dot((Tuple3DReadOnly)this.forceWorld));
        this.forceParallel.sub((Tuple3DReadOnly)this.forceWorld, (Tuple3DReadOnly)this.forceNormal);
        double parallelSpringForce = this.forceParallel.norm();
        double normalSpringForce = this.forceNormal.norm();
        double ratio = parallelSpringForce / normalSpringForce;
        if (ratio > this.parameters.getAlphaStick() || gcp.getIsSlipping().getValue() && ratio > this.parameters.getAlphaSlip()) {
            gcp.getIsSlipping().set(true);
            double parallelSlipForce = this.parameters.getAlphaSlip() * normalSpringForce;
            double parallelScale = parallelSlipForce / parallelSpringForce;
            if (parallelScale < 1.0) {
                this.forceParallel.scale(parallelScale);
            }
            this.forceWorld.add((Tuple3DReadOnly)this.forceNormal, (Tuple3DReadOnly)this.forceParallel);
            gcp.getWrench().getLinearPart().setMatchingFrame(this.inertialFrame, (Tuple3DReadOnly)this.forceWorld);
            double len = this.forceParallel.norm();
            if (len > 1.0E-7) {
                this.forceParallel.scale(1.0 / len);
            }
            YoFramePoseUsingYawPitchRoll gcpPose = gcp.getPose();
            YoFramePose3D gcpTouchdownPose = gcp.getTouchdownPose();
            gcpTouchdownPose.getPosition().scaleAdd(-0.05 * gcpPose.getPosition().distance((FramePoint3DReadOnly)gcpTouchdownPose.getPosition()), (Tuple3DReadOnly)this.forceParallel, (FrameTuple3DReadOnly)gcpTouchdownPose.getPosition());
            gcp.getContactNormal().set((Tuple3DReadOnly)this.normalAtClosestPoint);
        } else {
            gcp.getIsSlipping().set(false);
        }
    }
}

