/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.RobotStateDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.yoVariables.registry.YoRegistry;

public interface PhysicsEngine {
    public boolean initialize(Vector3DReadOnly var1);

    public void simulate(double var1, double var3, Vector3DReadOnly var5);

    public void pause();

    default public Robot addRobot(RobotDefinition robotDefinition) {
        Robot robot = new Robot(robotDefinition, this.getInertialFrame());
        this.addRobot(robot);
        return robot;
    }

    default public void addRobots(Collection<? extends Robot> robots) {
        for (Robot robot : robots) {
            this.addRobot(robot);
        }
    }

    public void addRobot(Robot var1);

    public void addTerrainObject(TerrainObjectDefinition var1);

    public ReferenceFrame getInertialFrame();

    public List<? extends Robot> getRobots();

    public List<RobotDefinition> getRobotDefinitions();

    public List<TerrainObjectDefinition> getTerrainObjectDefinitions();

    default public List<RobotStateDefinition> getCurrentRobotStateDefinitions() {
        return this.getRobots().stream().map(Robot::getCurrentRobotStateDefinition).collect(Collectors.toList());
    }

    public List<RobotStateDefinition> getBeforePhysicsRobotStateDefinitions();

    public YoRegistry getPhysicsEngineRegistry();

    default public void dispose() {
    }
}

