/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.impulseBased;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.algorithms.ForwardDynamicsCalculator;
import us.ihmc.mecano.algorithms.MultiBodyResponseCalculator;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyAccelerationProvider;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyTwistProvider;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialImpulse;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialImpulseBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialImpulseReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.scs2.simulation.collision.Collidable;
import us.ihmc.scs2.simulation.collision.CollisionResult;
import us.ihmc.scs2.simulation.collision.PhysicsEngineTools;
import us.ihmc.scs2.simulation.parameters.ContactParameters;
import us.ihmc.scs2.simulation.parameters.ContactParametersBasics;
import us.ihmc.scs2.simulation.parameters.ContactParametersReadOnly;
import us.ihmc.scs2.simulation.physicsEngine.JointStateProvider;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.ImpulseBasedConstraintCalculator;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.ImpulseBasedJointTwistProvider;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.ImpulseBasedRigidBodyTwistProvider;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.SingleContactImpulseSolver;

public class SingleContactImpulseCalculator
implements ImpulseBasedConstraintCalculator {
    private final ContactParameters contactParameters = new ContactParameters();
    private boolean isFirstUpdate = false;
    private boolean isImpulseZero = false;
    private boolean isContactClosing = false;
    private boolean isContactSlipping = false;
    private boolean wasMomentFrictionZero = false;
    private final ForwardDynamicsCalculator forwardDynamicsCalculatorA;
    private final ForwardDynamicsCalculator forwardDynamicsCalculatorB;
    private final MultiBodyResponseCalculator responseCalculatorA;
    private final MultiBodyResponseCalculator responseCalculatorB;
    private final FramePoint3D pointA = new FramePoint3D();
    private final FramePoint3D pointB = new FramePoint3D();
    private final SpatialVector velocityNoImpulseA = new SpatialVector();
    private final SpatialVector velocityNoImpulseB = new SpatialVector();
    private final SpatialVector velocityDueToOtherImpulseA = new SpatialVector();
    private final SpatialVector velocityDueToOtherImpulseB = new SpatialVector();
    private final SpatialVector velocityA = new SpatialVector();
    private final SpatialVector velocityB = new SpatialVector();
    private final SpatialVector velocityRelative = new SpatialVector();
    private final SpatialVector velocityRelativePrevious = new SpatialVector();
    private final SpatialVector velocityRelativeChange = new SpatialVector();
    private final SpatialVector velocitySolverInput = new SpatialVector();
    private final DMatrixRMaj inverseApparentInertiaA = new DMatrixRMaj(4, 4);
    private final DMatrixRMaj inverseApparentInertiaB = new DMatrixRMaj(4, 4);
    private final SpatialImpulse impulseA = new SpatialImpulse();
    private final SpatialImpulse impulseB = new SpatialImpulse();
    private final SpatialImpulse impulsePreviousA = new SpatialImpulse();
    private final SpatialImpulse impulseChangeA = new SpatialImpulse();
    private final Point3D contactFramePosition = new Point3D();
    private final Quaternion contactFrameOrientation = new Quaternion();
    private final ReferenceFrame contactFrame;
    private final RigidBodyBasics rootA;
    private final RigidBodyBasics rootB;
    private RigidBodyTwistProvider externalRigidBodyTwistModifier;
    private final ImpulseBasedRigidBodyTwistProvider rigidBodyTwistModifierA;
    private final ImpulseBasedRigidBodyTwistProvider rigidBodyTwistModifierB;
    private final ImpulseBasedJointTwistProvider jointTwistModifierA;
    private final ImpulseBasedJointTwistProvider jointTwistModifierB;
    private CollisionResult collisionResult;
    private RigidBodyBasics contactingBodyA;
    private RigidBodyBasics contactingBodyB;
    private MovingReferenceFrame bodyFrameA;
    private MovingReferenceFrame bodyFrameB;
    private final SingleContactImpulseSolver.SolverOutput solverOutput = new SingleContactImpulseSolver.SolverOutput();
    private final SingleContactImpulseSolver solver = new SingleContactImpulseSolver();
    private final DMatrixRMaj M_inv = new DMatrixRMaj(4, 4);
    private final FrameVector3D collisionErrorReductionTerm = new FrameVector3D();
    private final SpatialImpulse testImpulse = new SpatialImpulse();
    private final Twist testTwist = new Twist();

    public SingleContactImpulseCalculator(ReferenceFrame rootFrame, RigidBodyBasics rootBodyA, ForwardDynamicsCalculator forwardDynamicsCalculatorA, RigidBodyBasics rootBodyB, ForwardDynamicsCalculator forwardDynamicsCalculatorB) {
        this.forwardDynamicsCalculatorA = forwardDynamicsCalculatorA;
        this.forwardDynamicsCalculatorB = forwardDynamicsCalculatorB;
        this.rootA = rootBodyA;
        this.rootB = rootBodyB;
        this.contactFrame = new ReferenceFrame("contactFrame[SCS2Internal]", rootFrame, true, false){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                transformToParent.set((Orientation3DReadOnly)SingleContactImpulseCalculator.this.contactFrameOrientation, (Tuple3DReadOnly)SingleContactImpulseCalculator.this.contactFramePosition);
            }
        };
        this.velocityA.setReferenceFrame(this.contactFrame);
        this.velocityB.setReferenceFrame(this.contactFrame);
        this.velocityRelative.setReferenceFrame(this.contactFrame);
        this.velocityRelativePrevious.setReferenceFrame(this.contactFrame);
        this.velocityRelativeChange.setReferenceFrame(this.contactFrame);
        this.impulsePreviousA.setReferenceFrame(this.contactFrame);
        this.impulseChangeA.setReferenceFrame(this.contactFrame);
        this.responseCalculatorA = new MultiBodyResponseCalculator(forwardDynamicsCalculatorA);
        this.responseCalculatorB = forwardDynamicsCalculatorB != null ? new MultiBodyResponseCalculator(forwardDynamicsCalculatorB) : null;
        this.rigidBodyTwistModifierA = new ImpulseBasedRigidBodyTwistProvider(rootFrame, this.rootA);
        this.jointTwistModifierA = new ImpulseBasedJointTwistProvider(this.rootA);
        if (forwardDynamicsCalculatorB != null) {
            this.rigidBodyTwistModifierB = new ImpulseBasedRigidBodyTwistProvider(rootFrame, this.rootB);
            this.jointTwistModifierB = new ImpulseBasedJointTwistProvider(this.rootB);
        } else {
            this.rigidBodyTwistModifierB = null;
            this.jointTwistModifierB = null;
        }
        this.setContactParameters(ContactParameters.defaultIneslasticContactParameters(true));
    }

    public void setTolerance(double gamma) {
        this.solver.setTolerance(gamma);
    }

    public void setContactParameters(ContactParametersReadOnly parameters) {
        this.contactParameters.set(parameters);
    }

    @Override
    public void setExternalTwistModifier(RigidBodyTwistProvider externalRigidBodyTwistModifier) {
        this.externalRigidBodyTwistModifier = externalRigidBodyTwistModifier;
    }

    public void setCollision(CollisionResult collisionResult) {
        Collidable collidableA = collisionResult.getCollidableA();
        Collidable collidableB = collisionResult.getCollidableB();
        if (collidableA.getRootBody() != this.rootA || collidableB.getRootBody() != this.rootB) {
            throw new IllegalArgumentException("Robot mismatch!");
        }
        this.collisionResult = collisionResult;
        this.contactingBodyA = collidableA.getRigidBody();
        this.contactingBodyB = collidableB.getRigidBody();
        this.bodyFrameA = this.contactingBodyA.getBodyFixedFrame();
        this.bodyFrameB = this.contactingBodyB == null ? null : this.contactingBodyB.getBodyFixedFrame();
    }

    @Override
    public void initialize(double dt) {
        EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)this.collisionResult.getCollisionAxisForA(), (Orientation3DBasics)this.contactFrameOrientation);
        this.contactFramePosition.set((Tuple3DReadOnly)this.collisionResult.getPointOnARootFrame());
        this.contactFrame.update();
        this.pointA.setIncludingFrame((FrameTuple3DReadOnly)this.collisionResult.getCollisionData().getPointOnA());
        this.pointA.changeFrame((ReferenceFrame)this.bodyFrameA);
        RigidBodyAccelerationProvider accelerationProviderA = this.forwardDynamicsCalculatorA.getAccelerationProvider(false);
        SingleContactImpulseCalculator.predictContactPointSpatialVelocity(dt, (RigidBodyReadOnly)this.rootA, (RigidBodyReadOnly)this.contactingBodyA, accelerationProviderA, (FramePoint3DReadOnly)this.pointA, (SpatialVectorBasics)this.velocityNoImpulseA);
        this.velocityNoImpulseA.changeFrame(this.contactFrame);
        this.pointB.setIncludingFrame((FrameTuple3DReadOnly)this.collisionResult.getCollisionData().getPointOnB());
        if (this.rootB != null) {
            this.pointB.changeFrame((ReferenceFrame)this.bodyFrameB);
            RigidBodyAccelerationProvider accelerationProviderB = this.forwardDynamicsCalculatorB.getAccelerationProvider(false);
            SingleContactImpulseCalculator.predictContactPointSpatialVelocity(dt, (RigidBodyReadOnly)this.rootB, (RigidBodyReadOnly)this.contactingBodyB, accelerationProviderB, (FramePoint3DReadOnly)this.pointB, (SpatialVectorBasics)this.velocityNoImpulseB);
            this.velocityNoImpulseB.changeFrame(this.contactFrame);
        }
        this.velocitySolverInput.setToZero(this.contactFrame);
        this.isFirstUpdate = true;
        this.wasMomentFrictionZero = true;
        this.solver.setEnableFrictionMoment(this.contactParameters.getComputeFrictionMoment());
        this.solver.setCoulombMomentRatio(this.contactParameters.getCoulombMomentFrictionRatio());
    }

    @Override
    public void updateInertia(List<? extends RigidBodyBasics> rigidBodyTargets, List<? extends JointBasics> jointTargets) {
        this.rigidBodyTwistModifierA.clear(this.solver.getProblemSize());
        this.jointTwistModifierA.clear(this.solver.getProblemSize());
        if (rigidBodyTargets != null) {
            this.rigidBodyTwistModifierA.addAll(rigidBodyTargets);
        }
        if (jointTargets != null) {
            this.jointTwistModifierA.addAll(jointTargets);
        }
        if (this.rootB != null) {
            this.rigidBodyTwistModifierB.clear(this.solver.getProblemSize());
            this.jointTwistModifierB.clear(this.solver.getProblemSize());
            if (rigidBodyTargets != null) {
                this.rigidBodyTwistModifierB.addAll(rigidBodyTargets);
            }
            if (jointTargets != null) {
                this.jointTwistModifierB.addAll(jointTargets);
            }
        }
        this.computeApparentInertiaInverse(this.contactingBodyA, this.responseCalculatorA, this.rigidBodyTwistModifierA, this.jointTwistModifierA, this.inverseApparentInertiaA);
        if (this.rootB != null) {
            this.computeApparentInertiaInverse(this.contactingBodyB, this.responseCalculatorB, this.rigidBodyTwistModifierB, this.jointTwistModifierB, this.inverseApparentInertiaB);
            CommonOps_DDRM.add((DMatrixD1)this.inverseApparentInertiaA, (DMatrixD1)this.inverseApparentInertiaB, (DMatrixD1)this.M_inv);
        } else {
            this.M_inv.set((DMatrixD1)this.inverseApparentInertiaA);
        }
        this.solver.reset();
    }

    public static void computeContactPointLinearVelocity(double dt, RigidBodyReadOnly rootBody, RigidBodyReadOnly contactingBody, RigidBodyAccelerationProvider noVelocityRigidBodyAccelerationProvider, FramePoint3DReadOnly contactPoint, FrameVector3DBasics linearVelocityToPack) {
        MovingReferenceFrame bodyFixedFrame = contactingBody.getBodyFixedFrame();
        linearVelocityToPack.setReferenceFrame((ReferenceFrame)bodyFixedFrame);
        SpatialAccelerationReadOnly contactingBodyAcceleration = noVelocityRigidBodyAccelerationProvider.getRelativeAcceleration(rootBody, contactingBody);
        contactingBodyAcceleration.getLinearAccelerationAt(null, contactPoint, linearVelocityToPack);
        linearVelocityToPack.scale(dt);
        double vx = linearVelocityToPack.getX();
        double vy = linearVelocityToPack.getY();
        double vz = linearVelocityToPack.getZ();
        bodyFixedFrame.getTwistOfFrame().getLinearVelocityAt(contactPoint, linearVelocityToPack);
        linearVelocityToPack.add(vx, vy, vz);
    }

    public static void predictContactPointSpatialVelocity(double dt, RigidBodyReadOnly rootBody, RigidBodyReadOnly contactingBody, RigidBodyAccelerationProvider noVelocityRigidBodyAccelerationProvider, FramePoint3DReadOnly contactPoint, SpatialVectorBasics spatialVelocityToPack) {
        MovingReferenceFrame bodyFixedFrame = contactingBody.getBodyFixedFrame();
        spatialVelocityToPack.setReferenceFrame((ReferenceFrame)bodyFixedFrame);
        FixedFrameVector3DBasics angularVelocity = spatialVelocityToPack.getAngularPart();
        FixedFrameVector3DBasics linearVelocity = spatialVelocityToPack.getLinearPart();
        SpatialAccelerationReadOnly contactingBodyAcceleration = noVelocityRigidBodyAccelerationProvider.getRelativeAcceleration(rootBody, contactingBody);
        angularVelocity.set((FrameTuple3DReadOnly)contactingBodyAcceleration.getAngularPart());
        contactingBodyAcceleration.getLinearAccelerationAt(null, contactPoint, linearVelocity);
        spatialVelocityToPack.scale(dt);
        double wx = angularVelocity.getX();
        double wy = angularVelocity.getY();
        double wz = angularVelocity.getZ();
        double vx = linearVelocity.getX();
        double vy = linearVelocity.getY();
        double vz = linearVelocity.getZ();
        SingleContactImpulseCalculator.packSpatialVelocityAt(bodyFixedFrame.getTwistOfFrame(), contactPoint, spatialVelocityToPack);
        angularVelocity.add(wx, wy, wz);
        linearVelocity.add(vx, vy, vz);
    }

    public static void packSpatialVelocityAt(TwistReadOnly twist, FramePoint3DReadOnly observerPosition, SpatialVectorBasics spatialVelocityToPack) {
        spatialVelocityToPack.setReferenceFrame(twist.getReferenceFrame());
        spatialVelocityToPack.getAngularPart().set((FrameTuple3DReadOnly)twist.getAngularPart());
        twist.getLinearVelocityAt(observerPosition, spatialVelocityToPack.getLinearPart());
    }

    @Override
    public void updateImpulse(double dt, double alpha, boolean ignoreOtherImpulses) {
        double erp;
        if (!ignoreOtherImpulses && this.externalRigidBodyTwistModifier != null) {
            SingleContactImpulseCalculator.packSpatialVelocityAt(this.externalRigidBodyTwistModifier.getTwistOfBody((RigidBodyReadOnly)this.contactingBodyA), (FramePoint3DReadOnly)this.pointA, (SpatialVectorBasics)this.velocityDueToOtherImpulseA);
            this.velocityDueToOtherImpulseA.changeFrame(this.contactFrame);
            this.velocityA.set((SpatialVectorReadOnly)this.velocityNoImpulseA);
            this.velocityA.add((SpatialVectorReadOnly)this.velocityDueToOtherImpulseA);
        } else {
            this.velocityA.set((SpatialVectorReadOnly)this.velocityNoImpulseA);
        }
        if (this.rootB != null) {
            if (!ignoreOtherImpulses && this.externalRigidBodyTwistModifier != null) {
                SingleContactImpulseCalculator.packSpatialVelocityAt(this.externalRigidBodyTwistModifier.getTwistOfBody((RigidBodyReadOnly)this.contactingBodyB), (FramePoint3DReadOnly)this.pointB, (SpatialVectorBasics)this.velocityDueToOtherImpulseB);
                this.velocityDueToOtherImpulseB.changeFrame(this.contactFrame);
                this.velocityB.set((SpatialVectorReadOnly)this.velocityNoImpulseB);
                this.velocityB.add((SpatialVectorReadOnly)this.velocityDueToOtherImpulseB);
            } else {
                this.velocityB.set((SpatialVectorReadOnly)this.velocityNoImpulseB);
            }
            this.velocityRelative.set((SpatialVectorReadOnly)this.velocityA);
            this.velocityRelative.sub((SpatialVectorReadOnly)this.velocityB);
        } else {
            this.velocityRelative.set((SpatialVectorReadOnly)this.velocityA);
        }
        this.velocitySolverInput.set((SpatialVectorReadOnly)this.velocityRelative);
        FixedFrameVector3DBasics linearVelocitySolverInput = this.velocitySolverInput.getLinearPart();
        double cr = this.contactParameters.getCoefficientOfRestitution();
        double rth = this.contactParameters.getRestitutionThreshold();
        if (cr != 0.0 && this.velocityRelative.getLinearPart().getZ() <= -rth) {
            linearVelocitySolverInput.addZ(cr * (this.velocityRelative.getLinearPart().getZ() + rth));
        }
        if ((erp = this.contactParameters.getErrorReductionParameter()) != 0.0) {
            this.collisionErrorReductionTerm.setIncludingFrame((FrameTuple3DReadOnly)this.collisionResult.getPointOnBRootFrame());
            this.collisionErrorReductionTerm.sub((FrameTuple3DReadOnly)this.collisionResult.getPointOnARootFrame());
            this.collisionErrorReductionTerm.changeFrame(this.contactFrame);
            double normalError = this.collisionErrorReductionTerm.getZ() - this.contactParameters.getMinimumPenetration();
            if (normalError > 0.0) {
                linearVelocitySolverInput.subZ(normalError *= erp / dt);
            }
        }
        this.isContactClosing = linearVelocitySolverInput.getZ() < 0.0;
        this.impulseA.setToZero((ReferenceFrame)this.bodyFrameA, this.contactFrame);
        if (this.isContactClosing) {
            boolean isMomentFrictionZero;
            this.solver.solveImpulseGeneral((SpatialVectorReadOnly)this.velocitySolverInput, this.M_inv, this.contactParameters.getCoefficientOfFriction(), this.solverOutput);
            this.solverOutput.getSpatialImpulse((FixedFrameSpatialImpulseBasics)this.impulseA);
            this.isContactSlipping = this.solverOutput.isLinearSlipping();
            boolean bl = isMomentFrictionZero = this.impulseA.getAngularPartZ() == 0.0;
            if (isMomentFrictionZero && !this.wasMomentFrictionZero) {
                this.solver.setEnableFrictionMoment(false);
            }
            this.wasMomentFrictionZero = isMomentFrictionZero;
        } else {
            this.isContactSlipping = false;
        }
        if (this.impulseA.getLinearPart().getZ() < 0.0) {
            LogTools.error((String)("Malformed impulse: " + this.impulseA + ", z: " + this.impulseA.getLinearPartZ()));
            this.impulseA.setToZero();
        }
        if (this.isFirstUpdate) {
            if (this.isContactClosing) {
                this.impulseChangeA.setIncludingFrame((SpatialImpulseReadOnly)this.impulseA);
                this.isImpulseZero = !this.isContactClosing;
            } else {
                this.impulseChangeA.setToZero((ReferenceFrame)this.bodyFrameA, this.contactFrame);
                this.isImpulseZero = true;
            }
        } else {
            this.impulseA.getLinearPart().interpolate((FrameTuple3DReadOnly)this.impulsePreviousA.getLinearPart(), (FrameTuple3DReadOnly)this.impulseA.getLinearPart(), alpha);
            if (this.contactParameters.getComputeFrictionMoment()) {
                this.impulseA.getAngularPart().setZ(EuclidCoreTools.interpolate((double)this.impulsePreviousA.getAngularPartZ(), (double)this.impulseA.getAngularPartZ(), (double)alpha));
            }
            this.impulseChangeA.set(this.impulseA);
            this.impulseChangeA.sub((SpatialImpulseReadOnly)this.impulsePreviousA);
            boolean bl = this.isImpulseZero = this.impulseA.getLinearPart().length() < 1.0E-6;
        }
        if (this.isImpulseZero) {
            if (this.rootB != null) {
                this.impulseB.setToZero((ReferenceFrame)this.contactingBodyB.getBodyFixedFrame(), this.impulseA.getReferenceFrame());
            }
        } else if (this.rootB != null) {
            this.impulseB.setIncludingFrame((ReferenceFrame)this.contactingBodyB.getBodyFixedFrame(), (SpatialVectorReadOnly)this.impulseA);
            this.impulseB.negate();
        }
        this.impulsePreviousA.setIncludingFrame((SpatialImpulseReadOnly)this.impulseA);
        if (this.isFirstUpdate) {
            this.velocityRelativePrevious.set((SpatialVectorReadOnly)this.velocityRelative);
            this.velocityRelativeChange.set((SpatialVectorReadOnly)this.velocityRelative);
        } else {
            this.velocityRelativeChange.set((SpatialVectorReadOnly)this.velocityRelative);
            this.velocityRelativeChange.sub((SpatialVectorReadOnly)this.velocityRelativePrevious);
            this.velocityRelativePrevious.set((SpatialVectorReadOnly)this.velocityRelative);
        }
        this.isFirstUpdate = false;
    }

    @Override
    public void updateTwistModifiers() {
        if (this.isImpulseZero) {
            this.rigidBodyTwistModifierA.setImpulseToZero();
            this.jointTwistModifierA.setImpulseToZero();
            if (this.rootB != null) {
                this.rigidBodyTwistModifierB.setImpulseToZero();
                this.jointTwistModifierB.setImpulseToZero();
            }
        } else if (this.contactParameters.getComputeFrictionMoment()) {
            this.rigidBodyTwistModifierA.setImpulse((Vector3DReadOnly)this.impulseA.getLinearPart(), this.impulseA.getAngularPartZ());
            this.jointTwistModifierA.setImpulse((Vector3DReadOnly)this.impulseA.getLinearPart(), this.impulseA.getAngularPartZ());
            if (this.rootB != null) {
                this.rigidBodyTwistModifierB.setImpulse((Vector3DReadOnly)this.impulseB.getLinearPart(), this.impulseB.getAngularPartZ());
                this.jointTwistModifierB.setImpulse((Vector3DReadOnly)this.impulseB.getLinearPart(), this.impulseB.getAngularPartZ());
            }
        } else {
            this.rigidBodyTwistModifierA.setImpulse((Vector3DReadOnly)this.impulseA.getLinearPart());
            this.jointTwistModifierA.setImpulse((Vector3DReadOnly)this.impulseA.getLinearPart());
            if (this.rootB != null) {
                this.rigidBodyTwistModifierB.setImpulse((Vector3DReadOnly)this.impulseB.getLinearPart());
                this.jointTwistModifierB.setImpulse((Vector3DReadOnly)this.impulseB.getLinearPart());
            }
        }
    }

    @Override
    public void finalizeImpulse() {
        this.responseCalculatorA.applyRigidBodyImpulse((RigidBodyReadOnly)this.contactingBodyA, (SpatialImpulseReadOnly)this.impulseA);
        if (this.rootB != null) {
            this.responseCalculatorB.applyRigidBodyImpulse((RigidBodyReadOnly)this.contactingBodyB, (SpatialImpulseReadOnly)this.impulseB);
        }
    }

    private void computeApparentInertiaInverse(RigidBodyBasics body, MultiBodyResponseCalculator calculator, ImpulseBasedRigidBodyTwistProvider rigidBodyTwistModifierToUpdate, ImpulseBasedJointTwistProvider jointTwistModifierToUpdate, DMatrixRMaj inertiaMatrixToPack) {
        calculator.reset();
        inertiaMatrixToPack.reshape(this.solver.getProblemSize(), this.solver.getProblemSize());
        RigidBodyTwistProvider twistChangeProvider = calculator.getTwistChangeProvider();
        for (int axis = 0; axis < 3; ++axis) {
            DMatrixRMaj externalInertiaMatrix;
            this.testImpulse.setIncludingFrame((ReferenceFrame)body.getBodyFixedFrame(), this.contactFrame, EuclidCoreTools.zeroVector3D, (Vector3DReadOnly)Axis3D.values[axis]);
            if (!calculator.applyRigidBodyImpulse((RigidBodyReadOnly)body, (SpatialImpulseReadOnly)this.testImpulse)) {
                throw new IllegalStateException("Something went wrong with the response calculator");
            }
            this.testTwist.setIncludingFrame((SpatialMotionReadOnly)twistChangeProvider.getTwistOfBody((RigidBodyReadOnly)body));
            this.testTwist.changeFrame(this.contactFrame);
            this.testTwist.getLinearPart().get(0, axis, (DMatrix)inertiaMatrixToPack);
            if (this.contactParameters.getComputeFrictionMoment()) {
                inertiaMatrixToPack.set(3, axis, this.testTwist.getAngularPartZ());
            }
            for (RigidBodyBasics rigidBodyBasics : rigidBodyTwistModifierToUpdate.getRigidBodies()) {
                externalInertiaMatrix = rigidBodyTwistModifierToUpdate.getApparentInertiaMatrixInverse(rigidBodyBasics);
                twistChangeProvider.getTwistOfBody((RigidBodyReadOnly)rigidBodyBasics).get(0, axis, (DMatrix)externalInertiaMatrix);
            }
            for (JointBasics jointBasics : jointTwistModifierToUpdate.getJoints()) {
                externalInertiaMatrix = jointTwistModifierToUpdate.getApparentInertiaMatrixInverse(jointBasics);
                CommonOps_DDRM.insert((DMatrix)calculator.getJointTwistChange((JointReadOnly)jointBasics), (DMatrix)externalInertiaMatrix, (int)0, (int)axis);
            }
            calculator.reset();
        }
        if (this.contactParameters.getComputeFrictionMoment()) {
            this.testImpulse.setIncludingFrame((ReferenceFrame)body.getBodyFixedFrame(), this.contactFrame, (Vector3DReadOnly)Axis3D.Z, EuclidCoreTools.zeroVector3D);
            if (!calculator.applyRigidBodyImpulse((RigidBodyReadOnly)body, (SpatialImpulseReadOnly)this.testImpulse)) {
                throw new IllegalStateException("Something went wrong with the response calculator");
            }
            this.testTwist.setIncludingFrame((SpatialMotionReadOnly)twistChangeProvider.getTwistOfBody((RigidBodyReadOnly)body));
            this.testTwist.changeFrame(this.contactFrame);
            this.testTwist.getLinearPart().get(0, 3, (DMatrix)inertiaMatrixToPack);
            inertiaMatrixToPack.set(3, 3, this.testTwist.getAngularPartZ());
            for (RigidBodyBasics rigidBodyBasics : rigidBodyTwistModifierToUpdate.getRigidBodies()) {
                DMatrixRMaj dMatrixRMaj = rigidBodyTwistModifierToUpdate.getApparentInertiaMatrixInverse(rigidBodyBasics);
                twistChangeProvider.getTwistOfBody((RigidBodyReadOnly)rigidBodyBasics).get(0, 3, (DMatrix)dMatrixRMaj);
            }
            for (JointBasics jointBasics : jointTwistModifierToUpdate.getJoints()) {
                DMatrixRMaj dMatrixRMaj = jointTwistModifierToUpdate.getApparentInertiaMatrixInverse(jointBasics);
                CommonOps_DDRM.insert((DMatrix)calculator.getJointTwistChange((JointReadOnly)jointBasics), (DMatrix)dMatrixRMaj, (int)0, (int)3);
            }
            calculator.reset();
        }
    }

    @Override
    public double getImpulseUpdate() {
        return EuclidCoreTools.norm((double)this.impulseChangeA.getLinearPartX(), (double)this.impulseChangeA.getLinearPartY(), (double)this.impulseChangeA.getLinearPartZ(), (double)this.impulseChangeA.getAngularPartZ());
    }

    @Override
    public double getVelocityUpdate() {
        return EuclidCoreTools.norm((double)this.velocityRelativeChange.getLinearPartX(), (double)this.velocityRelativeChange.getLinearPartY(), (double)this.velocityRelativeChange.getLinearPartZ(), (double)this.velocityRelativeChange.getAngularPartZ());
    }

    @Override
    public boolean isConstraintActive() {
        return !this.isImpulseZero;
    }

    public boolean isContactClosing() {
        return this.isContactClosing;
    }

    public boolean isContactSlipping() {
        return this.isContactSlipping;
    }

    public CollisionResult getCollisionResult() {
        return this.collisionResult;
    }

    public RigidBodyBasics getContactingBodyA() {
        return this.contactingBodyA;
    }

    public ForwardDynamicsCalculator getForwardDynamicsCalculatorA() {
        return this.forwardDynamicsCalculatorA;
    }

    public RigidBodyBasics getContactingBodyB() {
        return this.contactingBodyB;
    }

    public ForwardDynamicsCalculator getForwardDynamicsCalculatorB() {
        return this.forwardDynamicsCalculatorB;
    }

    @Override
    public int getNumberOfRobotsInvolved() {
        return this.responseCalculatorB == null ? 1 : 2;
    }

    @Override
    public RigidBodyBasics getRootBody(int index) {
        return index == 0 ? this.rootA : this.rootB;
    }

    @Override
    public RigidBodyTwistProvider getRigidBodyTwistChangeProvider(int index) {
        return index == 0 ? this.rigidBodyTwistModifierA : this.rigidBodyTwistModifierB;
    }

    @Override
    public JointStateProvider getJointTwistChangeProvider(int index) {
        return index == 0 ? this.jointTwistModifierA : this.jointTwistModifierB;
    }

    @Override
    public DMatrixRMaj getJointVelocityChange(int index) {
        return index == 0 ? this.getJointVelocityChangeA() : this.getJointVelocityChangeB();
    }

    public DMatrixRMaj getJointVelocityChangeA() {
        if (!this.isConstraintActive()) {
            return null;
        }
        return this.responseCalculatorA.propagateImpulse();
    }

    public DMatrixRMaj getJointVelocityChangeB() {
        if (this.rootB == null || !this.isConstraintActive()) {
            return null;
        }
        return this.responseCalculatorB.propagateImpulse();
    }

    public SpatialImpulseReadOnly getImpulse(int index) {
        return index == 0 ? this.getImpulseA() : this.getImpulseB();
    }

    public SpatialImpulseReadOnly getImpulseA() {
        return this.impulseA;
    }

    public SpatialImpulseReadOnly getImpulseB() {
        return this.impulseB;
    }

    public FramePoint3DReadOnly getPointA() {
        return this.pointA;
    }

    public FramePoint3DReadOnly getPointB() {
        return this.pointB;
    }

    public SpatialVectorReadOnly getVelocityRelative() {
        return this.velocityRelative;
    }

    public SpatialVectorReadOnly getVelocitySolverInput() {
        return this.velocitySolverInput;
    }

    public DMatrixRMaj getCollisionMatrix() {
        return this.M_inv;
    }

    public SpatialVectorReadOnly getVelocityNoImpulseA() {
        return this.velocityNoImpulseA;
    }

    public SpatialVectorReadOnly getVelocityNoImpulseB() {
        return this.velocityNoImpulseB;
    }

    public SpatialVectorReadOnly getVelocityDueToOtherImpulseA() {
        return this.velocityDueToOtherImpulseA;
    }

    public SpatialVectorReadOnly getVelocityDueToOtherImpulseB() {
        return this.velocityDueToOtherImpulseB;
    }

    public MultiBodyResponseCalculator getResponseCalculatorA() {
        return this.responseCalculatorA;
    }

    public MultiBodyResponseCalculator getResponseCalculatorB() {
        return this.responseCalculatorB;
    }

    public ContactParametersBasics getContactParameters() {
        return this.contactParameters;
    }

    @Override
    public List<? extends JointBasics> getJointTargets() {
        return Collections.emptyList();
    }

    @Override
    public List<? extends RigidBodyBasics> getRigidBodyTargets() {
        if (this.rootB == null) {
            return Collections.singletonList(this.contactingBodyA);
        }
        return Arrays.asList(this.contactingBodyA, this.contactingBodyB);
    }

    public void printForUnitTest() {
        this.solver.printForUnitTest(this.M_inv, this.contactParameters.getCoefficientOfFriction());
    }

    public String toString() {
        return "Collidables [A: " + PhysicsEngineTools.collidableSimpleName(this.collisionResult.getCollidableA()) + ", B: " + PhysicsEngineTools.collidableSimpleName(this.collisionResult.getCollidableB()) + "], velocity relative: " + this.velocityRelative + ", impulse A: " + this.impulseA.getLinearPart();
    }
}

