/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.multiBodySystem;

import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoFactories;
import us.ihmc.mecano.yoVariables.multiBodySystem.YoRevoluteJoint;
import us.ihmc.scs2.definition.robot.RevoluteJointDefinition;
import us.ihmc.scs2.simulation.robot.SimJointAuxiliaryData;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimOneDoFJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class SimRevoluteJoint
extends YoRevoluteJoint
implements SimOneDoFJointBasics {
    private final YoRegistry registry;
    private final SimJointAuxiliaryData auxiliaryData;
    private final YoDouble deltaQd;
    private final YoBoolean isPinned;
    private final YoDouble damping;
    private final TwistReadOnly jointDeltaTwist;

    public SimRevoluteJoint(RevoluteJointDefinition definition, SimRigidBodyBasics predecessor) {
        this(definition.getName(), predecessor, (RigidBodyTransformReadOnly)definition.getTransformToParent(), (Vector3DReadOnly)definition.getAxis());
        this.setJointLimits(definition.getPositionLowerLimit(), definition.getPositionUpperLimit());
        this.setVelocityLimits(definition.getVelocityLowerLimit(), definition.getVelocityUpperLimit());
        this.setEffortLimits(definition.getEffortLowerLimit(), definition.getEffortUpperLimit());
        this.setDamping(definition.getDamping());
    }

    public SimRevoluteJoint(String name, SimRigidBodyBasics predecessor, Vector3DReadOnly jointAxis) {
        this(name, predecessor, (RigidBodyTransformReadOnly)null, jointAxis);
    }

    public SimRevoluteJoint(String name, SimRigidBodyBasics predecessor, Tuple3DReadOnly jointOffset, Vector3DReadOnly jointAxis) {
        this(name, predecessor, (RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), jointOffset), jointAxis);
    }

    public SimRevoluteJoint(String name, SimRigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent, Vector3DReadOnly jointAxis) {
        super(name, (RigidBodyBasics)predecessor, transformToParent, jointAxis, predecessor.getRegistry());
        this.registry = predecessor.getRegistry();
        this.auxiliaryData = new SimJointAuxiliaryData(this);
        this.deltaQd = new YoDouble("qd_delta_" + this.getName(), this.registry);
        this.jointDeltaTwist = MecanoFactories.newTwistReadOnly(this::getDeltaQd, (TwistReadOnly)this.getUnitJointTwist());
        this.isPinned = new YoBoolean("is_" + this.getName() + "_pinned", this.registry);
        this.damping = new YoDouble("damping_" + this.getName(), this.registry);
        this.getYoQ().addListener(v -> {
            if (!Double.isFinite(this.getQ())) {
                throw new IllegalStateException("Invalid joint configuration: " + this.getQ());
            }
        });
    }

    @Override
    public YoRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public SimJointAuxiliaryData getAuxiliaryData() {
        return this.auxiliaryData;
    }

    public void setSuccessor(RigidBodyBasics successor) {
        if (!(successor instanceof SimRigidBodyBasics)) {
            throw new IllegalArgumentException("Can only set a " + SimRigidBodyBasics.class.getSimpleName() + " as successor of a " + this.getClass().getSimpleName());
        }
        super.setSuccessor(successor);
    }

    @Override
    public SimRigidBodyBasics getPredecessor() {
        return (SimRigidBodyBasics)super.getPredecessor();
    }

    @Override
    public SimRigidBodyBasics getSuccessor() {
        return (SimRigidBodyBasics)super.getSuccessor();
    }

    @Override
    public double getDamping() {
        return this.damping.getValue();
    }

    @Override
    public void setDamping(double damping) {
        this.damping.set(damping);
    }

    @Override
    public double getDeltaQd() {
        return this.deltaQd.getValue();
    }

    @Override
    public void setDeltaQd(double deltaQd) {
        this.deltaQd.set(deltaQd);
    }

    @Override
    public void setJointAngularDeltaVelocity(Vector3DReadOnly jointAngularDeltaVelocity) {
        this.setDeltaQd(this.getJointAxis().dot(jointAngularDeltaVelocity));
    }

    @Override
    public void setJointLinearDeltaVelocity(Vector3DReadOnly jointLinearDeltaVelocity) {
    }

    @Override
    public TwistReadOnly getJointDeltaTwist() {
        return this.jointDeltaTwist;
    }

    @Override
    public void setPinned(boolean isPinned) {
        this.isPinned.set(isPinned);
    }

    @Override
    public boolean isPinned() {
        return this.isPinned.getValue();
    }
}

