/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.multiBodySystem;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoFactories;
import us.ihmc.mecano.tools.MecanoTools;
import us.ihmc.mecano.yoVariables.multiBodySystem.YoSphericalJoint;
import us.ihmc.scs2.definition.robot.SphericalJointDefinition;
import us.ihmc.scs2.simulation.robot.SimJointAuxiliaryData;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimSixDoFJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SimSphericalJoint
extends YoSphericalJoint
implements SimJointBasics {
    private final YoRegistry registry;
    private final SimJointAuxiliaryData auxiliaryData;
    private final YoFrameVector3D jointAngularDeltaVelocity;
    private final TwistReadOnly jointDeltaTwist;

    public SimSphericalJoint(SphericalJointDefinition definition, SimRigidBodyBasics predecessor) {
        this(definition.getName(), predecessor, (RigidBodyTransformReadOnly)definition.getTransformToParent());
    }

    public SimSphericalJoint(String name, SimRigidBodyBasics predecessor, Tuple3DReadOnly jointOffset) {
        this(name, predecessor, (RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), jointOffset));
    }

    public SimSphericalJoint(String name, SimRigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
        super(name, (RigidBodyBasics)predecessor, transformToParent, predecessor.getRegistry());
        this.registry = predecessor.getRegistry();
        this.auxiliaryData = new SimJointAuxiliaryData(this);
        Object varName = !name.isEmpty() ? "_" + name + "_" : "_";
        this.jointAngularDeltaVelocity = new YoFrameVector3D("qd_delta" + (String)varName + "w", (ReferenceFrame)this.afterJointFrame, this.registry);
        this.jointDeltaTwist = MecanoFactories.newTwistReadOnly((ReferenceFrame)this.afterJointFrame, (ReferenceFrame)this.beforeJointFrame, (FrameVector3DReadOnly)this.jointAngularDeltaVelocity, (FrameVector3DReadOnly)new FrameVector3D((ReferenceFrame)this.afterJointFrame));
    }

    @Override
    public YoRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public SimJointAuxiliaryData getAuxialiryData() {
        return this.auxiliaryData;
    }

    public void setSuccessor(RigidBodyBasics successor) {
        if (!(successor instanceof SimRigidBodyBasics)) {
            throw new IllegalArgumentException("Can only set a " + SimRigidBodyBasics.class.getSimpleName() + " as successor of a " + this.getClass().getSimpleName());
        }
        super.setSuccessor(successor);
    }

    public FixedFrameVector3DBasics getJointAngularDeltaVelocity() {
        return this.jointAngularDeltaVelocity;
    }

    @Override
    public SimRigidBodyBasics getPredecessor() {
        return (SimRigidBodyBasics)super.getPredecessor();
    }

    @Override
    public SimRigidBodyBasics getSuccessor() {
        return (SimRigidBodyBasics)super.getSuccessor();
    }

    @Override
    public TwistReadOnly getJointDeltaTwist() {
        return this.jointDeltaTwist;
    }

    @Override
    public int getJointDeltaVelocity(int rowStart, DMatrix matrixToPack) {
        this.getJointTwist().get(rowStart, matrixToPack);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    public void setJointDeltaTwistToZero() {
        this.jointAngularDeltaVelocity.setToZero();
    }

    @Override
    public void setJointDeltaTwist(JointReadOnly other) {
        this.setJointDeltaTwist((SimSixDoFJoint)MecanoTools.checkTypeAndCast((JointReadOnly)other, SimSixDoFJoint.class));
    }

    public void setJointDeltaTwist(SimSixDoFJoint other) {
        FixedFrameVector3DBasics otherAngularDeltaVelocity = other.getJointDeltaTwist().getAngularPart();
        this.setJointAngularDeltaVelocity((Vector3DReadOnly)otherAngularDeltaVelocity);
    }

    @Override
    public int setJointDeltaVelocity(int rowStart, DMatrix matrix) {
        this.jointAngularDeltaVelocity.set(rowStart, matrix);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    public void setJointAngularDeltaVelocity(Vector3DReadOnly jointAngularDeltaVelocity) {
        this.jointAngularDeltaVelocity.set((Tuple3DReadOnly)jointAngularDeltaVelocity);
    }

    @Override
    public void setJointLinearDeltaVelocity(Vector3DReadOnly jointLinearDeltaVelocity) {
    }
}

