/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.state;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.state.interfaces.SixDoFJointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.SixDoFJointStateReadOnly;
import us.ihmc.yoVariables.euclid.YoPoint3D;
import us.ihmc.yoVariables.euclid.YoQuaternion;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoSixDoFJointState
implements SixDoFJointStateBasics {
    private final YoQuaternion orientation;
    private final YoPoint3D position;
    private final YoVector3D angularVelocity;
    private final YoVector3D linearVelocity;
    private final YoVector3D angularAcceleration;
    private final YoVector3D linearAcceleration;
    private final YoVector3D torque;
    private final YoVector3D force;
    private final DMatrixRMaj temp = new DMatrixRMaj(7, 1);

    public YoSixDoFJointState(String namePrefix, String nameSuffix, YoRegistry registry) {
        if (namePrefix == null) {
            namePrefix = "";
        } else if (!((String)namePrefix).isEmpty() && !((String)namePrefix).endsWith("_")) {
            namePrefix = (String)namePrefix + "_";
        }
        if (nameSuffix == null) {
            nameSuffix = "";
        } else if (!((String)nameSuffix).isEmpty() && !((String)nameSuffix).startsWith("_")) {
            nameSuffix = "_" + (String)nameSuffix;
        }
        this.orientation = new YoQuaternion((String)namePrefix + "q_", (String)nameSuffix, registry);
        this.position = new YoPoint3D((String)namePrefix + "q_", (String)nameSuffix, registry);
        this.angularVelocity = new YoVector3D((String)namePrefix + "qd_w", (String)nameSuffix, registry);
        this.linearVelocity = new YoVector3D((String)namePrefix + "qd_", (String)nameSuffix, registry);
        this.angularAcceleration = new YoVector3D((String)namePrefix + "qdd_w", (String)nameSuffix, registry);
        this.linearAcceleration = new YoVector3D((String)namePrefix + "qdd_", (String)nameSuffix, registry);
        this.torque = new YoVector3D((String)namePrefix + "tau_w", (String)nameSuffix, registry);
        this.force = new YoVector3D((String)namePrefix + "tau_", (String)nameSuffix, registry);
    }

    public void set(JointStateReadOnly jointStateReadOnly) {
        if (jointStateReadOnly instanceof SixDoFJointStateReadOnly) {
            super.set((SixDoFJointStateReadOnly)jointStateReadOnly);
        } else {
            if (jointStateReadOnly.getConfigurationSize() != this.getConfigurationSize() || jointStateReadOnly.getDegreesOfFreedom() != this.getDegreesOfFreedom()) {
                throw new IllegalArgumentException("Dimension mismatch");
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.CONFIGURATION)) {
                jointStateReadOnly.getConfiguration(0, (DMatrix)this.temp);
                this.setConfiguration(0, (DMatrix)this.temp);
            } else {
                this.orientation.setToNaN();
                this.position.setToNaN();
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.VELOCITY)) {
                jointStateReadOnly.getVelocity(0, (DMatrix)this.temp);
                this.setVelocity(0, (DMatrix)this.temp);
            } else {
                this.angularVelocity.setToNaN();
                this.linearVelocity.setToNaN();
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.ACCELERATION)) {
                jointStateReadOnly.getAcceleration(0, (DMatrix)this.temp);
                this.setAcceleration(0, (DMatrix)this.temp);
            } else {
                this.angularAcceleration.setToNaN();
                this.linearAcceleration.setToNaN();
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.EFFORT)) {
                jointStateReadOnly.getEffort(0, (DMatrix)this.temp);
                this.setEffort(0, (DMatrix)this.temp);
            } else {
                this.torque.setToNaN();
                this.force.setToNaN();
            }
        }
    }

    public SixDoFJointState copy() {
        return new SixDoFJointState((JointStateReadOnly)this);
    }

    public YoQuaternion getOrientation() {
        return this.orientation;
    }

    public YoPoint3D getPosition() {
        return this.position;
    }

    public YoVector3D getAngularVelocity() {
        return this.angularVelocity;
    }

    public YoVector3D getLinearVelocity() {
        return this.linearVelocity;
    }

    public YoVector3D getAngularAcceleration() {
        return this.angularAcceleration;
    }

    public YoVector3D getLinearAcceleration() {
        return this.linearAcceleration;
    }

    public YoVector3D getTorque() {
        return this.torque;
    }

    public YoVector3D getForce() {
        return this.force;
    }

    public String toString() {
        Object ret = "6-DoF joint state";
        if (this.hasOutputFor(JointStateType.CONFIGURATION)) {
            ret = (String)ret + ", orientation: " + this.orientation.toStringAsYawPitchRoll() + ", position: " + String.valueOf(this.position);
        }
        if (this.hasOutputFor(JointStateType.VELOCITY)) {
            ret = (String)ret + ", angular velocity: " + String.valueOf(this.angularVelocity) + ", linear velocity: " + String.valueOf(this.linearVelocity);
        }
        if (this.hasOutputFor(JointStateType.ACCELERATION)) {
            ret = (String)ret + ", angular acceleration: " + String.valueOf(this.angularAcceleration) + ", linear acceleration: " + String.valueOf(this.linearAcceleration);
        }
        if (this.hasOutputFor(JointStateType.EFFORT)) {
            ret = (String)ret + ", torqe: " + String.valueOf(this.torque) + ", force: " + String.valueOf(this.force);
        }
        return ret;
    }
}

