/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.sensors;

import java.util.function.Function;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyAccelerationProvider;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyTwistProvider;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialImpulseReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameWrench;
import us.ihmc.scs2.definition.robot.WrenchSensorDefinition;
import us.ihmc.scs2.simulation.robot.RobotPhysicsOutput;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.scs2.simulation.robot.sensors.SimSensor;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class SimWrenchSensor
extends SimSensor {
    private static final WrenchSensorDefinition.SensorLocation DEFAULT_LOCATION = WrenchSensorDefinition.SensorLocation.AFTER_BODY;
    private final YoFixedFrameWrench wrench;
    private final YoDouble filterBreakFrequency;
    private final YoBoolean filterInitialized;
    private final YoFixedFrameWrench wrenchFiltered;
    private final YoEnum<WrenchSensorDefinition.SensorLocation> sensorLocation;
    private final Wrench intermediateWrench = new Wrench();
    private final SpatialAcceleration intermediateAcceleration = new SpatialAcceleration();

    public SimWrenchSensor(WrenchSensorDefinition definition, SimJointBasics parentJoint) {
        this(definition.getName(), parentJoint, (RigidBodyTransformReadOnly)definition.getTransformToJoint());
        this.setSamplingRate(SimWrenchSensor.toSamplingRate(definition.getUpdatePeriod()));
        this.setSensorLocation(definition.getLocation());
    }

    public SimWrenchSensor(String name, SimJointBasics parentJoint, RigidBodyTransformReadOnly transformToParent) {
        super(name, parentJoint, transformToParent);
        YoRegistry registry = parentJoint.getRegistry();
        this.wrench = new YoFixedFrameWrench((ReferenceFrame)parentJoint.getSuccessor().getBodyFixedFrame(), new YoFrameVector3D(name + "Moment", (ReferenceFrame)this.getFrame(), registry), new YoFrameVector3D(name + "Force", (ReferenceFrame)this.getFrame(), registry));
        this.filterBreakFrequency = new YoDouble(name + "FilterBreakFrequency", registry);
        this.filterBreakFrequency.set(Double.POSITIVE_INFINITY);
        this.getSamplingRate().addListener(v -> this.filterBreakFrequency.set(this.getSamplingRate().getValue() * 0.25));
        this.filterInitialized = new YoBoolean(name + "FilterInitialized", registry);
        this.wrenchFiltered = new YoFixedFrameWrench((ReferenceFrame)parentJoint.getSuccessor().getBodyFixedFrame(), new YoFrameVector3D(name + "MomentFiltered", (ReferenceFrame)this.getFrame(), registry), new YoFrameVector3D(name + "ForceFiltered", (ReferenceFrame)this.getFrame(), registry));
        this.sensorLocation = new YoEnum(name + "SensorLocation", registry, WrenchSensorDefinition.SensorLocation.class);
        this.sensorLocation.set((Enum)DEFAULT_LOCATION);
    }

    @Override
    public void update(RobotPhysicsOutput robotPhysicsOutput) {
        super.update(robotPhysicsOutput);
        SimRigidBodyBasics body = this.getParentJoint().getSuccessor();
        double dt = robotPhysicsOutput.getDT();
        this.wrench.setToZero();
        SimWrenchSensor.sumSubtreeExternalWrenches(body, robotPhysicsOutput, (FixedFrameWrenchBasics)this.wrench, (WrenchBasics)this.intermediateWrench);
        switch ((WrenchSensorDefinition.SensorLocation)this.sensorLocation.getValue()) {
            case AFTER_BODY: {
                for (JointReadOnly childJoint : body.getChildrenJoints()) {
                    SimWrenchSensor.sumSubtreeDynamicWrenches(childJoint.getSuccessor(), robotPhysicsOutput, (FixedFrameWrenchBasics)this.wrench, (WrenchBasics)this.intermediateWrench, (SpatialAccelerationBasics)this.intermediateAcceleration);
                }
                break;
            }
            case BEFORE_BODY: {
                SimWrenchSensor.sumSubtreeDynamicWrenches(body, robotPhysicsOutput, (FixedFrameWrenchBasics)this.wrench, (WrenchBasics)this.intermediateWrench, (SpatialAccelerationBasics)this.intermediateAcceleration);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + this.sensorLocation.getValue());
            }
        }
        if (dt <= 0.0) {
            this.filterInitialized.set(false);
        }
        if (!this.filterInitialized.getValue()) {
            this.wrenchFiltered.set(this.wrench);
            this.filterInitialized.set(true);
        } else {
            if (Double.isInfinite(this.filterBreakFrequency.getValue())) {
                this.filterBreakFrequency.set(0.25 / dt);
            }
            double alpha = 1.0 - SimWrenchSensor.computeLowPassFilterAlpha(this.filterBreakFrequency.getValue(), dt);
            this.wrenchFiltered.interpolate((SpatialVectorReadOnly)this.wrench, alpha);
        }
    }

    private static void sumSubtreeExternalWrenches(RigidBodyReadOnly start, RobotPhysicsOutput robotPhysicsOutput, FixedFrameWrenchBasics wrenchSumToPack, WrenchBasics intermediateWrench) {
        SpatialImpulseReadOnly externalImpulse;
        Function<RigidBodyReadOnly, WrenchReadOnly> externalWrenchProvider = robotPhysicsOutput.getExternalWrenchProvider();
        Function<RigidBodyReadOnly, SpatialImpulseReadOnly> externalImpulseProvider = robotPhysicsOutput.getExternalImpulseProvider();
        double dt = robotPhysicsOutput.getDT();
        WrenchReadOnly externalWrench = externalWrenchProvider == null ? null : externalWrenchProvider.apply(start);
        SpatialImpulseReadOnly spatialImpulseReadOnly = externalImpulse = externalImpulseProvider == null ? null : externalImpulseProvider.apply(start);
        if (dt != 0.0 && externalImpulse != null) {
            intermediateWrench.setIncludingFrame((SpatialVectorReadOnly)externalImpulse);
            intermediateWrench.scale(1.0 / dt);
            if (externalWrench != null) {
                intermediateWrench.add((SpatialVectorReadOnly)externalWrench);
            }
            intermediateWrench.changeFrame(wrenchSumToPack.getReferenceFrame());
            wrenchSumToPack.add((SpatialVectorReadOnly)intermediateWrench);
        } else if (externalWrench != null) {
            intermediateWrench.setIncludingFrame(externalWrench);
            intermediateWrench.changeFrame(wrenchSumToPack.getReferenceFrame());
            wrenchSumToPack.add((SpatialVectorReadOnly)intermediateWrench);
        }
        for (JointReadOnly childJoint : start.getChildrenJoints()) {
            SimWrenchSensor.sumSubtreeExternalWrenches(childJoint.getSuccessor(), robotPhysicsOutput, wrenchSumToPack, intermediateWrench);
        }
    }

    private static void sumSubtreeDynamicWrenches(RigidBodyReadOnly start, RobotPhysicsOutput robotPhysicsOutput, FixedFrameWrenchBasics wrenchSumToPack, WrenchBasics intermediateWrench, SpatialAccelerationBasics intermediateAcceleration) {
        SpatialAccelerationReadOnly bodyAcceleration;
        TwistReadOnly bodyDeltaTwist;
        double dt = robotPhysicsOutput.getDT();
        RigidBodyTwistProvider deltaTwistProvider = robotPhysicsOutput.getDeltaTwistProvider();
        RigidBodyAccelerationProvider accelerationProvider = robotPhysicsOutput.getAccelerationProvider();
        MovingReferenceFrame bodyFixedFrame = start.getBodyFixedFrame();
        boolean isAccelerationSet = false;
        if (dt != 0.0 && deltaTwistProvider != null && (bodyDeltaTwist = deltaTwistProvider.getTwistOfBody(start)) != null) {
            intermediateAcceleration.setIncludingFrame((SpatialMotionReadOnly)bodyDeltaTwist);
            intermediateAcceleration.scale(1.0 / dt);
            isAccelerationSet = true;
        }
        if ((bodyAcceleration = accelerationProvider.getAccelerationOfBody(start)) != null) {
            if (!isAccelerationSet) {
                intermediateAcceleration.setIncludingFrame((SpatialMotionReadOnly)bodyAcceleration);
            } else {
                intermediateAcceleration.add((SpatialVectorReadOnly)bodyAcceleration);
            }
            isAccelerationSet = true;
        }
        if (isAccelerationSet) {
            start.getInertia().computeDynamicWrenchFast((SpatialAccelerationReadOnly)intermediateAcceleration, bodyFixedFrame.getTwistOfFrame(), intermediateWrench);
        } else {
            start.getInertia().computeDynamicWrenchFast(null, bodyFixedFrame.getTwistOfFrame(), intermediateWrench);
        }
        intermediateWrench.changeFrame(wrenchSumToPack.getReferenceFrame());
        wrenchSumToPack.sub((SpatialVectorReadOnly)intermediateWrench);
        for (JointReadOnly childJoint : start.getChildrenJoints()) {
            SimWrenchSensor.sumSubtreeDynamicWrenches(childJoint.getSuccessor(), robotPhysicsOutput, wrenchSumToPack, intermediateWrench, intermediateAcceleration);
        }
    }

    public void setSensorLocation(WrenchSensorDefinition.SensorLocation sensorLocation) {
        if (sensorLocation == null) {
            LogTools.error((String)"Given sensor location is null, setting to {}", (Object)DEFAULT_LOCATION);
            this.sensorLocation.set((Enum)DEFAULT_LOCATION);
        } else {
            this.sensorLocation.set((Enum)sensorLocation);
        }
    }

    public YoEnum<WrenchSensorDefinition.SensorLocation> getSensorLocation() {
        return this.sensorLocation;
    }

    public void setFilterBreakFrequency(double breakFrequency) {
        this.filterBreakFrequency.set(breakFrequency);
    }

    public YoDouble getFilterBreakFrequency() {
        return this.filterBreakFrequency;
    }

    public YoBoolean getFilterInitialized() {
        return this.filterInitialized;
    }

    public YoFixedFrameWrench getWrench() {
        return this.wrench;
    }

    public YoFixedFrameWrench getWrenchFiltered() {
        return this.wrenchFiltered;
    }
}

