/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.trackers;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameTwist;
import us.ihmc.scs2.definition.robot.KinematicPointDefinition;
import us.ihmc.scs2.session.YoFixedMovingReferenceFrameUsingYawPitchRoll;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class KinematicPoint {
    private final String name;
    private final SimJointBasics parentJoint;
    private final YoFixedMovingReferenceFrameUsingYawPitchRoll frame;
    private final YoFramePoseUsingYawPitchRoll pose;
    private final YoFixedFrameTwist twist;

    public KinematicPoint(KinematicPointDefinition definition, SimJointBasics parentJoint) {
        this(definition.getName(), parentJoint, (RigidBodyTransformReadOnly)definition.getTransformToParent());
    }

    public KinematicPoint(String name, SimJointBasics parentJoint, RigidBodyTransformReadOnly transformToParent) {
        this.name = name;
        this.parentJoint = parentJoint;
        ReferenceFrame rootFrame = parentJoint.getFrameBeforeJoint().getRootFrame();
        YoRegistry registry = parentJoint.getRegistry();
        this.frame = new YoFixedMovingReferenceFrameUsingYawPitchRoll(name + "Frame", name + "Offset", (ReferenceFrame)parentJoint.getFrameAfterJoint(), registry);
        this.frame.getOffset().set(transformToParent);
        this.pose = new YoFramePoseUsingYawPitchRoll(name, rootFrame, registry);
        this.twist = new YoFixedFrameTwist((ReferenceFrame)parentJoint.getSuccessor().getBodyFixedFrame(), rootFrame, new YoFrameVector3D(name + "AngularVelocity", (ReferenceFrame)this.frame, registry), new YoFrameVector3D(name + "LinearVelocity", (ReferenceFrame)this.frame, registry));
    }

    public void update() {
        this.frame.update();
        this.pose.setFromReferenceFrame((ReferenceFrame)this.frame);
        this.twist.getAngularPart().set((FrameTuple3DReadOnly)this.frame.getTwistOfFrame().getAngularPart());
        this.twist.getLinearPart().set((FrameTuple3DReadOnly)this.frame.getTwistOfFrame().getLinearPart());
    }

    public String getName() {
        return this.name;
    }

    public SimJointBasics getParentJoint() {
        return this.parentJoint;
    }

    public MovingReferenceFrame getFrame() {
        return this.frame;
    }

    public YoFramePoseUsingYawPitchRoll getOffset() {
        return this.frame.getOffset();
    }

    public YoFramePoseUsingYawPitchRoll getPose() {
        return this.pose;
    }

    public YoFixedFrameTwist getTwist() {
        return this.twist;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - " + this.getName();
    }
}

