/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import us.ihmc.commons.Conversions;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.messager.Messager;
import us.ihmc.messager.TopicListener;
import us.ihmc.messager.TopicListenerBase;
import us.ihmc.scs2.definition.robot.CameraSensorDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.RobotStateDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.session.DaemonThreadFactory;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionDataExportRequest;
import us.ihmc.scs2.session.SessionMessagerAPI;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.sharedMemory.CropBufferRequest;
import us.ihmc.scs2.sharedMemory.YoSharedBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.simulation.SimulationSessionControls;
import us.ihmc.scs2.simulation.SimulationTerminalCondition;
import us.ihmc.scs2.simulation.TimeConsumer;
import us.ihmc.scs2.simulation.physicsEngine.PhysicsEngine;
import us.ihmc.scs2.simulation.physicsEngine.PhysicsEngineFactory;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.sensors.SimCameraSensor;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferProcessor;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;

public class SimulationSession
extends Session {
    public static final ReferenceFrame DEFAULT_INERTIAL_FRAME = ReferenceFrameTools.constructARootFrame((String)"worldFrame");
    private final PhysicsEngine physicsEngine;
    private final YoFrameVector3D gravity;
    private final String simulationName;
    private final List<YoGraphicDefinition> yoGraphicDefinitions = new ArrayList<YoGraphicDefinition>();
    private final List<Consumer<SessionMessagerAPI.Sensors.SensorMessage<CameraSensorDefinition>>> cameraDefinitionListeners = new ArrayList<Consumer<SessionMessagerAPI.Sensors.SensorMessage<CameraSensorDefinition>>>();
    private final List<SimCameraSensor.CameraDefinitionConsumer> cameraDefinitionNotifiers = new ArrayList<SimCameraSensor.CameraDefinitionConsumer>();
    private final Map<String, Map<String, SimCameraSensor>> robotNameToSensorNameToCameraMap = new HashMap<String, Map<String, SimCameraSensor>>();
    private final ExecutorService cameraBroadcastExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory("SCS2-Camera-Server"));
    private final List<SimulationTerminalCondition> terminalConditions = new ArrayList<SimulationTerminalCondition>();
    private final List<TimeConsumer> beforePhysicsCallbacks = new ArrayList<TimeConsumer>();
    private final List<TimeConsumer> afterPhysicsCallbacks = new ArrayList<TimeConsumer>();
    private final List<Runnable> cleanupActions = new ArrayList<Runnable>();
    private SimulationSessionControlsImpl controls = null;

    public SimulationSession() {
        this(SimulationSession.retrieveCallerName());
    }

    public SimulationSession(PhysicsEngineFactory physicsEngineFactory) {
        this(SimulationSession.retrieveCallerName(), physicsEngineFactory);
    }

    public SimulationSession(String simulationName) {
        this(DEFAULT_INERTIAL_FRAME, simulationName);
    }

    public SimulationSession(ReferenceFrame inertialFrame, String simulationName) {
        this(inertialFrame, simulationName, PhysicsEngineFactory.newImpulseBasedPhysicsEngineFactory());
    }

    public SimulationSession(String simulationName, PhysicsEngineFactory physicsEngineFactory) {
        this(DEFAULT_INERTIAL_FRAME, simulationName, physicsEngineFactory);
    }

    public SimulationSession(ReferenceFrame inertialFrame, String simulationName, PhysicsEngineFactory physicsEngineFactory) {
        super(inertialFrame);
        if (!inertialFrame.isRootFrame()) {
            throw new IllegalArgumentException("The given inertialFrame is not a root frame: " + inertialFrame);
        }
        this.simulationName = simulationName;
        this.physicsEngine = physicsEngineFactory.build(inertialFrame, this.rootRegistry);
        this.sessionRegistry.addChild(this.physicsEngine.getPhysicsEngineRegistry());
        this.setSessionDTSeconds(1.0E-4);
        this.setSessionMode(SessionMode.PAUSE);
        this.gravity = new YoFrameVector3D("gravity", inertialFrame, this.rootRegistry);
        this.gravity.set(0.0, 0.0, -9.81);
    }

    public SimulationSessionControls getSimulationSessionControls() {
        if (this.controls == null) {
            this.controls = new SimulationSessionControlsImpl();
        }
        return this.controls;
    }

    protected void initializeSession() {
        super.initializeSession();
        this.physicsEngine.initialize((Vector3DReadOnly)this.gravity);
        this.time.set(0.0);
    }

    public void shutdownSession() {
        super.shutdownSession();
        this.cleanupActions.forEach(Runnable::run);
        this.cleanupActions.clear();
        this.cameraBroadcastExecutor.shutdown();
        this.physicsEngine.dispose();
    }

    protected void doGeneric(SessionMode currentMode) {
        super.doGeneric(currentMode);
        this.cameraDefinitionNotifiers.forEach(notifier -> notifier.nextDefinition(null));
    }

    protected double doSpecificRunTick() {
        double dt = Conversions.nanosecondsToSeconds((long)this.getSessionDTNanoseconds());
        for (int i = 0; i < this.beforePhysicsCallbacks.size(); ++i) {
            this.beforePhysicsCallbacks.get(i).accept(this.time.getValue());
        }
        this.physicsEngine.simulate(this.time.getValue(), dt, (Vector3DReadOnly)this.gravity);
        double newTime = this.time.getValue() + dt;
        for (int i = 0; i < this.afterPhysicsCallbacks.size(); ++i) {
            this.afterPhysicsCallbacks.get(i).accept(newTime);
        }
        return newTime;
    }

    protected void schedulingSessionMode(SessionMode previousMode, SessionMode newMode) {
        if (previousMode == newMode) {
            return;
        }
        if (previousMode == SessionMode.RUNNING) {
            this.physicsEngine.pause();
            this.finalizeRunTick(true);
        }
    }

    public void addRobot(Robot robot) {
        this.physicsEngine.addRobot(robot);
    }

    public void addRobots(Collection<? extends Robot> robots) {
        this.physicsEngine.addRobots(robots);
    }

    public Robot addRobot(RobotDefinition robotDefinition) {
        Robot robot = new Robot(robotDefinition, this.inertialFrame);
        this.configureCameraSensors(robot);
        this.addRobot(robot);
        return robot;
    }

    private void configureCameraSensors(Robot robot) {
        for (SimJointBasics simJointBasics : robot.getAllJoints()) {
            for (SimCameraSensor cameraSensor : simJointBasics.getAuxiliaryData().getCameraSensors()) {
                this.configureCameraSensor(robot.getName(), cameraSensor);
            }
        }
    }

    private void configureCameraSensor(String robotName, SimCameraSensor cameraSensor) {
        this.robotNameToSensorNameToCameraMap.computeIfAbsent(robotName, s -> new HashMap()).put(cameraSensor.getName(), cameraSensor);
        SimCameraSensor.CameraDefinitionConsumer cameraDefinitionNotifier = newDefinition -> {
            String sensorName = cameraSensor.getName();
            CameraSensorDefinition definitionData = newDefinition != null ? newDefinition : cameraSensor.toCameraSensorDefinition();
            SessionMessagerAPI.Sensors.SensorMessage newMessage = new SessionMessagerAPI.Sensors.SensorMessage(robotName, sensorName, (Object)definitionData);
            this.cameraDefinitionListeners.forEach(listener -> listener.accept(newMessage));
        };
        this.cameraDefinitionNotifiers.add(cameraDefinitionNotifier);
        cameraSensor.addCameraDefinitionConsumer(cameraDefinitionNotifier);
    }

    public void setupWithMessager(Messager messager) {
        super.setupWithMessager(messager);
        this.cameraDefinitionListeners.add(message -> messager.submitMessage(SessionMessagerAPI.Sensors.CameraSensorDefinitionData, message));
        TopicListener listener = message -> {
            long timestamp = Conversions.secondsToNanoseconds((double)this.time.getValue());
            SimCameraSensor cameraSensor = (SimCameraSensor)this.robotNameToSensorNameToCameraMap.getOrDefault(message.getRobotName(), Collections.emptyMap()).get(message.getSensorName());
            this.cameraBroadcastExecutor.execute(() -> {
                for (SimCameraSensor.CameraFrameConsumer consumer : cameraSensor.getCameraFrameConsumers()) {
                    consumer.nextFrame(timestamp, (BufferedImage)message.getMessageContent());
                }
            });
        };
        messager.addTopicListener(SessionMessagerAPI.Sensors.CameraSensorFrame, listener);
        this.cleanupActions.add(() -> messager.removeTopicListener(SessionMessagerAPI.Sensors.CameraSensorFrame, (TopicListenerBase)listener));
    }

    public void addTerrainObject(TerrainObjectDefinition terrainObjectDefinition) {
        this.physicsEngine.addTerrainObject(terrainObjectDefinition);
    }

    public void addTerrainObjects(Collection<? extends TerrainObjectDefinition> terrainObjectDefinitions) {
        for (TerrainObjectDefinition terrainObjectDefinition : terrainObjectDefinitions) {
            this.physicsEngine.addTerrainObject(terrainObjectDefinition);
        }
    }

    public void addYoGraphicDefinition(YoGraphicDefinition yoGraphicDefinition) {
        this.yoGraphicDefinitions.add(yoGraphicDefinition);
    }

    public void addYoGraphicDefinitions(YoGraphicDefinition ... yoGraphicDefinitions) {
        for (YoGraphicDefinition yoGraphicDefinition : yoGraphicDefinitions) {
            this.addYoGraphicDefinition(yoGraphicDefinition);
        }
    }

    public void addYoGraphicDefinitions(Iterable<? extends YoGraphicDefinition> yoGraphicDefinitions) {
        for (YoGraphicDefinition yoGraphicDefinition : yoGraphicDefinitions) {
            this.addYoGraphicDefinition(yoGraphicDefinition);
        }
    }

    public String getSessionName() {
        return this.simulationName;
    }

    public PhysicsEngine getPhysicsEngine() {
        return this.physicsEngine;
    }

    public List<RobotDefinition> getRobotDefinitions() {
        return this.physicsEngine.getRobotDefinitions();
    }

    public List<TerrainObjectDefinition> getTerrainObjectDefinitions() {
        return this.physicsEngine.getTerrainObjectDefinitions();
    }

    public List<YoGraphicDefinition> getYoGraphicDefinitions() {
        return this.yoGraphicDefinitions;
    }

    public List<RobotStateDefinition> getCurrentRobotStateDefinitions(boolean initialState) {
        if (initialState) {
            return this.physicsEngine.getBeforePhysicsRobotStateDefinitions();
        }
        return this.physicsEngine.getCurrentRobotStateDefinitions();
    }

    public void setGravity(double x, double y, double z) {
        this.gravity.set(x, y, z);
    }

    public YoFrameVector3D getGravity() {
        return this.gravity;
    }

    public void addBeforePhysicsCallback(TimeConsumer beforePhysicsCallback) {
        this.beforePhysicsCallbacks.add(beforePhysicsCallback);
    }

    public boolean removeBeforePhysicsCallback(TimeConsumer beforePhysicsCallback) {
        return this.beforePhysicsCallbacks.remove(beforePhysicsCallback);
    }

    public void addAfterPhysicsCallback(TimeConsumer afterPhysicsCallback) {
        this.afterPhysicsCallbacks.add(afterPhysicsCallback);
    }

    public boolean removeAfterPhysicsCallback(TimeConsumer afterPhysicsCallback) {
        return this.afterPhysicsCallbacks.remove(afterPhysicsCallback);
    }

    private class SimulationSessionControlsImpl
    implements SimulationSessionControls {
        private SimulationSessionControlsImpl() {
        }

        @Override
        public double getDT() {
            return SimulationSession.this.getSessionDTSeconds();
        }

        @Override
        public void setDT(double dt) {
            SimulationSession.this.setSessionDTSeconds(dt);
        }

        @Override
        public boolean isSimulationThreadRunning() {
            return SimulationSession.this.hasSessionStarted();
        }

        @Override
        public boolean isRealTimeRateSimulation() {
            return SimulationSession.this.getRunAtRealTimeRate();
        }

        @Override
        public double getPlaybackRealTimeRate() {
            return SimulationSession.this.getPlaybackRealTimeRate();
        }

        @Override
        public boolean isSimulating() {
            return SimulationSession.this.getActiveMode() == SessionMode.RUNNING;
        }

        @Override
        public boolean isPlaying() {
            return SimulationSession.this.getActiveMode() == SessionMode.PLAYBACK;
        }

        @Override
        public boolean isPaused() {
            return SimulationSession.this.getActiveMode() == SessionMode.PAUSE;
        }

        @Override
        public boolean isSessionShutdown() {
            return SimulationSession.this.isSessionShutdown();
        }

        @Override
        public boolean startSimulationThread() {
            return SimulationSession.this.startSessionThread();
        }

        @Override
        public boolean stopSimulationThread() {
            return SimulationSession.this.stopSessionThread();
        }

        @Override
        public void shutdownSession() {
            SimulationSession.this.shutdownSession();
        }

        @Override
        public void addSessionShutdownListener(Runnable listener) {
            SimulationSession.this.addShutdownListener(listener);
        }

        @Override
        public void setRealTimeRateSimulation(boolean enableRealTimeRate) {
            SimulationSession.this.submitRunAtRealTimeRate(enableRealTimeRate);
        }

        @Override
        public void setPlaybackRealTimeRate(double realTimeRate) {
            SimulationSession.this.submitPlaybackRealTimeRate(realTimeRate);
        }

        @Override
        public void simulate(double duration) {
            Session.SessionModeTransition transition;
            if (SimulationSession.this.getActiveMode() == SessionMode.RUNNING) {
                SimulationSession.this.setSessionMode(SessionMode.PAUSE);
            }
            if (duration == Double.POSITIVE_INFINITY) {
                if (SimulationSession.this.terminalConditions.isEmpty()) {
                    transition = null;
                } else {
                    BooleanSupplier terminalCondition = () -> this.testTerminalConditions() != null;
                    transition = Session.SessionModeTransition.newTransition((BooleanSupplier)terminalCondition, (SessionMode)SessionMode.PAUSE);
                }
            } else {
                double startTime = SimulationSession.this.time.getValue();
                BooleanSupplier terminalCondition = SimulationSession.this.terminalConditions.isEmpty() ? () -> SimulationSession.this.time.getValue() - startTime >= duration : () -> SimulationSession.this.time.getValue() - startTime >= duration || this.testTerminalConditions() != null;
                transition = Session.SessionModeTransition.newTransition((BooleanSupplier)terminalCondition, (SessionMode)SessionMode.PAUSE);
            }
            SimulationSession.this.setSessionMode(SessionMode.RUNNING, transition);
        }

        @Override
        public void simulate(final int numberOfTicks) {
            if (SimulationSession.this.getActiveMode() == SessionMode.RUNNING) {
                SimulationSession.this.setSessionMode(SessionMode.PAUSE);
            }
            BooleanSupplier terminalCondition = new BooleanSupplier(){
                private int tickCounter = 0;

                @Override
                public boolean getAsBoolean() {
                    ++this.tickCounter;
                    return this.tickCounter >= numberOfTicks || SimulationSessionControlsImpl.this.testTerminalConditions() != null;
                }
            };
            SimulationSession.this.setSessionMode(SessionMode.RUNNING, Session.SessionModeTransition.newTransition((BooleanSupplier)terminalCondition, (SessionMode)SessionMode.PAUSE));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean simulateNow(long numberOfTicks) {
            if (this.isSessionShutdown()) {
                return false;
            }
            boolean sessionStartedInitialValue = this.isSimulationThreadRunning();
            if (sessionStartedInitialValue && !this.stopSimulationThread()) {
                return false;
            }
            SessionMode activeModeInitialValue = SimulationSession.this.getActiveMode();
            try {
                boolean success;
                block15: {
                    SimulationSession.this.setSessionMode(SessionMode.RUNNING);
                    success = true;
                    if (numberOfTicks == -1L || numberOfTicks == Long.MAX_VALUE) {
                        SimulationTerminalCondition.TerminalState state;
                        do {
                            if (this.isSessionShutdown()) {
                                boolean bl = false;
                                return bl;
                            }
                            if (!this.handleVisualizerSessionModeRequests() || !(success = SimulationSession.this.runTick())) break block15;
                        } while ((state = this.testTerminalConditions()) == null);
                        if (state == SimulationTerminalCondition.TerminalState.FAILURE) {
                            success = false;
                        }
                    } else {
                        for (long tick = 0L; tick < numberOfTicks; ++tick) {
                            if (this.isSessionShutdown()) {
                                boolean bl = false;
                                return bl;
                            }
                            if (!this.handleVisualizerSessionModeRequests() || !(success = SimulationSession.this.runTick())) break;
                            SimulationTerminalCondition.TerminalState state = this.testTerminalConditions();
                            if (state == null) continue;
                            if (state != SimulationTerminalCondition.TerminalState.FAILURE) break;
                            success = false;
                            break;
                        }
                    }
                }
                boolean bl = success;
                return bl;
            }
            finally {
                SimulationSession.this.physicsEngine.pause();
                if (sessionStartedInitialValue) {
                    SimulationSession.this.startSessionThread();
                }
                SimulationSession.this.setSessionMode(activeModeInitialValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean handleVisualizerSessionModeRequests() {
            if (this.isSimulating() || !SimulationSession.this.hasWrittenBufferInLastRunTick()) {
                return true;
            }
            CountDownLatch latch = new CountDownLatch(1);
            Session.SessionModeChangeListener listener = (prevMode, newMode) -> {
                if (newMode != prevMode && newMode == SessionMode.RUNNING) {
                    this.stopSimulationThread();
                    if (this.getBufferCurrentIndex() != this.getBufferOutPoint()) {
                        this.gotoBufferOutPoint();
                        SimulationSession.this.finalizePauseTick(true);
                    }
                    latch.countDown();
                }
            };
            SimulationSession.this.addPreSessionModeChangeListener(listener);
            SimulationSession.this.startSessionThread();
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                SimulationSession.this.removePreSessionModeChangeListener(listener);
            }
            return true;
        }

        private SimulationTerminalCondition.TerminalState testTerminalConditions() {
            for (int i = 0; i < SimulationSession.this.terminalConditions.size(); ++i) {
                SimulationTerminalCondition.TerminalState result = SimulationSession.this.terminalConditions.get(i).testCondition();
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public void addSimulationThrowableListener(Consumer<Throwable> listener) {
            SimulationSession.this.addRunThrowableListener(listener);
        }

        @Override
        public void addExternalTerminalCondition(SimulationTerminalCondition ... externalTerminalConditions) {
            for (int i = 0; i < externalTerminalConditions.length; ++i) {
                SimulationSession.this.terminalConditions.add(externalTerminalConditions[i]);
            }
        }

        @Override
        public boolean removeExternalTerminalCondition(SimulationTerminalCondition externalTerminalCondition) {
            return SimulationSession.this.terminalConditions.remove(externalTerminalCondition);
        }

        @Override
        public void clearExternalTerminalConditions() {
            SimulationSession.this.terminalConditions.clear();
        }

        @Override
        public void play() {
            SimulationSession.this.setSessionMode(SessionMode.PLAYBACK);
        }

        @Override
        public void pause() {
            SimulationSession.this.setSessionMode(SessionMode.PAUSE);
        }

        @Override
        public YoBufferPropertiesReadOnly getBufferProperties() {
            return SimulationSession.this.getBufferProperties();
        }

        @Override
        public int getBufferRecordTickPeriod() {
            return SimulationSession.this.getBufferRecordTickPeriod();
        }

        @Override
        public YoSharedBuffer getBuffer() {
            return SimulationSession.this.getBuffer();
        }

        @Override
        public boolean initializeBufferRecordTickPeriod(int bufferRecordTickPeriod) {
            return SimulationSession.this.initializeBufferRecordTickPeriod(bufferRecordTickPeriod);
        }

        @Override
        public void setBufferRecordTickPeriod(int bufferRecordTickPeriod) {
            SimulationSession.this.setBufferRecordTickPeriod(bufferRecordTickPeriod);
        }

        @Override
        public void tick() {
            if (!this.isPaused()) {
                return;
            }
            if (this.isSimulationThreadRunning()) {
                this.stopSimulationThread();
                this.getBuffer().incrementBufferIndex(true);
                SimulationSession.this.startSessionThread();
            } else {
                this.getBuffer().incrementBufferIndex(true);
            }
        }

        @Override
        public void gotoBufferIndex(int bufferIndexRequest) {
            SimulationSession.this.submitBufferIndexRequestAndWait(bufferIndexRequest);
        }

        @Override
        public void setBufferInPoint(int index) {
            SimulationSession.this.submitBufferInPointIndexRequestAndWait(index);
        }

        @Override
        public void setBufferOutPoint(int index) {
            SimulationSession.this.submitBufferOutPointIndexRequestAndWait(index);
        }

        @Override
        public void stepBufferIndexBackward(int stepSize) {
            SimulationSession.this.submitDecrementBufferIndexRequestAndWait(stepSize);
        }

        @Override
        public void stepBufferIndexForward(int stepSize) {
            SimulationSession.this.submitIncrementBufferIndexRequestAndWait(stepSize);
        }

        @Override
        public void cropBuffer(CropBufferRequest request) {
            SimulationSession.this.submitCropBufferRequestAndWait(request);
        }

        @Override
        public boolean initializeBufferSize(int bufferSize) {
            return SimulationSession.this.initializeBufferSize(bufferSize);
        }

        @Override
        public void changeBufferSize(int bufferSize) {
            SimulationSession.this.submitBufferSizeRequestAndWait(bufferSize);
        }

        @Override
        public void applyBufferProcessor(YoBufferProcessor processor) {
            if (!this.isPaused()) {
                return;
            }
            if (this.isSimulationThreadRunning()) {
                this.stopSimulationThread();
                this.getBuffer().applyProcessor(processor);
                this.startSimulationThread();
            } else {
                this.getBuffer().applyProcessor(processor);
            }
        }

        @Override
        public String getSimulationName() {
            return SimulationSession.this.getSessionName();
        }

        @Override
        public void exportData(SessionDataExportRequest request) {
            SimulationSession.this.submitSessionDataExportRequestAndWait(request);
        }

        @Override
        public void addBeforePhysicsCallback(TimeConsumer beforePhysicsCallback) {
            SimulationSession.this.addBeforePhysicsCallback(beforePhysicsCallback);
        }

        @Override
        public boolean removeBeforePhysicsCallback(TimeConsumer beforePhysicsCallback) {
            return SimulationSession.this.removeBeforePhysicsCallback(beforePhysicsCallback);
        }

        @Override
        public void addAfterPhysicsCallback(TimeConsumer afterPhysicsCallback) {
            SimulationSession.this.addAfterPhysicsCallback(afterPhysicsCallback);
        }

        @Override
        public boolean removeAfterPhysicsCallback(TimeConsumer afterPhysicsCallback) {
            return SimulationSession.this.removeAfterPhysicsCallback(afterPhysicsCallback);
        }
    }
}

