/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.screwTools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ejml.data.DMatrix;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointReadOnly;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimOneDoFJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyReadOnly;
import us.ihmc.scs2.simulation.screwTools.SimJointStateType;

public class SimMultiBodySystemTools {
    private static final JointStateInsertor jointConfigurationInsertor = (joint, startIndex, state) -> joint.setJointConfiguration(startIndex, state);
    private static final JointStateInsertor jointVelocityInsertor = (joint, startIndex, state) -> joint.setJointVelocity(startIndex, state);
    private static final JointStateInsertor jointDeltaVelocityInsertor = (joint, startIndex, state) -> joint.setJointDeltaVelocity(startIndex, state);
    private static final JointStateInsertor jointAccelerationInsertor = (joint, startIndex, state) -> joint.setJointAcceleration(startIndex, state);
    private static final JointStateInsertor jointEffortInsertor = (joint, startIndex, state) -> joint.setJointTau(startIndex, state);

    public static SimRigidBodyReadOnly getRootBody(SimRigidBodyReadOnly body) {
        SimRigidBodyReadOnly root = body;
        while (root.getParentJoint() != null) {
            root = root.getParentJoint().getPredecessor();
        }
        return root;
    }

    public static SimRigidBodyBasics getRootBody(SimRigidBodyBasics body) {
        SimRigidBodyBasics root = body;
        while (root.getParentJoint() != null) {
            root = root.getParentJoint().getPredecessor();
        }
        return root;
    }

    public static SimOneDoFJointBasics[] createOneDoFJointPath(SimRigidBodyBasics start, SimRigidBodyBasics end) {
        return (SimOneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])SimMultiBodySystemTools.createJointPath(start, end), SimOneDoFJointBasics.class);
    }

    public static SimJointBasics[] createJointPath(SimRigidBodyBasics start, SimRigidBodyBasics end) {
        ArrayList<SimJointBasics> jointPath = new ArrayList<SimJointBasics>();
        SimMultiBodySystemTools.collectJointPath(start, end, jointPath);
        return jointPath.toArray(new SimJointBasics[jointPath.size()]);
    }

    public static SimJointReadOnly[] createJointPath(SimRigidBodyReadOnly start, SimRigidBodyReadOnly end) {
        ArrayList<SimJointReadOnly> jointPath = new ArrayList<SimJointReadOnly>();
        SimMultiBodySystemTools.collectJointPath(start, end, jointPath);
        return jointPath.toArray(new SimJointReadOnly[jointPath.size()]);
    }

    public static SimRigidBodyReadOnly collectJointPath(SimRigidBodyReadOnly start, SimRigidBodyReadOnly end, List<SimJointReadOnly> jointPathToPack) {
        jointPathToPack.clear();
        SimRigidBodyReadOnly ancestor = SimMultiBodySystemTools.computeNearestCommonAncestor(start, end);
        SimRigidBodyReadOnly currentBody = start;
        while (currentBody != ancestor) {
            SimJointReadOnly parentJoint = currentBody.getParentJoint();
            jointPathToPack.add(parentJoint);
            currentBody = parentJoint.getPredecessor();
        }
        int distance = jointPathToPack.size();
        currentBody = end;
        while (currentBody != ancestor) {
            currentBody = currentBody.getParentJoint().getPredecessor();
            ++distance;
        }
        while (jointPathToPack.size() < distance) {
            jointPathToPack.add(null);
        }
        currentBody = end;
        int i = distance - 1;
        while (currentBody != ancestor) {
            SimJointReadOnly parentJoint = currentBody.getParentJoint();
            jointPathToPack.set(i, parentJoint);
            currentBody = parentJoint.getPredecessor();
            --i;
        }
        return ancestor;
    }

    public static SimRigidBodyBasics collectJointPath(SimRigidBodyBasics start, SimRigidBodyBasics end, List<SimJointBasics> jointPathToPack) {
        jointPathToPack.clear();
        SimRigidBodyBasics ancestor = SimMultiBodySystemTools.computeNearestCommonAncestor(start, end);
        SimRigidBodyBasics currentBody = start;
        while (currentBody != ancestor) {
            SimJointBasics parentJoint = currentBody.getParentJoint();
            jointPathToPack.add(parentJoint);
            currentBody = parentJoint.getPredecessor();
        }
        int distance = jointPathToPack.size();
        currentBody = end;
        while (currentBody != ancestor) {
            currentBody = currentBody.getParentJoint().getPredecessor();
            ++distance;
        }
        while (jointPathToPack.size() < distance) {
            jointPathToPack.add(null);
        }
        currentBody = end;
        int i = distance - 1;
        while (currentBody != ancestor) {
            SimJointBasics parentJoint = currentBody.getParentJoint();
            jointPathToPack.set(i, parentJoint);
            currentBody = parentJoint.getPredecessor();
            --i;
        }
        return ancestor;
    }

    public static SimRigidBodyReadOnly collectRigidBodyPath(SimRigidBodyReadOnly start, SimRigidBodyReadOnly end, List<SimRigidBodyReadOnly> rigidBodyPathToPack) {
        rigidBodyPathToPack.clear();
        if (start == end) {
            rigidBodyPathToPack.add(end);
            return end;
        }
        SimRigidBodyReadOnly ancestor = SimMultiBodySystemTools.computeNearestCommonAncestor(start, end);
        SimRigidBodyReadOnly currentBody = start;
        if (start == ancestor) {
            rigidBodyPathToPack.add(start);
        }
        while (currentBody != ancestor) {
            rigidBodyPathToPack.add(currentBody);
            currentBody = currentBody.getParentJoint().getPredecessor();
        }
        int distance = rigidBodyPathToPack.size();
        currentBody = end;
        while (currentBody != ancestor) {
            currentBody = currentBody.getParentJoint().getPredecessor();
            ++distance;
        }
        while (rigidBodyPathToPack.size() < distance) {
            rigidBodyPathToPack.add(null);
        }
        currentBody = end;
        if (end == ancestor) {
            rigidBodyPathToPack.add(end);
        }
        int i = distance - 1;
        while (currentBody != ancestor) {
            rigidBodyPathToPack.set(i, currentBody);
            currentBody = currentBody.getParentJoint().getPredecessor();
            --i;
        }
        return ancestor;
    }

    public static SimRigidBodyBasics collectRigidBodyPath(SimRigidBodyBasics start, SimRigidBodyBasics end, List<SimRigidBodyBasics> rigidBodyPathToPack) {
        rigidBodyPathToPack.clear();
        if (start == end) {
            rigidBodyPathToPack.add(end);
            return end;
        }
        SimRigidBodyBasics ancestor = SimMultiBodySystemTools.computeNearestCommonAncestor(start, end);
        SimRigidBodyBasics currentBody = start;
        if (start == ancestor) {
            rigidBodyPathToPack.add(start);
        }
        while (currentBody != ancestor) {
            rigidBodyPathToPack.add(currentBody);
            currentBody = currentBody.getParentJoint().getPredecessor();
        }
        int distance = rigidBodyPathToPack.size();
        currentBody = end;
        while (currentBody != ancestor) {
            currentBody = currentBody.getParentJoint().getPredecessor();
            ++distance;
        }
        while (rigidBodyPathToPack.size() < distance) {
            rigidBodyPathToPack.add(null);
        }
        currentBody = end;
        if (end == ancestor) {
            rigidBodyPathToPack.add(end);
        }
        int i = distance - 1;
        while (currentBody != ancestor) {
            rigidBodyPathToPack.set(i, currentBody);
            currentBody = currentBody.getParentJoint().getPredecessor();
            --i;
        }
        return ancestor;
    }

    public static SimRigidBodyBasics computeNearestCommonAncestor(SimRigidBodyBasics firstBody, SimRigidBodyBasics secondBody) {
        return (SimRigidBodyBasics)SimMultiBodySystemTools.computeNearestCommonAncestor((SimRigidBodyReadOnly)firstBody, (SimRigidBodyReadOnly)secondBody);
    }

    public static SimRigidBodyReadOnly computeNearestCommonAncestor(SimRigidBodyReadOnly firstBody, SimRigidBodyReadOnly secondBody) {
        return (SimRigidBodyReadOnly)MultiBodySystemTools.computeNearestCommonAncestor((RigidBodyReadOnly)firstBody, (RigidBodyReadOnly)secondBody);
    }

    public static SimRigidBodyReadOnly[] collectSuccessors(SimJointReadOnly ... joints) {
        return (SimRigidBodyReadOnly[])Stream.of(joints).map(SimJointReadOnly::getSuccessor).toArray(SimRigidBodyReadOnly[]::new);
    }

    public static SimRigidBodyBasics[] collectSuccessors(SimJointBasics ... joints) {
        return (SimRigidBodyBasics[])Stream.of(joints).map(SimJointBasics::getSuccessor).toArray(SimRigidBodyBasics[]::new);
    }

    public static SimRigidBodyReadOnly[] collectSubtreeSuccessors(SimJointReadOnly ... joints) {
        return (SimRigidBodyReadOnly[])Stream.of(joints).map(SimJointReadOnly::getSuccessor).flatMap(SimRigidBodyReadOnly::subtreeStream).distinct().toArray(SimRigidBodyReadOnly[]::new);
    }

    public static SimRigidBodyBasics[] collectSubtreeSuccessors(SimJointBasics ... joints) {
        return (SimRigidBodyBasics[])Stream.of(joints).map(SimJointBasics::getSuccessor).flatMap(SimRigidBodyBasics::subtreeStream).distinct().toArray(SimRigidBodyBasics[]::new);
    }

    public static SimJointReadOnly[] collectSupportJoints(SimRigidBodyReadOnly rigidBody) {
        return SimMultiBodySystemTools.createJointPath(SimMultiBodySystemTools.getRootBody(rigidBody), rigidBody);
    }

    public static SimJointBasics[] collectSupportJoints(SimRigidBodyBasics rigidBody) {
        return SimMultiBodySystemTools.createJointPath(SimMultiBodySystemTools.getRootBody(rigidBody), rigidBody);
    }

    public static SimJointReadOnly[] collectSupportJoints(SimRigidBodyReadOnly ... rigidBodies) {
        return (SimJointReadOnly[])Stream.of(rigidBodies).map(SimMultiBodySystemTools::collectSupportJoints).flatMap(Stream::of).distinct().toArray(SimJointReadOnly[]::new);
    }

    public static SimJointBasics[] collectSupportJoints(SimRigidBodyBasics ... rigidBodies) {
        return (SimJointBasics[])Stream.of(rigidBodies).map(SimMultiBodySystemTools::collectSupportJoints).flatMap(Stream::of).distinct().toArray(SimJointBasics[]::new);
    }

    public static SimJointReadOnly[] collectSubtreeJoints(SimRigidBodyReadOnly ... rootBodies) {
        return (SimJointReadOnly[])Stream.of(rootBodies).flatMap(SubtreeStreams::fromChildren).distinct().toArray(SimJointReadOnly[]::new);
    }

    public static SimJointBasics[] collectSubtreeJoints(SimRigidBodyBasics ... rootBodies) {
        return (SimJointBasics[])Stream.of(rootBodies).flatMap(SubtreeStreams::fromChildren).distinct().toArray(SimJointBasics[]::new);
    }

    public static SimJointReadOnly[] collectSubtreeJoints(List<? extends SimRigidBodyReadOnly> rootBodies) {
        return (SimJointReadOnly[])rootBodies.stream().flatMap(SubtreeStreams::fromChildren).distinct().toArray(SimJointReadOnly[]::new);
    }

    public static SimJointReadOnly[] collectSupportAndSubtreeJoints(SimRigidBodyReadOnly rigidBody) {
        List<SimJointReadOnly> supportAndSubtreeJoints = SubtreeStreams.fromChildren(SimJointReadOnly.class, (RigidBodyReadOnly)rigidBody).collect(Collectors.toList());
        supportAndSubtreeJoints.addAll(Arrays.asList(SimMultiBodySystemTools.collectSupportJoints(rigidBody)));
        return supportAndSubtreeJoints.toArray(new SimJointReadOnly[supportAndSubtreeJoints.size()]);
    }

    public static SimJointBasics[] collectSupportAndSubtreeJoints(SimRigidBodyBasics rigidBody) {
        ArrayList supportAndSubtreeJoints = new ArrayList();
        Stream.of(SimMultiBodySystemTools.collectSupportJoints(rigidBody)).forEach(supportAndSubtreeJoints::add);
        rigidBody.childrenSubtreeIterable().forEach(supportAndSubtreeJoints::add);
        return supportAndSubtreeJoints.toArray(new SimJointBasics[supportAndSubtreeJoints.size()]);
    }

    public static SimJointReadOnly[] collectSupportAndSubtreeJoints(SimRigidBodyReadOnly ... rigidBodies) {
        return (SimJointReadOnly[])Stream.of(rigidBodies).map(SimMultiBodySystemTools::collectSupportAndSubtreeJoints).flatMap(Stream::of).distinct().toArray(SimJointReadOnly[]::new);
    }

    public static SimJointBasics[] collectSupportAndSubtreeJoints(SimRigidBodyBasics ... rigidBodies) {
        return (SimJointBasics[])Stream.of(rigidBodies).map(SimMultiBodySystemTools::collectSupportAndSubtreeJoints).flatMap(Stream::of).distinct().toArray(SimJointBasics[]::new);
    }

    public static SimRigidBodyBasics[] collectSubtreeEndEffectors(SimRigidBodyBasics rigidBody) {
        return (SimRigidBodyBasics[])rigidBody.subtreeStream().filter(body -> body.getChildrenJoints().isEmpty()).toArray(SimRigidBodyBasics[]::new);
    }

    public static SimRigidBodyReadOnly[] collectSubtreeEndEffectors(SimRigidBodyReadOnly rigidBody) {
        return (SimRigidBodyReadOnly[])rigidBody.subtreeStream().filter(body -> body.getChildrenJoints().isEmpty()).toArray(SimRigidBodyReadOnly[]::new);
    }

    public static void copyJointsState(List<? extends SimJointReadOnly> source, List<? extends SimJointBasics> destination, SimJointStateType stateSelection) {
        if (source.size() != destination.size()) {
            throw new IllegalArgumentException("Inconsistent argument size: source = " + source.size() + ", destination = " + destination.size() + ".");
        }
        switch (stateSelection) {
            case VELOCITY_CHANGE: {
                SimMultiBodySystemTools.copyJointsDeltaVelocity(source, destination);
                return;
            }
        }
        MultiBodySystemTools.copyJointsState(source, destination, (JointStateType)stateSelection.toJointStateType());
    }

    private static void copyJointsDeltaVelocity(List<? extends SimJointReadOnly> source, List<? extends SimJointBasics> destination) {
        for (int jointIndex = 0; jointIndex < source.size(); ++jointIndex) {
            SimJointReadOnly sourceJoint = source.get(jointIndex);
            SimJointBasics destinationJoint = destination.get(jointIndex);
            destinationJoint.setJointDeltaTwist(sourceJoint);
        }
    }

    public static int extractJointsState(List<? extends SimJointReadOnly> joints, SimJointStateType stateSelection, DMatrix matrixToPack) {
        switch (stateSelection) {
            case VELOCITY_CHANGE: {
                return SimMultiBodySystemTools.extractJointsDeltaVelocity(joints, 0, matrixToPack);
            }
        }
        return MultiBodySystemTools.extractJointsState(joints, (JointStateType)stateSelection.toJointStateType(), (DMatrix)matrixToPack);
    }

    private static int extractJointsDeltaVelocity(List<? extends SimJointReadOnly> joints, int startIndex, DMatrix matrixToPack) {
        for (int jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
            SimJointReadOnly joint = joints.get(jointIndex);
            startIndex = joint.getJointDeltaVelocity(startIndex, matrixToPack);
        }
        return startIndex;
    }

    public static int extractJointsState(SimJointReadOnly[] joints, SimJointStateType stateSelection, DMatrix matrixToPack) {
        switch (stateSelection) {
            case VELOCITY_CHANGE: {
                return SimMultiBodySystemTools.extractJointsDeltaVelocity(joints, 0, matrixToPack);
            }
        }
        return MultiBodySystemTools.extractJointsState((JointReadOnly[])joints, (JointStateType)stateSelection.toJointStateType(), (DMatrix)matrixToPack);
    }

    private static int extractJointsDeltaVelocity(SimJointReadOnly[] joints, int startIndex, DMatrix matrixToPack) {
        for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
            SimJointReadOnly joint = joints[jointIndex];
            startIndex = joint.getJointDeltaVelocity(startIndex, matrixToPack);
        }
        return startIndex;
    }

    public static int insertJointsState(List<? extends SimJointBasics> joints, SimJointStateType stateSelection, DMatrix matrix, double maxMagnitude, boolean testFiniteValues) {
        if (testFiniteValues) {
            SimMultiBodySystemTools.checkFiniteValues(stateSelection, matrix);
        }
        JointStateInsertor stateInsertor = SimMultiBodySystemTools.toJointStateInsertor(stateSelection);
        int startIndex = 0;
        if (stateSelection == SimJointStateType.CONFIGURATION || maxMagnitude == Double.POSITIVE_INFINITY) {
            for (int jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
                SimJointBasics joint = joints.get(jointIndex);
                startIndex = stateInsertor.insertState(joint, startIndex, matrix);
            }
        } else {
            for (int jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
                SimJointBasics joint = joints.get(jointIndex);
                SimMultiBodySystemTools.checkStateNorm(joint, startIndex, matrix, maxMagnitude, stateSelection);
                startIndex = stateInsertor.insertState(joint, startIndex, matrix);
            }
        }
        return startIndex;
    }

    public static void checkFiniteValues(SimJointStateType stateSelection, DMatrix matrix) {
        SimMultiBodySystemTools.checkFiniteValues(stateSelection, matrix, 0, matrix.getNumRows());
    }

    public static void checkFiniteValues(SimJointStateType stateSelection, DMatrix matrix, int startIndex, int numberOfElements) {
        for (int row = startIndex; row < startIndex + numberOfElements; ++row) {
            if (Double.isFinite(matrix.get(row, 0))) continue;
            throw new IllegalArgumentException("The given state (" + stateSelection + ") matrix contains non-finite values: " + matrix);
        }
    }

    public static JointStateInsertor toJointStateInsertor(SimJointStateType stateSelection) {
        return switch (stateSelection) {
            case SimJointStateType.CONFIGURATION -> jointConfigurationInsertor;
            case SimJointStateType.VELOCITY -> jointVelocityInsertor;
            case SimJointStateType.VELOCITY_CHANGE -> jointDeltaVelocityInsertor;
            case SimJointStateType.ACCELERATION -> jointAccelerationInsertor;
            case SimJointStateType.EFFORT -> jointEffortInsertor;
            default -> throw new RuntimeException("Unexpected value for stateSelection: " + stateSelection);
        };
    }

    private static void checkStateNorm(JointReadOnly joint, int startIndex, DMatrix stateMatrix, double maxMagnitude, SimJointStateType state) {
        double normSquared = 0.0;
        for (int dof = 0; dof < joint.getDegreesOfFreedom(); ++dof) {
            normSquared += EuclidCoreTools.square((double)stateMatrix.get(startIndex + dof, 0));
        }
        if (normSquared > maxMagnitude * maxMagnitude) {
            throw new IllegalArgumentException("Joint (" + joint.getName() + ") state (" + state + ") exceeds max magnitude (" + maxMagnitude + "): " + Math.sqrt(normSquared));
        }
    }

    public static int insertJointsStateWithBackup(List<? extends SimJointBasics> joints, Predicate<SimJointBasics> predicateStateA, SimJointStateType stateSelectionA, DMatrix matrixA, double maxMagnitudeA, boolean testFiniteValuesA, SimJointStateType stateSelectionB, DMatrix matrixB, double maxMagnitudeB, boolean testFiniteValuesB) {
        JointStateInsertor stateInsertorA = SimMultiBodySystemTools.toJointStateInsertor(stateSelectionA);
        JointStateInsertor stateInsertorB = SimMultiBodySystemTools.toJointStateInsertor(stateSelectionB);
        int startIndex = 0;
        if (stateSelectionA == SimJointStateType.CONFIGURATION) {
            maxMagnitudeA = Double.POSITIVE_INFINITY;
        }
        if (stateSelectionB == SimJointStateType.CONFIGURATION) {
            maxMagnitudeB = Double.POSITIVE_INFINITY;
        }
        for (int jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
            SimJointBasics joint = joints.get(jointIndex);
            if (predicateStateA.test(joint)) {
                if (testFiniteValuesA) {
                    if (stateSelectionA == SimJointStateType.CONFIGURATION) {
                        SimMultiBodySystemTools.checkFiniteValues(stateSelectionA, matrixA, startIndex, joint.getConfigurationMatrixSize());
                    } else {
                        SimMultiBodySystemTools.checkFiniteValues(stateSelectionA, matrixA, startIndex, joint.getDegreesOfFreedom());
                    }
                }
                if (maxMagnitudeA != Double.POSITIVE_INFINITY) {
                    SimMultiBodySystemTools.checkStateNorm(joint, startIndex, matrixA, maxMagnitudeA, stateSelectionA);
                }
                startIndex = stateInsertorA.insertState(joint, startIndex, matrixA);
                continue;
            }
            if (testFiniteValuesB) {
                if (stateSelectionB == SimJointStateType.CONFIGURATION) {
                    SimMultiBodySystemTools.checkFiniteValues(stateSelectionB, matrixB, startIndex, joint.getConfigurationMatrixSize());
                } else {
                    SimMultiBodySystemTools.checkFiniteValues(stateSelectionB, matrixB, startIndex, joint.getDegreesOfFreedom());
                }
            }
            if (maxMagnitudeB != Double.POSITIVE_INFINITY) {
                SimMultiBodySystemTools.checkStateNorm(joint, startIndex, matrixB, maxMagnitudeB, stateSelectionB);
            }
            startIndex = stateInsertorB.insertState(joint, startIndex, matrixB);
        }
        return startIndex;
    }

    public static int insertJointsState(SimJointBasics[] joints, SimJointStateType stateSelection, DMatrix matrix, double maxMagnitude, boolean testFiniteValues) {
        if (testFiniteValues) {
            SimMultiBodySystemTools.checkFiniteValues(stateSelection, matrix);
        }
        switch (stateSelection) {
            case CONFIGURATION: {
                return SimMultiBodySystemTools.insertJointsConfiguration(joints, 0, matrix);
            }
            case VELOCITY: {
                return SimMultiBodySystemTools.insertJointsVelocity(joints, 0, matrix, maxMagnitude);
            }
            case VELOCITY_CHANGE: {
                return SimMultiBodySystemTools.insertJointsDeltaVelocity(joints, 0, matrix, maxMagnitude);
            }
            case ACCELERATION: {
                return SimMultiBodySystemTools.insertJointsAcceleration(joints, 0, matrix, maxMagnitude);
            }
            case EFFORT: {
                return SimMultiBodySystemTools.insertJointsTau(joints, 0, matrix, maxMagnitude);
            }
        }
        throw new RuntimeException("Unexpected value for stateSelection: " + stateSelection);
    }

    private static int insertJointsConfiguration(JointBasics[] joints, int startIndex, DMatrix matrix) {
        for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
            JointBasics joint = joints[jointIndex];
            startIndex = joint.setJointConfiguration(startIndex, matrix);
        }
        return startIndex;
    }

    private static int insertJointsVelocity(JointBasics[] joints, int startIndex, DMatrix matrix, double maxMagnitude) {
        if (maxMagnitude == Double.POSITIVE_INFINITY) {
            for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
                JointBasics joint = joints[jointIndex];
                startIndex = joint.setJointVelocity(startIndex, matrix);
            }
        } else {
            double maxMagSquared = maxMagnitude * maxMagnitude;
            for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
                JointBasics joint = joints[jointIndex];
                double normSquared = 0.0;
                for (int dof = 0; dof < joint.getDegreesOfFreedom(); ++dof) {
                    normSquared += EuclidCoreTools.square((double)matrix.get(startIndex + dof, 0));
                }
                if (normSquared > maxMagSquared) {
                    throw new IllegalArgumentException("Joint (" + joint.getName() + ") velocity exceeds max magnitude (" + maxMagnitude + "): " + Math.sqrt(normSquared));
                }
                startIndex = joint.setJointVelocity(startIndex, matrix);
            }
        }
        return startIndex;
    }

    private static int insertJointsDeltaVelocity(SimJointBasics[] joints, int startIndex, DMatrix matrix, double maxMagnitude) {
        if (maxMagnitude == Double.POSITIVE_INFINITY) {
            for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
                SimJointBasics joint = joints[jointIndex];
                startIndex = joint.setJointDeltaVelocity(startIndex, matrix);
            }
        } else {
            double maxMagSquared = maxMagnitude * maxMagnitude;
            for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
                SimJointBasics joint = joints[jointIndex];
                double normSquared = 0.0;
                for (int dof = 0; dof < joint.getDegreesOfFreedom(); ++dof) {
                    normSquared += EuclidCoreTools.square((double)matrix.get(startIndex + dof, 0));
                }
                if (normSquared > maxMagSquared) {
                    throw new IllegalArgumentException("Joint (" + joint.getName() + ") dela-velocity exceeds max magnitude (" + maxMagnitude + "): " + Math.sqrt(normSquared));
                }
                startIndex = joint.setJointDeltaVelocity(startIndex, matrix);
            }
        }
        return startIndex;
    }

    private static int insertJointsAcceleration(JointBasics[] joints, int startIndex, DMatrix matrix, double maxMagnitude) {
        if (maxMagnitude == Double.POSITIVE_INFINITY) {
            for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
                JointBasics joint = joints[jointIndex];
                startIndex = joint.setJointAcceleration(startIndex, matrix);
            }
        } else {
            double maxMagSquared = maxMagnitude * maxMagnitude;
            for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
                JointBasics joint = joints[jointIndex];
                double normSquared = 0.0;
                for (int dof = 0; dof < joint.getDegreesOfFreedom(); ++dof) {
                    normSquared += EuclidCoreTools.square((double)matrix.get(startIndex + dof, 0));
                }
                if (normSquared > maxMagSquared) {
                    throw new IllegalArgumentException("Joint (" + joint.getName() + ") acceleration exceeds max magnitude (" + maxMagnitude + "): " + Math.sqrt(normSquared));
                }
                startIndex = joint.setJointAcceleration(startIndex, matrix);
            }
        }
        return startIndex;
    }

    private static int insertJointsTau(JointBasics[] joints, int startIndex, DMatrix matrix, double maxMagnitude) {
        if (maxMagnitude == Double.POSITIVE_INFINITY) {
            for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
                JointBasics joint = joints[jointIndex];
                startIndex = joint.setJointTau(startIndex, matrix);
            }
        } else {
            double maxMagSquared = maxMagnitude * maxMagnitude;
            for (int jointIndex = 0; jointIndex < joints.length; ++jointIndex) {
                JointBasics joint = joints[jointIndex];
                double normSquared = 0.0;
                for (int dof = 0; dof < joint.getDegreesOfFreedom(); ++dof) {
                    normSquared += EuclidCoreTools.square((double)matrix.get(startIndex + dof, 0));
                }
                if (normSquared > maxMagSquared) {
                    throw new IllegalArgumentException("Joint (" + joint.getName() + ") acceleration exceeds max magnitude (" + maxMagnitude + "): " + Math.sqrt(normSquared));
                }
                startIndex = joint.setJointTau(startIndex, matrix);
            }
        }
        return startIndex;
    }

    private static interface JointStateInsertor {
        public int insertState(SimJointBasics var1, int var2, DMatrix var3);
    }
}

