/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.impulseBased;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix3;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrix4x4;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.fixed.CommonOps_DDF3;
import org.ejml.dense.fixed.CommonOps_DDF4;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialImpulseBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.ContactImpulseTools;

public class SingleContactImpulseSolver {
    private static final double DEGENERATE_THRESHOLD = 1.0E-6;
    private static final double NEGATIVE_NORMAL_IMPULSE_THRESHOLD = -1.0E-12;
    private double beta1 = 0.35;
    private double beta2 = 0.95;
    private double beta3 = 1.15;
    private double gamma = 1.0E-6;
    private boolean computeFrictionMoment = false;
    private int problemSize = 3;
    private double coulombMomentRatio = 0.3;
    private final DMatrixRMaj c = new DMatrixRMaj(4, 1);
    private final DMatrix3 c_linear = new DMatrix3();
    private final DMatrix3x3 M_linear_inv = new DMatrix3x3();
    private final DMatrix3x3 M_linear = new DMatrix3x3();
    private final DMatrix4x4 M_full_inv = new DMatrix4x4();
    private final DMatrix4x4 M_full = new DMatrix4x4();
    private final DMatrix3 M_lin_ang = new DMatrix3();
    private final LinearSolverDense<DMatrixRMaj> svdSolver = LinearSolverFactory_DDRM.pseudoInverse((boolean)true);
    private final DMatrix3 lambda_linear_v_0 = new DMatrix3();
    private final DMatrixRMaj lambda_v_0 = new DMatrixRMaj(4, 1);
    private boolean isProblemDegenerate = false;
    private boolean M_linear_inv_dirty = true;
    private boolean M_full_inv_dirty = true;
    private boolean M_inv_det_dirty = true;

    public void setSlipBisectionParameters(double beta1, double beta2, double beta3) {
        this.beta1 = beta1;
        this.beta2 = beta2;
        this.beta3 = beta3;
    }

    public void setTolerance(double gamma) {
        this.gamma = gamma;
    }

    public void setEnableFrictionMoment(boolean enable) {
        this.computeFrictionMoment = enable;
        this.problemSize = enable ? 4 : 3;
    }

    public void setCoulombMomentRatio(double ratio) {
        this.coulombMomentRatio = ratio;
    }

    public int getProblemSize() {
        return this.problemSize;
    }

    public void reset() {
        this.M_linear_inv_dirty = true;
        this.M_full_inv_dirty = true;
        this.M_inv_det_dirty = true;
    }

    public void solveImpulseGeneral(SpatialVectorReadOnly velocity, DMatrixRMaj M_inv, double mu, SolverOutput output) {
        if (EuclidCoreTools.isZero((double)mu, (double)1.0E-12)) {
            output.impulseLinear.a1 = 0.0;
            output.impulseLinear.a2 = 0.0;
            output.impulseLinear.a3 = -velocity.getLinearPart().getZ() / M_inv.get(2, 2);
            output.impulseAngularZ = 0.0;
            output.isLinearSlipping = true;
            return;
        }
        if (this.M_inv_det_dirty) {
            this.isProblemDegenerate = CommonOps_DDRM.det((DMatrixRMaj)M_inv) <= 1.0E-6;
            this.M_inv_det_dirty = false;
        }
        output.isContactDegenerate = this.isProblemDegenerate;
        if (this.isProblemDegenerate) {
            this.solveImpulseDegenerate(velocity, M_inv, mu, output);
            return;
        }
        velocity.getLinearPart().get((DMatrix)this.c_linear);
        boolean isSlipping = this.solveLinearImpulse(M_inv, mu, this.c_linear, output.impulseLinear);
        if (!isSlipping && this.computeFrictionMoment) {
            this.solveAngularImpulse(velocity.getAngularPartZ(), M_inv, mu, output);
        } else {
            output.impulseAngularZ = 0.0;
        }
    }

    private boolean solveLinearImpulse(DMatrixRMaj M_inv, double mu, DMatrix3 c, DMatrix3 lambda) {
        if (this.M_linear_inv_dirty) {
            ContactImpulseTools.extract((DMatrix)M_inv, 0, 0, this.M_linear_inv);
            CommonOps_DDF3.invert((DMatrix3x3)this.M_linear_inv, (DMatrix3x3)this.M_linear);
            this.M_linear_inv_dirty = false;
        }
        CommonOps_DDF3.mult((DMatrix3x3)this.M_linear, (DMatrix3)c, (DMatrix3)this.lambda_linear_v_0);
        CommonOps_DDF3.changeSign((DMatrix3)this.lambda_linear_v_0);
        if (this.lambda_linear_v_0.a3 > -1.0E-12 && ContactImpulseTools.isInsideFrictionCone(mu, (DMatrix)this.lambda_linear_v_0)) {
            lambda.set((Matrix)this.lambda_linear_v_0);
            return false;
        }
        ContactImpulseTools.computeSlipLambda(this.beta1, this.beta2, this.beta3, this.gamma, mu, (DMatrix)this.M_linear_inv, (DMatrix)this.lambda_linear_v_0, (DMatrix)c, (DMatrix)lambda, false);
        return true;
    }

    private void solveAngularImpulse(double velocityAngularZ, DMatrixRMaj M_inv, double mu, SolverOutput output) {
        if (this.M_full_inv_dirty) {
            this.M_full_inv.set((Matrix)M_inv);
            CommonOps_DDF4.invert((DMatrix4x4)this.M_full_inv, (DMatrix4x4)this.M_full);
            this.M_full_inv_dirty = false;
        }
        DMatrix3 lambda_linear_decoupled = this.lambda_linear_v_0;
        lambda_linear_decoupled.a1 = -this.M_full.a11 * this.c_linear.a1 - this.M_full.a12 * this.c_linear.a2 - this.M_full.a13 * this.c_linear.a3;
        lambda_linear_decoupled.a2 = -this.M_full.a21 * this.c_linear.a1 - this.M_full.a22 * this.c_linear.a2 - this.M_full.a23 * this.c_linear.a3;
        lambda_linear_decoupled.a3 = -this.M_full.a31 * this.c_linear.a1 - this.M_full.a32 * this.c_linear.a2 - this.M_full.a33 * this.c_linear.a3;
        this.M_lin_ang.set(this.M_full.a14, this.M_full.a24, this.M_full.a34);
        double lambda_angular_coupling = -CommonOps_DDF3.dot((DMatrix3)this.M_lin_ang, (DMatrix3)this.c_linear);
        if (lambda_linear_decoupled.a3 < -1.0E-12 || !ContactImpulseTools.isInsideFrictionEllipsoid(mu, lambda_linear_decoupled, lambda_angular_coupling, this.coulombMomentRatio)) {
            output.impulseAngularZ = 0.0;
            output.isAngularSlipping = true;
            return;
        }
        double M_angular = this.M_full.get(3, 3);
        double c_angular = velocityAngularZ;
        ContactImpulseTools.scaleAdd(-c_angular, this.M_lin_ang, lambda_linear_decoupled, output.impulseLinear);
        double lambda_angular = lambda_angular_coupling - M_angular * c_angular;
        if (output.impulseLinear.a3 > -1.0E-12 && ContactImpulseTools.isInsideFrictionEllipsoid(mu, output.impulseLinear, lambda_angular, this.coulombMomentRatio)) {
            output.impulseAngularZ = lambda_angular;
            output.isAngularSlipping = false;
            return;
        }
        double c_angular_lo = 0.0;
        double c_angular_hi = c_angular;
        output.impulseLinear.set((Matrix)lambda_linear_decoupled);
        output.impulseAngularZ = lambda_angular_coupling;
        output.isAngularSlipping = true;
        int iteration = 0;
        while (true) {
            ++iteration;
            if (Math.abs(c_angular_hi - c_angular_lo) < this.gamma) {
                return;
            }
            if (iteration > 1000) {
                throw new IllegalStateException("Failed to computed friction moment");
            }
            double c_angular_mid = 0.5 * (c_angular_lo + c_angular_hi);
            ContactImpulseTools.scaleAdd(-c_angular_mid, this.M_lin_ang, lambda_linear_decoupled, output.impulseLinear);
            if (output.impulseLinear.a3 < -1.0E-12) {
                c_angular_hi = c_angular_mid;
                continue;
            }
            output.impulseAngularZ = lambda_angular_coupling - M_angular * c_angular_mid;
            if (!ContactImpulseTools.isInsideFrictionEllipsoid(mu, output.impulseLinear, output.impulseAngularZ, this.coulombMomentRatio)) {
                c_angular_hi = c_angular_mid;
                continue;
            }
            c_angular_lo = c_angular_mid;
        }
    }

    private void solveImpulseDegenerate(SpatialVectorReadOnly velocity, DMatrixRMaj M_inv, double mu, SolverOutput output) {
        this.lambda_v_0.reshape(this.problemSize, 1);
        this.c.reshape(this.problemSize, 1);
        velocity.getLinearPart().get((DMatrix)this.c);
        if (this.computeFrictionMoment) {
            this.c.set(3, velocity.getAngularPart().getZ());
        }
        this.svdSolver.setA((Matrix)M_inv);
        this.svdSolver.solve((Matrix)this.c, (Matrix)this.lambda_v_0);
        CommonOps_DDRM.changeSign((DMatrixD1)this.lambda_v_0);
        if (this.computeFrictionMoment) {
            if (this.lambda_v_0.get(2) < -1.0E-12 || !ContactImpulseTools.isInsideFrictionEllipsoid(mu, (DMatrix)this.lambda_v_0, this.coulombMomentRatio)) {
                throw new IllegalStateException("Unable to fully solve degenerate case. Need to be improved.");
            }
            output.impulseLinear.set((Matrix)this.lambda_v_0);
            output.impulseAngularZ = this.lambda_v_0.get(3, 0);
            output.isLinearSlipping = false;
        } else if (this.lambda_v_0.get(2) < -1.0E-12 || !ContactImpulseTools.isInsideFrictionCone(mu, (DMatrix)this.lambda_v_0)) {
            ContactImpulseTools.computeSlipLambda(this.beta1, this.beta2, this.beta3, this.gamma, mu, (DMatrix)M_inv, (DMatrix)this.lambda_v_0, (DMatrix)this.c, (DMatrix)output.impulseLinear, false);
            output.isLinearSlipping = true;
        } else {
            output.impulseLinear.set((Matrix)this.lambda_v_0);
            output.isLinearSlipping = false;
        }
    }

    public void printForUnitTest(DMatrixRMaj M_inv, double mu) {
        System.err.println(ContactImpulseTools.toStringForUnitTest(this.beta1, this.beta2, this.beta3, this.gamma, mu, (DMatrix)M_inv, (DMatrix)this.lambda_linear_v_0, (DMatrix)this.c_linear));
    }

    public static class SolverOutput {
        private final DMatrix3 impulseLinear = new DMatrix3();
        private double impulseAngularZ;
        private boolean isLinearSlipping;
        private boolean isAngularSlipping;
        private boolean isContactDegenerate;

        public void getSpatialImpulse(FixedFrameSpatialImpulseBasics impulseToPack) {
            impulseToPack.getLinearPart().set(this.impulseLinear.a1, this.impulseLinear.a2, this.impulseLinear.a3);
            impulseToPack.getAngularPart().set(0.0, 0.0, this.impulseAngularZ);
        }

        public boolean isLinearSlipping() {
            return this.isLinearSlipping;
        }

        public boolean isAngularSlipping() {
            return this.isAngularSlipping;
        }

        public boolean isContactDegenerate() {
            return this.isContactDegenerate;
        }
    }
}

