/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.screwTools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimFixedJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimPlanarJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimPrismaticJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimRevoluteJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimRigidBody;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimSixDoFJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimSphericalJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimOneDoFJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.scs2.simulation.screwTools.SimJointStateType;

public class SimMultiBodySystemRandomTools {
    public static void nextState(Random random, SimJointStateType stateToRandomize, SimJointBasics joint) {
        switch (stateToRandomize) {
            case CONFIGURATION: {
                joint.setJointOrientation((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
                joint.setJointPosition((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                break;
            }
            case VELOCITY: {
                joint.setJointAngularVelocity((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                joint.setJointLinearVelocity((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                break;
            }
            case VELOCITY_CHANGE: {
                joint.setJointAngularDeltaVelocity((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                joint.setJointLinearDeltaVelocity((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                break;
            }
            case ACCELERATION: {
                joint.setJointAngularAcceleration((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                joint.setJointLinearAcceleration((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                break;
            }
            case EFFORT: {
                joint.setJointTorque((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                joint.setJointForce((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                break;
            }
            default: {
                throw new RuntimeException("Unhandled state selection: " + stateToRandomize);
            }
        }
    }

    public static void nextState(Random random, SimJointStateType stateToRandomize, SimJointBasics[] joints) {
        for (SimJointBasics joint : joints) {
            SimMultiBodySystemRandomTools.nextState(random, stateToRandomize, joint);
        }
    }

    public static void nextState(Random random, SimJointStateType stateToRandomize, Iterable<? extends SimJointBasics> joints) {
        joints.forEach(joint -> SimMultiBodySystemRandomTools.nextState(random, stateToRandomize, joint));
    }

    public static void nextState(Random random, SimJointStateType stateToRandomize, double min, double max, SimOneDoFJointBasics joint) {
        switch (stateToRandomize) {
            case CONFIGURATION: {
                joint.setQ(EuclidCoreRandomTools.nextDouble((Random)random, (double)min, (double)max));
                break;
            }
            case VELOCITY: {
                joint.setQd(EuclidCoreRandomTools.nextDouble((Random)random, (double)min, (double)max));
                break;
            }
            case VELOCITY_CHANGE: {
                joint.setDeltaQd(EuclidCoreRandomTools.nextDouble((Random)random, (double)min, (double)max));
                break;
            }
            case ACCELERATION: {
                joint.setQdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)min, (double)max));
                break;
            }
            case EFFORT: {
                joint.setTau(EuclidCoreRandomTools.nextDouble((Random)random, (double)min, (double)max));
                break;
            }
            default: {
                throw new RuntimeException("Unhandled state selection: " + stateToRandomize);
            }
        }
    }

    public static void nextStateWithinJointLimits(Random random, SimJointStateType stateToRandomize, SimOneDoFJointBasics[] joints) {
        for (SimOneDoFJointBasics joint : joints) {
            SimMultiBodySystemRandomTools.nextStateWithinJointLimits(random, stateToRandomize, joint);
        }
    }

    public static void nextStateWithinJointLimits(Random random, SimJointStateType stateToRandomize, Iterable<? extends SimOneDoFJointBasics> joints) {
        joints.forEach(joint -> SimMultiBodySystemRandomTools.nextStateWithinJointLimits(random, stateToRandomize, joint));
    }

    public static void nextStateWithinJointLimits(Random random, SimJointStateType stateToRandomize, SimOneDoFJointBasics joint) {
        switch (stateToRandomize) {
            case CONFIGURATION: {
                joint.setQ(EuclidCoreRandomTools.nextDouble((Random)random, (double)joint.getJointLimitLower(), (double)joint.getJointLimitUpper()));
                break;
            }
            case VELOCITY: {
                joint.setQd(EuclidCoreRandomTools.nextDouble((Random)random, (double)joint.getVelocityLimitLower(), (double)joint.getVelocityLimitUpper()));
                break;
            }
            case VELOCITY_CHANGE: {
                double deltaQdMax = joint.getVelocityLimitUpper() - joint.getQd();
                double deltaQdMin = joint.getVelocityLimitLower() - joint.getQd();
                joint.setDeltaQd(EuclidCoreRandomTools.nextDouble((Random)random, (double)deltaQdMin, (double)deltaQdMax));
                break;
            }
            case EFFORT: {
                joint.setTau(EuclidCoreRandomTools.nextDouble((Random)random, (double)joint.getEffortLimitLower(), (double)joint.getEffortLimitUpper()));
                break;
            }
            default: {
                throw new RuntimeException("Unhandled state selection: " + stateToRandomize);
            }
        }
    }

    public static void nextState(Random random, SimJointStateType stateToRandomize, double min, double max, SimOneDoFJointBasics[] joints) {
        for (SimOneDoFJointBasics joint : joints) {
            SimMultiBodySystemRandomTools.nextState(random, stateToRandomize, min, max, joint);
        }
    }

    public static void nextState(Random random, SimJointStateType stateToRandomize, double min, double max, Iterable<? extends SimOneDoFJointBasics> joints) {
        joints.forEach(joint -> SimMultiBodySystemRandomTools.nextState(random, stateToRandomize, min, max, joint));
    }

    public static List<SimPrismaticJoint> nextPrismaticJointChain(Random random, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextPrismaticJointChain(random, "", numberOfJoints);
    }

    public static List<SimPrismaticJoint> nextPrismaticJointChain(Random random, String prefix, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextPrismaticJointChain(random, prefix, (Vector3DReadOnly[])MecanoRandomTools.nextVector3DArray((Random)random, (int)numberOfJoints, (double)1.0));
    }

    public static List<SimPrismaticJoint> nextPrismaticJointChain(Random random, String prefix, Vector3DReadOnly[] jointAxes) {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        SimRigidBody rootBody = new SimRigidBody(prefix + "RootBody", worldFrame, null);
        return SimMultiBodySystemRandomTools.nextPrismaticJointChain(random, prefix, (SimRigidBodyBasics)rootBody, jointAxes);
    }

    public static List<SimPrismaticJoint> nextPrismaticJointChain(Random random, SimRigidBodyBasics rootBody, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextPrismaticJointChain(random, "", rootBody, numberOfJoints);
    }

    public static List<SimPrismaticJoint> nextPrismaticJointChain(Random random, String prefix, SimRigidBodyBasics rootBody, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextPrismaticJointChain(random, prefix, rootBody, (Vector3DReadOnly[])MecanoRandomTools.nextVector3DArray((Random)random, (int)numberOfJoints, (double)1.0));
    }

    public static List<SimPrismaticJoint> nextPrismaticJointChain(Random random, String prefix, SimRigidBodyBasics rootBody, Vector3DReadOnly[] jointAxes) {
        SimRigidBodyBasics predecessor = rootBody;
        ArrayList<SimPrismaticJoint> prismaticJoints = new ArrayList<SimPrismaticJoint>();
        for (int i = 0; i < jointAxes.length; ++i) {
            SimPrismaticJoint joint = SimMultiBodySystemRandomTools.nextPrismaticJoint(random, prefix + "SimJointBasics" + i, jointAxes[i], predecessor);
            prismaticJoints.add(joint);
            predecessor = SimMultiBodySystemRandomTools.nextRigidBody(random, prefix + "Body" + i, joint);
        }
        return prismaticJoints;
    }

    public static List<SimRevoluteJoint> nextRevoluteJointChain(Random random, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextRevoluteJointChain(random, "", numberOfJoints);
    }

    public static List<SimRevoluteJoint> nextRevoluteJointChain(Random random, String prefix, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextRevoluteJointChain(random, prefix, (Vector3DReadOnly[])MecanoRandomTools.nextVector3DArray((Random)random, (int)numberOfJoints, (double)1.0));
    }

    public static List<SimRevoluteJoint> nextRevoluteJointChain(Random random, String prefix, Vector3DReadOnly[] jointAxes) {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        SimRigidBody rootBody = new SimRigidBody(prefix + "RootBody", worldFrame, null);
        return SimMultiBodySystemRandomTools.nextRevoluteJointChain(random, prefix, (SimRigidBodyBasics)rootBody, jointAxes);
    }

    public static List<SimRevoluteJoint> nextRevoluteJointChain(Random random, SimRigidBodyBasics rootBody, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextRevoluteJointChain(random, "", rootBody, numberOfJoints);
    }

    public static List<SimRevoluteJoint> nextRevoluteJointChain(Random random, String prefix, SimRigidBodyBasics rootBody, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextRevoluteJointChain(random, prefix, rootBody, (Vector3DReadOnly[])MecanoRandomTools.nextVector3DArray((Random)random, (int)numberOfJoints, (double)1.0));
    }

    public static List<SimRevoluteJoint> nextRevoluteJointChain(Random random, String prefix, SimRigidBodyBasics rootBody, Vector3DReadOnly[] jointAxes) {
        SimRigidBodyBasics predecessor = rootBody;
        ArrayList<SimRevoluteJoint> revoluteJoints = new ArrayList<SimRevoluteJoint>();
        for (int i = 0; i < jointAxes.length; ++i) {
            SimRevoluteJoint joint = SimMultiBodySystemRandomTools.nextRevoluteJoint(random, prefix + "SimJointBasics" + i, jointAxes[i], predecessor);
            revoluteJoints.add(joint);
            predecessor = SimMultiBodySystemRandomTools.nextRigidBody(random, prefix + "Body" + i, joint);
        }
        return revoluteJoints;
    }

    public static List<SimOneDoFJointBasics> nextOneDoFJointChain(Random random, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextOneDoFJointChain(random, "", numberOfJoints);
    }

    public static List<SimOneDoFJointBasics> nextOneDoFJointChain(Random random, String prefix, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextOneDoFJointChain(random, prefix, (Vector3DReadOnly[])MecanoRandomTools.nextVector3DArray((Random)random, (int)numberOfJoints, (double)1.0));
    }

    public static List<SimOneDoFJointBasics> nextOneDoFJointChain(Random random, String prefix, Vector3DReadOnly[] jointAxes) {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        SimRigidBody rootBody = new SimRigidBody(prefix + "RootBody", worldFrame, null);
        return SimMultiBodySystemRandomTools.nextOneDoFJointChain(random, prefix, (SimRigidBodyBasics)rootBody, jointAxes);
    }

    public static List<SimOneDoFJointBasics> nextOneDoFJointChain(Random random, SimRigidBodyBasics rootBody, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextOneDoFJointChain(random, "", rootBody, numberOfJoints);
    }

    public static List<SimOneDoFJointBasics> nextOneDoFJointChain(Random random, String prefix, SimRigidBodyBasics rootBody, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextOneDoFJointChain(random, prefix, rootBody, (Vector3DReadOnly[])MecanoRandomTools.nextVector3DArray((Random)random, (int)numberOfJoints, (double)1.0));
    }

    public static List<SimOneDoFJointBasics> nextOneDoFJointChain(Random random, String prefix, SimRigidBodyBasics rootBody, Vector3DReadOnly[] jointAxes) {
        SimRigidBodyBasics predecessor = rootBody;
        ArrayList<SimOneDoFJointBasics> oneDoFJoints = new ArrayList<SimOneDoFJointBasics>();
        for (int i = 0; i < jointAxes.length; ++i) {
            SimOneDoFJointBasics joint = SimMultiBodySystemRandomTools.nextOneDoFJoint(random, prefix + "SimJointBasics" + i, jointAxes[i], predecessor);
            oneDoFJoints.add(joint);
            predecessor = SimMultiBodySystemRandomTools.nextRigidBody(random, prefix + "Body" + i, joint);
        }
        return oneDoFJoints;
    }

    public static List<SimJointBasics> nextJointChain(Random random, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextJointChain(random, "", numberOfJoints);
    }

    public static List<SimJointBasics> nextJointChain(Random random, String prefix, int numberOfJoints) {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        SimRigidBody rootBody = new SimRigidBody(prefix + "RootBody", worldFrame, null);
        return SimMultiBodySystemRandomTools.nextJointChain(random, prefix, rootBody, numberOfJoints);
    }

    public static List<SimJointBasics> nextJointChain(Random random, SimRigidBodyBasics rootBody, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextJointChain(random, "", rootBody, numberOfJoints);
    }

    public static List<SimJointBasics> nextJointChain(Random random, String prefix, SimRigidBodyBasics rootBody, int numberOfJoints) {
        SimRigidBodyBasics predecessor = rootBody;
        ArrayList<SimJointBasics> joints = new ArrayList<SimJointBasics>();
        for (int i = 0; i < numberOfJoints; ++i) {
            SimJointBasics joint = SimMultiBodySystemRandomTools.nextJoint(random, prefix + "SimJointBasics" + i, predecessor);
            joints.add(joint);
            predecessor = SimMultiBodySystemRandomTools.nextRigidBody(random, prefix + "Body" + i, joint);
        }
        return joints;
    }

    public static List<SimPrismaticJoint> nextPrismaticJointTree(Random random, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextPrismaticJointTree(random, "", numberOfJoints);
    }

    public static List<SimPrismaticJoint> nextPrismaticJointTree(Random random, String prefix, int numberOfJoints) {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        SimRigidBody rootBody = new SimRigidBody(prefix + "RootBody", worldFrame, null);
        return SimMultiBodySystemRandomTools.nextPrismaticJointTree(random, prefix, rootBody, numberOfJoints);
    }

    public static List<SimPrismaticJoint> nextPrismaticJointTree(Random random, SimRigidBodyBasics rootBody, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextPrismaticJointTree(random, "", rootBody, numberOfJoints);
    }

    public static List<SimPrismaticJoint> nextPrismaticJointTree(Random random, String prefix, SimRigidBodyBasics rootBody, int numberOfJoints) {
        ArrayList<SimPrismaticJoint> prismaticJoints = new ArrayList<SimPrismaticJoint>();
        SimRigidBodyBasics predecessor = rootBody;
        for (int i = 0; i < numberOfJoints; ++i) {
            SimPrismaticJoint joint = SimMultiBodySystemRandomTools.nextPrismaticJoint(random, prefix + "SimJointBasics" + i, predecessor);
            SimMultiBodySystemRandomTools.nextRigidBody(random, prefix + "Body" + i, joint);
            prismaticJoints.add(joint);
            predecessor = ((SimPrismaticJoint)prismaticJoints.get(random.nextInt(prismaticJoints.size()))).getSuccessor();
        }
        return SubtreeStreams.from(SimPrismaticJoint.class, (Collection)rootBody.getChildrenJoints()).collect(Collectors.toList());
    }

    public static List<SimRevoluteJoint> nextRevoluteJointTree(Random random, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextRevoluteJointTree(random, "", numberOfJoints);
    }

    public static List<SimRevoluteJoint> nextRevoluteJointTree(Random random, String prefix, int numberOfJoints) {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        SimRigidBody rootBody = new SimRigidBody("RootBody", worldFrame, null);
        return SimMultiBodySystemRandomTools.nextRevoluteJointTree(random, prefix, rootBody, numberOfJoints);
    }

    public static List<SimRevoluteJoint> nextRevoluteJointTree(Random random, SimRigidBodyBasics rootBody, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextRevoluteJointTree(random, "", rootBody, numberOfJoints);
    }

    public static List<SimRevoluteJoint> nextRevoluteJointTree(Random random, String prefix, SimRigidBodyBasics rootBody, int numberOfJoints) {
        ArrayList<SimRevoluteJoint> revoluteJoints = new ArrayList<SimRevoluteJoint>();
        SimRigidBodyBasics predecessor = rootBody;
        for (int i = 0; i < numberOfJoints; ++i) {
            SimRevoluteJoint joint = SimMultiBodySystemRandomTools.nextRevoluteJoint(random, prefix + "SimJointBasics" + i, predecessor);
            SimMultiBodySystemRandomTools.nextRigidBody(random, prefix + "Body" + i, joint);
            revoluteJoints.add(joint);
            predecessor = ((SimRevoluteJoint)revoluteJoints.get(random.nextInt(revoluteJoints.size()))).getSuccessor();
        }
        return SubtreeStreams.from(SimRevoluteJoint.class, (Collection)rootBody.getChildrenJoints()).collect(Collectors.toList());
    }

    public static List<SimOneDoFJointBasics> nextOneDoFJointTree(Random random, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextOneDoFJointTree(random, "", numberOfJoints);
    }

    public static List<SimOneDoFJointBasics> nextOneDoFJointTree(Random random, String prefix, int numberOfJoints) {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        SimRigidBody rootBody = new SimRigidBody("RootBody", worldFrame, null);
        return SimMultiBodySystemRandomTools.nextOneDoFJointTree(random, prefix, rootBody, numberOfJoints);
    }

    public static List<SimOneDoFJointBasics> nextOneDoFJointTree(Random random, SimRigidBodyBasics rootBody, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextOneDoFJointTree(random, "", rootBody, numberOfJoints);
    }

    public static List<SimOneDoFJointBasics> nextOneDoFJointTree(Random random, String prefix, SimRigidBodyBasics rootBody, int numberOfJoints) {
        ArrayList<SimOneDoFJointBasics> oneDoFJoints = new ArrayList<SimOneDoFJointBasics>();
        SimRigidBodyBasics predecessor = rootBody;
        for (int i = 0; i < numberOfJoints; ++i) {
            SimOneDoFJointBasics joint = SimMultiBodySystemRandomTools.nextOneDoFJoint(random, prefix + "SimJointBasics" + i, predecessor);
            SimMultiBodySystemRandomTools.nextRigidBody(random, prefix + "Body" + i, joint);
            oneDoFJoints.add(joint);
            predecessor = ((SimOneDoFJointBasics)oneDoFJoints.get(random.nextInt(oneDoFJoints.size()))).getSuccessor();
        }
        return SubtreeStreams.from(SimOneDoFJointBasics.class, (Collection)rootBody.getChildrenJoints()).collect(Collectors.toList());
    }

    public static List<SimJointBasics> nextJointTree(Random random, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextJointTree(random, "", numberOfJoints);
    }

    public static List<SimJointBasics> nextJointTree(Random random, String prefix, int numberOfJoints) {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        SimRigidBody rootBody = new SimRigidBody("RootBody", worldFrame, null);
        return SimMultiBodySystemRandomTools.nextJointTree(random, prefix, rootBody, numberOfJoints);
    }

    public static List<SimJointBasics> nextJointTree(Random random, SimRigidBodyBasics rootBody, int numberOfJoints) {
        return SimMultiBodySystemRandomTools.nextJointTree(random, "", rootBody, numberOfJoints);
    }

    public static List<SimJointBasics> nextJointTree(Random random, String prefix, SimRigidBodyBasics rootBody, int numberOfJoints) {
        ArrayList<SimJointBasics> joints = new ArrayList<SimJointBasics>();
        SimRigidBodyBasics predecessor = rootBody;
        for (int i = 0; i < numberOfJoints; ++i) {
            SimJointBasics joint = SimMultiBodySystemRandomTools.nextJoint(random, prefix + "SimJointBasics" + i, predecessor);
            SimMultiBodySystemRandomTools.nextRigidBody(random, prefix + "Body" + i, joint);
            joints.add(joint);
            predecessor = ((SimJointBasics)joints.get(random.nextInt(joints.size()))).getSuccessor();
        }
        return SubtreeStreams.from(SimJointBasics.class, (Collection)rootBody.getChildrenJoints()).collect(Collectors.toList());
    }

    public static List<SimRevoluteJoint> nextKinematicLoopRevoluteJoints(Random random, String prefix, SimRigidBodyBasics start, SimRigidBodyBasics end, int numberOfJoints) {
        if (!MultiBodySystemTools.isAncestor((RigidBodyReadOnly)end, (RigidBodyReadOnly)start)) {
            throw new IllegalArgumentException("Improper rigid-bodies configuration: the end must be a descendant of start. Given bodies: [start: " + start.getName() + ", end: " + end.getName() + "].");
        }
        List<SimRevoluteJoint> loopChain = SimMultiBodySystemRandomTools.nextRevoluteJointChain(random, prefix, start, numberOfJoints);
        SimRevoluteJoint loopClosureJoint = loopChain.get(numberOfJoints - 1);
        start.updateFramesRecursively();
        RigidBodyTransform transformFromSuccessorParentJoint = end.getParentJoint().getFrameAfterJoint().getTransformToDesiredFrame((ReferenceFrame)loopClosureJoint.getFrameAfterJoint());
        loopClosureJoint.setupLoopClosure(end, (RigidBodyTransformReadOnly)transformFromSuccessorParentJoint);
        return loopChain;
    }

    public static SimPrismaticJoint nextPrismaticJoint(Random random, String name, SimRigidBodyBasics predecessor) {
        Vector3D jointAxis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
        return SimMultiBodySystemRandomTools.nextPrismaticJoint(random, name, (Vector3DReadOnly)jointAxis, predecessor);
    }

    public static SimPrismaticJoint nextPrismaticJoint(Random random, String name, Vector3DReadOnly jointAxis, SimRigidBodyBasics predecessor) {
        RigidBodyTransform transformToParent = predecessor.isRootBody() ? null : EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        return new SimPrismaticJoint(name, predecessor, (RigidBodyTransformReadOnly)transformToParent, jointAxis);
    }

    public static SimRevoluteJoint nextRevoluteJoint(Random random, String name, SimRigidBodyBasics predecessor) {
        Vector3D jointAxis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
        return SimMultiBodySystemRandomTools.nextRevoluteJoint(random, name, (Vector3DReadOnly)jointAxis, predecessor);
    }

    public static SimRevoluteJoint nextRevoluteJoint(Random random, String name, Vector3DReadOnly jointAxis, SimRigidBodyBasics predecessor) {
        RigidBodyTransform transformToParent = predecessor.isRootBody() ? null : EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        return new SimRevoluteJoint(name, predecessor, (RigidBodyTransformReadOnly)transformToParent, jointAxis);
    }

    public static SimOneDoFJointBasics nextOneDoFJoint(Random random, String name, SimRigidBodyBasics predecessor) {
        if (random.nextBoolean()) {
            return SimMultiBodySystemRandomTools.nextPrismaticJoint(random, name, predecessor);
        }
        return SimMultiBodySystemRandomTools.nextRevoluteJoint(random, name, predecessor);
    }

    public static SimOneDoFJointBasics nextOneDoFJoint(Random random, String name, Vector3DReadOnly jointAxis, SimRigidBodyBasics predecessor) {
        if (random.nextBoolean()) {
            return SimMultiBodySystemRandomTools.nextPrismaticJoint(random, name, jointAxis, predecessor);
        }
        return SimMultiBodySystemRandomTools.nextRevoluteJoint(random, name, jointAxis, predecessor);
    }

    public static SimSixDoFJoint nextSixDoFJoint(Random random, String name, SimRigidBodyBasics predecessor) {
        RigidBodyTransform transformToParent = predecessor.isRootBody() ? null : EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        return new SimSixDoFJoint(name, predecessor, (RigidBodyTransformReadOnly)transformToParent);
    }

    public static SimPlanarJoint nextPlanarJoint(Random random, String name, SimRigidBodyBasics predecessor) {
        RigidBodyTransform transformToParent = predecessor.isRootBody() ? null : EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        return new SimPlanarJoint(name, predecessor, (RigidBodyTransformReadOnly)transformToParent);
    }

    public static SimSphericalJoint nextSphericalJoint(Random random, String name, SimRigidBodyBasics predecessor) {
        RigidBodyTransform transformToParent = predecessor.isRootBody() ? null : EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        return new SimSphericalJoint(name, predecessor, (RigidBodyTransformReadOnly)transformToParent);
    }

    public static SimFixedJoint nextFixedJoint(Random random, String name, SimRigidBodyBasics predecessor) {
        RigidBodyTransform transformToParent = predecessor.isRootBody() ? null : EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        return new SimFixedJoint(name, predecessor, (RigidBodyTransformReadOnly)transformToParent);
    }

    public static SimJointBasics nextJoint(Random random, String name, SimRigidBodyBasics predecessor) {
        switch (random.nextInt(6)) {
            case 0: {
                return SimMultiBodySystemRandomTools.nextSixDoFJoint(random, name, predecessor);
            }
            case 1: {
                return SimMultiBodySystemRandomTools.nextPlanarJoint(random, name, predecessor);
            }
            case 2: {
                return SimMultiBodySystemRandomTools.nextSphericalJoint(random, name, predecessor);
            }
            case 3: {
                return SimMultiBodySystemRandomTools.nextPrismaticJoint(random, name, predecessor);
            }
            case 4: {
                return SimMultiBodySystemRandomTools.nextRevoluteJoint(random, name, predecessor);
            }
        }
        return SimMultiBodySystemRandomTools.nextFixedJoint(random, name, predecessor);
    }

    public static SimRigidBody nextRigidBody(Random random, String name, SimJointBasics parentJoint) {
        Matrix3D momentOfInertia = MecanoRandomTools.nextSymmetricPositiveDefiniteMatrix3D((Random)random, (double)1.0E-4, (double)2.0, (double)0.5);
        double mass = 0.1 + random.nextDouble();
        Vector3D comOffset = EuclidCoreRandomTools.nextVector3D((Random)random);
        return new SimRigidBody(name, parentJoint, (Matrix3DReadOnly)momentOfInertia, mass, (Tuple3DReadOnly)comOffset);
    }

    public static class RandomFloatingRevoluteJointChain {
        private final SimRigidBody elevator;
        private final SimSixDoFJoint rootJoint;
        private final List<SimRevoluteJoint> revoluteJoints;
        private final List<SimJointBasics> joints = new ArrayList<SimJointBasics>();

        public RandomFloatingRevoluteJointChain(Random random, int numberOfRevoluteJoints) {
            this(random, MecanoRandomTools.nextVector3DArray((Random)random, (int)numberOfRevoluteJoints, (double)1.0));
        }

        public RandomFloatingRevoluteJointChain(Random random, Vector3D[] jointAxes) {
            this.elevator = new SimRigidBody("elevator", ReferenceFrame.getWorldFrame(), null);
            this.rootJoint = new SimSixDoFJoint("rootJoint", this.elevator, null);
            SimRigidBody rootBody = SimMultiBodySystemRandomTools.nextRigidBody(random, "rootBody", this.rootJoint);
            this.revoluteJoints = SimMultiBodySystemRandomTools.nextRevoluteJointChain(random, "test", (SimRigidBodyBasics)rootBody, (Vector3DReadOnly[])jointAxes);
            this.joints.add(this.rootJoint);
            this.joints.addAll(this.revoluteJoints);
        }

        public void nextState(Random random, SimJointStateType ... stateSelections) {
            for (SimJointStateType selection : stateSelections) {
                SimMultiBodySystemRandomTools.nextState(random, selection, this.getJoints());
            }
            this.getElevator().updateFramesRecursively();
        }

        public SimRigidBody getElevator() {
            return this.elevator;
        }

        public SimSixDoFJoint getRootJoint() {
            return this.rootJoint;
        }

        public List<SimRevoluteJoint> getRevoluteJoints() {
            return this.revoluteJoints;
        }

        public List<SimJointBasics> getJoints() {
            return this.joints;
        }

        public SimRigidBodyBasics getLeafBody() {
            int nRevoluteJoints = this.revoluteJoints.size();
            if (nRevoluteJoints > 0) {
                return this.revoluteJoints.get(nRevoluteJoints - 1).getSuccessor();
            }
            return this.rootJoint.getSuccessor();
        }
    }
}

