/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ejml.data.DMatrix;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.JointIterable;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.scs2.simulation.robot.SimJointAuxiliaryData;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;

public interface SimJointReadOnly
extends JointReadOnly {
    public boolean isPinned();

    public YoRegistry getRegistry();

    public SimRigidBodyReadOnly getPredecessor();

    public SimRigidBodyReadOnly getSuccessor();

    public TwistReadOnly getJointDeltaTwist();

    default public void getSuccessorDeltaTwist(TwistBasics successorDeltaTwistToPack) {
        successorDeltaTwistToPack.setIncludingFrame((SpatialMotionReadOnly)this.getJointDeltaTwist());
        MovingReferenceFrame predecessorFrame = this.getPredecessor().getBodyFixedFrame();
        MovingReferenceFrame successorFrame = this.getSuccessor().getBodyFixedFrame();
        successorDeltaTwistToPack.setBaseFrame((ReferenceFrame)predecessorFrame);
        successorDeltaTwistToPack.setBodyFrame((ReferenceFrame)successorFrame);
        successorDeltaTwistToPack.changeFrame((ReferenceFrame)successorFrame);
    }

    default public void getPredecessorDeltaTwist(TwistBasics predecessorDeltaTwistToPack) {
        predecessorDeltaTwistToPack.setIncludingFrame((SpatialMotionReadOnly)this.getJointDeltaTwist());
        MovingReferenceFrame predecessorFrame = this.getPredecessor().getBodyFixedFrame();
        MovingReferenceFrame successorFrame = this.getSuccessor().getBodyFixedFrame();
        predecessorDeltaTwistToPack.setBaseFrame((ReferenceFrame)predecessorFrame);
        predecessorDeltaTwistToPack.setBodyFrame((ReferenceFrame)successorFrame);
        predecessorDeltaTwistToPack.invert();
        predecessorDeltaTwistToPack.changeFrame((ReferenceFrame)predecessorFrame);
    }

    public int getJointDeltaVelocity(int var1, DMatrix var2);

    @Deprecated
    default public SimJointAuxiliaryData getAuxialiryData() {
        return this.getAuxiliaryData();
    }

    public SimJointAuxiliaryData getAuxiliaryData();

    default public Iterable<? extends SimJointReadOnly> subtreeIterable() {
        return new JointIterable(SimJointBasics.class, null, (JointReadOnly)this);
    }

    default public Stream<? extends SimJointReadOnly> subtreeStream() {
        return SubtreeStreams.from(SimJointReadOnly.class, (JointReadOnly)this);
    }

    default public List<? extends SimJointReadOnly> subtreeList() {
        return this.subtreeStream().collect(Collectors.toList());
    }

    default public SimJointReadOnly[] subtreeArray() {
        return (SimJointReadOnly[])this.subtreeStream().toArray(SimJointReadOnly[]::new);
    }
}

