/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.shapes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeTools;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.log.LogTools;

public class STPShape3DTools {
    public static double computeLargeRadiusFromMargins(double minimumMargin, double maximumMargin, double maximumEdgeLengthSquared) {
        double safeMaximumMargin = maximumMargin;
        if (EuclidCoreTools.square((double)(maximumMargin - minimumMargin)) > 0.25 * maximumEdgeLengthSquared) {
            safeMaximumMargin = 0.99 * (0.5 * EuclidCoreTools.squareRoot((double)maximumEdgeLengthSquared) + minimumMargin);
            LogTools.error((String)"Unachievable margins, modified maximumMargin from: {}, down to: {}.", (Object)maximumMargin, (Object)safeMaximumMargin);
        }
        double smallRadius = minimumMargin;
        double smallRadiusSquared = EuclidCoreTools.square((double)smallRadius);
        double maximumMarginSquared = EuclidCoreTools.square((double)safeMaximumMargin);
        double largeRadius = smallRadiusSquared - maximumMarginSquared - 0.25 * maximumEdgeLengthSquared;
        return largeRadius /= 2.0 * (smallRadius - safeMaximumMargin);
    }

    public static double computeBox3DMaximumEdgeLengthSquared(Vector3DReadOnly box3DSize) {
        return EuclidCoreTools.max((double)EuclidCoreTools.normSquared((double)box3DSize.getX(), (double)box3DSize.getY()), (double)EuclidCoreTools.normSquared((double)box3DSize.getX(), (double)box3DSize.getZ()), (double)EuclidCoreTools.normSquared((double)box3DSize.getY(), (double)box3DSize.getZ()));
    }

    public static double computeCylinder3DMaximumEdgeLengthSquared(double length, double radius) {
        double maximumEdgeLengthSquared = Math.max(length, 2.0 * radius);
        return maximumEdgeLengthSquared * maximumEdgeLengthSquared;
    }

    public static double computeConvexPolytope3DMaximumEdgeLengthSquared(ConvexPolytope3DReadOnly convexPolytope3D) {
        double maximumEdgeLengthSquared = 0.0;
        for (int faceIndex = 0; faceIndex < convexPolytope3D.getNumberOfFaces(); ++faceIndex) {
            Face3DReadOnly face = convexPolytope3D.getFace(faceIndex);
            Vertex3DReadOnly firstVertex = face.getVertex(0);
            for (int vertexIndex = 1; vertexIndex < face.getNumberOfEdges(); ++vertexIndex) {
                maximumEdgeLengthSquared = Math.max(firstVertex.distanceSquared((Point3DReadOnly)face.getVertex(vertexIndex)), maximumEdgeLengthSquared);
            }
        }
        return maximumEdgeLengthSquared;
    }

    public static double computeRamp3DMaximumEdgeLengthSquared(Vector3DReadOnly ramp3DSize) {
        double rampLengthSquared = EuclidCoreTools.normSquared((double)ramp3DSize.getX(), (double)ramp3DSize.getZ());
        return EuclidCoreTools.max((double)EuclidCoreTools.normSquared((double)ramp3DSize.getX(), (double)ramp3DSize.getY()), (double)EuclidCoreTools.normSquared((double)ramp3DSize.getY(), (double)ramp3DSize.getZ()), (double)(rampLengthSquared + EuclidCoreTools.square((double)ramp3DSize.getY())));
    }

    public static boolean arePoint3DsSameSideOfPlane3D(Point3DReadOnly firstQuery, Point3DReadOnly secondQuery, Point3DReadOnly firstPointOnPlane, Point3DReadOnly secondPointOnPlane, Vector3DReadOnly planeTangent) {
        double firstQueryX = firstQuery.getX();
        double firstQueryY = firstQuery.getY();
        double firstQueryZ = firstQuery.getZ();
        double secondQueryX = secondQuery.getX();
        double secondQueryY = secondQuery.getY();
        double secondQueryZ = secondQuery.getZ();
        double firstPointOnPlaneX = firstPointOnPlane.getX();
        double firstPointOnPlaneY = firstPointOnPlane.getY();
        double firstPointOnPlaneZ = firstPointOnPlane.getZ();
        double planeFirstTangentX = planeTangent.getX();
        double planeFirstTangentY = planeTangent.getY();
        double planeFirstTangentZ = planeTangent.getZ();
        double planeSecondTangentX = firstPointOnPlane.getX() - secondPointOnPlane.getX();
        double planeSecondTangentY = firstPointOnPlane.getY() - secondPointOnPlane.getY();
        double planeSecondTangentZ = firstPointOnPlane.getZ() - secondPointOnPlane.getZ();
        return STPShape3DTools.arePoint3DsSameSideOfPlane3D(firstQueryX, firstQueryY, firstQueryZ, secondQueryX, secondQueryY, secondQueryZ, firstPointOnPlaneX, firstPointOnPlaneY, firstPointOnPlaneZ, planeFirstTangentX, planeFirstTangentY, planeFirstTangentZ, planeSecondTangentX, planeSecondTangentY, planeSecondTangentZ);
    }

    public static boolean arePoint3DsSameSideOfPlane3D(double firstQueryX, double firstQueryY, double firstQueryZ, double secondQueryX, double secondQueryY, double secondQueryZ, double pointOnPlaneX, double pointOnPlaneY, double pointOnPlaneZ, double planeFirstTangentX, double planeFirstTangentY, double planeFirstTangentZ, double planeSecondTangentX, double planeSecondTangentY, double planeSecondTangentZ) {
        boolean isSecondQueryAbovePlane;
        double planeNormalX = planeFirstTangentY * planeSecondTangentZ - planeFirstTangentZ * planeSecondTangentY;
        double planeNormalY = planeFirstTangentZ * planeSecondTangentX - planeFirstTangentX * planeSecondTangentZ;
        double planeNormalZ = planeFirstTangentX * planeSecondTangentY - planeFirstTangentY * planeSecondTangentX;
        boolean isFirstQueryAbovePlane = EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)firstQueryX, (double)firstQueryY, (double)firstQueryZ, (double)pointOnPlaneX, (double)pointOnPlaneY, (double)pointOnPlaneZ, (double)planeNormalX, (double)planeNormalY, (double)planeNormalZ, (boolean)true);
        return isFirstQueryAbovePlane == (isSecondQueryAbovePlane = EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)secondQueryX, (double)secondQueryY, (double)secondQueryZ, (double)pointOnPlaneX, (double)pointOnPlaneY, (double)pointOnPlaneZ, (double)planeNormalX, (double)planeNormalY, (double)planeNormalZ, (boolean)true));
    }

    public static FrameBoundingBox3DReadOnly newLinkedFrameBoundingBox3DReadOnly(final ReferenceFrameHolder referenceFrameHolder, final Point3DReadOnly minPoint, final Point3DReadOnly maxPoint) {
        final FramePoint3DReadOnly linkedMinPoint = EuclidFrameFactories.newLinkedFramePoint3DReadOnly((ReferenceFrameHolder)referenceFrameHolder, (Point3DReadOnly)minPoint);
        final FramePoint3DReadOnly linkedMaxPoint = EuclidFrameFactories.newLinkedFramePoint3DReadOnly((ReferenceFrameHolder)referenceFrameHolder, (Point3DReadOnly)maxPoint);
        return new FrameBoundingBox3DReadOnly(){

            public FramePoint3DReadOnly getMinPoint() {
                return linkedMinPoint;
            }

            public FramePoint3DReadOnly getMaxPoint() {
                return linkedMaxPoint;
            }

            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public boolean equals(Object object) {
                if (object instanceof FrameBoundingBox3DReadOnly) {
                    return this.equals((EuclidFrameGeometry)((FrameBoundingBox3DReadOnly)object));
                }
                return false;
            }

            public String toString() {
                return EuclidFrameIOTools.getFrameBoundingBox3DString((FrameBoundingBox3DReadOnly)this);
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)minPoint, (Object)maxPoint);
            }
        };
    }

    public static class STPRamp3DSupportingVertexCalculator {
        private final UnitVector3D supportDirectionLocal = new UnitVector3D();
        private final Point3D faceSphereCenter = new Point3D();
        private final Point3D closestVertexCenter = new Point3D();
        private final Vector3D limitPlaneNormal = new Vector3D();
        private final Vector3D toFaceCentroid = new Vector3D();
        private final Point3D closestFaceEdgeCenter0 = new Point3D();
        private final Point3D closestFaceEdgeCenter1 = new Point3D();
        private final Point3D closestFaceEdgeCenter2 = new Point3D();
        private final Point3D[] closestFaceEdgeCenters = new Point3D[]{this.closestFaceEdgeCenter0, this.closestFaceEdgeCenter1, this.closestFaceEdgeCenter2};
        private final Vector3D closestFaceEdgeAxis0 = new Vector3D();
        private final Vector3D closestFaceEdgeAxis1 = new Vector3D();
        private final Vector3D closestFaceEdgeAxis2 = new Vector3D();
        private final Vector3D[] closestFaceEdgeAxes = new Vector3D[]{this.closestFaceEdgeAxis0, this.closestFaceEdgeAxis1, this.closestFaceEdgeAxis2};
        private final double[] closestFaceEdgeLengths = new double[]{0.0, 0.0, 0.0};

        public boolean getSupportingVertex(Ramp3DReadOnly ramp3D, double smallRadius, double largeRadius, Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
            Face firstClosestFace;
            if (ramp3D.getPose().hasRotation()) {
                ramp3D.getPose().inverseTransform(supportDirection, (Vector3DBasics)this.supportDirectionLocal);
            } else {
                this.supportDirectionLocal.set((Tuple3DReadOnly)supportDirection);
            }
            supportDirection = this.supportDirectionLocal;
            Vector3DReadOnly rampSurfaceNormal = ramp3D.getRampSurfaceNormal();
            Vector3DReadOnly size = ramp3D.getSize();
            double rampDot = supportDirection.dot((Tuple3DReadOnly)rampSurfaceNormal);
            double faceXPlusDot = supportDirection.getX();
            double faceYPlusDot = supportDirection.getY();
            double faceZPlusDot = supportDirection.getZ();
            double faceYAbsDot = Math.abs(faceYPlusDot);
            boolean isFaceYMaxCloser = faceYPlusDot > 0.0;
            this.faceSphereCenter.setToZero();
            if (EuclidShapeTools.isFirstValueMaximum((double)faceXPlusDot, (double)faceYAbsDot, (double)(-faceZPlusDot), (double)rampDot)) {
                firstClosestFace = Face.X_MAX;
                sphereOffset = this.sphereOffset(ramp3D, smallRadius, largeRadius, firstClosestFace);
                this.faceSphereCenter.setX(size.getX() - sphereOffset);
                this.faceSphereCenter.setZ(0.5 * size.getZ());
                this.closestFaceEdgeLengths[0] = size.getZ();
                this.closestFaceEdgeLengths[1] = size.getY();
                this.closestFaceEdgeLengths[2] = size.getY();
                this.closestFaceEdgeAxis0.set((Tuple3DReadOnly)Axis3D.Z);
                this.closestFaceEdgeAxis1.set((Tuple3DReadOnly)Axis3D.Y);
                this.closestFaceEdgeAxis2.set((Tuple3DReadOnly)Axis3D.Y);
                this.closestFaceEdgeCenter0.set(size.getX(), isFaceYMaxCloser ? 0.5 * size.getY() : -0.5 * size.getY(), 0.5 * size.getZ());
                this.closestFaceEdgeCenter1.set(size.getX(), 0.0, 0.0);
                this.closestFaceEdgeCenter2.set(size.getX(), 0.0, size.getZ());
            } else if (EuclidShapeTools.isFirstValueMaximum((double)faceYAbsDot, (double)(-faceZPlusDot), (double)rampDot)) {
                firstClosestFace = isFaceYMaxCloser ? Face.Y_MAX : Face.Y_MIN;
                sphereOffset = this.sphereOffset(ramp3D, smallRadius, largeRadius, firstClosestFace);
                this.faceSphereCenter.setX(0.5 * size.getX());
                this.faceSphereCenter.setY(isFaceYMaxCloser ? 0.5 * size.getY() - sphereOffset : -0.5 * size.getY() + sphereOffset);
                this.faceSphereCenter.setZ(0.5 * size.getZ());
                this.closestFaceEdgeLengths[0] = size.getZ();
                this.closestFaceEdgeLengths[1] = size.getX();
                this.closestFaceEdgeLengths[2] = ramp3D.getRampLength();
                this.closestFaceEdgeAxis0.set((Tuple3DReadOnly)Axis3D.Z);
                this.closestFaceEdgeAxis1.set((Tuple3DReadOnly)Axis3D.X);
                this.closestFaceEdgeAxis2.set(rampSurfaceNormal.getZ(), 0.0, -rampSurfaceNormal.getX());
                this.closestFaceEdgeCenter0.set(size.getX(), isFaceYMaxCloser ? 0.5 * size.getY() : -0.5 * size.getY(), 0.5 * size.getZ());
                this.closestFaceEdgeCenter1.set(0.5 * size.getX(), isFaceYMaxCloser ? 0.5 * size.getY() : -0.5 * size.getY(), 0.0);
                this.closestFaceEdgeCenter2.set(0.5 * size.getX(), isFaceYMaxCloser ? 0.5 * size.getY() : -0.5 * size.getY(), 0.5 * size.getZ());
            } else if (-faceZPlusDot > rampDot) {
                firstClosestFace = Face.Z_MIN;
                sphereOffset = this.sphereOffset(ramp3D, smallRadius, largeRadius, firstClosestFace);
                this.faceSphereCenter.setX(0.5 * size.getX());
                this.faceSphereCenter.setZ(sphereOffset);
                this.closestFaceEdgeLengths[0] = size.getY();
                this.closestFaceEdgeLengths[1] = size.getX();
                this.closestFaceEdgeLengths[2] = size.getY();
                this.closestFaceEdgeAxis0.set((Tuple3DReadOnly)Axis3D.Y);
                this.closestFaceEdgeAxis1.set((Tuple3DReadOnly)Axis3D.X);
                this.closestFaceEdgeAxis2.set((Tuple3DReadOnly)Axis3D.Y);
                this.closestFaceEdgeCenter0.set(size.getX(), 0.0, 0.0);
                this.closestFaceEdgeCenter1.set(0.5 * size.getX(), isFaceYMaxCloser ? 0.5 * size.getY() : -0.5 * size.getY(), 0.0);
                this.closestFaceEdgeCenter2.set(0.0, 0.0, 0.0);
            } else {
                firstClosestFace = Face.RAMP;
                sphereOffset = this.sphereOffset(ramp3D, smallRadius, largeRadius, firstClosestFace);
                this.faceSphereCenter.setX(0.5 * size.getX());
                this.faceSphereCenter.setZ(0.5 * size.getZ());
                this.faceSphereCenter.scaleAdd(-sphereOffset, (Tuple3DReadOnly)rampSurfaceNormal, (Tuple3DReadOnly)this.faceSphereCenter);
                this.closestFaceEdgeLengths[0] = size.getY();
                this.closestFaceEdgeLengths[1] = ramp3D.getRampLength();
                this.closestFaceEdgeLengths[2] = size.getY();
                this.closestFaceEdgeAxis0.set((Tuple3DReadOnly)Axis3D.Y);
                this.closestFaceEdgeAxis1.set(rampSurfaceNormal.getZ(), 0.0, -rampSurfaceNormal.getX());
                this.closestFaceEdgeAxis2.set((Tuple3DReadOnly)Axis3D.Y);
                this.closestFaceEdgeCenter0.set(size.getX(), 0.0, size.getZ());
                this.closestFaceEdgeCenter1.set(0.5 * size.getX(), isFaceYMaxCloser ? 0.5 * size.getY() : -0.5 * size.getY(), 0.5 * size.getZ());
                this.closestFaceEdgeCenter2.set(0.0, 0.0, 0.0);
            }
            double limitScaleFactor = 0.5 * largeRadius / (largeRadius - smallRadius);
            firstClosestFace.getFaceCentroid(ramp3D, (Tuple3DBasics)this.toFaceCentroid);
            this.toFaceCentroid.sub((Tuple3DReadOnly)this.faceSphereCenter);
            int isOutsideCounter = 0;
            boolean isWithinFace = true;
            boolean hasComputedSupportingVertex = false;
            for (int edgeIndex = 0; edgeIndex < 3; ++edgeIndex) {
                Point3D edgeCenter = this.closestFaceEdgeCenters[edgeIndex];
                Vector3D edgeAxis = this.closestFaceEdgeAxes[edgeIndex];
                double edgeLength = this.closestFaceEdgeLengths[edgeIndex];
                this.limitPlaneNormal.sub((Tuple3DReadOnly)edgeCenter, (Tuple3DReadOnly)this.faceSphereCenter);
                this.limitPlaneNormal.cross((Tuple3DReadOnly)edgeAxis);
                if (!(this.toFaceCentroid.dot((Tuple3DReadOnly)this.limitPlaneNormal) * supportDirection.dot((Tuple3DReadOnly)this.limitPlaneNormal) < 0.0)) continue;
                ++isOutsideCounter;
                isWithinFace = false;
                double torusRadius = EuclidGeometryTools.triangleIsoscelesHeight((double)(largeRadius - smallRadius), (double)edgeLength);
                EuclidShapeTools.innerSupportingVertexTorus3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)edgeCenter, (Vector3DReadOnly)edgeAxis, (double)torusRadius, (double)largeRadius, (Point3DBasics)supportingVertexToPack);
                if (Math.abs(EuclidGeometryTools.percentageAlongLine3D((Point3DReadOnly)supportingVertexToPack, (Point3DReadOnly)edgeCenter, (Vector3DReadOnly)edgeAxis)) <= edgeLength * limitScaleFactor) {
                    hasComputedSupportingVertex = true;
                    break;
                }
                if (isOutsideCounter < 2) continue;
                EuclidShapeTools.supportingVectexRamp3D((Vector3DReadOnly)supportDirection, (Vector3DReadOnly)size, (Point3DBasics)this.closestVertexCenter);
                EuclidShapeTools.supportingVertexSphere3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)this.closestVertexCenter, (double)smallRadius, (Point3DBasics)supportingVertexToPack);
                hasComputedSupportingVertex = true;
                break;
            }
            if (!hasComputedSupportingVertex) {
                if (isWithinFace) {
                    EuclidShapeTools.supportingVertexSphere3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)this.faceSphereCenter, (double)largeRadius, (Point3DBasics)supportingVertexToPack);
                } else {
                    EuclidShapeTools.supportingVectexRamp3D((Vector3DReadOnly)supportDirection, (Vector3DReadOnly)size, (Point3DBasics)this.closestVertexCenter);
                    EuclidShapeTools.supportingVertexSphere3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)this.closestVertexCenter, (double)smallRadius, (Point3DBasics)supportingVertexToPack);
                }
            }
            ramp3D.transformToWorld((Transformable)supportingVertexToPack);
            return true;
        }

        private double sphereOffset(Ramp3DReadOnly ramp3D, double smallRadius, double largeRadius, Face face) {
            double diagonalSquared = switch (face) {
                case Face.RAMP -> {
                    double a = ramp3D.getRampLength();
                    double b = ramp3D.getSizeY();
                    yield a * a + b * b;
                }
                case Face.X_MAX -> {
                    double a = ramp3D.getSizeY();
                    double b = ramp3D.getSizeZ();
                    yield a * a + b * b;
                }
                case Face.Y_MAX, Face.Y_MIN -> ramp3D.getRampLength() * ramp3D.getRampLength();
                case Face.Z_MIN -> {
                    double a = ramp3D.getSizeX();
                    double b = ramp3D.getSizeY();
                    yield a * a + b * b;
                }
                default -> throw new IllegalStateException();
            };
            double radius = largeRadius - smallRadius;
            return Math.sqrt(radius * radius - 0.25 * diagonalSquared);
        }

        private static enum Face {
            RAMP((shape3D, centroid) -> centroid.set(0.5 * shape3D.getSizeX(), 0.0, 0.5 * shape3D.getSizeZ())),
            X_MAX((shape3D, centroid) -> centroid.set(shape3D.getSizeX(), 0.0, 0.5 * shape3D.getSizeZ())),
            Y_MIN((shape3D, centroid) -> centroid.set(shape3D.getCentroid().getX(), -0.5 * shape3D.getSizeY(), shape3D.getCentroid().getZ())),
            Y_MAX((shape3D, centroid) -> centroid.set(shape3D.getCentroid().getX(), 0.5 * shape3D.getSizeY(), shape3D.getCentroid().getZ())),
            Z_MIN((shape3D, centroid) -> centroid.set(0.5 * shape3D.getSizeX(), 0.0, 0.0));

            private final BiConsumer<Ramp3DReadOnly, Tuple3DBasics> faceCentroidCalculator;

            private Face(BiConsumer<Ramp3DReadOnly, Tuple3DBasics> faceCentroidCalculator) {
                this.faceCentroidCalculator = faceCentroidCalculator;
            }

            public void getFaceCentroid(Ramp3DReadOnly shape3D, Tuple3DBasics faceCentroid) {
                this.faceCentroidCalculator.accept(shape3D, faceCentroid);
            }
        }
    }

    public static class STPConvexPolytope3DSupportingVertexCalculator {
        private final Point3D faceSphereCenter = new Point3D();
        private final Point3D edgeTorusCenter = new Point3D();
        private final Vector3D edgeTorusAxis = new Vector3D();

        public boolean getSupportingVertex(ConvexPolytope3DReadOnly convexPolytope3D, double smallRadius, double largeRadius, Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
            Vertex3DReadOnly bestVertex = convexPolytope3D.getSupportingVertex(supportDirection);
            if (bestVertex == null) {
                return false;
            }
            List<STPFace3D> bestSTPFaces = this.findBestFace(supportDirection, bestVertex);
            if (this.getFaceSupportingVertex(supportDirection, bestSTPFaces, bestVertex, smallRadius, largeRadius, supportingVertexToPack)) {
                return true;
            }
            if (this.getBestEdgeSupportingVertex(supportDirection, bestSTPFaces, bestVertex, smallRadius, largeRadius, supportingVertexToPack)) {
                return true;
            }
            EuclidShapeTools.supportingVertexSphere3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)bestVertex, (double)smallRadius, (Point3DBasics)supportingVertexToPack);
            return true;
        }

        private List<STPFace3D> findBestFace(Vector3DReadOnly supportDirection, Vertex3DReadOnly bestVertex) {
            Face3DReadOnly bestFace = bestVertex.getAssociatedEdge(0).getFace();
            double bestFaceDot = bestFace.getNormal().dot((Tuple3DReadOnly)supportDirection);
            for (int i = 1; i < bestVertex.getNumberOfAssociatedEdges(); ++i) {
                HalfEdge3DReadOnly candidateEdge = bestVertex.getAssociatedEdge(i);
                Face3DReadOnly candidateFace = candidateEdge.getFace();
                double candidateDot = candidateFace.getNormal().dot((Tuple3DReadOnly)supportDirection);
                if (!(candidateDot > bestFaceDot)) continue;
                bestFaceDot = candidateDot;
                bestFace = candidateFace;
            }
            return STPFace3D.newSTPFace3Ds(bestFace);
        }

        private boolean getFaceSupportingVertex(Vector3DReadOnly supportDirection, List<STPFace3D> bestFaces, Vertex3DReadOnly bestVertex, double smallRadius, double largeRadius, Point3DBasics supportingVertexToPack) {
            for (STPFace3D stpFace : bestFaces) {
                if (!stpFace.contains(bestVertex) || !this.getTriangleSupportingVertex(supportDirection, stpFace, smallRadius, largeRadius, supportingVertexToPack)) continue;
                return true;
            }
            return false;
        }

        private boolean getTriangleSupportingVertex(Vector3DReadOnly supportDirection, STPFace3D face, double smallRadius, double largeRadius, Point3DBasics supportingVertexToPack) {
            EuclidGeometryTools.sphere3DPositionFromThreePoints((Point3DReadOnly)face.v0, (Point3DReadOnly)face.v1, (Point3DReadOnly)face.v2, (double)(largeRadius - smallRadius), (Point3DBasics)this.faceSphereCenter);
            EuclidShapeTools.supportingVertexSphere3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)this.faceSphereCenter, (double)largeRadius, (Point3DBasics)supportingVertexToPack);
            return face.isPointDirectlyAboveOrBelow((Point3DReadOnly)supportingVertexToPack);
        }

        private boolean getBestEdgeSupportingVertex(Vector3DReadOnly supportDirection, List<STPFace3D> bestFaces, Vertex3DReadOnly bestVertex, double smallRadius, double largeRadius, Point3DBasics supportingVertexToPack) {
            STPHalfEdge3D bestEdge = null;
            double bestEdgeDot = Double.NEGATIVE_INFINITY;
            for (STPFace3D face : bestFaces) {
                if (!face.contains(bestVertex)) continue;
                for (STPHalfEdge3D edge : face.getEdges()) {
                    double candidateDot;
                    if (!edge.contains(bestVertex) || !((candidateDot = TupleTools.dot((Tuple3DReadOnly)edge.midpoint(), (Tuple3DReadOnly)supportDirection)) > bestEdgeDot)) continue;
                    bestEdgeDot = candidateDot;
                    bestEdge = edge;
                }
            }
            return this.getEdgeSupportingVertex(supportDirection, bestEdge, smallRadius, largeRadius, supportingVertexToPack);
        }

        private boolean getEdgeSupportingVertex(Vector3DReadOnly supportDirection, STPHalfEdge3D edge, double smallRadius, double largeRadius, Point3DBasics supportingVertexToPack) {
            this.edgeTorusCenter.add((Tuple3DReadOnly)edge.getFirstEndpoint(), (Tuple3DReadOnly)edge.getSecondEndpoint());
            this.edgeTorusCenter.scale(0.5);
            this.edgeTorusAxis.sub((Tuple3DReadOnly)edge.getSecondEndpoint(), (Tuple3DReadOnly)edge.getFirstEndpoint());
            double radius = largeRadius - smallRadius;
            double torusRadius = Math.sqrt(radius * radius - 0.25 * this.edgeTorusAxis.normSquared());
            double torusTubeRadius = largeRadius;
            EuclidShapeTools.innerSupportingVertexTorus3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)this.edgeTorusCenter, (Vector3DReadOnly)this.edgeTorusAxis, (double)torusRadius, (double)torusTubeRadius, (Point3DBasics)supportingVertexToPack);
            if (!edge.isBetweenEndpoints((Point3DReadOnly)supportingVertexToPack)) {
                return false;
            }
            if (edge.face.isPointDirectlyAboveOrBelow((Point3DReadOnly)supportingVertexToPack)) {
                return false;
            }
            return edge.twin == null || !edge.twin.face.isPointDirectlyAboveOrBelow((Point3DReadOnly)supportingVertexToPack);
        }

        private static class STPFace3D {
            private final Face3DReadOnly owner;
            private final Vertex3DReadOnly v0;
            private final Vertex3DReadOnly v1;
            private final Vertex3DReadOnly v2;
            private final STPHalfEdge3D e0;
            private final STPHalfEdge3D e1;
            private final STPHalfEdge3D e2;
            private final List<STPHalfEdge3D> edges;

            public static List<STPFace3D> newSTPFace3Ds(Face3DReadOnly owner) {
                ArrayList<STPFace3D> faces = new ArrayList<STPFace3D>();
                STPFace3D previousFace = new STPFace3D(owner, owner.getVertex(0), owner.getVertex(1), owner.getVertex(2));
                faces.add(previousFace);
                for (int i = 1; i < owner.getNumberOfEdges() - 2; ++i) {
                    Vertex3DReadOnly v0 = owner.getVertex(0);
                    Vertex3DReadOnly v1 = owner.getVertex(i + 1);
                    Vertex3DReadOnly v2 = owner.getVertex(i + 2);
                    STPFace3D currentFace = new STPFace3D(owner, v0, v1, v2);
                    currentFace.e0.twin = previousFace.e2;
                    previousFace.e2.twin = currentFace.e0;
                    faces.add(currentFace);
                }
                return faces;
            }

            public STPFace3D(Face3DReadOnly face3D, Vertex3DReadOnly v0, Vertex3DReadOnly v1, Vertex3DReadOnly v2) {
                this.owner = face3D;
                this.v0 = v0;
                this.v1 = v1;
                this.v2 = v2;
                this.e0 = new STPHalfEdge3D(v0, v1);
                this.e1 = new STPHalfEdge3D(v1, v2);
                this.e2 = new STPHalfEdge3D(v2, v0);
                this.e0.face = this;
                this.e1.face = this;
                this.e2.face = this;
                this.edges = Arrays.asList(this.e0, this.e1, this.e2);
            }

            public boolean contains(Vertex3DReadOnly query) {
                return this.v0 == query || this.v1 == query || this.v2 == query;
            }

            public boolean isPointDirectlyAboveOrBelow(Point3DReadOnly query) {
                if (this.canObserverSeeEdge(query, this.e0)) {
                    return false;
                }
                if (this.canObserverSeeEdge(query, this.e1)) {
                    return false;
                }
                return !this.canObserverSeeEdge(query, this.e2);
            }

            public boolean canObserverSeeEdge(Point3DReadOnly observer, LineSegment3DReadOnly edge) {
                return EuclidPolytopeTools.isPoint3DOnLeftSideOfLine3D((Point3DReadOnly)observer, (Point3DReadOnly)edge.getFirstEndpoint(), (Point3DReadOnly)edge.getSecondEndpoint(), (Vector3DReadOnly)this.owner.getNormal());
            }

            public List<STPHalfEdge3D> getEdges() {
                return this.edges;
            }
        }

        private static class STPHalfEdge3D
        implements LineSegment3DReadOnly {
            private Vertex3DReadOnly origin;
            private Vertex3DReadOnly destination;
            private STPFace3D face;
            private STPHalfEdge3D twin;

            public STPHalfEdge3D(Vertex3DReadOnly origin, Vertex3DReadOnly destination) {
                this.origin = origin;
                this.destination = destination;
            }

            public boolean contains(Vertex3DReadOnly query) {
                return this.origin == query || this.destination == query;
            }

            public Vertex3DReadOnly getFirstEndpoint() {
                return this.origin;
            }

            public Vertex3DReadOnly getSecondEndpoint() {
                return this.destination;
            }
        }
    }

    public static class STPCylinder3DSupportingVertexCalculator {
        private final Vector3D orthogonalToAxis = new Vector3D();
        private final Point3D sideSphereCenter = new Point3D();
        private final Point3D edgeSphereCenter = new Point3D();
        private final Point3D capSphereCenter = new Point3D();
        private final Point3D validationPoint = new Point3D();

        public boolean getSupportingVertex(Cylinder3DReadOnly cylinder3D, double smallRadius, double largeRadius, Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
            double cylinderRadius = cylinder3D.getRadius();
            double cylinderHalfLength = cylinder3D.getHalfLength();
            UnitVector3DReadOnly cylinderAxis = cylinder3D.getAxis();
            Point3DReadOnly cylinderPosition = cylinder3D.getPosition();
            this.orthogonalToAxis.set((Tuple3DReadOnly)supportDirection);
            double dot = supportDirection.dot((Tuple3DReadOnly)cylinderAxis);
            double sign = dot > 0.0 ? 1.0 : -1.0;
            this.orthogonalToAxis.setAndScale(dot, (Tuple3DReadOnly)cylinderAxis);
            this.orthogonalToAxis.sub((Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)this.orthogonalToAxis);
            double distanceSquaredFromAxis = this.orthogonalToAxis.normSquared();
            if (distanceSquaredFromAxis < 1.0E-12) {
                this.sideSphereCenter.setToNaN();
                this.edgeSphereCenter.setToNaN();
            } else {
                this.orthogonalToAxis.scale(1.0 / EuclidCoreTools.squareRoot((double)distanceSquaredFromAxis));
                double sideSphereRadius = EuclidGeometryTools.triangleIsoscelesHeight((double)(largeRadius - smallRadius), (double)cylinder3D.getLength());
                this.sideSphereCenter.setAndScale(cylinderRadius - sideSphereRadius, (Tuple3DReadOnly)this.orthogonalToAxis);
                this.edgeSphereCenter.setAndScale(cylinderRadius, (Tuple3DReadOnly)this.orthogonalToAxis);
                this.edgeSphereCenter.scaleAdd(sign * cylinderHalfLength, (Tuple3DReadOnly)cylinderAxis, (Tuple3DReadOnly)this.edgeSphereCenter);
            }
            double capSphereRadius = EuclidGeometryTools.triangleIsoscelesHeight((double)(largeRadius - smallRadius), (double)(2.0 * cylinderRadius));
            this.capSphereCenter.setAndScale(sign * (cylinderHalfLength - capSphereRadius), (Tuple3DReadOnly)cylinderAxis);
            if (!this.getSideSupportingVertex(cylinder3D, largeRadius, supportDirection, supportingVertexToPack) && !this.getCapSupportingVertex(cylinder3D, largeRadius, supportDirection, supportingVertexToPack)) {
                EuclidShapeTools.supportingVertexSphere3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)this.edgeSphereCenter, (double)smallRadius, (Point3DBasics)supportingVertexToPack);
            }
            supportingVertexToPack.add((Tuple3DReadOnly)cylinderPosition);
            return true;
        }

        private boolean getSideSupportingVertex(Cylinder3DReadOnly cylinder3D, double largeRadius, Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
            if (this.sideSphereCenter.containsNaN()) {
                return false;
            }
            EuclidShapeTools.supportingVertexSphere3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)this.sideSphereCenter, (double)largeRadius, (Point3DBasics)supportingVertexToPack);
            double dot = TupleTools.dot((Tuple3DReadOnly)supportingVertexToPack, (Tuple3DReadOnly)cylinder3D.getAxis());
            return dot <= cylinder3D.getHalfLength() && dot >= -cylinder3D.getHalfLength();
        }

        private boolean getCapSupportingVertex(Cylinder3DReadOnly cylinder3D, double largeRadius, Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
            EuclidShapeTools.supportingVertexSphere3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)this.capSphereCenter, (double)largeRadius, (Point3DBasics)supportingVertexToPack);
            double dot = TupleTools.dot((Tuple3DReadOnly)supportingVertexToPack, (Tuple3DReadOnly)cylinder3D.getAxis());
            this.validationPoint.setAndScale(dot, (Tuple3DReadOnly)cylinder3D.getAxis());
            this.validationPoint.sub((Tuple3DReadOnly)supportingVertexToPack, (Tuple3DReadOnly)this.validationPoint);
            return this.validationPoint.distanceFromOriginSquared() <= cylinder3D.getRadius() * cylinder3D.getRadius();
        }
    }

    public static class STPCapsule3DSupportingVertexCalculator {
        private final Vector3D orthogonalToAxis = new Vector3D();
        private final Point3D sideSphereCenter = new Point3D();
        private final Point3D edgeSphereCenter = new Point3D();

        public boolean getSupportingVertex(Capsule3DReadOnly capsule3D, double smallRadius, double largeRadius, Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
            double capsuleHalfLength = capsule3D.getHalfLength();
            UnitVector3DReadOnly capsuleAxis = capsule3D.getAxis();
            Point3DReadOnly capsulePosition = capsule3D.getPosition();
            this.orthogonalToAxis.set((Tuple3DReadOnly)supportDirection);
            double dot = supportDirection.dot((Tuple3DReadOnly)capsuleAxis);
            double sign = dot > 0.0 ? 1.0 : -1.0;
            this.orthogonalToAxis.setAndScale(dot, (Tuple3DReadOnly)capsuleAxis);
            this.orthogonalToAxis.sub((Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)this.orthogonalToAxis);
            this.edgeSphereCenter.setAndScale(sign * capsuleHalfLength, (Tuple3DReadOnly)capsuleAxis);
            double distanceSquaredFromAxis = this.orthogonalToAxis.normSquared();
            if (distanceSquaredFromAxis < 1.0E-12) {
                this.sideSphereCenter.setToNaN();
                this.edgeSphereCenter.setToNaN();
            } else {
                this.orthogonalToAxis.scale(1.0 / EuclidCoreTools.squareRoot((double)distanceSquaredFromAxis));
                double sideSphereRadius = EuclidGeometryTools.triangleIsoscelesHeight((double)(largeRadius - smallRadius), (double)capsule3D.getLength());
                this.sideSphereCenter.setAndScale(-sideSphereRadius, (Tuple3DReadOnly)this.orthogonalToAxis);
            }
            if (!this.getSideSupportingVertex(capsule3D, smallRadius, largeRadius, supportDirection, supportingVertexToPack)) {
                EuclidShapeTools.supportingVertexSphere3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)this.edgeSphereCenter, (double)smallRadius, (Point3DBasics)supportingVertexToPack);
            }
            supportingVertexToPack.add((Tuple3DReadOnly)capsulePosition);
            return true;
        }

        private boolean getSideSupportingVertex(Capsule3DReadOnly capsule3D, double smallRadius, double largeRadius, Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
            if (this.sideSphereCenter.containsNaN()) {
                return false;
            }
            EuclidShapeTools.supportingVertexSphere3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)this.sideSphereCenter, (double)largeRadius, (Point3DBasics)supportingVertexToPack);
            double dotMax = capsule3D.getHalfLength() * largeRadius / (largeRadius - smallRadius);
            double dot = TupleTools.dot((Tuple3DReadOnly)supportingVertexToPack, (Tuple3DReadOnly)capsule3D.getAxis());
            return Math.abs(dot) <= Math.abs(dotMax);
        }
    }

    public static class STPBox3DSupportingVertexCalculator {
        private final Vector3D halfSize = new Vector3D();
        private final UnitVector3D supportUnitDirection = new UnitVector3D();
        private final Point3D faceSphereCenter = new Point3D();
        private final Point3D closestVertexCenter = new Point3D();
        private final Point3D faceCenter = new Point3D();
        private final Point3D edgeCenter = new Point3D();

        public boolean getSupportingVertex(Box3DReadOnly box3D, double smallRadius, double largeRadius, Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
            boolean isMaxFace;
            Axis3D firstClosestFace;
            boolean isFaceZMaxCloser;
            if (box3D.getPose().hasRotation()) {
                box3D.getPose().inverseTransform(supportDirection, (Vector3DBasics)this.supportUnitDirection);
            } else {
                this.supportUnitDirection.set((Tuple3DReadOnly)supportDirection);
            }
            supportDirection = this.supportUnitDirection;
            this.halfSize.setAndScale(0.5, (Tuple3DReadOnly)box3D.getSize());
            double faceXPlusDot = supportDirection.getX();
            double faceYPlusDot = supportDirection.getY();
            double faceZPlusDot = supportDirection.getZ();
            double faceXAbsDot = Math.abs(faceXPlusDot);
            double faceYAbsDot = Math.abs(faceYPlusDot);
            double faceZAbsDot = Math.abs(faceZPlusDot);
            boolean isFaceXMaxCloser = faceXPlusDot > 0.0;
            boolean isFaceYMaxCloser = faceYPlusDot > 0.0;
            boolean bl = isFaceZMaxCloser = faceZPlusDot > 0.0;
            if (faceXAbsDot > faceYAbsDot) {
                if (faceXAbsDot > faceZAbsDot) {
                    firstClosestFace = Axis3D.X;
                    isMaxFace = isFaceXMaxCloser;
                } else {
                    firstClosestFace = Axis3D.Z;
                    isMaxFace = isFaceZMaxCloser;
                }
            } else if (faceYAbsDot > faceZAbsDot) {
                firstClosestFace = Axis3D.Y;
                isMaxFace = isFaceYMaxCloser;
            } else {
                firstClosestFace = Axis3D.Z;
                isMaxFace = isFaceZMaxCloser;
            }
            double faceSphereOffset = STPBox3DSupportingVertexCalculator.getFaceSphereOffset(firstClosestFace, (Vector3DReadOnly)this.halfSize, smallRadius, largeRadius);
            this.faceCenter.setToZero();
            this.faceSphereCenter.setToZero();
            this.faceCenter.setElement(firstClosestFace, this.halfSize.getElement(firstClosestFace));
            this.faceSphereCenter.setElement(firstClosestFace, this.halfSize.getElement(firstClosestFace) - faceSphereOffset);
            if (!isMaxFace) {
                this.faceCenter.negate();
                this.faceSphereCenter.negate();
            }
            EuclidShapeTools.supportingVertexSphere3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)this.faceSphereCenter, (double)largeRadius, (Point3DBasics)supportingVertexToPack);
            if (!STPBox3DSupportingVertexCalculator.isFaceSphereSupportingVertexValid((Point3DReadOnly)supportingVertexToPack, firstClosestFace, faceSphereOffset, (Vector3DReadOnly)this.halfSize)) {
                this.closestVertexCenter.set(isFaceXMaxCloser ? this.halfSize.getX() : -this.halfSize.getX(), isFaceYMaxCloser ? this.halfSize.getY() : -this.halfSize.getY(), isFaceZMaxCloser ? this.halfSize.getZ() : -this.halfSize.getZ());
                EuclidShapeTools.supportingVertexSphere3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)this.closestVertexCenter, (double)smallRadius, (Point3DBasics)supportingVertexToPack);
                double limitScaleFactor = largeRadius / (largeRadius - smallRadius);
                for (Axis3D axis : Axis3D.values) {
                    if (!(Math.abs(supportingVertexToPack.getElement(axis)) < this.halfSize.getElement(axis) * limitScaleFactor)) continue;
                    this.edgeCenter.setElement(axis, 0.0);
                    this.edgeCenter.setElement(axis.next(), this.closestVertexCenter.getElement(axis.next()));
                    this.edgeCenter.setElement(axis.previous(), this.closestVertexCenter.getElement(axis.previous()));
                    double torusRadius = EuclidGeometryTools.triangleIsoscelesHeight((double)(largeRadius - smallRadius), (double)box3D.getSize().getElement(axis));
                    EuclidShapeTools.innerSupportingVertexTorus3D((Vector3DReadOnly)supportDirection, (Point3DReadOnly)this.edgeCenter, (Vector3DReadOnly)axis, (double)torusRadius, (double)largeRadius, (Point3DBasics)supportingVertexToPack);
                    break;
                }
            }
            box3D.transformToWorld((Transformable)supportingVertexToPack);
            return true;
        }

        private static boolean isFaceSphereSupportingVertexValid(Point3DReadOnly query, Axis3D face, double faceSphereOffset, Vector3DReadOnly box3DHalfSize) {
            double edgeAxisZ;
            double edgeAxisY;
            double queryAbsX = Math.abs(query.getX());
            double queryAbsY = Math.abs(query.getY());
            double queryAbsZ = Math.abs(query.getZ());
            double faceCenterX = face == Axis3D.X ? box3DHalfSize.getX() : 0.0;
            double faceCenterY = face == Axis3D.Y ? box3DHalfSize.getY() : 0.0;
            double faceCenterZ = face == Axis3D.Z ? box3DHalfSize.getZ() : 0.0;
            double faceSphereCenterX = face == Axis3D.X ? box3DHalfSize.getX() - faceSphereOffset : 0.0;
            double faceSphereCenterY = face == Axis3D.Y ? box3DHalfSize.getY() - faceSphereOffset : 0.0;
            double faceSphereCenterZ = face == Axis3D.Z ? box3DHalfSize.getZ() - faceSphereOffset : 0.0;
            double edgeCenterX = faceCenterX + (face.next() == Axis3D.X ? box3DHalfSize.getX() : 0.0);
            double edgeCenterY = faceCenterY + (face.next() == Axis3D.Y ? box3DHalfSize.getY() : 0.0);
            double edgeCenterZ = faceCenterZ + (face.next() == Axis3D.Z ? box3DHalfSize.getZ() : 0.0);
            double sphereCenterToEdgeX = faceSphereCenterX - edgeCenterX;
            double sphereCenterToEdgeY = faceSphereCenterY - edgeCenterY;
            double sphereCenterToEdgeZ = faceSphereCenterZ - edgeCenterZ;
            double edgeAxisX = face.previous().getX();
            if (!STPShape3DTools.arePoint3DsSameSideOfPlane3D(faceCenterX, faceCenterY, faceCenterZ, queryAbsX, queryAbsY, queryAbsZ, edgeCenterX, edgeCenterY, edgeCenterZ, edgeAxisX, edgeAxisY = face.previous().getY(), edgeAxisZ = face.previous().getZ(), sphereCenterToEdgeX, sphereCenterToEdgeY, sphereCenterToEdgeZ)) {
                return false;
            }
            edgeCenterX = faceCenterX + (face.previous() == Axis3D.X ? box3DHalfSize.getX() : 0.0);
            edgeCenterY = faceCenterY + (face.previous() == Axis3D.Y ? box3DHalfSize.getY() : 0.0);
            edgeCenterZ = faceCenterZ + (face.previous() == Axis3D.Z ? box3DHalfSize.getZ() : 0.0);
            sphereCenterToEdgeX = faceSphereCenterX - edgeCenterX;
            sphereCenterToEdgeY = faceSphereCenterY - edgeCenterY;
            sphereCenterToEdgeZ = faceSphereCenterZ - edgeCenterZ;
            edgeAxisX = face.next().getX();
            return STPShape3DTools.arePoint3DsSameSideOfPlane3D(faceCenterX, faceCenterY, faceCenterZ, queryAbsX, queryAbsY, queryAbsZ, edgeCenterX, edgeCenterY, edgeCenterZ, edgeAxisX, edgeAxisY = face.next().getY(), edgeAxisZ = face.next().getZ(), sphereCenterToEdgeX, sphereCenterToEdgeY, sphereCenterToEdgeZ);
        }

        private static double getFaceSphereOffset(Axis3D face, Vector3DReadOnly box3DHalfSize, double smallRadius, double largeRadius) {
            double a = box3DHalfSize.getElement(face.next());
            double b = box3DHalfSize.getElement(face.previous());
            return Math.sqrt(EuclidCoreTools.square((double)(largeRadius - smallRadius)) - (a * a + b * b));
        }
    }
}

