/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.impulseBased;

import java.util.List;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.algorithms.ForwardDynamicsCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialImpulseReadOnly;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.simulation.collision.Collidable;
import us.ihmc.scs2.simulation.collision.CollidableHolder;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.ImpulseBasedRobotPhysics;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.RobotJointLimitImpulseBasedCalculator;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.SingleContactImpulseCalculator;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.RobotExtension;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ImpulseBasedRobot
extends RobotExtension
implements CollidableHolder {
    private final ImpulseBasedRobotPhysics robotPhysics = new ImpulseBasedRobotPhysics(this, this.getRobotPhysicsRegistry());

    public ImpulseBasedRobot(Robot robot, YoRegistry physicsRegistry) {
        super(robot, physicsRegistry);
    }

    public ImpulseBasedRobot(RobotDefinition robotDefinition, ReferenceFrame inertialFrame, YoRegistry physicsRegistry) {
        super(robotDefinition, inertialFrame, physicsRegistry);
    }

    public void resetCalculators() {
        this.robotPhysics.resetCalculators();
    }

    public void doForwardDynamics(Vector3DReadOnly gravity) {
        this.robotPhysics.doForwardDynamics(gravity);
    }

    public void updateCollidableBoundingBoxes() {
        this.robotPhysics.updateCollidableBoundingBoxes();
    }

    public ForwardDynamicsCalculator getForwardDynamicsCalculator() {
        return this.robotPhysics.getForwardDynamicsCalculator();
    }

    public RobotJointLimitImpulseBasedCalculator getJointLimitConstraintCalculator() {
        return this.robotPhysics.getJointLimitConstraintCalculator();
    }

    public SingleContactImpulseCalculator getOrCreateEnvironmentContactConstraintCalculator() {
        return this.robotPhysics.getOrCreateEnvironmentContactConstraintCalculator();
    }

    public SingleContactImpulseCalculator getOrCreateInterRobotContactConstraintCalculator(ImpulseBasedRobot otherRobot) {
        return this.robotPhysics.getOrCreateInterRobotContactConstraintCalculator(otherRobot);
    }

    public void addRigidBodyExternalImpulse(RigidBodyReadOnly target, SpatialImpulseReadOnly wrenchToAdd) {
        this.robotPhysics.addRigidBodyExternalImpulse(target, wrenchToAdd);
    }

    public void addJointVelocityChange(DMatrixRMaj velocityChange) {
        this.robotPhysics.addJointVelocityChange(velocityChange);
    }

    public void writeJointAccelerations() {
        this.robotPhysics.writeJointAccelerations();
    }

    public void writeJointDeltaVelocities() {
        this.robotPhysics.writeJointDeltaVelocities();
    }

    public void integrateState(double dt) {
        this.robotPhysics.integrateState(dt);
    }

    public void updateSensors() {
        for (SimJointBasics simJointBasics : this.getJointsToConsider()) {
            simJointBasics.getAuxiliaryData().update(this.robotPhysics.getPhysicsOutput());
        }
    }

    @Override
    public List<Collidable> getCollidables() {
        return this.robotPhysics.getCollidables();
    }
}

