/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.impulseBased;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.mecano.algorithms.ForwardDynamicsCalculator;
import us.ihmc.mecano.algorithms.MultiBodyResponseCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointReadOnly;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialVector;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameTwist;
import us.ihmc.scs2.simulation.collision.CollisionResult;
import us.ihmc.scs2.simulation.physicsEngine.YoMatrix;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.SingleContactImpulseCalculator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoSingleContactImpulseCalculator
extends SingleContactImpulseCalculator {
    private static final boolean EXTRA_YOVARIABLES = false;
    private YoBoolean isContactClosing;
    private YoFrameVector3D collisionAxis;
    private YoFrameVector3D impulseA;
    private YoFrameVector3D impulseB;
    private YoFramePoint3D pointA;
    private YoFramePoint3D pointB;
    private YoFixedFrameSpatialVector velocityRelative;
    private YoFixedFrameSpatialVector velocitySolverInput;
    private YoMatrix collisionMatrix;
    private YoDouble collisionMatrixDet;
    private YoFixedFrameSpatialVector velocityInitialA;
    private YoFixedFrameSpatialVector velocityInitialB;
    private YoFixedFrameSpatialVector velocityNoImpulseA;
    private YoFixedFrameSpatialVector velocityNoImpulseB;
    private YoFixedFrameSpatialVector velocityDueToOtherImpulseA;
    private YoFixedFrameSpatialVector velocityDueToOtherImpulseB;
    private YoFixedFrameSpatialVector velocityChangeA;
    private YoFixedFrameSpatialVector velocityChangeB;
    private List<JointVelocityChange> jointVelocityChangeAList;
    private List<JointVelocityChange> jointVelocityChangeBList;
    private final FrameVector3D mutableFrameVector = new FrameVector3D();

    public YoSingleContactImpulseCalculator(String prefix, int identifier, ReferenceFrame rootFrame, RigidBodyBasics rootBodyA, ForwardDynamicsCalculator forwardDynamicsCalculatorA, RigidBodyBasics rootBodyB, ForwardDynamicsCalculator forwardDynamicsCalculatorB, YoRegistry registry) {
        super(rootFrame, rootBodyA, forwardDynamicsCalculatorA, rootBodyB, forwardDynamicsCalculatorB);
        this.isContactClosing = new YoBoolean(prefix + "IsContactClosing" + identifier, registry);
        this.collisionAxis = new YoFrameVector3D(prefix + "CollisionAxis" + identifier, rootFrame, registry);
        this.pointA = new YoFramePoint3D(prefix + "PointA" + identifier, rootFrame, registry);
        this.pointB = new YoFramePoint3D(prefix + "PointB" + identifier, rootFrame, registry);
        this.velocityRelative = new YoFixedFrameSpatialVector(prefix + "VelocityRelative" + identifier, rootFrame, registry);
        this.impulseA = new YoFrameVector3D(prefix + "ImpulseA" + identifier, rootFrame, registry);
        this.clear();
    }

    public void clear() {
        if (this.isContactClosing != null) {
            this.isContactClosing.set(false);
        }
        if (this.collisionAxis != null) {
            this.collisionAxis.setToNaN();
        }
        if (this.pointA != null) {
            this.pointA.setToNaN();
        }
        if (this.pointB != null) {
            this.pointB.setToNaN();
        }
        if (this.velocityRelative != null) {
            this.velocityRelative.setToNaN();
        }
        if (this.velocitySolverInput != null) {
            this.velocitySolverInput.setToNaN();
        }
        if (this.collisionMatrix != null) {
            this.collisionMatrix.setToNaN(3, 3);
        }
        if (this.collisionMatrixDet != null) {
            this.collisionMatrixDet.setToNaN();
        }
        if (this.impulseA != null) {
            this.impulseA.setToNaN();
        }
        if (this.velocityInitialA != null) {
            this.velocityInitialA.setToNaN();
        }
        if (this.velocityNoImpulseA != null) {
            this.velocityNoImpulseA.setToNaN();
        }
        if (this.velocityDueToOtherImpulseA != null) {
            this.velocityDueToOtherImpulseA.setToNaN();
        }
        if (this.velocityChangeA != null) {
            this.velocityChangeA.setToNaN();
        }
        if (this.jointVelocityChangeAList != null) {
            this.jointVelocityChangeAList.forEach(JointVelocityChange::setToNaN);
        }
        if (this.impulseB != null) {
            this.impulseB.setToNaN();
        }
        if (this.velocityInitialB != null) {
            this.velocityInitialB.setToNaN();
        }
        if (this.velocityNoImpulseB != null) {
            this.velocityNoImpulseB.setToNaN();
        }
        if (this.velocityDueToOtherImpulseB != null) {
            this.velocityDueToOtherImpulseB.setToNaN();
        }
        if (this.velocityChangeB != null) {
            this.velocityChangeB.setToNaN();
        }
        if (this.jointVelocityChangeBList != null) {
            this.jointVelocityChangeBList.forEach(JointVelocityChange::setToNaN);
        }
    }

    @Override
    public void setCollision(CollisionResult collisionResult) {
        super.setCollision(collisionResult);
        if (this.collisionAxis != null) {
            this.collisionAxis.set((FrameTuple3DReadOnly)collisionResult.getCollisionAxisForA());
        }
        if (this.pointA != null) {
            this.pointA.setMatchingFrame((FrameTuple3DReadOnly)collisionResult.getPointOnARootFrame());
        }
        if (this.pointB != null) {
            this.pointB.setMatchingFrame((FrameTuple3DReadOnly)collisionResult.getPointOnBRootFrame());
        }
    }

    @Override
    public void initialize(double dt) {
        super.initialize(dt);
        if (this.velocityInitialA != null) {
            this.getContactingBodyA().getBodyFixedFrame().getTwistOfFrame().getLinearVelocityAt(this.getPointA(), (FrameVector3DBasics)this.mutableFrameVector);
            this.velocityInitialA.getLinearPart().setMatchingFrame((FrameTuple3DReadOnly)this.mutableFrameVector);
        }
        if (this.velocityNoImpulseA != null) {
            this.velocityNoImpulseA.setMatchingFrame(this.getVelocityNoImpulseA());
        }
        if (this.velocityInitialB != null) {
            this.getContactingBodyB().getBodyFixedFrame().getTwistOfFrame().getLinearVelocityAt(this.getPointB(), (FrameVector3DBasics)this.mutableFrameVector);
            this.velocityInitialB.getLinearPart().setMatchingFrame((FrameTuple3DReadOnly)this.mutableFrameVector);
        }
        if (this.velocityNoImpulseB != null) {
            this.velocityNoImpulseB.setMatchingFrame(this.getVelocityNoImpulseB());
        }
    }

    @Override
    public void finalizeImpulse() {
        super.finalizeImpulse();
        if (this.isContactClosing != null) {
            this.isContactClosing.set(this.isContactClosing());
        }
        if (this.impulseA != null) {
            this.impulseA.setMatchingFrame((FrameTuple3DReadOnly)this.getImpulseA().getLinearPart());
        }
        if (this.velocityRelative != null) {
            this.velocityRelative.setMatchingFrame(this.getVelocityRelative());
        }
        if (this.velocitySolverInput != null) {
            this.velocitySolverInput.setMatchingFrame(this.getVelocitySolverInput());
        }
        if (this.collisionMatrix != null) {
            this.collisionMatrix.set((Matrix)this.getCollisionMatrix());
        }
        if (this.collisionMatrixDet != null) {
            this.collisionMatrixDet.set(CommonOps_DDRM.det((DMatrixRMaj)this.getCollisionMatrix()));
        }
        if (this.velocityDueToOtherImpulseA != null) {
            this.velocityDueToOtherImpulseA.setMatchingFrame(this.getVelocityDueToOtherImpulseA());
        }
        if (this.velocityChangeA != null) {
            this.velocityChangeA.getLinearPart().setMatchingFrame((FrameTuple3DReadOnly)this.getResponseCalculatorA().getTwistChangeProvider().getLinearVelocityOfBodyFixedPoint((RigidBodyReadOnly)this.getContactingBodyA(), this.getPointA()));
        }
        if (this.jointVelocityChangeAList != null) {
            if (this.getJointVelocityChange(0) != null) {
                this.jointVelocityChangeAList.forEach(holder -> holder.updateVelocity(this.getResponseCalculatorA()));
            } else {
                this.jointVelocityChangeAList.forEach(JointVelocityChange::setToZero);
            }
        }
        if (this.impulseB != null) {
            this.impulseB.setMatchingFrame((FrameTuple3DReadOnly)this.getImpulseB().getLinearPart());
        }
        if (this.velocityDueToOtherImpulseB != null) {
            this.velocityDueToOtherImpulseB.setMatchingFrame(this.getVelocityDueToOtherImpulseB());
        }
        if (this.velocityChangeB != null) {
            this.velocityChangeB.getLinearPart().setMatchingFrame((FrameTuple3DReadOnly)this.getResponseCalculatorB().getTwistChangeProvider().getLinearVelocityOfBodyFixedPoint((RigidBodyReadOnly)this.getContactingBodyB(), this.getPointB()));
        }
        if (this.jointVelocityChangeBList != null) {
            if (this.getJointVelocityChange(1) != null) {
                this.jointVelocityChangeBList.forEach(holder -> holder.updateVelocity(this.getResponseCalculatorB()));
            } else {
                this.jointVelocityChangeBList.forEach(JointVelocityChange::setToZero);
            }
        }
    }

    private static JointVelocityChange toJointVelocityChange(String prefix, String suffix, int identifier, JointReadOnly joint, YoRegistry registry) {
        if (joint instanceof SixDoFJointReadOnly) {
            return new SixDoFJointVelocityChange(prefix, suffix, identifier, (SixDoFJointReadOnly)joint, registry);
        }
        if (joint instanceof OneDoFJointReadOnly) {
            return new OneDoFJointVelocityChange(prefix, suffix, identifier, (OneDoFJointReadOnly)joint, registry);
        }
        throw new IllegalStateException("Unexpected joint type: " + joint.getClass().getSimpleName());
    }

    private static /* synthetic */ JointVelocityChange lambda$new$1(String prefix, int identifier, YoRegistry registry, JointBasics joint) {
        return YoSingleContactImpulseCalculator.toJointVelocityChange(prefix, "VelocityChangeB", identifier, (JointReadOnly)joint, registry);
    }

    private static /* synthetic */ JointVelocityChange lambda$new$0(String prefix, int identifier, YoRegistry registry, JointBasics joint) {
        return YoSingleContactImpulseCalculator.toJointVelocityChange(prefix, "VelocityChangeA", identifier, (JointReadOnly)joint, registry);
    }

    private static class SixDoFJointVelocityChange
    implements JointVelocityChange {
        private final SixDoFJointReadOnly joint;
        private final YoFixedFrameTwist velocityChange;

        public SixDoFJointVelocityChange(String prefix, String suffix, int identifier, SixDoFJointReadOnly joint, YoRegistry registry) {
            this.joint = joint;
            this.velocityChange = new YoFixedFrameTwist(prefix + StringUtils.capitalize((String)joint.getName()) + suffix + identifier, (ReferenceFrame)joint.getFrameAfterJoint(), (ReferenceFrame)joint.getFrameBeforeJoint(), (ReferenceFrame)joint.getFrameAfterJoint(), registry);
        }

        @Override
        public void setToZero() {
            this.velocityChange.setToZero();
        }

        @Override
        public void setToNaN() {
            this.velocityChange.setToNaN();
        }

        @Override
        public void updateVelocity(MultiBodyResponseCalculator responseCalculator) {
            this.velocityChange.set((DMatrix)responseCalculator.getJointTwistChange((JointReadOnly)this.joint));
        }

        public SixDoFJointReadOnly getJoint() {
            return this.joint;
        }
    }

    private static class OneDoFJointVelocityChange
    implements JointVelocityChange {
        private final OneDoFJointReadOnly joint;
        private final YoDouble velocityChange;

        public OneDoFJointVelocityChange(String prefix, String suffix, int identifier, OneDoFJointReadOnly joint, YoRegistry registry) {
            this.joint = joint;
            this.velocityChange = new YoDouble(prefix + StringUtils.capitalize((String)joint.getName()) + suffix + identifier, registry);
        }

        @Override
        public void setToZero() {
            this.velocityChange.set(0.0);
        }

        @Override
        public void setToNaN() {
            this.velocityChange.setToNaN();
        }

        @Override
        public void updateVelocity(MultiBodyResponseCalculator responseCalculator) {
            this.velocityChange.set(responseCalculator.getJointTwistChange(this.joint));
        }

        public OneDoFJointReadOnly getJoint() {
            return this.joint;
        }
    }

    private static interface JointVelocityChange {
        public void setToZero();

        public void setToNaN();

        public void updateVelocity(MultiBodyResponseCalculator var1);

        public JointReadOnly getJoint();
    }
}

