/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.multiBodySystem;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.tools.MecanoTools;
import us.ihmc.mecano.yoVariables.multiBodySystem.YoSixDoFJoint;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameTwist;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.simulation.robot.SimJointAuxiliaryData;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimFloatingJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class SimSixDoFJoint
extends YoSixDoFJoint
implements SimJointBasics,
SimFloatingJointBasics {
    private final YoRegistry registry;
    private final SimJointAuxiliaryData auxiliaryData;
    private final FixedFrameTwistBasics jointDeltaTwist;
    private final YoBoolean isPinned;

    public SimSixDoFJoint(SixDoFJointDefinition definition, SimRigidBodyBasics predecessor) {
        this(definition.getName(), predecessor, (RigidBodyTransformReadOnly)definition.getTransformToParent());
    }

    public SimSixDoFJoint(String name, SimRigidBodyBasics predecessor) {
        this(name, predecessor, null);
    }

    public SimSixDoFJoint(String name, SimRigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
        super(name, (RigidBodyBasics)predecessor, transformToParent, predecessor.getRegistry());
        this.registry = predecessor.getRegistry();
        this.auxiliaryData = new SimJointAuxiliaryData(this);
        String varName = !name.isEmpty() ? "_" + name + "_" : "_";
        this.jointDeltaTwist = new YoFixedFrameTwist((ReferenceFrame)this.afterJointFrame, (ReferenceFrame)this.beforeJointFrame, new YoFrameVector3D("qd_delta" + varName + "w", (ReferenceFrame)this.afterJointFrame, this.registry), new YoFrameVector3D("qd_delta" + varName, (ReferenceFrame)this.afterJointFrame, this.registry));
        this.isPinned = new YoBoolean("is" + varName + "pinned", this.registry);
    }

    @Override
    public YoRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public SimJointAuxiliaryData getAuxiliaryData() {
        return this.auxiliaryData;
    }

    public void setSuccessor(RigidBodyBasics successor) {
        if (!(successor instanceof SimRigidBodyBasics)) {
            throw new IllegalArgumentException("Can only set a " + SimRigidBodyBasics.class.getSimpleName() + " as successor of a " + this.getClass().getSimpleName());
        }
        super.setSuccessor(successor);
    }

    @Override
    public SimRigidBodyBasics getPredecessor() {
        return (SimRigidBodyBasics)super.getPredecessor();
    }

    @Override
    public SimRigidBodyBasics getSuccessor() {
        return (SimRigidBodyBasics)super.getSuccessor();
    }

    @Override
    public FixedFrameTwistBasics getJointDeltaTwist() {
        return this.jointDeltaTwist;
    }

    @Override
    public int getJointDeltaVelocity(int rowStart, DMatrix matrixToPack) {
        this.getJointTwist().get(rowStart, matrixToPack);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    public void setJointDeltaTwist(JointReadOnly other) {
        this.setJointDeltaTwist((SimSixDoFJoint)MecanoTools.checkTypeAndCast((JointReadOnly)other, SimSixDoFJoint.class));
    }

    public void setJointDeltaTwist(SimSixDoFJoint other) {
        FixedFrameVector3DBasics otherAngularDeltaVelocity = other.getJointDeltaTwist().getAngularPart();
        FixedFrameVector3DBasics otherLinearDeltaVelocity = other.getJointDeltaTwist().getLinearPart();
        this.setJointAngularDeltaVelocity((Vector3DReadOnly)otherAngularDeltaVelocity);
        this.setJointLinearDeltaVelocity((Vector3DReadOnly)otherLinearDeltaVelocity);
    }

    @Override
    public int setJointDeltaVelocity(int rowStart, DMatrix matrix) {
        this.getJointDeltaTwist().set(rowStart, matrix);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    public void setPinned(boolean isPinned) {
        this.isPinned.set(isPinned);
    }

    @Override
    public boolean isPinned() {
        return this.isPinned.getValue();
    }
}

