/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.state;

import java.util.function.Function;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.JointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoJointState
implements JointStateBasics {
    private final YoDouble[] configuration;
    private final YoDouble[] velocity;
    private final YoDouble[] acceleration;
    private final YoDouble[] effort;
    private final int configurationSize;
    private final int degreesOfFreedom;
    private final DMatrixRMaj temp;

    public YoJointState(String namePrefix, String nameSuffix, int configurationSize, int defreesOfFreedom, YoRegistry registry) {
        int i;
        if (namePrefix == null) {
            namePrefix = "";
        } else if (!namePrefix.isEmpty() && !namePrefix.endsWith("_")) {
            namePrefix = namePrefix + "_";
        }
        if (nameSuffix == null) {
            nameSuffix = "";
        } else if (!nameSuffix.isEmpty() && !nameSuffix.startsWith("_")) {
            nameSuffix = "_" + nameSuffix;
        }
        this.configurationSize = configurationSize;
        this.degreesOfFreedom = defreesOfFreedom;
        this.configuration = new YoDouble[configurationSize];
        this.velocity = new YoDouble[defreesOfFreedom];
        this.acceleration = new YoDouble[defreesOfFreedom];
        this.effort = new YoDouble[defreesOfFreedom];
        for (i = 0; i < configurationSize; ++i) {
            this.configuration[i] = new YoDouble(namePrefix + "q_" + Integer.toString(i) + nameSuffix, registry);
        }
        for (i = 0; i < defreesOfFreedom; ++i) {
            this.velocity[i] = new YoDouble(namePrefix + "qd_" + Integer.toString(i) + nameSuffix, registry);
            this.acceleration[i] = new YoDouble(namePrefix + "qdd_" + Integer.toString(i) + nameSuffix, registry);
            this.effort[i] = new YoDouble(namePrefix + "tau_" + Integer.toString(i) + nameSuffix, registry);
        }
        this.temp = new DMatrixRMaj(configurationSize, 1);
    }

    public void clear() {
        this.clearConfiguration();
        this.clearVelocity();
        this.clearAcceleration();
        this.clearEffort();
    }

    private void clearEffort() {
        for (YoDouble variable : this.effort) {
            variable.setToNaN();
        }
    }

    private void clearAcceleration() {
        for (YoDouble variable : this.acceleration) {
            variable.setToNaN();
        }
    }

    private void clearVelocity() {
        for (YoDouble variable : this.velocity) {
            variable.setToNaN();
        }
    }

    private void clearConfiguration() {
        for (YoDouble variable : this.configuration) {
            variable.setToNaN();
        }
    }

    public void set(JointStateReadOnly other) {
        if (other.getConfigurationSize() != this.configurationSize || other.getDegreesOfFreedom() != this.degreesOfFreedom) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        if (other.hasOutputFor(JointStateType.CONFIGURATION)) {
            this.temp.reshape(this.configurationSize, 1);
            other.getConfiguration(0, (DMatrix)this.temp);
            this.setConfiguration(0, (DMatrix)this.temp);
        } else {
            this.clearConfiguration();
        }
        if (other.hasOutputFor(JointStateType.VELOCITY)) {
            this.temp.reshape(this.degreesOfFreedom, 1);
            other.getVelocity(0, (DMatrix)this.temp);
            this.setVelocity(0, (DMatrix)this.temp);
        } else {
            this.clearVelocity();
        }
        if (other.hasOutputFor(JointStateType.ACCELERATION)) {
            this.temp.reshape(this.degreesOfFreedom, 1);
            other.getAcceleration(0, (DMatrix)this.temp);
            this.setAcceleration(0, (DMatrix)this.temp);
        } else {
            this.clearAcceleration();
        }
        if (other.hasOutputFor(JointStateType.EFFORT)) {
            this.temp.reshape(this.degreesOfFreedom, 1);
            other.getEffort(0, (DMatrix)this.temp);
            this.setEffort(0, (DMatrix)this.temp);
        } else {
            this.clearEffort();
        }
    }

    public int getConfigurationSize() {
        return this.configurationSize;
    }

    public int getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    public void setConfiguration(JointReadOnly joint) {
        this.checkConfigurationSize(joint);
        this.temp.reshape(this.configurationSize, 1);
        joint.getJointConfiguration(0, (DMatrix)this.temp);
        this.setConfiguration(0, (DMatrix)this.temp);
    }

    public int setConfiguration(int startRow, DMatrix configuration) {
        this.checkConfigurationSize(startRow, configuration);
        YoJointState.copyDMatrixIntoYoVariables(startRow, configuration, this.configuration);
        return startRow + this.configurationSize;
    }

    public void setVelocity(JointReadOnly joint) {
        this.checkDegreesOfFreedom(joint);
        this.temp.reshape(this.degreesOfFreedom, 1);
        joint.getJointVelocity(0, (DMatrix)this.temp);
        this.setVelocity(0, (DMatrix)this.temp);
    }

    public int setVelocity(int startRow, DMatrix velocity) {
        this.checkDegreesOfFreedom(startRow, velocity);
        YoJointState.copyDMatrixIntoYoVariables(startRow, velocity, this.velocity);
        return startRow + this.degreesOfFreedom;
    }

    public void setAcceleration(JointReadOnly joint) {
        this.checkDegreesOfFreedom(joint);
        this.temp.reshape(this.degreesOfFreedom, 1);
        joint.getJointAcceleration(0, (DMatrix)this.temp);
        this.setAcceleration(0, (DMatrix)this.temp);
    }

    public int setAcceleration(int startRow, DMatrix acceleration) {
        this.checkDegreesOfFreedom(startRow, acceleration);
        YoJointState.copyDMatrixIntoYoVariables(startRow, acceleration, this.acceleration);
        return startRow + this.degreesOfFreedom;
    }

    public void setEffort(JointReadOnly joint) {
        this.checkDegreesOfFreedom(joint);
        this.temp.reshape(this.degreesOfFreedom, 1);
        joint.getJointTau(0, (DMatrix)this.temp);
        this.setEffort(0, (DMatrix)this.temp);
    }

    public int setEffort(int startRow, DMatrix effort) {
        this.checkDegreesOfFreedom(startRow, effort);
        YoJointState.copyDMatrixIntoYoVariables(startRow, effort, this.effort);
        return startRow + this.degreesOfFreedom;
    }

    public boolean hasOutputFor(JointStateType query) {
        switch (query) {
            case CONFIGURATION: {
                return !YoJointState.containsNaN(this.configuration);
            }
            case VELOCITY: {
                return !YoJointState.containsNaN(this.velocity);
            }
            case ACCELERATION: {
                return !YoJointState.containsNaN(this.acceleration);
            }
            case EFFORT: {
                return !YoJointState.containsNaN(this.effort);
            }
        }
        throw new IllegalStateException("Should not get here.");
    }

    public void getConfiguration(JointBasics jointToUpdate) {
        this.temp.reshape(this.configurationSize, 1);
        this.getConfiguration(0, (DMatrix)this.temp);
        jointToUpdate.setJointConfiguration(0, (DMatrix)this.temp);
    }

    public int getConfiguration(int startRow, DMatrix configurationToPack) {
        YoJointState.copyYoVariablesIntoDMatrix(this.configuration, startRow, configurationToPack);
        return startRow + this.configurationSize;
    }

    public void getVelocity(JointBasics jointToUpdate) {
        this.temp.reshape(this.degreesOfFreedom, 1);
        this.getVelocity(0, (DMatrix)this.temp);
        jointToUpdate.setJointVelocity(0, (DMatrix)this.temp);
    }

    public int getVelocity(int startRow, DMatrix velocityToPack) {
        YoJointState.copyYoVariablesIntoDMatrix(this.velocity, startRow, velocityToPack);
        return startRow + this.degreesOfFreedom;
    }

    public void getAcceleration(JointBasics jointToUpdate) {
        this.temp.reshape(this.degreesOfFreedom, 1);
        this.getAcceleration(0, (DMatrix)this.temp);
        jointToUpdate.setJointAcceleration(0, (DMatrix)this.temp);
    }

    public int getAcceleration(int startRow, DMatrix accelerationToPack) {
        YoJointState.copyYoVariablesIntoDMatrix(this.acceleration, startRow, accelerationToPack);
        return startRow + this.degreesOfFreedom;
    }

    public void getEffort(JointBasics jointToUpdate) {
        this.temp.reshape(this.degreesOfFreedom, 1);
        this.getEffort(0, (DMatrix)this.temp);
        jointToUpdate.setJointTau(0, (DMatrix)this.temp);
    }

    public int getEffort(int startRow, DMatrix effortToPack) {
        YoJointState.copyYoVariablesIntoDMatrix(this.effort, startRow, effortToPack);
        return startRow + this.degreesOfFreedom;
    }

    public JointState copy() {
        return new JointState((JointStateReadOnly)this);
    }

    public String toString() {
        String ret = this.degreesOfFreedom + "-DoF joint state";
        Function<YoDouble, String> elementToStringFunction = v -> String.format(EuclidCoreIOTools.DEFAULT_FORMAT, v.getValue());
        if (this.hasOutputFor(JointStateType.CONFIGURATION)) {
            ret = ret + EuclidCoreIOTools.getArrayString((String)", configuration: [", (String)"]", (String)", ", (Object[])this.configuration, elementToStringFunction);
        }
        if (this.hasOutputFor(JointStateType.VELOCITY)) {
            ret = ret + EuclidCoreIOTools.getArrayString((String)", velocity: [", (String)"]", (String)", ", (Object[])this.velocity, elementToStringFunction);
        }
        if (this.hasOutputFor(JointStateType.ACCELERATION)) {
            ret = ret + EuclidCoreIOTools.getArrayString((String)", acceleration: [", (String)"]", (String)", ", (Object[])this.acceleration, elementToStringFunction);
        }
        if (this.hasOutputFor(JointStateType.EFFORT)) {
            ret = ret + EuclidCoreIOTools.getArrayString((String)", effort: [", (String)"]", (String)", ", (Object[])this.effort, elementToStringFunction);
        }
        return ret;
    }

    private static boolean containsNaN(YoDouble[] variables) {
        for (int i = 0; i < variables.length; ++i) {
            if (!variables[i].isNaN()) continue;
            return true;
        }
        return false;
    }

    private static void copyDMatrixIntoYoVariables(int startRow, DMatrix source, YoDouble[] destination) {
        for (int i = 0; i < destination.length; ++i) {
            destination[i].set(source.get(startRow++, 0));
        }
    }

    private static void copyYoVariablesIntoDMatrix(YoDouble[] source, int startRow, DMatrix destination) {
        for (int i = 0; i < source.length; ++i) {
            destination.set(startRow++, 0, source[i].getValue());
        }
    }
}

