/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import us.ihmc.commons.Conversions;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.messager.Messager;
import us.ihmc.messager.TopicListener;
import us.ihmc.scs2.definition.robot.CameraSensorDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.RobotStateDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.session.DaemonThreadFactory;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionMessagerAPI;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.sharedMemory.CropBufferRequest;
import us.ihmc.scs2.simulation.SimulationSessionControls;
import us.ihmc.scs2.simulation.TimeConsumer;
import us.ihmc.scs2.simulation.physicsEngine.PhysicsEngine;
import us.ihmc.scs2.simulation.physicsEngine.PhysicsEngineFactory;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.sensors.SimCameraSensor;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.exceptions.IllegalOperationException;

public class SimulationSession
extends Session {
    public static final ReferenceFrame DEFAULT_INERTIAL_FRAME = ReferenceFrameTools.constructARootFrame((String)"worldFrame");
    private final PhysicsEngine physicsEngine;
    private final YoFrameVector3D gravity;
    private final String simulationName;
    private final List<YoGraphicDefinition> yoGraphicDefinitions;
    private final List<Consumer<SessionMessagerAPI.Sensors.SensorMessage<CameraSensorDefinition>>> cameraDefinitionListeners;
    private final List<SimCameraSensor.CameraDefinitionConsumer> cameraDefinitionNotifiers;
    private final Map<String, Map<String, SimCameraSensor>> robotNameToSensorNameToCameraMap;
    private final ExecutorService cameraBroadcastExecutor;
    private final List<BooleanSupplier> terminalConditions;
    private final List<TimeConsumer> beforePhysicsCallbacks;
    private final List<TimeConsumer> afterPhysicsCallbacks;
    private final List<Runnable> cleanupActions;
    private SimulationSessionControlsImpl controls;
    private boolean hasSessionStarted;

    public SimulationSession() {
        this(SimulationSession.retrieveCallerName());
    }

    public SimulationSession(PhysicsEngineFactory physicsEngineFactory) {
        this(SimulationSession.retrieveCallerName(), physicsEngineFactory);
    }

    public SimulationSession(String simulationName) {
        this(DEFAULT_INERTIAL_FRAME, simulationName);
    }

    public SimulationSession(ReferenceFrame inertialFrame, String simulationName) {
        this(inertialFrame, simulationName, PhysicsEngineFactory.newImpulseBasedPhysicsEngineFactory());
    }

    public SimulationSession(String simulationName, PhysicsEngineFactory physicsEngineFactory) {
        this(DEFAULT_INERTIAL_FRAME, simulationName, physicsEngineFactory);
    }

    public SimulationSession(ReferenceFrame inertialFrame, String simulationName, PhysicsEngineFactory physicsEngineFactory) {
        super(inertialFrame);
        this.gravity = new YoFrameVector3D("gravity", ReferenceFrame.getWorldFrame(), this.rootRegistry);
        this.yoGraphicDefinitions = new ArrayList<YoGraphicDefinition>();
        this.cameraDefinitionListeners = new ArrayList<Consumer<SessionMessagerAPI.Sensors.SensorMessage<CameraSensorDefinition>>>();
        this.cameraDefinitionNotifiers = new ArrayList<SimCameraSensor.CameraDefinitionConsumer>();
        this.robotNameToSensorNameToCameraMap = new HashMap<String, Map<String, SimCameraSensor>>();
        this.cameraBroadcastExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory("SCS2-Camera-Server"));
        this.terminalConditions = new ArrayList<BooleanSupplier>();
        this.beforePhysicsCallbacks = new ArrayList<TimeConsumer>();
        this.afterPhysicsCallbacks = new ArrayList<TimeConsumer>();
        this.cleanupActions = new ArrayList<Runnable>();
        this.controls = null;
        this.hasSessionStarted = false;
        if (!inertialFrame.isRootFrame()) {
            throw new IllegalArgumentException("The given inertialFrame is not a root frame: " + inertialFrame);
        }
        this.simulationName = simulationName;
        this.physicsEngine = physicsEngineFactory.build(inertialFrame, this.rootRegistry);
        this.sessionRegistry.addChild(this.physicsEngine.getPhysicsEngineRegistry());
        this.setSessionDTSeconds(1.0E-4);
        this.setSessionMode(SessionMode.PAUSE);
        this.gravity.set(0.0, 0.0, -9.81);
    }

    public SimulationSessionControls getSimulationSessionControls() {
        if (this.controls == null) {
            this.controls = new SimulationSessionControlsImpl();
        }
        return this.controls;
    }

    protected void initializeSession() {
        this.hasSessionStarted = true;
        super.initializeSession();
        this.physicsEngine.initialize((Vector3DReadOnly)this.gravity);
    }

    public void shutdownSession() {
        super.shutdownSession();
        this.cleanupActions.forEach(Runnable::run);
        this.cleanupActions.clear();
        this.cameraBroadcastExecutor.shutdown();
        this.physicsEngine.dispose();
    }

    protected void doGeneric(SessionMode currentMode) {
        super.doGeneric(currentMode);
        this.cameraDefinitionNotifiers.forEach(notifier -> notifier.nextDefinition(null));
    }

    protected double doSpecificRunTick() {
        double dt = Conversions.nanosecondsToSeconds((long)this.getSessionDTNanoseconds());
        for (int i = 0; i < this.beforePhysicsCallbacks.size(); ++i) {
            this.beforePhysicsCallbacks.get(i).accept(this.time.getValue());
        }
        this.physicsEngine.simulate(this.time.getValue(), dt, (Vector3DReadOnly)this.gravity);
        double newTime = this.time.getValue() + dt;
        for (int i = 0; i < this.afterPhysicsCallbacks.size(); ++i) {
            this.afterPhysicsCallbacks.get(i).accept(newTime);
        }
        return newTime;
    }

    protected void schedulingSessionMode(SessionMode previousMode, SessionMode newMode) {
        if (previousMode == newMode) {
            return;
        }
        if (previousMode == SessionMode.RUNNING) {
            this.physicsEngine.pause();
            this.finalizeRunTick(true);
        }
    }

    public void addRobot(Robot robot) {
        this.checkSessionHasNotStarted();
        this.physicsEngine.addRobot(robot);
    }

    public Robot addRobot(RobotDefinition robotDefinition) {
        Robot robot = new Robot(robotDefinition, this.inertialFrame);
        this.configureCameraSensors(robot);
        this.addRobot(robot);
        return robot;
    }

    private void configureCameraSensors(Robot robot) {
        for (SimJointBasics simJointBasics : robot.getAllJoints()) {
            for (SimCameraSensor cameraSensor : simJointBasics.getAuxialiryData().getCameraSensors()) {
                this.configureCameraSensor(robot.getName(), cameraSensor);
            }
        }
    }

    private void configureCameraSensor(String robotName, SimCameraSensor cameraSensor) {
        this.robotNameToSensorNameToCameraMap.computeIfAbsent(robotName, s -> new HashMap()).put(cameraSensor.getName(), cameraSensor);
        SimCameraSensor.CameraDefinitionConsumer cameraDefinitionNotifier = newDefinition -> {
            String sensorName = cameraSensor.getName();
            CameraSensorDefinition definitionData = newDefinition != null ? newDefinition : cameraSensor.toCameraSensorDefinition();
            SessionMessagerAPI.Sensors.SensorMessage newMessage = new SessionMessagerAPI.Sensors.SensorMessage(robotName, sensorName, (Object)definitionData);
            this.cameraDefinitionListeners.forEach(listener -> listener.accept(newMessage));
        };
        this.cameraDefinitionNotifiers.add(cameraDefinitionNotifier);
        cameraSensor.addCameraDefinitionConsumer(cameraDefinitionNotifier);
    }

    public void setupWithMessager(Messager messager) {
        super.setupWithMessager(messager);
        this.cameraDefinitionListeners.add(message -> messager.submitMessage(SessionMessagerAPI.Sensors.CameraSensorDefinitionData, message));
        TopicListener listener = message -> {
            long timestamp = Conversions.secondsToNanoseconds((double)this.time.getValue());
            SimCameraSensor cameraSensor = (SimCameraSensor)this.robotNameToSensorNameToCameraMap.getOrDefault(message.getRobotName(), Collections.emptyMap()).get(message.getSensorName());
            this.cameraBroadcastExecutor.execute(() -> {
                for (SimCameraSensor.CameraFrameConsumer consumer : cameraSensor.getCameraFrameConsumers()) {
                    consumer.nextFrame(timestamp, (BufferedImage)message.getMessageContent());
                }
            });
        };
        messager.registerTopicListener(SessionMessagerAPI.Sensors.CameraSensorFrame, listener);
        this.cleanupActions.add(() -> messager.removeTopicListener(SessionMessagerAPI.Sensors.CameraSensorFrame, listener));
    }

    public void addTerrainObject(TerrainObjectDefinition terrainObjectDefinition) {
        this.checkSessionHasNotStarted();
        this.physicsEngine.addTerrainObject(terrainObjectDefinition);
    }

    public void addYoGraphicDefinition(YoGraphicDefinition yoGraphicDefinition) {
        this.checkSessionHasNotStarted();
        this.yoGraphicDefinitions.add(yoGraphicDefinition);
    }

    public void addYoGraphicDefinitions(YoGraphicDefinition ... yoGraphicDefinitions) {
        for (YoGraphicDefinition yoGraphicDefinition : yoGraphicDefinitions) {
            this.addYoGraphicDefinition(yoGraphicDefinition);
        }
    }

    public void addYoGraphicDefinitions(Iterable<? extends YoGraphicDefinition> yoGraphicDefinitions) {
        for (YoGraphicDefinition yoGraphicDefinition : yoGraphicDefinitions) {
            this.addYoGraphicDefinition(yoGraphicDefinition);
        }
    }

    public String getSessionName() {
        return this.simulationName;
    }

    public PhysicsEngine getPhysicsEngine() {
        return this.physicsEngine;
    }

    public List<RobotDefinition> getRobotDefinitions() {
        return this.physicsEngine.getRobotDefinitions();
    }

    public List<TerrainObjectDefinition> getTerrainObjectDefinitions() {
        return this.physicsEngine.getTerrainObjectDefinitions();
    }

    public List<YoGraphicDefinition> getYoGraphicDefinitions() {
        return this.yoGraphicDefinitions;
    }

    public List<RobotStateDefinition> getCurrentRobotStateDefinitions(boolean initialState) {
        if (initialState) {
            return this.physicsEngine.getBeforePhysicsRobotStateDefinitions();
        }
        return this.physicsEngine.getCurrentRobotStateDefinitions();
    }

    private void checkSessionHasNotStarted() {
        if (this.hasSessionStarted) {
            throw new IllegalOperationException("Illegal operation after session has started.");
        }
    }

    public void addBeforePhysicsCallback(TimeConsumer beforePhysicsCallback) {
        this.beforePhysicsCallbacks.add(beforePhysicsCallback);
    }

    public boolean removeBeforePhysicsCallback(TimeConsumer beforePhysicsCallback) {
        return this.beforePhysicsCallbacks.remove(beforePhysicsCallback);
    }

    public void addAfterPhysicsCallback(TimeConsumer afterPhysicsCallback) {
        this.afterPhysicsCallbacks.add(afterPhysicsCallback);
    }

    public boolean removeAfterPhysicsCallback(TimeConsumer afterPhysicsCallback) {
        return this.afterPhysicsCallbacks.remove(afterPhysicsCallback);
    }

    private class SimulationSessionControlsImpl
    implements SimulationSessionControls {
        private SimulationSessionControlsImpl() {
        }

        @Override
        public void pause() {
            SimulationSession.this.setSessionMode(SessionMode.PAUSE);
        }

        @Override
        public void simulate() {
            SimulationSession.this.setSessionMode(SessionMode.RUNNING);
        }

        @Override
        public void simulate(double duration) {
            if (SimulationSession.this.getActiveMode() == SessionMode.RUNNING) {
                SimulationSession.this.setSessionMode(SessionMode.PAUSE);
            }
            double startTime = SimulationSession.this.time.getValue();
            BooleanSupplier terminalCondition = () -> SimulationSession.this.time.getValue() - startTime >= duration;
            SimulationSession.this.setSessionMode(SessionMode.RUNNING, Session.SessionModeTransition.newTransition((BooleanSupplier)terminalCondition, (SessionMode)SessionMode.PAUSE));
        }

        @Override
        public void simulate(final int numberOfTicks) {
            if (SimulationSession.this.getActiveMode() == SessionMode.RUNNING) {
                SimulationSession.this.setSessionMode(SessionMode.PAUSE);
            }
            BooleanSupplier terminalCondition = new BooleanSupplier(){
                private int tickCounter = 0;

                @Override
                public boolean getAsBoolean() {
                    ++this.tickCounter;
                    return this.tickCounter >= numberOfTicks || SimulationSessionControlsImpl.this.testTerminalConditions();
                }
            };
            SimulationSession.this.setSessionMode(SessionMode.RUNNING, Session.SessionModeTransition.newTransition((BooleanSupplier)terminalCondition, (SessionMode)SessionMode.PAUSE));
        }

        @Override
        public boolean simulateNow(double duration) {
            long numberOfTicks = Conversions.secondsToNanoseconds((double)duration) / SimulationSession.this.getSessionDTNanoseconds();
            return this.simulateNow(numberOfTicks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean simulateNow(long numberOfTicks) {
            if (SimulationSession.this.isSessionShutdown()) {
                return false;
            }
            boolean sessionStartedInitialValue = SimulationSession.this.hasSessionStarted();
            if (sessionStartedInitialValue && !SimulationSession.this.stopSessionThread()) {
                return false;
            }
            SessionMode activeModeInitialValue = SimulationSession.this.getActiveMode();
            try {
                SimulationSession.this.setSessionMode(SessionMode.RUNNING);
                boolean success = true;
                if (numberOfTicks == -1L) {
                    do {
                        if (!SimulationSession.this.isSessionShutdown()) continue;
                        boolean bl = false;
                        return bl;
                    } while ((success = SimulationSession.this.runTick()) && !this.testTerminalConditions());
                } else {
                    for (long tick = 0L; tick < numberOfTicks; ++tick) {
                        if (SimulationSession.this.isSessionShutdown()) {
                            boolean bl = false;
                            return bl;
                        }
                        success = SimulationSession.this.runTick();
                        if (!success || this.testTerminalConditions()) break;
                    }
                }
                boolean bl = success;
                return bl;
            }
            finally {
                SimulationSession.this.physicsEngine.pause();
                if (sessionStartedInitialValue) {
                    SimulationSession.this.startSessionThread();
                }
                SimulationSession.this.setSessionMode(activeModeInitialValue);
            }
        }

        @Override
        public boolean simulateNow() {
            return this.simulateNow(-1L);
        }

        private boolean testTerminalConditions() {
            for (int i = 0; i < SimulationSession.this.terminalConditions.size(); ++i) {
                if (!((BooleanSupplier)SimulationSession.this.terminalConditions.get(i)).getAsBoolean()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void addExternalTerminalCondition(BooleanSupplier ... externalTerminalConditions) {
            for (int i = 0; i < externalTerminalConditions.length; ++i) {
                SimulationSession.this.terminalConditions.add(externalTerminalConditions[i]);
            }
        }

        @Override
        public boolean removeExternalTerminalCondition(BooleanSupplier externalTerminalCondition) {
            return SimulationSession.this.terminalConditions.remove(externalTerminalCondition);
        }

        @Override
        public void clearExternalTerminalConditions() {
            SimulationSession.this.terminalConditions.clear();
        }

        @Override
        public void addSimulationThrowableListener(Consumer<Throwable> listener) {
            SimulationSession.this.addRunThrowableListener(listener);
        }

        @Override
        public void cropBuffer() {
            SimulationSession.this.submitCropBufferRequestAndWait(new CropBufferRequest(SimulationSession.this.getBufferProperties().getInPoint(), SimulationSession.this.getBufferProperties().getOutPoint()));
        }

        @Override
        public void setBufferInPointIndexToCurrent() {
            SimulationSession.this.submitBufferInPointIndexRequestAndWait(SimulationSession.this.getBufferProperties().getCurrentIndex());
        }

        @Override
        public void setBufferOutPointIndexToCurrent() {
            SimulationSession.this.submitBufferOutPointIndexRequestAndWait(SimulationSession.this.getBufferProperties().getCurrentIndex());
        }

        @Override
        public void setBufferCurrentIndexToInPoint() {
            SimulationSession.this.submitBufferIndexRequestAndWait(SimulationSession.this.getBufferProperties().getInPoint());
        }

        @Override
        public void setBufferCurrentIndexToOutPoint() {
            SimulationSession.this.submitBufferIndexRequestAndWait(SimulationSession.this.getBufferProperties().getOutPoint());
        }

        @Override
        public void stepBufferIndexBackward(int stepSize) {
            SimulationSession.this.submitDecrementBufferIndexRequestAndWait(stepSize);
        }

        @Override
        public void stepBufferIndexForward(int stepSize) {
            SimulationSession.this.submitIncrementBufferIndexRequestAndWait(stepSize);
        }
    }
}

