/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.shapes;

import java.util.List;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.BoxPolytope3DView;
import us.ihmc.euclid.shape.primitives.interfaces.IntermediateVariableSupplier;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DChangeListener;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseBasics;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.simulation.shapes.STPShape3DTools;
import us.ihmc.scs2.simulation.shapes.interfaces.STPBox3DBasics;
import us.ihmc.scs2.simulation.shapes.interfaces.STPBox3DReadOnly;

public class STPBox3D
implements STPBox3DBasics {
    private double minimumMargin;
    private double maximumMargin;
    private double largeRadius;
    private double smallRadius;
    private final Box3D rawBox3D = new Box3D();
    private final STPShape3DTools.STPBox3DSupportingVertexCalculator supportingVertexCalculator = new STPShape3DTools.STPBox3DSupportingVertexCalculator();
    private boolean stpRadiiDirty = true;

    public STPBox3D() {
        this(1.0, 1.0, 1.0);
    }

    public STPBox3D(double sizeX, double sizeY, double sizeZ) {
        this.getSize().set(sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public STPBox3D(Vector3DReadOnly size) {
        this.getSize().set((Tuple3DReadOnly)size);
        this.setupListeners();
    }

    public STPBox3D(Point3DReadOnly position, Orientation3DReadOnly orientation, double sizeX, double sizeY, double sizeZ) {
        this.set(position, orientation, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public STPBox3D(Point3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly size) {
        this.set(position, orientation, size);
        this.setupListeners();
    }

    public STPBox3D(Pose3DReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.set(pose, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public STPBox3D(Pose3DReadOnly pose, Vector3DReadOnly size) {
        this.set(pose, size);
        this.setupListeners();
    }

    public STPBox3D(RigidBodyTransformReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.set(pose, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public STPBox3D(RigidBodyTransformReadOnly pose, Vector3DReadOnly size) {
        this.set(pose, size);
        this.setupListeners();
    }

    public STPBox3D(Box3DReadOnly other) {
        this.set(other);
        this.setupListeners();
    }

    public STPBox3D(STPBox3DReadOnly other) {
        this.set(other);
        this.setupListeners();
    }

    private void setupListeners() {
        this.addChangeListener(() -> {
            this.stpRadiiDirty = true;
        });
    }

    public Shape3DPoseBasics getPose() {
        return this.rawBox3D.getPose();
    }

    public Vector3DBasics getSize() {
        return this.rawBox3D.getSize();
    }

    @Override
    public double getMinimumMargin() {
        return this.minimumMargin;
    }

    @Override
    public double getMaximumMargin() {
        return this.maximumMargin;
    }

    @Override
    public double getSmallRadius() {
        this.updateRadii();
        return this.smallRadius;
    }

    @Override
    public double getLargeRadius() {
        this.updateRadii();
        return this.largeRadius;
    }

    @Override
    public void setMargins(double minimumMargin, double maximumMargin) {
        if (maximumMargin <= minimumMargin) {
            throw new IllegalArgumentException("The maximum margin has to be strictly greater that the minimum margin, max margin: " + maximumMargin + ", min margin: " + minimumMargin);
        }
        this.minimumMargin = minimumMargin;
        this.maximumMargin = maximumMargin;
        this.stpRadiiDirty = true;
    }

    protected void updateRadii() {
        if (!this.stpRadiiDirty) {
            return;
        }
        this.stpRadiiDirty = false;
        if (this.minimumMargin == 0.0 && this.maximumMargin == 0.0) {
            this.smallRadius = Double.NaN;
            this.largeRadius = Double.NaN;
        } else {
            this.smallRadius = this.minimumMargin;
            this.largeRadius = STPShape3DTools.computeLargeRadiusFromMargins(this.minimumMargin, this.maximumMargin, STPShape3DTools.computeBox3DMaximumEdgeLengthSquared((Vector3DReadOnly)this.getSize()));
        }
    }

    @Override
    public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        return this.supportingVertexCalculator.getSupportingVertex((Box3DReadOnly)this.rawBox3D, this.getSmallRadius(), this.getLargeRadius(), supportDirection, supportingVertexToPack);
    }

    public IntermediateVariableSupplier getIntermediateVariableSupplier() {
        return this.rawBox3D.getIntermediateVariableSupplier();
    }

    public void setIntermediateVariableSupplier(IntermediateVariableSupplier newSupplier) {
        this.rawBox3D.setIntermediateVariableSupplier(newSupplier);
    }

    public STPBox3D copy() {
        return new STPBox3D(this);
    }

    public BoxPolytope3DView asConvexPolytope() {
        return this.rawBox3D.asConvexPolytope();
    }

    public void notifyChangeListeners() {
        this.rawBox3D.notifyChangeListeners();
    }

    public void addChangeListeners(List<? extends Shape3DChangeListener> listeners) {
        this.rawBox3D.addChangeListeners(listeners);
    }

    public void addChangeListener(Shape3DChangeListener listener) {
        this.rawBox3D.addChangeListener(listener);
    }

    public boolean removeChangeListener(Shape3DChangeListener listener) {
        return this.rawBox3D.removeChangeListener(listener);
    }

    public boolean equals(Object object) {
        if (object instanceof STPBox3DReadOnly) {
            return STPBox3DBasics.super.equals((STPBox3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        long hash = EuclidHashCodeTools.combineHashCode((long)this.rawBox3D.hashCode(), (long)EuclidHashCodeTools.toLongHashCode((double)this.minimumMargin, (double)this.maximumMargin));
        return EuclidHashCodeTools.toIntHashCode((long)hash);
    }

    public String toString() {
        String stpSuffix = String.format(", small radius: " + EuclidCoreIOTools.DEFAULT_FORMAT + ", large radius: " + EuclidCoreIOTools.DEFAULT_FORMAT + "]", this.getSmallRadius(), this.getLargeRadius());
        return "STP " + EuclidShapeIOTools.getBox3DString((Box3DReadOnly)this).replace("]", stpSuffix);
    }
}

