/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.controller;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.simulation.robot.RobotInterface;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimOneDoFJointBasics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class RobotOneDoFJointDampingCalculator {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final List<JointCalculator> jointCalculators = new ArrayList<JointCalculator>();

    public RobotOneDoFJointDampingCalculator(RobotInterface robot) {
        for (SimJointBasics simJointBasics : robot.getJointsToConsider()) {
            if (!(simJointBasics instanceof SimOneDoFJointBasics)) continue;
            SimOneDoFJointBasics oneDoFJoint = (SimOneDoFJointBasics)simJointBasics;
            OneDoFJointDefinition jointDefinition = (OneDoFJointDefinition)robot.getRobotDefinition().getJointDefinition(oneDoFJoint.getName());
            if (!(jointDefinition.getDamping() > 0.0)) continue;
            this.jointCalculators.add(new JointCalculator(oneDoFJoint, jointDefinition, this.registry));
        }
    }

    public void compute() {
        for (int i = 0; i < this.jointCalculators.size(); ++i) {
            this.jointCalculators.get(i).doControl();
        }
    }

    public YoRegistry getRegistry() {
        return this.registry;
    }

    private static class JointCalculator {
        private final SimOneDoFJointBasics joint;
        private final YoDouble damping;
        private final YoDouble dampingEffort;

        public JointCalculator(SimOneDoFJointBasics joint, OneDoFJointDefinition jointDefinition, YoRegistry registry) {
            this.joint = joint;
            this.damping = new YoDouble("damping_" + joint.getName(), registry);
            this.damping.set(jointDefinition.getDamping());
            this.dampingEffort = new YoDouble("tau_damping_" + joint.getName(), registry);
        }

        public void doControl() {
            double tauDamping = -this.damping.getValue() * this.joint.getQd();
            this.dampingEffort.set(tauDamping);
            this.joint.setTau(this.joint.getTau() + tauDamping);
        }
    }
}

