/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.impulseBased;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import us.ihmc.mecano.algorithms.ForwardDynamicsCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.RobotJointLimitImpulseBasedCalculator;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class YoRobotJointLimitImpulseBasedCalculator
extends RobotJointLimitImpulseBasedCalculator {
    private final YoInteger numberOfJointsAtLimit;
    private final Map<OneDoFJointReadOnly, YoJointLimitImpulseData> yoJointDataMap;

    public YoRobotJointLimitImpulseBasedCalculator(RigidBodyBasics rootBody, ForwardDynamicsCalculator forwardDynamicsCalculator, YoRegistry registry) {
        super(rootBody, forwardDynamicsCalculator);
        this.numberOfJointsAtLimit = new YoInteger("numberOfJointsAtLimit", registry);
        this.yoJointDataMap = SubtreeStreams.fromChildren(OneDoFJointReadOnly.class, (RigidBodyReadOnly)rootBody).map(joint -> new YoJointLimitImpulseData((OneDoFJointReadOnly)joint, registry)).collect(Collectors.toMap(YoJointLimitImpulseData::getJoint, Function.identity()));
    }

    @Override
    public void initialize(double dt) {
        super.initialize(dt);
        this.yoJointDataMap.forEach((joint, data) -> {
            ((YoJointLimitImpulseData)data).impulse.set(0.0);
            ((YoJointLimitImpulseData)data).jointVelocityNoImpulse.set(joint.getQd());
            ((YoJointLimitImpulseData)data).jointVelocityDueToOtherImpulse.setToNaN();
        });
    }

    @Override
    public void finalizeImpulse() {
        super.finalizeImpulse();
        for (int i = 0; i < this.getJointTargets().size(); ++i) {
            OneDoFJointReadOnly joint2 = (OneDoFJointReadOnly)this.getJointTargets().get(i);
            YoJointLimitImpulseData yoJointData = this.yoJointDataMap.get(joint2);
            yoJointData.impulse.set(this.getImpulse().get(i));
            yoJointData.jointVelocityDueToOtherImpulse.set(this.getJointVelocityDueToOtherImpulse().get(i));
        }
        this.getJointVelocityChange(0);
        this.yoJointDataMap.forEach((joint, data) -> ((YoJointLimitImpulseData)data).jointVelocityChange.set(this.getResponseCalculator().getJointTwistChange(joint)));
        this.numberOfJointsAtLimit.set(this.getJointTargets().size());
    }

    private static class YoJointLimitImpulseData {
        private final OneDoFJointReadOnly joint;
        private final YoDouble impulse;
        private final YoDouble jointVelocityNoImpulse;
        private final YoDouble jointVelocityDueToOtherImpulse;
        private final YoDouble jointVelocityChange;

        public YoJointLimitImpulseData(OneDoFJointReadOnly joint, YoRegistry registry) {
            this.joint = joint;
            this.impulse = new YoDouble(joint.getName() + "Impulse", registry);
            this.jointVelocityNoImpulse = new YoDouble(joint.getName() + "VelocityNoImpulse", registry);
            this.jointVelocityDueToOtherImpulse = new YoDouble(joint.getName() + "VelocityDueToOtherImpulse", registry);
            this.jointVelocityChange = new YoDouble(joint.getName() + "VelocityChange", registry);
        }

        public OneDoFJointReadOnly getJoint() {
            return this.joint;
        }
    }
}

