/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.impulseBased;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.simulation.collision.CollisionResult;
import us.ihmc.scs2.simulation.parameters.ConstraintParametersReadOnly;
import us.ihmc.scs2.simulation.parameters.ContactParametersReadOnly;
import us.ihmc.scs2.simulation.physicsEngine.CombinedJointStateProviders;
import us.ihmc.scs2.simulation.physicsEngine.CombinedRigidBodyTwistProviders;
import us.ihmc.scs2.simulation.physicsEngine.MultiRobotCollisionGroup;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.ImpulseBasedConstraintCalculator;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.ImpulseBasedRobot;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.RobotJointLimitImpulseBasedCalculator;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.SingleContactImpulseCalculator;

public class MultiContactImpulseCalculator {
    private final ReferenceFrame rootFrame;
    private final List<SingleContactImpulseCalculator> contactCalculators = new ArrayList<SingleContactImpulseCalculator>();
    private final List<RobotJointLimitImpulseBasedCalculator> jointLimitCalculators = new ArrayList<RobotJointLimitImpulseBasedCalculator>();
    private final List<ImpulseBasedConstraintCalculator> allCalculators = new ArrayList<ImpulseBasedConstraintCalculator>();
    private final Map<RigidBodyBasics, List<Supplier<DMatrixRMaj>>> robotToCalculatorsOutputMap = new HashMap<RigidBodyBasics, List<Supplier<DMatrixRMaj>>>();
    private double alphaMin = 0.7;
    private double gamma = 0.99;
    private double tolerance = 1.0E-6;
    private boolean solveContactsIndependentlyOnFailure = false;
    private int maxNumberOfIterations = 100;
    private int iterationCounter = 0;
    private static boolean hasCalculatorFailedOnce = false;
    private Map<RigidBodyBasics, ImpulseBasedRobot> robots;

    public MultiContactImpulseCalculator(ReferenceFrame rootFrame) {
        this.rootFrame = rootFrame;
    }

    public void configure(Map<RigidBodyBasics, ImpulseBasedRobot> robots, MultiRobotCollisionGroup collisionGroup) {
        this.robots = robots;
        this.contactCalculators.clear();
        this.jointLimitCalculators.clear();
        this.allCalculators.clear();
        this.robotToCalculatorsOutputMap.clear();
        for (RigidBodyBasics rootBody : collisionGroup.getRootBodies()) {
            ImpulseBasedRobot robot = robots.get(rootBody);
            this.jointLimitCalculators.add(robot.getJointLimitConstraintCalculator());
        }
        for (int i = 0; i < collisionGroup.getNumberOfCollisions(); ++i) {
            CollisionResult collisionResult = collisionGroup.getGroupCollisions().get(i);
            RigidBodyBasics rootA = collisionResult.getCollidableA().getRootBody();
            RigidBodyBasics rootB = collisionResult.getCollidableB().getRootBody();
            SingleContactImpulseCalculator calculator = rootB == null ? robots.get(rootA).getOrCreateEnvironmentContactConstraintCalculator() : robots.get(rootA).getOrCreateInterRobotContactConstraintCalculator(robots.get(rootB));
            calculator.setCollision(collisionResult);
            this.contactCalculators.add(calculator);
        }
        this.allCalculators.addAll(this.contactCalculators);
        this.allCalculators.addAll(this.jointLimitCalculators);
        for (ImpulseBasedConstraintCalculator calculator : this.allCalculators) {
            for (int i = 0; i < calculator.getNumberOfRobotsInvolved(); ++i) {
                int robotIndex = i;
                RigidBodyBasics roobtBody = calculator.getRootBody(i);
                List<Supplier<DMatrixRMaj>> robotCalculatorsOutput = this.robotToCalculatorsOutputMap.get(roobtBody);
                if (robotCalculatorsOutput == null) {
                    robotCalculatorsOutput = new ArrayList<Supplier<DMatrixRMaj>>();
                    this.robotToCalculatorsOutputMap.put(roobtBody, robotCalculatorsOutput);
                }
                robotCalculatorsOutput.add(() -> calculator.getJointVelocityChange(robotIndex));
            }
            CombinedRigidBodyTwistProviders externalRigidBodyTwistModifier = this.assembleExternalRigidBodyTwistModifierForCalculator(calculator);
            CombinedJointStateProviders externalJointTwistModifier = this.assembleExternalJointTwistModifierForCalculator(calculator);
            calculator.setExternalTwistModifiers(externalRigidBodyTwistModifier, externalJointTwistModifier);
        }
    }

    public double computeImpulses(double time, double dt, boolean verbose) {
        for (ImpulseBasedConstraintCalculator calculator : this.allCalculators) {
            calculator.initialize(dt);
        }
        Iterator<ImpulseBasedConstraintCalculator> iterator = this.jointLimitCalculators.iterator();
        while (iterator.hasNext()) {
            ImpulseBasedConstraintCalculator calculator;
            calculator = iterator.next();
            if (!((RobotJointLimitImpulseBasedCalculator)calculator).getActiveLimits().isEmpty()) continue;
            this.allCalculators.remove(calculator);
            iterator.remove();
        }
        for (ImpulseBasedConstraintCalculator calculator : this.allCalculators) {
            List<RigidBodyBasics> rigidBodyTargets = this.collectRigidBodyTargetsForCalculator(calculator);
            List<JointBasics> jointTargets = this.collectJointTargetsForCalculator(calculator);
            calculator.updateInertia(rigidBodyTargets, jointTargets);
        }
        if (this.allCalculators.size() == 1) {
            ImpulseBasedConstraintCalculator calculator = this.allCalculators.get(0);
            calculator.computeImpulse(dt);
            calculator.finalizeImpulse();
            return 0.0;
        }
        double alpha = 1.0;
        double maxUpdateMagnitude = Double.POSITIVE_INFINITY;
        this.iterationCounter = 0;
        while (maxUpdateMagnitude > this.tolerance) {
            maxUpdateMagnitude = Double.NEGATIVE_INFINITY;
            int numberOfClosingContacts = 0;
            for (int i = 0; i < this.allCalculators.size(); ++i) {
                ImpulseBasedConstraintCalculator calculator = this.allCalculators.get(i);
                calculator.updateImpulse(dt, alpha, false);
                calculator.updateTwistModifiers();
                double updateMagnitude = calculator.getVelocityUpdate();
                if (verbose) {
                    if (calculator instanceof SingleContactImpulseCalculator) {
                        SingleContactImpulseCalculator contactCalculator = (SingleContactImpulseCalculator)calculator;
                        System.out.println("Iteration " + this.iterationCounter + ", calc index: " + i + ", active: " + contactCalculator.isConstraintActive() + ", closing: " + contactCalculator.isContactClosing() + ", impulse update: " + contactCalculator.getImpulseUpdate() + ", velocity update: " + contactCalculator.getVelocityUpdate());
                    } else {
                        System.out.println("Iteration " + this.iterationCounter + ", alc index: " + i + ", active: " + calculator.isConstraintActive() + ", impulse update: " + calculator.getImpulseUpdate() + ", velocity update: " + calculator.getVelocityUpdate());
                    }
                }
                maxUpdateMagnitude = Math.max(maxUpdateMagnitude, updateMagnitude);
                if (!calculator.isConstraintActive()) continue;
                ++numberOfClosingContacts;
            }
            ++this.iterationCounter;
            if (this.iterationCounter == 1 && numberOfClosingContacts <= 1) break;
            alpha = this.alphaMin + this.gamma * (alpha - this.alphaMin);
            if (this.iterationCounter <= this.maxNumberOfIterations) continue;
            if (hasCalculatorFailedOnce) break;
            LogTools.error((String)"Unable to converge during Successive Over-Relaxation method. Only reporting the first failure.");
            hasCalculatorFailedOnce = true;
            break;
        }
        if (this.solveContactsIndependentlyOnFailure && this.iterationCounter > this.maxNumberOfIterations) {
            for (ImpulseBasedConstraintCalculator calculator : this.allCalculators) {
                calculator.computeImpulse(dt);
                calculator.finalizeImpulse();
            }
        } else {
            for (ImpulseBasedConstraintCalculator calculator : this.allCalculators) {
                calculator.finalizeImpulse();
            }
        }
        return maxUpdateMagnitude;
    }

    public void setAlphaMin(double alphaMin) {
        this.alphaMin = alphaMin;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public void setMaxNumberOfIterations(int maxNumberOfIterations) {
        this.maxNumberOfIterations = maxNumberOfIterations;
    }

    public void setSolveContactsIndependentlyOnFailure(boolean solveContactsIndependentlyOnFailure) {
        this.solveContactsIndependentlyOnFailure = solveContactsIndependentlyOnFailure;
    }

    public void setSingleContactTolerance(double gamma) {
        this.contactCalculators.forEach(calculator -> calculator.setTolerance(gamma));
    }

    public void setConstraintParameters(ConstraintParametersReadOnly constraintParameters) {
        this.jointLimitCalculators.forEach(calculator -> calculator.setConstraintParameters(constraintParameters));
    }

    public void setContactParameters(ContactParametersReadOnly contactParameters) {
        this.contactCalculators.forEach(calculator -> calculator.setContactParameters(contactParameters));
    }

    public void applyJointVelocityChange(RigidBodyBasics rootBody, Consumer<DMatrixRMaj> jointVelocityChangeConsumer) {
        List<Supplier<DMatrixRMaj>> robotCalculatorsOutput = this.robotToCalculatorsOutputMap.get(rootBody);
        if (robotCalculatorsOutput == null) {
            return;
        }
        robotCalculatorsOutput.forEach(output -> jointVelocityChangeConsumer.accept((DMatrixRMaj)output.get()));
    }

    public void writeJointDeltaVelocities() {
        for (ImpulseBasedConstraintCalculator calculator : this.allCalculators) {
            if (!calculator.isConstraintActive()) continue;
            for (int i = 0; i < calculator.getNumberOfRobotsInvolved(); ++i) {
                RigidBodyBasics rootBody = calculator.getRootBody(i);
                this.robots.get(rootBody).addJointVelocityChange(calculator.getJointVelocityChange(i));
            }
        }
    }

    public void writeImpulses() {
        for (SingleContactImpulseCalculator calculator : this.contactCalculators) {
            if (!calculator.isConstraintActive()) continue;
            for (int i = 0; i < calculator.getNumberOfRobotsInvolved(); ++i) {
                RigidBodyBasics rootBody = calculator.getRootBody(i);
                this.robots.get(rootBody).addRigidBodyExternalImpulse((RigidBodyReadOnly)calculator.getRigidBodyTargets().get(i), calculator.getImpulse(i));
            }
        }
    }

    public double getAlphaMin() {
        return this.alphaMin;
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public int getMaxNumberOfIterations() {
        return this.maxNumberOfIterations;
    }

    public int getNumberOfIterations() {
        return this.iterationCounter;
    }

    public List<SingleContactImpulseCalculator> getImpulseCalculators() {
        return this.contactCalculators;
    }

    public boolean hasConverged() {
        return this.iterationCounter <= this.maxNumberOfIterations;
    }

    private CombinedRigidBodyTwistProviders assembleExternalRigidBodyTwistModifierForCalculator(ImpulseBasedConstraintCalculator calculator) {
        CombinedRigidBodyTwistProviders rigidBodyTwistProviders = new CombinedRigidBodyTwistProviders(this.rootFrame);
        for (ImpulseBasedConstraintCalculator otherCalculator : this.allCalculators) {
            if (otherCalculator == calculator) continue;
            for (int i = 0; i < otherCalculator.getNumberOfRobotsInvolved(); ++i) {
                rigidBodyTwistProviders.add(otherCalculator.getRigidBodyTwistChangeProvider(i));
            }
        }
        return rigidBodyTwistProviders;
    }

    private CombinedJointStateProviders assembleExternalJointTwistModifierForCalculator(ImpulseBasedConstraintCalculator calculator) {
        CombinedJointStateProviders jointTwistProviders = new CombinedJointStateProviders(JointStateType.VELOCITY);
        for (ImpulseBasedConstraintCalculator otherCalculator : this.allCalculators) {
            if (otherCalculator == calculator) continue;
            for (int i = 0; i < otherCalculator.getNumberOfRobotsInvolved(); ++i) {
                jointTwistProviders.add(otherCalculator.getJointTwistChangeProvider(i));
            }
        }
        return jointTwistProviders;
    }

    private List<RigidBodyBasics> collectRigidBodyTargetsForCalculator(ImpulseBasedConstraintCalculator calculator) {
        ArrayList<RigidBodyBasics> rigidBodyTargets = new ArrayList<RigidBodyBasics>();
        for (ImpulseBasedConstraintCalculator otherCalculator : this.allCalculators) {
            if (otherCalculator == calculator) continue;
            rigidBodyTargets.addAll(otherCalculator.getRigidBodyTargets());
        }
        return rigidBodyTargets;
    }

    private List<JointBasics> collectJointTargetsForCalculator(ImpulseBasedConstraintCalculator calculator) {
        ArrayList<JointBasics> jointTargets = new ArrayList<JointBasics>();
        for (ImpulseBasedConstraintCalculator otherCalculator : this.allCalculators) {
            if (otherCalculator == calculator) continue;
            jointTargets.addAll(otherCalculator.getJointTargets());
        }
        return jointTargets;
    }
}

