/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.sensors;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.scs2.definition.robot.SensorDefinition;
import us.ihmc.scs2.session.YoFixedMovingReferenceFrameUsingYawPitchRoll;
import us.ihmc.scs2.simulation.robot.RobotPhysicsOutput;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;

public abstract class SimSensor {
    private final String name;
    private final SimJointBasics parentJoint;
    private final YoFixedMovingReferenceFrameUsingYawPitchRoll frame;

    public SimSensor(SensorDefinition definition, SimJointBasics parentJoint) {
        this(definition.getName(), parentJoint, (RigidBodyTransformReadOnly)definition.getTransformToJoint());
    }

    public SimSensor(String name, SimJointBasics parentJoint, RigidBodyTransformReadOnly transformToParent) {
        this.name = name;
        this.parentJoint = parentJoint;
        this.frame = new YoFixedMovingReferenceFrameUsingYawPitchRoll(name + "Frame", name + "Offset", (ReferenceFrame)parentJoint.getFrameAfterJoint(), parentJoint.getRegistry());
        this.frame.getOffset().set(transformToParent);
    }

    public void update(RobotPhysicsOutput robotPhysicsOutput) {
        this.frame.update();
    }

    public String getName() {
        return this.name;
    }

    public SimJointBasics getParentJoint() {
        return this.parentJoint;
    }

    public MovingReferenceFrame getFrame() {
        return this.frame;
    }

    public YoFramePoseUsingYawPitchRoll getOffset() {
        return this.frame.getOffset();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - " + this.getName();
    }
}

