/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.collision;

import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.algorithms.ForwardDynamicsCalculator;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyAccelerationProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemStateIntegrator;

public class FrameShapePosePredictor {
    private final ForwardDynamicsCalculator forwardDynamicsCalculator;
    private final MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator();
    private final Pose3D pose = new Pose3D();
    private final RigidBodyTransform transform = new RigidBodyTransform();
    private final Twist bodyTwist = new Twist();
    private final SpatialAcceleration bodyAcceleration = new SpatialAcceleration();

    public FrameShapePosePredictor(ForwardDynamicsCalculator forwardDynamicsCalculator) {
        this.forwardDynamicsCalculator = forwardDynamicsCalculator;
    }

    public FrameShape3DReadOnly predictShape(FrameShape3DReadOnly shape, RigidBodyReadOnly rigidBody, double dt) {
        if (rigidBody == null) {
            return shape;
        }
        ReferenceFrame shapeFrame = shape.getReferenceFrame();
        RigidBodyAccelerationProvider accelerationProvider = this.forwardDynamicsCalculator.getAccelerationProvider();
        this.integrator.setIntegrationDT(dt);
        this.bodyTwist.setIncludingFrame((SpatialMotionReadOnly)rigidBody.getBodyFixedFrame().getTwistOfFrame());
        this.bodyTwist.changeFrame(shapeFrame);
        this.bodyTwist.setBodyFrame(shapeFrame);
        this.bodyAcceleration.setIncludingFrame((SpatialMotionReadOnly)accelerationProvider.getAccelerationOfBody(rigidBody));
        this.bodyAcceleration.changeFrame(shapeFrame);
        this.bodyAcceleration.setBodyFrame(shapeFrame);
        this.pose.set((RigidBodyTransformReadOnly)shapeFrame.getTransformToRoot());
        this.integrator.doubleIntegrate((FixedFrameSpatialAccelerationBasics)this.bodyAcceleration, (FixedFrameTwistBasics)this.bodyTwist, (Pose3DBasics)this.pose);
        FrameShape3DBasics predictedShape = (FrameShape3DBasics)shape.copy();
        this.pose.get((RigidBodyTransformBasics)this.transform);
        predictedShape.setReferenceFrame(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)(shapeFrame.getName() + "Predicted"), (ReferenceFrame)shapeFrame.getRootFrame(), (RigidBodyTransformReadOnly)this.transform));
        return predictedShape;
    }
}

