/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.screwTools;

import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.FixedJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.PlanarJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.PrismaticJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SphericalJointReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimFixedJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimPlanarJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimPrismaticJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimRevoluteJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimRigidBody;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimSixDoFJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimSphericalJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimOneDoFJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SimMultiBodySystemFactories {

    public static class SimRigidBodyBuilder
    implements MultiBodySystemFactories.RigidBodyBuilder {
        private final YoRegistry registry;

        public SimRigidBodyBuilder(YoRegistry registry) {
            this.registry = registry;
        }

        public RigidBodyBasics buildRoot(String bodyName, RigidBodyTransform transformToParent, ReferenceFrame parentStationaryFrame) {
            return new SimRigidBody(bodyName, (RigidBodyTransformReadOnly)transformToParent, parentStationaryFrame, this.registry);
        }

        public RigidBodyBasics build(String bodyName, JointBasics parentJoint, Matrix3DReadOnly momentOfInertia, double mass, RigidBodyTransform inertiaPose) {
            return new SimRigidBody(bodyName, (SimJointBasics)parentJoint, momentOfInertia, mass, (RigidBodyTransformReadOnly)inertiaPose);
        }
    }

    public static class SimJointBuilder
    implements MultiBodySystemFactories.JointBuilder {
        public SimJointBasics buildJoint(Class<? extends JointReadOnly> jointType, String name, RigidBodyBasics predecessor, RigidBodyTransform transformToParent) {
            if (SixDoFJointReadOnly.class.isAssignableFrom(jointType)) {
                return this.buildSixDoFJoint(name, predecessor, transformToParent);
            }
            if (PlanarJointReadOnly.class.isAssignableFrom(jointType)) {
                return this.buildPlanarJoint(name, predecessor, transformToParent);
            }
            if (SphericalJointReadOnly.class.isAssignableFrom(jointType)) {
                return this.buildSphericalJoint(name, predecessor, transformToParent);
            }
            if (FixedJointReadOnly.class.isAssignableFrom(jointType)) {
                return this.buildFixedJoint(name, predecessor, transformToParent);
            }
            return null;
        }

        public SimOneDoFJointBasics buildOneDoFJoint(Class<? extends OneDoFJointReadOnly> jointType, String name, RigidBodyBasics predecessor, RigidBodyTransform transformToParent, Vector3DReadOnly jointAxis) {
            if (RevoluteJointBasics.class.isAssignableFrom(jointType)) {
                return this.buildRevoluteJoint(name, predecessor, transformToParent, jointAxis);
            }
            if (PrismaticJointBasics.class.isAssignableFrom(jointType)) {
                return this.buildPrismaticJoint(name, predecessor, transformToParent, jointAxis);
            }
            return null;
        }

        public SimSixDoFJoint buildSixDoFJoint(String name, RigidBodyBasics predecessor, RigidBodyTransform transformToParent) {
            return new SimSixDoFJoint(name, (SimRigidBodyBasics)predecessor, (RigidBodyTransformReadOnly)transformToParent);
        }

        public SimPlanarJoint buildPlanarJoint(String name, RigidBodyBasics predecessor, RigidBodyTransform transformToParent) {
            return new SimPlanarJoint(name, (SimRigidBodyBasics)predecessor, (RigidBodyTransformReadOnly)transformToParent);
        }

        public SimSphericalJoint buildSphericalJoint(String name, RigidBodyBasics predecessor, RigidBodyTransform transformToParent) {
            return new SimSphericalJoint(name, (SimRigidBodyBasics)predecessor, (RigidBodyTransformReadOnly)transformToParent);
        }

        public SimRevoluteJoint buildRevoluteJoint(String name, RigidBodyBasics predecessor, RigidBodyTransform transformToParent, Vector3DReadOnly jointAxis) {
            return new SimRevoluteJoint(name, (SimRigidBodyBasics)predecessor, (RigidBodyTransformReadOnly)transformToParent, jointAxis);
        }

        public SimPrismaticJoint buildPrismaticJoint(String name, RigidBodyBasics predecessor, RigidBodyTransform transformToParent, Vector3DReadOnly jointAxis) {
            return new SimPrismaticJoint(name, (SimRigidBodyBasics)predecessor, (RigidBodyTransformReadOnly)transformToParent, jointAxis);
        }

        public SimFixedJoint buildFixedJoint(String name, RigidBodyBasics predecessor, RigidBodyTransform transformToParent) {
            return new SimFixedJoint(name, (SimRigidBodyBasics)predecessor, (RigidBodyTransformReadOnly)transformToParent);
        }
    }
}

