/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot;

import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointMatrixIndexProvider;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.RobotInterface;
import us.ihmc.scs2.simulation.robot.controller.RobotControllerManager;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.yoVariables.registry.YoRegistry;

public abstract class RobotExtension
implements RobotInterface {
    private final Robot robot;

    public RobotExtension(Robot robot) {
        this.robot = robot;
    }

    public RobotExtension(RobotDefinition robotDefinition, ReferenceFrame inertialFrame) {
        this(new Robot(robotDefinition, inertialFrame));
    }

    public Robot getRobot() {
        return this.robot;
    }

    @Override
    public String getName() {
        return this.robot.getName();
    }

    @Override
    public RobotDefinition getRobotDefinition() {
        return this.robot.getRobotDefinition();
    }

    @Override
    public RobotControllerManager getControllerManager() {
        return this.robot.getControllerManager();
    }

    @Override
    public void initializeState() {
        this.robot.initializeState();
    }

    @Override
    public SimRigidBodyBasics getRootBody() {
        return this.robot.getRootBody();
    }

    @Override
    public SimRigidBodyBasics getRigidBody(String name) {
        return this.robot.getRigidBody(name);
    }

    @Override
    public SimJointBasics getJoint(String name) {
        return this.robot.getJoint(name);
    }

    @Override
    public List<? extends SimJointBasics> getAllJoints() {
        return this.robot.getAllJoints();
    }

    public ReferenceFrame getInertialFrame() {
        return this.robot.getInertialFrame();
    }

    public JointMatrixIndexProvider getJointMatrixIndexProvider() {
        return this.robot.getJointMatrixIndexProvider();
    }

    @Override
    public List<? extends SimJointBasics> getJointsToConsider() {
        return this.robot.getJointsToConsider();
    }

    @Override
    public List<? extends SimJointBasics> getJointsToIgnore() {
        return this.robot.getJointsToIgnore();
    }

    @Override
    public YoRegistry getRegistry() {
        return this.robot.getRegistry();
    }
}

