/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.shapes;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameUnitVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameCapsule3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeIOTools;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DChangeListener;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.simulation.shapes.STPShape3DTools;
import us.ihmc.scs2.simulation.shapes.interfaces.FrameSTPCapsule3DBasics;
import us.ihmc.scs2.simulation.shapes.interfaces.FrameSTPCapsule3DReadOnly;
import us.ihmc.scs2.simulation.shapes.interfaces.STPCapsule3DReadOnly;

public class FrameSTPCapsule3D
implements FrameSTPCapsule3DBasics {
    private ReferenceFrame referenceFrame;
    private final List<Shape3DChangeListener> changeListeners = new ArrayList<Shape3DChangeListener>();
    private double minimumMargin;
    private double maximumMargin;
    private double largeRadius;
    private double smallRadius;
    private final STPShape3DTools.STPCapsule3DSupportingVertexCalculator supportingVertexCalculator = new STPShape3DTools.STPCapsule3DSupportingVertexCalculator();
    private final FixedFramePoint3DBasics position = EuclidFrameFactories.newObservableFixedFramePoint3DBasics((ReferenceFrameHolder)this, (axis, value) -> this.notifyChangeListeners(), null);
    private final FixedFrameUnitVector3DBasics axis = EuclidFrameFactories.newObservableFixedFrameUnitVector3DBasics((axis, value) -> this.notifyChangeListeners(), null, (FixedFrameUnitVector3DBasics)EuclidFrameFactories.newFixedFrameUnitVector3DBasics((ReferenceFrameHolder)this, (Vector3DReadOnly)Axis3D.Z));
    private double radius;
    private double length;
    private double halfLength;
    private final FramePoint3DReadOnly topCenter = EuclidFrameFactories.newLinkedFramePoint3DReadOnly((ReferenceFrameHolder)this, () -> this.halfLength * this.axis.getX() + this.position.getX(), () -> this.halfLength * this.axis.getY() + this.position.getY(), () -> this.halfLength * this.axis.getZ() + this.position.getZ());
    private final FramePoint3DReadOnly bottomCenter = EuclidFrameFactories.newLinkedFramePoint3DReadOnly((ReferenceFrameHolder)this, () -> -this.halfLength * this.axis.getX() + this.position.getX(), () -> -this.halfLength * this.axis.getY() + this.position.getY(), () -> -this.halfLength * this.axis.getZ() + this.position.getZ());
    private boolean stpRadiiDirty = true;

    public FrameSTPCapsule3D() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FrameSTPCapsule3D(ReferenceFrame referenceFrame) {
        this(referenceFrame, 1.0, 0.5);
    }

    public FrameSTPCapsule3D(ReferenceFrame referenceFrame, double length, double radius) {
        this.setReferenceFrame(referenceFrame);
        this.setSize(length, radius);
        this.setupListeners();
    }

    public FrameSTPCapsule3D(ReferenceFrame referenceFrame, Point3DReadOnly position, Vector3DReadOnly axis2, double length, double radius) {
        this.setIncludingFrame(referenceFrame, position, axis2, length, radius);
        this.setupListeners();
    }

    public FrameSTPCapsule3D(FramePoint3DReadOnly position, FrameVector3DReadOnly axis2, double length, double radius) {
        this.setIncludingFrame(position, axis2, length, radius);
        this.setupListeners();
    }

    public FrameSTPCapsule3D(ReferenceFrame referenceFrame, Capsule3DReadOnly other) {
        this.setIncludingFrame(referenceFrame, other);
        this.setupListeners();
    }

    public FrameSTPCapsule3D(ReferenceFrame referenceFrame, STPCapsule3DReadOnly other) {
        this.setIncludingFrame(referenceFrame, other);
        this.setupListeners();
    }

    public FrameSTPCapsule3D(FrameCapsule3DReadOnly other) {
        this.setIncludingFrame(other);
        this.setupListeners();
    }

    public FrameSTPCapsule3D(FrameSTPCapsule3DReadOnly other) {
        this.setIncludingFrame(other);
        this.setupListeners();
    }

    private void setupListeners() {
        this.addChangeListener(() -> {
            this.stpRadiiDirty = true;
        });
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public void setRadius(double radius) {
        if (radius < 0.0) {
            throw new IllegalArgumentException("The radius of a Capsule3D cannot be negative: " + radius);
        }
        this.radius = radius;
        this.notifyChangeListeners();
    }

    public void setLength(double length) {
        if (length < 0.0) {
            throw new IllegalArgumentException("The length of a Capsule3D cannot be negative: " + length);
        }
        this.length = length;
        this.halfLength = 0.5 * length;
        this.notifyChangeListeners();
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getLength() {
        return this.length;
    }

    public double getHalfLength() {
        return this.halfLength;
    }

    public FixedFramePoint3DBasics getPosition() {
        return this.position;
    }

    public FixedFrameUnitVector3DBasics getAxis() {
        return this.axis;
    }

    public FramePoint3DReadOnly getTopCenter() {
        return this.topCenter;
    }

    public FramePoint3DReadOnly getBottomCenter() {
        return this.bottomCenter;
    }

    @Override
    public double getMinimumMargin() {
        return this.minimumMargin;
    }

    @Override
    public double getMaximumMargin() {
        return this.maximumMargin;
    }

    @Override
    public double getSmallRadius() {
        this.updateRadii();
        return this.smallRadius;
    }

    @Override
    public double getLargeRadius() {
        this.updateRadii();
        return this.largeRadius;
    }

    @Override
    public void setMargins(double minimumMargin, double maximumMargin) {
        if (maximumMargin <= minimumMargin) {
            throw new IllegalArgumentException("The maximum margin has to be strictly greater that the minimum margin, max margin: " + maximumMargin + ", min margin: " + minimumMargin);
        }
        this.minimumMargin = minimumMargin;
        this.maximumMargin = maximumMargin;
        this.stpRadiiDirty = true;
    }

    protected void updateRadii() {
        if (!this.stpRadiiDirty) {
            return;
        }
        this.stpRadiiDirty = false;
        if (this.minimumMargin == 0.0 && this.maximumMargin == 0.0) {
            this.smallRadius = Double.NaN;
            this.largeRadius = Double.NaN;
        } else {
            this.smallRadius = this.radius + this.minimumMargin;
            this.largeRadius = this.radius + STPShape3DTools.computeLargeRadiusFromMargins(this.minimumMargin, this.maximumMargin, EuclidCoreTools.square((double)this.length));
        }
    }

    @Override
    public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        return this.supportingVertexCalculator.getSupportingVertex(this, this.getSmallRadius(), this.getLargeRadius(), supportDirection, supportingVertexToPack);
    }

    public void notifyChangeListeners() {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            this.changeListeners.get(i).changed();
        }
    }

    public void addChangeListeners(List<? extends Shape3DChangeListener> listeners) {
        for (int i = 0; i < listeners.size(); ++i) {
            this.addChangeListener(listeners.get(i));
        }
    }

    public void addChangeListener(Shape3DChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public boolean removeChangeListener(Shape3DChangeListener listener) {
        return this.changeListeners.remove(listener);
    }

    public FrameSTPCapsule3D copy() {
        return new FrameSTPCapsule3D(this);
    }

    public boolean equals(Object object) {
        if (object instanceof FrameSTPCapsule3DReadOnly) {
            return FrameSTPCapsule3DBasics.super.equals((FrameSTPCapsule3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        long hash = 1L;
        hash = EuclidHashCodeTools.toLongHashCode((double)this.length, (double)this.radius);
        hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)EuclidHashCodeTools.toLongHashCode((Object)this.position, (Object)this.axis));
        hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)EuclidHashCodeTools.toLongHashCode((double)this.minimumMargin, (double)this.maximumMargin));
        return EuclidHashCodeTools.toIntHashCode((long)hash);
    }

    public String toString() {
        String stpSuffix = String.format(", small radius: " + EuclidCoreIOTools.DEFAULT_FORMAT + ", large radius: " + EuclidCoreIOTools.DEFAULT_FORMAT + "]", this.getSmallRadius(), this.getLargeRadius());
        return "STP " + EuclidFrameShapeIOTools.getFrameCapsule3DString((FrameCapsule3DReadOnly)this).replace("]", stpSuffix);
    }
}

