/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.contactPointBased;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.simulation.collision.Collidable;
import us.ihmc.scs2.simulation.collision.CollisionTools;
import us.ihmc.scs2.simulation.parameters.ContactPointBasedContactParametersReadOnly;
import us.ihmc.scs2.simulation.physicsEngine.PhysicsEngine;
import us.ihmc.scs2.simulation.physicsEngine.contactPointBased.ContactPointBasedForceCalculator;
import us.ihmc.scs2.simulation.physicsEngine.contactPointBased.ContactPointBasedRobot;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.RobotExtension;
import us.ihmc.scs2.simulation.robot.RobotInterface;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.scs2.simulation.robot.trackers.GroundContactPoint;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ContactPointBasedPhysicsEngine
implements PhysicsEngine {
    public static final double MAX_TRANS_ACCEL = 1.0E12;
    public static final double MAX_ROT_ACCEL = 1.0E7;
    private final ReferenceFrame inertialFrame;
    private final YoRegistry rootRegistry;
    private final YoRegistry physicsEngineRegistry = new YoRegistry(this.getClass().getSimpleName());
    private final List<ContactPointBasedRobot> robotList = new ArrayList<ContactPointBasedRobot>();
    private final List<TerrainObjectDefinition> terrainObjectDefinitions = new ArrayList<TerrainObjectDefinition>();
    private final List<Collidable> environmentCollidables = new ArrayList<Collidable>();
    private final ContactPointBasedForceCalculator forceCalculator;
    private boolean initialize = true;
    private final Wrench tempWrench = new Wrench();

    public ContactPointBasedPhysicsEngine(ReferenceFrame inertialFrame, YoRegistry rootRegistry) {
        this.inertialFrame = inertialFrame;
        this.rootRegistry = rootRegistry;
        this.forceCalculator = new ContactPointBasedForceCalculator(inertialFrame, this.physicsEngineRegistry);
        rootRegistry.addChild(this.physicsEngineRegistry);
    }

    @Override
    public boolean initialize(Vector3DReadOnly gravity) {
        if (!this.initialize) {
            return false;
        }
        for (ContactPointBasedRobot robot : this.robotList) {
            robot.initializeState();
            robot.resetCalculators();
            robot.doForwardDynamics(gravity);
            robot.updateSensors();
            robot.getControllerManager().initializeControllers();
        }
        this.initialize = false;
        return true;
    }

    @Override
    public void simulate(double currentTime, double dt, Vector3DReadOnly gravity) {
        if (this.initialize(gravity)) {
            return;
        }
        for (ContactPointBasedRobot robot : this.robotList) {
            robot.resetCalculators();
            robot.getControllerManager().updateControllers(currentTime);
            robot.getControllerManager().writeControllerOutput(JointStateType.EFFORT);
            robot.getControllerManager().writeControllerOutputForJointsToIgnore(JointStateType.values());
            robot.computeJointDamping();
            robot.computeJointSoftLimits();
            robot.updateCollidableBoundingBoxes();
        }
        this.environmentCollidables.forEach(collidable -> collidable.updateBoundingBox(this.inertialFrame));
        this.forceCalculator.resolveContactForces(this.robotList, () -> this.environmentCollidables);
        for (ContactPointBasedRobot robot : this.robotList) {
            for (SimJointBasics simJointBasics : robot.getJointsToConsider()) {
                List<GroundContactPoint> groundContactPoints = simJointBasics.getAuxialiryData().getGroundContactPoints();
                if (groundContactPoints.isEmpty()) continue;
                SimRigidBodyBasics body = simJointBasics.getSuccessor();
                FixedFrameWrenchBasics externalWrench = robot.getForwardDynamicsCalculator().getExternalWrench((RigidBodyReadOnly)body);
                for (GroundContactPoint gcp : groundContactPoints) {
                    this.tempWrench.setIncludingFrame((WrenchReadOnly)gcp.getWrench());
                    this.tempWrench.changeFrame(externalWrench.getReferenceFrame());
                    externalWrench.add((WrenchReadOnly)this.tempWrench);
                }
                robot.addRigidBodyExternalWrench(body, (WrenchReadOnly)externalWrench);
            }
            robot.doForwardDynamics(gravity);
        }
        for (ContactPointBasedRobot robot : this.robotList) {
            robot.writeJointAccelerations();
            robot.getAllJoints().forEach(joint -> {
                if (joint.getJointTwist().getAngularPart().length() > 1.0E7) {
                    throw new IllegalStateException("Unreasonable acceleration for the joint " + joint);
                }
                if (joint.getJointTwist().getLinearPart().length() > 1.0E12) {
                    throw new IllegalStateException("Unreasonable acceleration for the joint " + joint);
                }
            });
            robot.integrateState(dt);
            robot.updateFrames();
            robot.updateSensors();
        }
    }

    @Override
    public void pause() {
        for (ContactPointBasedRobot robot : this.robotList) {
            robot.getControllerManager().pauseControllers();
        }
    }

    public void setGroundContactParameters(ContactPointBasedContactParametersReadOnly parameters) {
        this.forceCalculator.setParameters(parameters);
    }

    @Override
    public void addRobot(Robot robot) {
        this.inertialFrame.checkReferenceFrameMatch(robot.getInertialFrame());
        ContactPointBasedRobot cpbRobot = new ContactPointBasedRobot(robot);
        this.rootRegistry.addChild(cpbRobot.getRegistry());
        this.robotList.add(cpbRobot);
    }

    @Override
    public void addTerrainObject(TerrainObjectDefinition terrainObjectDefinition) {
        this.terrainObjectDefinitions.add(terrainObjectDefinition);
        this.environmentCollidables.addAll(CollisionTools.toCollisionShape(terrainObjectDefinition, this.inertialFrame));
    }

    @Override
    public ReferenceFrame getInertialFrame() {
        return this.inertialFrame;
    }

    public List<Robot> getRobots() {
        return this.robotList.stream().map(RobotExtension::getRobot).collect(Collectors.toList());
    }

    @Override
    public List<RobotDefinition> getRobotDefinitions() {
        return this.robotList.stream().map(RobotInterface::getRobotDefinition).collect(Collectors.toList());
    }

    @Override
    public List<TerrainObjectDefinition> getTerrainObjectDefinitions() {
        return this.terrainObjectDefinitions;
    }

    @Override
    public YoRegistry getPhysicsEngineRegistry() {
        return this.physicsEngineRegistry;
    }
}

