/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import us.ihmc.scs2.sharedMemory.BufferSample;
import us.ihmc.scs2.sharedMemory.LinkedYoVariable;
import us.ihmc.scs2.sharedMemory.YoBooleanBuffer;
import us.ihmc.scs2.sharedMemory.YoDoubleBuffer;
import us.ihmc.scs2.sharedMemory.YoEnumBuffer;
import us.ihmc.scs2.sharedMemory.YoIntegerBuffer;
import us.ihmc.scs2.sharedMemory.YoLongBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public abstract class YoVariableBuffer<T extends YoVariable> {
    protected final T yoVariable;
    private final YoBufferPropertiesReadOnly properties;

    public static YoVariableBuffer<?> newYoVariableBuffer(YoVariable yoVariable, YoBufferPropertiesReadOnly properties) {
        if (yoVariable instanceof YoDouble) {
            return new YoDoubleBuffer((YoDouble)yoVariable, properties);
        }
        if (yoVariable instanceof YoInteger) {
            return new YoIntegerBuffer((YoInteger)yoVariable, properties);
        }
        if (yoVariable instanceof YoLong) {
            return new YoLongBuffer((YoLong)yoVariable, properties);
        }
        if (yoVariable instanceof YoBoolean) {
            return new YoBooleanBuffer((YoBoolean)yoVariable, properties);
        }
        if (yoVariable instanceof YoEnum) {
            return new YoEnumBuffer((YoEnum)yoVariable, properties);
        }
        throw new UnsupportedOperationException("Unsupported YoVariable type: " + yoVariable.getClass().getSimpleName());
    }

    public YoVariableBuffer(T yoVariable, YoBufferPropertiesReadOnly properties) {
        this.yoVariable = yoVariable;
        this.properties = properties;
    }

    public abstract void resizeBuffer(int var1, int var2);

    public final void writeBuffer() {
        this.writeBufferAt(this.properties.getCurrentIndex());
    }

    public abstract void writeBufferAt(int var1);

    public final void readBuffer() {
        this.readBufferAt(this.properties.getCurrentIndex());
    }

    public abstract void readBufferAt(int var1);

    public abstract void fillBuffer(boolean var1, int var2, int var3);

    public T getYoVariable() {
        return this.yoVariable;
    }

    public YoBufferPropertiesReadOnly getProperties() {
        return this.properties;
    }

    long getValueAsLongBits() {
        return this.getValueAsLongBits(this.properties.getCurrentIndex());
    }

    abstract long getValueAsLongBits(int var1);

    public abstract BufferSample copy(int var1, int var2, YoBufferPropertiesReadOnly var3);

    abstract LinkedYoVariable<T> newLinkedYoVariable(T var1, Object var2);

    public abstract Object getBuffer();

    public abstract double[] getAsDoubleBuffer();

    public abstract void dispose();
}

