/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import us.ihmc.scs2.sharedMemory.BufferSample;
import us.ihmc.scs2.sharedMemory.LinkedYoLong;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.variable.YoLong;

public class YoLongBuffer
extends YoVariableBuffer<YoLong> {
    private long[] buffer;

    public YoLongBuffer(YoLong yoLong, YoBufferPropertiesReadOnly properties) {
        super(yoLong, properties);
        this.buffer = new long[properties.getSize()];
    }

    @Override
    public void resizeBuffer(int from, int length) {
        if (from == 0 && length == this.buffer.length) {
            return;
        }
        this.buffer = SharedMemoryTools.ringArrayCopy(this.buffer, from, length);
    }

    @Override
    public void writeBufferAt(int index) {
        this.buffer[index] = ((YoLong)this.yoVariable).getValue();
    }

    @Override
    public void readBufferAt(int index) {
        ((YoLong)this.yoVariable).set(this.buffer[index]);
    }

    @Override
    long getValueAsLongBits(int index) {
        return this.buffer[index];
    }

    @Override
    public BufferSample<long[]> copy(int from, int length, YoBufferPropertiesReadOnly properties) {
        return new BufferSample<long[]>(from, SharedMemoryTools.ringArrayCopy(this.buffer, from, length), length, properties);
    }

    @Override
    public void fillBuffer(boolean zeroFill, int from, int length) {
        SharedMemoryTools.ringArrayFill(this.buffer, zeroFill ? 0L : ((YoLong)this.yoVariable).getValue(), from, length);
    }

    LinkedYoLong newLinkedYoVariable(YoLong variableToLink) {
        return new LinkedYoLong(variableToLink, this);
    }

    public long[] getBuffer() {
        return this.buffer;
    }

    @Override
    public void dispose() {
        this.buffer = null;
    }
}

